/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.finalprocessing.operateservice;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.gl.enums.PlanType;
import kd.fi.gl.finalprocess.constant.AmortStyle;
import kd.fi.gl.finalprocess.constant.VoucherAmortConstant;
import kd.fi.gl.finalprocess.info.scheme.AbstractEndingProcessScheme;
import kd.fi.gl.finalprocess.info.scheme.VchAmortScheme;
import kd.fi.gl.finalprocess.service.impl.VchAmortService;
import kd.fi.gl.finalprocessing.info.AmortGenVchInfo;
import kd.fi.gl.util.CommonAssistUtil;
import kd.fi.gl.util.FinalProcessUtil;
import kd.fi.gl.util.VoucherAmortSchemeUtils;

public class AmortSaveOp
extends AbstractOperationServicePlugIn {
    protected static final String ASSGRP_ROW = "assgrprow";
    protected static final String FIELD_NAME = "fieldname";
    protected static final String VALUE = "value";
    protected static final String TXTVAL = "txtval";
    Map<String, Set<Long>> rowToHgs;

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                HashMap serviceMap = new HashMap(this.dataEntities.length);
                Set invalidSchemePkSet = Arrays.stream(this.dataEntities).map(entity -> new VchAmortScheme(entity.getDataEntity())).filter(schemeInfo -> {
                    VchAmortService service = new VchAmortService(schemeInfo);
                    serviceMap.put(schemeInfo, service);
                    return true;
                }).filter(amortScheme -> !AmortSaveOp.this.checkSchemeIfValid((VchAmortService)serviceMap.get(amortScheme))).map(AbstractEndingProcessScheme::getPkValue).collect(Collectors.toCollection(() -> new HashSet(this.dataEntities.length)));
                Arrays.stream(this.dataEntities).filter(entity -> invalidSchemePkSet.contains(entity.getDataEntity().getPkValue())).forEach(entity -> this.addErrorMessage((ExtendedDataEntity)entity, ResManager.loadKDString((String)"\u8be5\u65b9\u6848\u7684\u51ed\u8bc1\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5173\u95ed\u540e\u91cd\u65b0\u4fee\u6539\u4fdd\u5b58\u3002", (String)"AmortSaveOp_0", (String)"fi-gl-opplugin", (Object[])new Object[0])));
                block5: for (ExtendedDataEntity entity2 : this.dataEntities) {
                    DynamicObject dyn = entity2.getDataEntity();
                    VchAmortScheme scheme = new VchAmortScheme(dyn);
                    AmortStyle amortStyle = scheme.getAmortStyle();
                    boolean exists = FinalProcessUtil.isComAssistExistsNoLeaf((ExtendedDataEntity)entity2);
                    if (exists) {
                        this.addErrorMessage(entity2, ResManager.loadKDString((String)"\u516c\u5171\u7ef4\u5ea6\u503c\u5fc5\u987b\u4e3a\u660e\u7ec6\u503c\u3002", (String)"AmortSaveOp_6", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                    }
                    switch (amortStyle) {
                        case amortOnPeriodInFix: {
                            int periodNumToAmort = dyn.getInt("planperiod");
                            BigDecimal amtToAmortOnPeriod = dyn.getBigDecimal("periodamortamount");
                            BigDecimal amortedAmount = dyn.getBigDecimal("amortamount");
                            BigDecimal amortAmountInTotal = dyn.getBigDecimal("totalamount");
                            BigDecimal amtToAmortInTotal = amortAmountInTotal.subtract(amortedAmount);
                            BigDecimal amtToAmortOnCalculate = amtToAmortOnPeriod.multiply(BigDecimal.valueOf(Long.parseLong(periodNumToAmort + "")));
                            int amtprecision = dyn.getDynamicObject("currency").getInt("amtprecision");
                            int scale = amtprecision <= 0 ? amtToAmortOnPeriod.scale() - 1 : amtprecision - 1;
                            BigDecimal compareFactor = BigDecimal.ONE.divide(BigDecimal.TEN.multiply(BigDecimal.valueOf(1000000000000000L)), scale, RoundingMode.UP);
                            if (amtToAmortInTotal.subtract(amtToAmortOnCalculate).abs().compareTo(compareFactor) > 0) {
                                this.addErrorMessage(entity2, ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u644a\u9500\u65b9\u6848\uff0c\u786e\u4fdd\u6bcf\u671f\u644a\u9500\u91d1\u989d\u4e58\u4ee5\u5f85\u644a\u671f\u95f4\u6570\u7b49\u4e8e\u603b\u5f85\u644a\u91d1\u989d\u3002", (String)"AmortSaveOp_2", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                            }
                        }
                        case amortOnPeriodInAvr: 
                        case amortOnDate: {
                            if (dyn.getDynamicObjectCollection("destaccounts").stream().allMatch(destRow -> VoucherAmortConstant.DestType.RATIO.getValue().equals(destRow.getString("desttype")))) {
                                if (VoucherAmortSchemeUtils.checkLegalByRatio((DynamicObject)dyn)) continue block5;
                                this.addErrorMessage(entity2, ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u644a\u9500\u65b9\u6848\uff0c\u5f85\u644a\u6bd4\u4f8b\u548c\u4e0d\u7b49\u4e8e100\u3002", (String)"AmortSaveOp_4", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                                continue block5;
                            }
                            if (VoucherAmortSchemeUtils.checkLegalByAmount((DynamicObject)dyn)) continue block5;
                            this.addErrorMessage(entity2, ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u644a\u9500\u65b9\u6848\uff0c\u4ee5\u89e3\u51b3\u6bcf\u671f\u644a\u9500\u91d1\u989d\u548c\u8f6c\u5165\u5206\u5f55\u91d1\u989d\u4e0d\u5e73\u7684\u95ee\u9898\u3002", (String)"AmortSaveOp_3", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                            continue block5;
                        }
                        case amortOnPeriodInCst: {
                            if (dyn.getDynamicObjectCollection("destaccounts").stream().anyMatch(row -> VoucherAmortConstant.DestType.AMOUNT.getValue().equals(row.getString("desttype")))) {
                                this.addErrorMessage(entity2, ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u644a\u9500\u65b9\u6848\uff0c\u8f6c\u5165\u79d1\u76ee\u4e0d\u652f\u6301\u6309\u91d1\u989d\u644a\u9500\u3002", (String)"AmortSaveOp_5", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                            }
                            if (VoucherAmortSchemeUtils.checkLegalByRatio((DynamicObject)dyn)) continue block5;
                            this.addErrorMessage(entity2, ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u644a\u9500\u65b9\u6848\uff0c\u5f85\u644a\u6bd4\u4f8b\u548c\u4e0d\u7b49\u4e8e100\u3002", (String)"AmortSaveOp_4", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                            continue block5;
                        }
                    }
                }
            }
        });
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        this.parseRowToHgs(e.getDataEntities());
        for (DynamicObject scheme : e.getDataEntities()) {
            if (!VoucherAmortSchemeUtils.isNewVersion((DynamicObject)scheme, (VoucherAmortSchemeUtils.Action)VoucherAmortSchemeUtils.Action.Save)) {
                return;
            }
            AmortGenVchInfo amortInfo = new AmortGenVchInfo(scheme, this.getOption());
            DynamicObjectCollection detailEntry = amortInfo.getDetailEntry();
            this.removeDirtyDetailEntry(scheme);
            amortInfo.getTargetEntry().stream().filter(targetRow -> targetRow.getString("plantype").equals(PlanType.FIXED.getValue())).forEach(targetRow -> {
                String rowId = targetRow.getString("targetrowid");
                Set allAccts = VoucherAmortSchemeUtils.getLeafAccountIds((DynamicObject)targetRow, (AmortGenVchInfo)amortInfo);
                Set allHgs = Optional.ofNullable(this.rowToHgs.get(targetRow.getString("targetrowid"))).orElseGet(() -> Stream.of(Long.valueOf(0L)).collect(Collectors.toSet()));
                Map balanceAssistMap = amortInfo.getBalanceAssistMap();
                int comAssistCount = amortInfo.getComAssistCount();
                ArrayList<List<Long>> comAssistIdList = new ArrayList<List<Long>>(balanceAssistMap.size());
                for (int i = 1; i <= comAssistCount; ++i) {
                    Long balanceAssistId = (Long)balanceAssistMap.get(CommonAssistUtil.getComassistField((int)i));
                    if (balanceAssistId != null && balanceAssistId != 0L) {
                        comAssistIdList.add(Collections.singletonList(balanceAssistId));
                        continue;
                    }
                    comAssistIdList.add(targetRow.getDynamicObjectCollection(CommonAssistUtil.getComassistField((int)i) + "target").stream().map(comAssist -> comAssist.get("fbasedataid_id")).collect(Collectors.toList()));
                }
                ArrayList<List<Object>> combinationLists = new ArrayList<List<Object>>(8);
                combinationLists.add(Arrays.asList(allAccts.toArray()));
                combinationLists.add(Arrays.asList(allHgs.toArray()));
                combinationLists.addAll(comAssistIdList);
                List combination = FinalProcessUtil.getCartesianProduct(combinationLists);
                if (combination.isEmpty()) {
                    return;
                }
                BigDecimal eachOri = targetRow.getBigDecimal("planamount").divide(new BigDecimal(combination.size()), VoucherAmortSchemeUtils.getOriScale((DynamicObject)targetRow), RoundingMode.HALF_UP);
                BigDecimal eachLoc = targetRow.getBigDecimal("targetlocal").divide(new BigDecimal(combination.size()), VoucherAmortSchemeUtils.getLocScale((DynamicObject)scheme), RoundingMode.HALF_UP);
                for (int i = 0; i < combination.size() - 1; ++i) {
                    List detailRowKetList = ((List)combination.get(i)).stream().map(value -> Long.parseLong(value.toString())).collect(Collectors.toList());
                    HashMap<Integer, Long> comAssistMap = new HashMap<Integer, Long>(8);
                    for (int index = 2; index < detailRowKetList.size(); ++index) {
                        comAssistMap.put(index - 1, (Long)detailRowKetList.get(index));
                    }
                    this.updateDetailEntry(detailEntry, rowId, (Long)detailRowKetList.get(0), (Long)detailRowKetList.get(1), eachOri, eachLoc, comAssistMap);
                }
                List detailRowKetList = ((List)combination.get(combination.size() - 1)).stream().map(value -> Long.parseLong(value.toString())).collect(Collectors.toList());
                HashMap<Integer, Long> comAssistMap = new HashMap<Integer, Long>(8);
                for (int index = 2; index < detailRowKetList.size(); ++index) {
                    comAssistMap.put(index - 1, (Long)detailRowKetList.get(index));
                }
                this.updateDetailEntry(detailEntry, rowId, (Long)detailRowKetList.get(0), (Long)detailRowKetList.get(1), targetRow.getBigDecimal("planamount").subtract(eachOri.multiply(new BigDecimal(combination.size() - 1))), targetRow.getBigDecimal("targetlocal").subtract(eachLoc.multiply(new BigDecimal(combination.size() - 1))), comAssistMap);
            });
            detailEntry.removeIf(detailRow -> !this.rowToHgs.containsKey(detailRow.getString("detailrowid")));
            scheme.set("detailentry", (Object)VoucherAmortSchemeUtils.mergeDetailEntry((DynamicObjectCollection)detailEntry));
        }
        SaveServiceHelper.save((DynamicObject[])e.getDataEntities());
    }

    private void updateDetailEntry(DynamicObjectCollection detailEntry, String rowId, Long acctId, Long hgId, BigDecimal eachOri, BigDecimal eachLoc, Map<Integer, Long> comAssistMap) {
        DynamicObject detail = detailEntry.stream().filter(detailRow -> {
            List detailComAssistKeyList = detailRow.getDataEntityType().getProperties().stream().map(IMetadata::getName).filter(name -> name.startsWith("detailcomassist")).collect(Collectors.toList());
            HashMap<Integer, Long> curComAssistMap = new HashMap<Integer, Long>(8);
            for (String detailComAssistKey : detailComAssistKeyList) {
                curComAssistMap.put(Integer.parseInt(detailComAssistKey.substring("detailcomassist".length())), detailRow.getLong(detailComAssistKey));
            }
            return detailRow.getString("detailrowid").equals(rowId) && detailRow.getLong("detailaccount") == acctId.longValue() && detailRow.getLong("detailassgrp") == hgId.longValue() && curComAssistMap.equals(comAssistMap);
        }).findFirst().orElseGet(() -> ((DynamicObjectCollection)detailEntry).addNew());
        detail.set("detailrowid", (Object)rowId);
        detail.set("detailaccount", (Object)acctId);
        detail.set("detailassgrp", (Object)hgId);
        detail.set("detailoritotal", (Object)eachOri);
        detail.set("detailloctotal", (Object)eachLoc);
        for (Map.Entry<Integer, Long> comAssistEntry : comAssistMap.entrySet()) {
            detail.set("detailcomassist" + comAssistEntry.getKey(), (Object)comAssistEntry.getValue());
        }
    }

    private void parseRowToHgs(DynamicObject[] dataEntities) {
        Set targetRowIds = Arrays.stream(dataEntities).map(dyn -> dyn.getDynamicObjectCollection("targetaccounts")).flatMap(Collection::stream).map(targetRow -> targetRow.getString("targetrowid")).collect(Collectors.toSet());
        this.rowToHgs = VoucherAmortSchemeUtils.batchLoadRowId2Assgrp(targetRowIds);
    }

    private void removeDirtyDetailEntry(DynamicObject scheme) {
        scheme.getDynamicObjectCollection("detailentry").removeIf(detailRow -> !this.rowToHgs.containsKey(detailRow.getString("detailrowid")));
        Set fixedRowIds = scheme.getDynamicObjectCollection("targetaccounts").stream().filter(targetRow -> targetRow.getString("plantype").equals(PlanType.FIXED.getValue())).map(targetRow -> targetRow.getString("targetrowid")).collect(Collectors.toSet());
        scheme.getDynamicObjectCollection("detailentry").removeIf(detailRow -> fixedRowIds.contains(detailRow.getString("detailrowid")));
    }

    private boolean checkSchemeIfValid(VchAmortService service) {
        int vchNumberInScheme;
        int vchNumber = service.getVchNumberHasGen();
        return vchNumber == (vchNumberInScheme = service.getVchNumberHasGenByScheme());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject data : dataEntities = e.getDataEntities()) {
            DynamicObjectCollection targetAccounts = data.getDynamicObjectCollection("targetaccounts");
            for (DynamicObject account : targetAccounts) {
                String rowId = account.getString("targetrowid");
                DynamicObject assgrpDyn = this.queryFinalProcessAssgrpDyn(rowId, data.getLong("org_id"));
                if (assgrpDyn == null) continue;
                String desc = AmortSaveOp.getDesc(assgrpDyn.getDynamicObjectCollection("entryentity"));
                account.set("targetassgrp", (Object)desc);
            }
            DynamicObjectCollection destAccounts = data.getDynamicObjectCollection("destaccounts");
            for (DynamicObject account : destAccounts) {
                String rowId = account.getString("destrowid");
                DynamicObject assgrpDyn = this.queryFinalProcessAssgrpDyn(rowId, data.getLong("org_id"));
                if (assgrpDyn == null) continue;
                String desc = AmortSaveOp.getDesc(assgrpDyn.getDynamicObjectCollection("entryentity"));
                account.set("destassgrp", (Object)desc);
            }
        }
    }

    private DynamicObject queryFinalProcessAssgrpDyn(String rowId, Long orgId) {
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter(ASSGRP_ROW, "=", (Object)rowId)};
        return BusinessDataServiceHelper.loadSingleFromCache((String)"gl_finalprocess_assgrp", (QFilter[])filters);
    }

    protected static String getDesc(DynamicObjectCollection entries) {
        String substring;
        StringBuilder sb = new StringBuilder();
        for (DynamicObject row : entries) {
            if (sb.length() > 50) break;
            String name = row.getString("fieldname.name");
            sb.append(name);
            sb.append("\uff1a");
            String value = "";
            String type = row.getString("fieldname.valuetype");
            String dispPropTemp = "";
            String disprops = row.getString("fieldname.disprops");
            if (kd.bos.util.StringUtils.isNotEmpty((String)disprops)) {
                JSONObject jsonObject = JSONObject.parseObject((String)disprops);
                dispPropTemp = jsonObject.getJSONObject("disp").getString("dispprop");
            }
            String dispProp = dispPropTemp;
            if ("3".equals(type)) {
                String txtval = row.getString(TXTVAL);
                if (txtval != null) {
                    value = txtval = txtval.replaceAll(";", "\uff0c");
                }
            } else {
                List ids;
                String entityId = null;
                String nameProp = "name";
                String numProp = "number";
                if ("1".equals(type)) {
                    entityId = row.getString("fieldname.valuesource.id");
                    BasedataEntityType entityType = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)entityId);
                    nameProp = entityType.getNameProperty();
                    numProp = entityType.getNumberProperty();
                } else if ("2".equals(type)) {
                    entityId = "bos_assistantdata_detail";
                }
                if (StringUtils.isNotBlank((CharSequence)entityId) && !(ids = row.getDynamicObjectCollection(VALUE).stream().map(x -> x.getLong("fbasedataid_id")).collect(Collectors.toList())).isEmpty()) {
                    Map valsFormDb = BusinessDataServiceHelper.loadFromCache((String)entityId, (String)(numProp + "," + nameProp), (QFilter[])new QFilter("id", "in", ids).toArray());
                    String finalNumProp = numProp;
                    String finalNameProp = nameProp;
                    List vals = valsFormDb.values().stream().map(x -> {
                        if ("1".equals(dispProp)) {
                            return x.getString(finalNumProp);
                        }
                        if ("3".equals(dispProp)) {
                            return x.getString(finalNumProp) + "-" + x.getString(finalNameProp);
                        }
                        return x.getString(finalNameProp);
                    }).collect(Collectors.toList());
                    if (!vals.isEmpty()) {
                        value = String.join((CharSequence)"\uff0c", vals);
                    }
                }
            }
            sb.append(value);
            sb.append("\uff1b");
        }
        if ((substring = sb.substring(0, Math.min(sb.length(), 50))).endsWith("\uff1b")) {
            substring = substring.substring(0, substring.length() - 1);
        }
        return substring;
    }
}

