/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.finalprocessing.operateservice;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.Row;
import kd.fi.bd.business.vo.LocalCurrencyConfigVO;
import kd.fi.bd.consts.MCT;
import kd.fi.gl.common.VoucherEntryInfo;
import kd.fi.gl.finalprocessing.info.ExchangeRateType;
import kd.fi.gl.finalprocessing.info.TransPLProgramInfo;
import kd.fi.gl.finalprocessing.operateservice.IBalanceDTO;

public class MulLocalBalanceDTO
implements IBalanceDTO {
    private final Map<String, BigDecimal> mulLocalBalance = new HashMap<String, BigDecimal>();
    Collection<LocalCurrencyConfigVO> localCurrencyConfig;

    public MulLocalBalanceDTO(Collection<LocalCurrencyConfigVO> localCurrencyConfig) {
        this.localCurrencyConfig = localCurrencyConfig;
    }

    @Override
    public void init(Row balanceRow) {
        for (LocalCurrencyConfigVO configVO : this.localCurrencyConfig) {
            String balanceField = configVO.getBalanceField(MCT.END).getMetaId();
            this.mulLocalBalance.put(balanceField, balanceRow.getBigDecimal(balanceField));
        }
    }

    @Override
    public String getSumKey() {
        return "";
    }

    @Override
    public boolean needGenVchEntry() {
        boolean notZero = false;
        for (BigDecimal value : this.mulLocalBalance.values()) {
            if (BigDecimal.ZERO.compareTo(value) == 0) continue;
            notZero = true;
            break;
        }
        return notZero;
    }

    @Override
    public Map<String, BigDecimal> getSumMap() {
        return this.mulLocalBalance;
    }

    @Override
    public void fillVchEntry(TransPLProgramInfo info, VoucherEntryInfo preEntry) {
        BigDecimal baseCurAmt = preEntry.getlocAmt();
        BigDecimal mulCurAmt = BigDecimal.ZERO;
        long orgId = info.getOrgId();
        long bookTypeId = info.getAccountBookInfo().getBookTypeId();
        long baseCurId = info.getBaseCurrencyId();
        Date curPeriodEndDate = info.getCurPeriodEndDate();
        for (LocalCurrencyConfigVO config : this.localCurrencyConfig) {
            String balanceField = config.getBalanceField(MCT.END).getMetaId();
            mulCurAmt = this.mulLocalBalance.get(balanceField);
            String debitField = config.getVoucherField(MCT.DEBIT).getMetaId();
            String creditField = config.getVoucherField(MCT.CREDIT).getMetaId();
            if (preEntry.getEntryDC() != null) {
                if (!info.isTransPLByBalanceDirection()) {
                    if ("1".equals(preEntry.getEntryDC())) {
                        BigDecimal acctdcBigDecimal = new BigDecimal("-1");
                        mulCurAmt = mulCurAmt.multiply(acctdcBigDecimal);
                    }
                } else if ("1".equals(preEntry.getEntryDC())) {
                    mulCurAmt = mulCurAmt.negate();
                }
                if ("1".equals(preEntry.getEntryDC())) {
                    preEntry.set(debitField, (Object)mulCurAmt);
                    preEntry.set(creditField, (Object)BigDecimal.ZERO);
                } else {
                    preEntry.set(debitField, (Object)BigDecimal.ZERO);
                    preEntry.set(creditField, (Object)mulCurAmt);
                }
            } else if (mulCurAmt.signum() != 0) {
                String entryDc = mulCurAmt.signum() < 0 ? "1" : "-1";
                preEntry.setEntryDC(entryDc);
                if ("1".equals(preEntry.getEntryDC())) {
                    mulCurAmt = mulCurAmt.negate();
                    preEntry.set(debitField, (Object)mulCurAmt);
                    preEntry.set(creditField, (Object)BigDecimal.ZERO);
                } else {
                    preEntry.set(debitField, (Object)BigDecimal.ZERO);
                    preEntry.set(creditField, (Object)mulCurAmt);
                }
            }
            long mulCurId = config.getCurrencyId(orgId, bookTypeId);
            String rateField = config.getVoucherField(MCT.EX_RATE).getMetaId();
            long exRateTableId = config.getExRateTableId(orgId, bookTypeId);
            ExchangeRateType exchangeRateType = new ExchangeRateType(exRateTableId, baseCurId, mulCurId, curPeriodEndDate);
            preEntry.set(rateField, (Object)info.getLex(exchangeRateType, baseCurAmt, mulCurAmt));
        }
    }
}

