/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.finalprocessing.operateservice;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.fi.gl.finalprocessing.info.TransPLProgramInfo;
import kd.fi.gl.util.CommonAssistUtil;

public class YearProfitAcctDTO {
    private Long curId;
    private Long grpId;
    private Long unitId;
    private final String key;
    private final HashMap<String, BigDecimal> amountVal;
    private Map<String, Long> comAssistMap = new HashMap<String, Long>(8);
    private boolean enableComAssist;
    private boolean enableMulCur;

    public YearProfitAcctDTO(String key, HashMap<String, BigDecimal> amountVal) {
        this.key = key;
        this.amountVal = amountVal;
    }

    void init(TransPLProgramInfo info) {
        int startIndex;
        String[] spilt = this.key.split("_");
        this.grpId = info.getAssgrpId() > 0L ? info.getAssgrpId() : Long.valueOf(spilt[0]);
        this.unitId = Long.valueOf(spilt[1]);
        this.curId = Long.valueOf(spilt[2]);
        boolean bl = this.enableComAssist = info.getComAssistCount() > 0;
        if (this.enableComAssist && (startIndex = spilt[0].length() + spilt[1].length() + spilt[2].length() + 3) < this.key.length()) {
            this.comAssistMap = this.parseComAssist(this.key.substring(startIndex));
        }
        this.enableMulCur = !info.getLocalCurrencyConfig().isEmpty();
    }

    private Map<String, Long> parseComAssist(String comAssistKey) {
        HashMap<String, Long> comAssistMap = new HashMap<String, Long>(8);
        String[] comAssistValues = comAssistKey.split("_");
        for (int i = 0; i < comAssistValues.length; ++i) {
            comAssistMap.put(CommonAssistUtil.getComassistField((int)(i + 1)), Long.parseLong(comAssistValues[i]));
        }
        return comAssistMap;
    }

    public boolean needGenVchEntry() {
        for (BigDecimal value : this.amountVal.values()) {
            if (value.signum() == 0) continue;
            return true;
        }
        return false;
    }

    public void add(YearProfitAcctDTO forAdd) {
        for (Map.Entry<String, BigDecimal> entry : forAdd.getAmountVal().entrySet()) {
            this.amountVal.put(entry.getKey(), this.amountVal.getOrDefault(entry.getKey(), BigDecimal.ZERO).add(entry.getValue()));
        }
    }

    public Long getCurId() {
        return this.curId;
    }

    public BigDecimal getLoc() {
        return this.amountVal.getOrDefault("loc", BigDecimal.ZERO);
    }

    public BigDecimal getOrg() {
        return this.amountVal.getOrDefault("org", BigDecimal.ZERO);
    }

    public BigDecimal getQty() {
        return this.amountVal.getOrDefault("qty", BigDecimal.ZERO);
    }

    public Long getGrpId() {
        return this.grpId;
    }

    public Long getUnitId() {
        return this.unitId;
    }

    public Map<String, Long> getComAssistMap() {
        return this.comAssistMap;
    }

    public boolean isEnableComAssist() {
        return this.enableComAssist;
    }

    public boolean isEnableMulCur() {
        return this.enableMulCur;
    }

    public HashMap<String, BigDecimal> getAmountVal() {
        return this.amountVal;
    }
}

