/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.finalprocessing.parser.autotrans;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.gl.autotrans.FinalProcessAssgrp;
import kd.fi.gl.finalprocessing.info.AutoTransGenVchInfo;
import kd.fi.gl.finalprocessing.parser.autotrans.AbstractAutoTransExpParser;
import kd.fi.gl.finalprocessing.parser.result.AutoTransDataFormula;
import kd.fi.gl.util.CommonAssistUtil;

public class AutoTransFormulaValueParser
extends AbstractAutoTransExpParser<Map<String, AutoTransDataFormula>> {
    public AutoTransFormulaValueParser(AutoTransGenVchInfo schemeInfo) {
        super(schemeInfo);
    }

    @Override
    public Map<String, AutoTransDataFormula> parse() {
        ArrayList<String> rowIds = new ArrayList<String>(this.entries.size());
        for (DynamicObject row : this.entries) {
            String dataType;
            switch (dataType = row.getString("datasourcetype")) {
                case "6": 
                case "5": {
                    rowIds.add(row.getString("autorowid"));
                }
            }
        }
        QFilter orgFilter = new QFilter("org", "=", (Object)this.accountBookInfo.getOrgId());
        QFilter rowFilter = new QFilter("autorowid", "in", rowIds);
        StringBuilder selectFields = new StringBuilder("autorowid, account.id, assgrp.id, assgrp.value, currency.id, unit.id, qty, amounttype, periodrange");
        int comAssistCount = this.schemeInfo.getComAssistCount();
        for (int index = 0; index < comAssistCount; ++index) {
            selectFields.append(", ").append(CommonAssistUtil.getComassistField((int)(index + 1)));
        }
        DynamicObject[] formulaDyns = BusinessDataServiceHelper.load((String)"gl_autotransexpression", (String)selectFields.toString(), (QFilter[])new QFilter[]{orgFilter, rowFilter});
        HashMap<String, AutoTransDataFormula> result = new HashMap<String, AutoTransDataFormula>(formulaDyns.length);
        for (DynamicObject formulaDyn : formulaDyns) {
            String locAmountKey = null;
            String oriAmountKey = null;
            String amountType = formulaDyn.getString("amounttype");
            if ("2".equals(amountType)) {
                locAmountKey = "debitlocal";
                oriAmountKey = "debitfor";
            } else if ("3".equals(amountType)) {
                locAmountKey = "creditlocal";
                oriAmountKey = "creditfor";
            } else {
                locAmountKey = "endlocal";
                oriAmountKey = "endfor";
            }
            String assgrpJsonVal = formulaDyn.getString("assgrp.value");
            FinalProcessAssgrp finalProcessAssgrp = FinalProcessAssgrp.create((String)assgrpJsonVal);
            DataSet hgIdSet = null;
            if (finalProcessAssgrp != null) {
                hgIdSet = finalProcessAssgrp.getHgIdSet();
            }
            HashMap<Integer, Set<Long>> comAssistIdsMap = new HashMap<Integer, Set<Long>>(8);
            for (int index = 0; index < comAssistCount; ++index) {
                Set comAssistIdSet = formulaDyn.getDynamicObjectCollection(CommonAssistUtil.getComassistField((int)(index + 1))).stream().map(value -> value.getLong("fbasedataid_id")).collect(Collectors.toSet());
                comAssistIdsMap.put(index + 1, comAssistIdSet);
            }
            result.put(formulaDyn.getString("autorowid"), new AutoTransDataFormula(formulaDyn.getLong("account.id"), formulaDyn.getLong("assgrp.id"), hgIdSet, formulaDyn.getLong("currency.id"), formulaDyn.getLong("unit.id"), formulaDyn.getBigDecimal("qty"), locAmountKey, oriAmountKey, formulaDyn.getString("periodrange"), comAssistIdsMap));
        }
        return result;
    }
}

