/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.finalprocessing.parser.autotrans;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.gl.autotrans.PercentExpBuilder;
import kd.fi.gl.autotrans.PercentExpObject;
import kd.fi.gl.finalprocessing.info.AutoTransGenVchInfo;
import kd.fi.gl.finalprocessing.parser.autotrans.AbstractAutoTransExpParser;

public class AutoTransPercentExpParser
extends AbstractAutoTransExpParser<Map<String, BigDecimal>> {
    public AutoTransPercentExpParser(AutoTransGenVchInfo schemeInfo) {
        super(schemeInfo);
    }

    @Override
    public Map<String, BigDecimal> parse() {
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>(this.entries.size());
        HashMap<Long, String> pks = new HashMap<Long, String>(this.entries.size());
        for (DynamicObject row : this.entries) {
            String type = row.getString("percenttype");
            String rowId = row.getString("autorowid");
            if ("1".equals(type)) {
                long expPk = row.getLong("percentexp");
                if (expPk <= 0L) continue;
                pks.put(expPk, rowId);
                continue;
            }
            String replace = row.getString("percent").replace("%", "");
            if (!StringUtils.isNotBlank((CharSequence)replace)) continue;
            BigDecimal percent = new BigDecimal(replace).multiply(new BigDecimal("0.01"));
            result.put(rowId, percent);
        }
        if (!pks.isEmpty()) {
            Map chcheObjs = BusinessDataServiceHelper.loadFromCache((Object[])pks.keySet().toArray(), (String)"gl_autotrans_percent");
            for (Map.Entry expBill : chcheObjs.entrySet()) {
                Object key = expBill.getKey();
                Long id = Long.valueOf(key.toString());
                PercentExpObject expObject = PercentExpObject.create((DynamicObject)((DynamicObject)expBill.getValue()));
                PercentExpBuilder builder = PercentExpBuilder.create((PercentExpObject)expObject);
                BigDecimal val = builder.build(Boolean.TRUE.booleanValue(), this.schemeInfo.getCurPeriodId().longValue());
                result.put((String)pks.get(id), val);
            }
        }
        return result;
    }
}

