/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.finalprocessing.validate;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.finalprocess.service.AbstractEndingProcessingService;
import kd.fi.gl.finalprocessing.util.GenVchUtil;
import kd.fi.gl.finalprocessing.validate.FinalProcessingGenVchValidator;
import kd.fi.gl.util.AccountUtils;
import kd.fi.gl.util.QFBuilder;
import kd.fi.gl.util.ValidateUtils;

public class AdjustExchangeRateViewGenVchValidator
extends FinalProcessingGenVchValidator {
    public AdjustExchangeRateViewGenVchValidator(String org, String bookstype) {
        super(org, bookstype);
    }

    @Override
    protected AbstractEndingProcessingService getEndingProcessService(DynamicObject dataEntity) {
        return null;
    }

    @Override
    public String[] check(DynamicObject db, AccountBookInfo accountBookInfo) {
        List<String> acctAvailableInfo;
        ArrayList<String> checkList = new ArrayList<String>();
        String errMessage = GenVchUtil.checkHasTempVch(db, accountBookInfo, this.specifiedPeriodId);
        if (!StringUtils.isEmpty((String)errMessage)) {
            checkList.add(errMessage);
        }
        if (!(acctAvailableInfo = this.checkIfAcctIsAvailable(db)).isEmpty()) {
            checkList.addAll(acctAvailableInfo);
            return checkList.toArray(new String[0]);
        }
        if (!this.checkCanAdjRate(db, accountBookInfo)) {
            checkList.add(ResManager.loadKDString((String)"\u65e0\u5f85\u8c03\u6c47\u79d1\u76ee\u3002", (String)"AdjustExchangeRateViewGenVchValidator_0", (String)"fi-gl-opplugin", (Object[])new Object[0]));
        }
        if ("2".equals(db.getString("voucherdatetype")) && !this.checkDate(accountBookInfo)) {
            checkList.add(ResManager.loadKDString((String)"\u7cfb\u7edf\u65e5\u671f\u5c0f\u4e8e\u5f53\u524d\u671f\u95f4\u5f00\u59cb\u65e5\u671f\uff0c\u65e0\u6cd5\u751f\u6210\u51ed\u8bc1\u3002", (String)"AdjustExchangeRateViewGenVchValidator_1", (String)"fi-gl-opplugin", (Object[])new Object[0]));
        }
        return checkList.toArray(new String[0]);
    }

    private boolean checkDate(AccountBookInfo accountBookInfo) {
        DynamicObject curPeriod = BusinessDataServiceHelper.loadSingleFromCache((Object)accountBookInfo.getCurPeriodId(this.specifiedPeriodId), (String)"bd_period");
        return new Date().compareTo((Date)curPeriod.get("begindate")) >= 0;
    }

    protected boolean checkCanAdjRate(DynamicObject adjustexchangerate, AccountBookInfo accountBookInfo) {
        Set<Long> list = this.getAcctID(adjustexchangerate, accountBookInfo);
        return !list.isEmpty();
    }

    private Set<Long> getAcctID(DynamicObject adjRateInfo, AccountBookInfo books) {
        HashSet<Long> accountIdSet = new HashSet<Long>();
        String setaccountgroup = adjRateInfo.getString("setaccountgroup");
        if ("1".equals(setaccountgroup)) {
            long orgId = books.getOrgId();
            long bookTypeId = books.getBookTypeId();
            long curPeriodAccountTableId = AccSysUtil.getCurPeriodAccountTableId((long)orgId, (long)bookTypeId, (long)this.specifiedPeriodId);
            QFBuilder accountFilter = AccountUtils.getAccountFilter((long)orgId, (long)curPeriodAccountTableId, (long)this.specifiedPeriodId, (boolean)Boolean.FALSE, (QFilter)new QFilter("ischangecurrency", "=", (Object)"1"));
            try (DataSet res = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_accountview", (String)"id", (QFilter[])accountFilter.toArray(), null);){
                for (Row row : res) {
                    accountIdSet.add(row.getLong("id"));
                }
            }
        } else {
            DynamicObjectCollection aeAccColl = (DynamicObjectCollection)adjRateInfo.get("accountentry");
            if (aeAccColl != null && !aeAccColl.isEmpty()) {
                int j = aeAccColl.size();
                for (int i = 0; i < j; ++i) {
                    DynamicObject info = (DynamicObject)aeAccColl.get(i);
                    accountIdSet.add((Long)info.getDynamicObject("accountid").getPkValue());
                }
            }
        }
        return accountIdSet;
    }

    private List<String> checkIfAcctIsAvailable(DynamicObject adjustexchangerate) {
        Tuple plAcctTuple = Tuple.create((Object)adjustexchangerate.getDynamicObject("placcountid"), (Object)ResManager.loadKDString((String)"\u6c47\u5151\u635f\u76ca\u79d1\u76ee", (String)"AdjustExchangeRateViewGenVchValidator_4", (String)"fi-gl-opplugin", (Object[])new Object[0]));
        Tuple pAcctTuple = Tuple.create((Object)adjustexchangerate.getDynamicObject("placcountid"), (Object)ResManager.loadKDString((String)"\u6c47\u5151\u6536\u76ca\u79d1\u76ee", (String)"AdjustExchangeRateViewGenVchValidator_5", (String)"fi-gl-opplugin", (Object[])new Object[0]));
        Tuple lAcctTuple = Tuple.create((Object)adjustexchangerate.getDynamicObject("placcountid"), (Object)ResManager.loadKDString((String)"\u6c47\u5151\u635f\u5931\u79d1\u76ee", (String)"AdjustExchangeRateViewGenVchValidator_6", (String)"fi-gl-opplugin", (Object[])new Object[0]));
        Stream<Tuple> entryAcctStream = adjustexchangerate.getDynamicObjectCollection("accountentry").stream().map(entry -> Tuple.create((Object)entry.getDynamicObject("accountid"), (Object)String.format(ResManager.loadKDString((String)"\u6307\u5b9a\u79d1\u76ee\u7b2c%s\u884c\u7684\u79d1\u76ee", (String)"AdjustExchangeRateViewGenVchValidator_9", (String)"fi-gl-opplugin", (Object[])new Object[0]), entry.getString("seq"))));
        boolean bypl = adjustexchangerate.getBoolean("bypl");
        if (bypl) {
            return ValidateUtils.validateAcctAvailable(Stream.concat(entryAcctStream, Stream.of(pAcctTuple, lAcctTuple)));
        }
        return ValidateUtils.validateAcctAvailable(Stream.concat(entryAcctStream, Stream.of(plAcctTuple)));
    }
}

