/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.finalprocessing.validate;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.finalprocess.info.scheme.AutoTransScheme;
import kd.fi.gl.finalprocess.service.AbstractEndingProcessingService;
import kd.fi.gl.finalprocess.service.impl.AutoTransService;
import kd.fi.gl.finalprocessing.validate.FinalProcessingGenVchValidator;
import kd.fi.gl.util.FinalProcessUtil;

public class AutoTransGenVchValidator
extends FinalProcessingGenVchValidator {
    public AutoTransGenVchValidator(String org, String bookstype) {
        super(org, bookstype);
    }

    @Override
    protected AbstractEndingProcessingService getEndingProcessService(DynamicObject dataEntity) {
        return new AutoTransService(new AutoTransScheme(dataEntity));
    }

    @Override
    public String[] check(DynamicObject autoTransParam, AccountBookInfo accountBookInfo) {
        ArrayList<String> errList = new ArrayList<String>();
        if (accountBookInfo == null) {
            errList.add(FinalProcessUtil.formatOrgBookMessage((DynamicObject)autoTransParam, (String)ResManager.loadKDString((String)"\u751f\u6210\u51ed\u8bc1\u5931\u8d25\uff0c\u672a\u83b7\u53d6\u5230\u76f8\u5e94\u7684\u6570\u636e\u3002", (String)"AutoTransGenVchValidator_0", (String)"fi-gl-opplugin", (Object[])new Object[0])));
            return errList.toArray(new String[0]);
        }
        String billStatus = autoTransParam.getString("billstatus");
        if ("D".equals(billStatus)) {
            errList.add(FinalProcessUtil.formatOrgBookMessage((DynamicObject)autoTransParam, (String)ResManager.loadKDString((String)"\u751f\u6210\u51ed\u8bc1\u5931\u8d25\uff0c\u8be5\u65b9\u6848\u5df2\u88ab\u7981\u7528\u3002", (String)"AutoTransGenVchValidator_1", (String)"fi-gl-opplugin", (Object[])new Object[0])));
            return errList.toArray(new String[0]);
        }
        long autoId = autoTransParam.getLong("id");
        long curPeriodId = accountBookInfo.getCurPeriodId(this.specifiedPeriodId);
        QFilter fautoId = new QFilter("srcentity", "=", (Object)autoId);
        QFilter fperiod = new QFilter("period", "=", (Object)curPeriodId);
        DynamicObjectCollection voucherIdsColl = QueryServiceHelper.query((String)"gl_voucherrelation", (String)"targentity", (QFilter[])new QFilter[]{fautoId, fperiod});
        ArrayList<Long> voucherIds = new ArrayList<Long>();
        for (DynamicObject dyn : voucherIdsColl) {
            voucherIds.add(dyn.getLong("targentity"));
        }
        QFilter fvoucherIds = new QFilter("id", "in", voucherIds);
        DynamicObjectCollection voucherColl = QueryServiceHelper.query((String)"gl_voucher", (String)"billstatus", (QFilter[])new QFilter[]{fvoucherIds});
        boolean isSave = false;
        for (DynamicObject voucherDyn : voucherColl) {
            if (!"A".equalsIgnoreCase(voucherDyn.getString("billstatus"))) continue;
            isSave = true;
        }
        if (isSave) {
            errList.add(FinalProcessUtil.formatOrgBookMessage((DynamicObject)autoTransParam, (String)ResManager.loadKDString((String)"\u8be5\u65b9\u6848\u5df2\u751f\u6210\u6682\u5b58\u51ed\u8bc1\uff0c\u8bf7\u63d0\u4ea4\u6216\u5220\u9664\u6682\u5b58\u51ed\u8bc1\uff0c\u65b9\u53ef\u518d\u751f\u6210\u51ed\u8bc1\u3002", (String)"AutoTransGenVchValidator_2", (String)"fi-gl-opplugin", (Object[])new Object[0])));
            return errList.toArray(new String[0]);
        }
        DynamicObjectCollection accts = autoTransParam.getDynamicObjectCollection("autotransentry");
        for (DynamicObject dynamicObject : accts) {
            DynamicObject acct = dynamicObject.getDynamicObject("accountid");
            if (acct == null) {
                errList.add(FinalProcessUtil.formatOrgBookMessage((DynamicObject)autoTransParam, (String)ResManager.loadKDString((String)"\u751f\u6210\u51ed\u8bc1\u5931\u8d25\uff0c\u81ea\u52a8\u8f6c\u8d26\u7684\u4f1a\u8ba1\u79d1\u76ee\u4e22\u5931\uff0c\u8bf7\u91cd\u65b0\u7f16\u8f91\u3002", (String)"AutoTransGenVchValidator_3", (String)"fi-gl-opplugin", (Object[])new Object[0])));
                return errList.toArray(new String[0]);
            }
            if ("0".equals(acct.getString("enable"))) {
                errList.add(FinalProcessUtil.formatOrgBookMessage((DynamicObject)autoTransParam, (String)ResManager.loadKDString((String)"\u751f\u6210\u51ed\u8bc1\u5931\u8d25\uff0c\u81ea\u52a8\u8f6c\u8d26\u8868\u4e2d\u5f15\u7528\u4e86\u88ab\u7981\u7528\u7684\u4f1a\u8ba1\u79d1\u76ee\u3002", (String)"AutoTransGenVchValidator_4", (String)"fi-gl-opplugin", (Object[])new Object[0])));
                return errList.toArray(new String[0]);
            }
            DynamicObjectCollection checkItemEntrys = acct.getDynamicObjectCollection("checkitementry");
            for (DynamicObject aEntry : checkItemEntrys) {
                String itemEnable;
                long itemId = Long.parseLong(aEntry.getString("asstactitem_id"));
                DynamicObject item = QueryServiceHelper.queryOne((String)"bd_asstacttype", (String)"enable", (QFilter[])new QFilter("id", "=", (Object)itemId).toArray());
                if (item == null || !"0".equals(itemEnable = item.getString("enable"))) continue;
                errList.add(FinalProcessUtil.formatOrgBookMessage((DynamicObject)autoTransParam, (String)ResManager.loadKDString((String)"\u751f\u6210\u51ed\u8bc1\u5931\u8d25\uff0c\u5f15\u7528\u7684\u4f1a\u8ba1\u79d1\u76ee\u4e2d\u5b58\u5728\u88ab\u7981\u7528\u7684\u6838\u7b97\u7ef4\u5ea6\u3002", (String)"AutoTransGenVchValidator_5", (String)"fi-gl-opplugin", (Object[])new Object[0])));
                return errList.toArray(new String[0]);
            }
        }
        return errList.toArray(new String[0]);
    }
}

