/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.notice;

import java.util.HashMap;
import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.ext.fi.ai.v2.fah.dto.BillToVchRelationDto;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.business.GLServiceFactory;
import kd.fi.gl.common.Tuple;
import kd.fi.gl.interfaces.service.dap.IDAPService;

public class NoticeGenerateVoucherValidator
extends AbstractValidator {
    private static IDAPService getDAPService() {
        return (IDAPService)GLServiceFactory.getService(IDAPService.class);
    }

    public void validate() {
        HashSet<Object> acNoticeIds = new HashSet<Object>(16);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            Object billPkId = dataEntity.getBillPkId();
            acNoticeIds.add(billPkId);
        }
        HashSet<Long> excludeIds = new HashSet<Long>(16);
        HashSet<Long> voucherIds = new HashSet<Long>(16);
        HashMap<Long, Tuple> notice2VchId2ReciOrgMap = new HashMap<Long, Tuple>(16);
        QFilter idQF = new QFilter("id", "in", acNoticeIds);
        try (DataSet noticeDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_acnotice", (String)"id,noticetype,checkstatus,voucher,receiveorg", (QFilter[])new QFilter[]{idQF}, null);){
            for (Row row : noticeDataSet) {
                Long noticeId = row.getLong("id");
                String noticetype = row.getString("noticetype");
                String checkstatus = row.getString("checkstatus");
                Long voucherId = row.getLong("voucher");
                if ("1".equals(noticetype) || "1".equals(checkstatus)) {
                    excludeIds.add(noticeId);
                    continue;
                }
                voucherIds.add(voucherId);
                notice2VchId2ReciOrgMap.put(noticeId, new Tuple((Object)voucherId, (Object)row.getLong("receiveorg")));
            }
        }
        HashMap<Long, Long> vch2SourceBillIdMap = new HashMap<Long, Long>(16);
        BillToVchRelationDto voucherRelations = NoticeGenerateVoucherValidator.getDAPService().getBillToVchReDtoByBillTypeVchIDSet("gl_acnotice", voucherIds);
        for (BillToVchRelationDto.BillToVoucherRelation bill : voucherRelations) {
            vch2SourceBillIdMap.put(bill.getVoucherId(), bill.getBillId());
        }
        HashMap<Long, Long> sourceAc2SendOrgMap = new HashMap<Long, Long>(16);
        QFilter sourceNoticeIdQF = new QFilter("id", "in", vch2SourceBillIdMap.values());
        try (DataSet sourceNoticeDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_acnotice", (String)"id,sendorg", (QFilter[])new QFilter[]{sourceNoticeIdQF}, null);){
            for (Row row : sourceNoticeDataSet) {
                sourceAc2SendOrgMap.put(row.getLong("id"), row.getLong("sendorg"));
            }
        }
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            Object billPkId = dataEntity.getBillPkId();
            Tuple vchAndReceiveOrgTuple = (Tuple)notice2VchId2ReciOrgMap.get(billPkId);
            if (excludeIds.contains(billPkId)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u901a\u77e5\u5355\u7c7b\u578b\u4e3a\u53d1\u9001\u6216\u8005\u5df2\u52fe\u7a3d\u7684\u901a\u77e5\u5355\u4e0d\u80fd\u751f\u6210\u51ed\u8bc1\u3002", (String)"NoticeGenerateVoucherOp_1", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (vchAndReceiveOrgTuple == null || vch2SourceBillIdMap.get(vchAndReceiveOrgTuple.item1) == null) continue;
            Long noticeVchId = (Long)vchAndReceiveOrgTuple.item1;
            Long receiveOrg = (Long)vchAndReceiveOrgTuple.item2;
            Long sourceBillId = (Long)vch2SourceBillIdMap.get(noticeVchId);
            Long sendorg = (Long)sourceAc2SendOrgMap.get(sourceBillId);
            if (sendorg == null || !sendorg.equals(receiveOrg)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u901a\u77e5\u5355\u5bf9\u5e94\u7684\u51ed\u8bc1\u7531\u901a\u77e5\u5355\u751f\u6210\uff0c\u4e14\u8be5\u901a\u77e5\u5355\u7684\u63a5\u6536\u65b9\u7ec4\u7ec7\u7b49\u4e8e\u751f\u6210\u51ed\u8bc1\u901a\u77e5\u5355\u7684\u53d1\u9001\u65b9\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u751f\u6210\u51ed\u8bc1\u3002", (String)"NoticeGenerateVoucherOp_0", (String)"fi-gl-opplugin", (Object[])new Object[0]));
        }
    }
}

