/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.opplugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.coderule.api.CodeRuleEntryInfo;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.fi.bd.business.service.LocalCurrencyConfigService;
import kd.fi.bd.business.vo.LocalCurrencyConfigVO;
import kd.fi.bd.util.AccountBookUtil;
import kd.fi.bd.util.AccountingSysUtil;
import kd.fi.bd.util.DebugTrace;
import kd.fi.bd.util.PeriodUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.reciprocal.ReciprocalInitUtils;
import kd.fi.gl.util.AccountBookHelper;
import kd.fi.gl.util.CashFlowItemHelper;

public class AccountBookAddValidator
extends AbstractValidator {
    private static final String[] BIZ_CHECK_FIELD = new String[]{"number", "org", "bookstype", "accounttable", "basecurrency", "exratetable", "periodtype", "startperiod", "accountingsys", "curperiod"};
    private static final String[] BASEDATA_CHECK_FIELD = new String[]{"number", "org", "bookstype", "accounttable", "accountingsys"};
    private static final String[] UNBIZ_CHECK_FIELD = new String[]{"accountingsys", "org", "bookstype", "number"};
    private static final String[] NOT_LEAF_ORG_CHECK_FIELD = new String[]{"accountingsys", "org", "bookstype", "startperiod"};
    private static final String BUDGET_GROUP = "PRO_GL_GA";
    private static final Log logger = LogFactory.getLog(AccountBookAddValidator.class);

    public void validate() {
        HashSet<String> numberSet = new HashSet<String>(this.dataEntities.length);
        Map<Long, Boolean> bookIdToBudgetMap = this.getBookIdToBudget();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject accountBook = dataEntity.getDataEntity();
            String number = accountBook.getString("number");
            boolean isAdd = true;
            Object id = accountBook.get("id");
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            long cashflowInitPeriod = dynamicObject.getLong(GLField.id_((String)"cashinitperiod"));
            long curPeriod = dynamicObject.getLong(GLField.id_((String)"curperiod"));
            long startperiod = dynamicObject.getLong(GLField.id_((String)"startperiod"));
            if (curPeriod == 0L && cashflowInitPeriod != 0L) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8d26\u7c3f\u672a\u8bbe\u7f6e\u542f\u7528\u671f\u95f4\uff0c\u65e0\u6cd5\u8bbe\u7f6e\u73b0\u91d1\u6d41\u91cf\u542f\u7528\u671f\u95f4\u3002", (String)"AccountBookAddValidator_3", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (cashflowInitPeriod != 0L && startperiod > cashflowInitPeriod) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u73b0\u91d1\u6d41\u91cf\u542f\u7528\u671f\u95f4\u4e0d\u5f97\u65e9\u4e8e\u8d26\u7c3f\u542f\u7528\u671f\u95f4\u3002", (String)"AccountBookAddValidator_7", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (!this.validateRelateBizEntry(dataEntity, accountBook)) continue;
            if (!this.checkHasLicense(accountBook.getBoolean("isbudget"), bookIdToBudgetMap.getOrDefault(id, false))) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u65e0\u8bb8\u53ef\uff0c\u7981\u6b62\u4fee\u6539\u9884\u7b97\u4f1a\u8ba1\u3002", (String)"AccountBookAddValidator_10", (String)"fi-gl-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            boolean enableMulLocalCurrency = accountBook.getBoolean("enablemullocalcur");
            if (enableMulLocalCurrency) {
                List configVOList = LocalCurrencyConfigService.getCurrencyConfigByEntityId((String)"gl_accountbook");
                List curAndExRateTableFieldList = AccountBookUtil.getCurAndExRateTableFields();
                ArrayList<DynamicObject> curAndExRateTableList = new ArrayList<DynamicObject>(curAndExRateTableFieldList.size());
                for (String field : curAndExRateTableFieldList) {
                    curAndExRateTableList.add(accountBook.getDynamicObject(field));
                }
                if (curAndExRateTableList.stream().allMatch(Objects::isNull)) {
                    StringBuilder tip = new StringBuilder();
                    configVOList.forEach(configVO -> tip.append("\u201c").append(configVO.getName().getLocaleValue()).append("\u201d\u3001"));
                    tip.deleteCharAt(tip.length() - 1);
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u5f00\u542f\u201c\u591a\u672c\u4f4d\u5e01\u6838\u7b97\u201d\uff0c%s\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\u3002", (String)"AccountBookAddValidator_19", (String)"fi-gl-opplugin", (Object[])new Object[]{tip.toString()}));
                    continue;
                }
                for (LocalCurrencyConfigVO configVO2 : configVOList) {
                    DynamicObject currency = accountBook.getDynamicObject(configVO2.getCurrencyField());
                    DynamicObject exRateTable = accountBook.getDynamicObject(configVO2.getExRateField());
                    if ((!Objects.isNull(currency) || !Objects.nonNull(exRateTable)) && (!Objects.nonNull(currency) || !Objects.isNull(exRateTable))) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u591a\u672c\u4f4d\u5e01\u6838\u7b97\u7684\u201c\u672c\u4f4d\u5e01\u201d\u548c\u201c\u6c47\u7387\u8868\u201d\u5fc5\u987b\u540c\u65f6\u6709\u503c\u3002", (String)"AccountBookAddValidator_20", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                    break;
                }
            }
            if (!Objects.isNull(id) && !id.equals(0L)) {
                isAdd = false;
                QFilter qf = new QFilter("id", "=", id);
                DynamicObject record = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"number, isbizunit, cashinitperiod, isendinitcashflow, cashinitperiod.number cashinitperiodnumber", (QFilter[])new QFilter[]{qf});
                if (record != null) {
                    if (record.getBoolean("isbizunit")) {
                        long oldCashflowInitPeriod = record.getLong("cashinitperiod");
                        if (oldCashflowInitPeriod != cashflowInitPeriod) {
                            String msg;
                            long checkPeriod = 0L;
                            if (cashflowInitPeriod == 0L) {
                                checkPeriod = PeriodUtil.MAX_PERIOD;
                            } else if (oldCashflowInitPeriod < cashflowInitPeriod) {
                                checkPeriod = cashflowInitPeriod;
                            }
                            if (record.getBoolean("isendinitcashflow")) {
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u73b0\u91d1\u6d41\u91cf\u521d\u59cb\u5316\u5df2\u7ed3\u675f\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u73b0\u91d1\u6d41\u91cf\u7684\u201c\u542f\u7528\u671f\u95f4\u201d\uff0c\u8bf7\u5148\u53cd\u521d\u59cb\u5316\u73b0\u91d1\u6d41\u91cf\u5e76\u5220\u9664\u201c\u73b0\u91d1\u6d41\u91cf\u521d\u59cb\u5316\u201d\u6570\u636e\u540e\u518d\u8bd5\u3002", (String)"AccountBookAddValidator_5", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                                continue;
                            }
                            if (checkPeriod != 0L && (msg = CashFlowItemHelper.hasCashflowbiz((long)dynamicObject.getLong(GLField.id_((String)"org")), (long)dynamicObject.getLong(GLField.id_((String)"bookstype")), (long)checkPeriod)) != null) {
                                String periodNumber = dynamicObject.get("cashinitperiod") != null ? dynamicObject.getDynamicObject("cashinitperiod").getString("number") : record.getString("cashinitperiodnumber");
                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8d26\u7c3f\u5728%1$s\u671f\u4e4b\u524d%2$s\u3002", (String)"AccountBookAddValidator_6", (String)"fi-gl-opplugin", (Object[])new Object[0]), periodNumber, msg));
                                continue;
                            }
                        }
                        DynamicObject dataObj = BusinessDataServiceHelper.loadSingle((Object)dynamicObject.getLong("id"), (String)"gl_accountbook", (String)"org,bookstype");
                        boolean isRefered = AccountBookHelper.checkAccountBookIsRefered((DynamicObject)dataObj);
                        boolean isInitBalances = this.checkInitBalances(dynamicObject);
                        if (dynamicObject.getBoolean("isendinit") || isInitBalances || AccountBookHelper.checkVoucherRef((DynamicObject)dataObj)) {
                            this.checkIsChangedNotChangeField(dataEntity, BIZ_CHECK_FIELD);
                        } else if (isRefered) {
                            this.checkIsChangedNotChangeField(dataEntity, BASEDATA_CHECK_FIELD);
                        } else {
                            this.checkIsChangedNotChangeField(dataEntity, UNBIZ_CHECK_FIELD);
                        }
                        if (oldCashflowInitPeriod != cashflowInitPeriod) {
                            long lastCurPeriod = dataEntity.getDataEntity().getLong(GLField.id_((String)"curperiod"));
                            if (cashflowInitPeriod != 0L && lastCurPeriod > cashflowInitPeriod) {
                                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u73b0\u91d1\u6d41\u91cf\u542f\u7528\u671f\u95f4\u4e0d\u5f97\u65e9\u4e8e\u8d26\u7c3f\u5f53\u524d\u671f\u95f4\u3002", (String)"AccountBookAddValidator_4", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                            }
                        }
                    } else {
                        this.checkIsChangedNotChangeField(dataEntity, NOT_LEAF_ORG_CHECK_FIELD);
                    }
                    if (AccountBookUtil.isHaveBiz(Collections.singleton((Long)id)) && AccountBookUtil.isChangedMulLocalCurrencyFields((DynamicObject)accountBook)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u4f1a\u8ba1\u8d26\u7c3f\u5df2\u53d1\u751f\u4e1a\u52a1\uff0c\u591a\u672c\u4f4d\u5e01\u76f8\u5173\u7684\u5b57\u6bb5\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"AccountBookAddValidator_18", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    DynamicObject dbData = BusinessDataServiceHelper.loadSingle((Object)id, (String)"gl_accountbook", (String)"number,org,accounttable,basecurrency,periodtype,startperiod,curperiod,cashinitperiod,b_entry.b_app,b_entry.b_relatebook,o_entry.o_app,o_entry.o_relateorg");
                    this.cacheUpdateInfo(dbData, dynamicObject);
                    if (number.equals(record.getString("number"))) {
                        continue;
                    }
                }
            } else if (cashflowInitPeriod != 0L && curPeriod > cashflowInitPeriod) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u73b0\u91d1\u6d41\u91cf\u542f\u7528\u671f\u95f4\u4e0d\u5f97\u65e9\u4e8e\u8d26\u7c3f\u5f53\u524d\u671f\u95f4\u3002", (String)"AccountBookAddValidator_4", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                continue;
            }
            DynamicObjectCollection orgObjects = accountBook.getDynamicObjectCollection("multiplechoiceorg");
            long accountingSysId = accountBook.getLong("accountingsys.id");
            if (!orgObjects.isEmpty()) {
                if (orgObjects.size() > 1) {
                    dataEntity.getDataEntity().set("number", null);
                    continue;
                }
                for (DynamicObject org : orgObjects) {
                    DynamicObject orgObj = (DynamicObject)org.get("fbasedataid");
                    String orgNumber = orgObj.getString("number");
                    Long orgId = orgObj.getLong("id");
                    if (this.checkIsLeafOrg(orgId, accountingSysId) && accountBook.getDynamicObject("startperiod") == null) {
                        this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5b9e\u4f53\u7ec4\u7ec7\u8d26\u7c3f\uff0c\u542f\u7528\u671f\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AccountBookAddValidator_2", (String)"fi-gl-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                        continue;
                    }
                    if (isAdd && this.isExistCodeRuleInfoWithOrg(orgId, accountBook, dataEntity)) {
                        dataEntity.getDataEntity().set("number", null);
                        accountBook.set("org", (Object)orgObj);
                    }
                    this.doNumberValidate(orgNumber, accountBook, dataEntity, true);
                    this.checkOrgInAccountingSys(accountingSysId, orgId, dataEntity);
                }
                continue;
            }
            String orgNumber = accountBook.getDynamicObject("org").getString("number");
            this.doNumberValidate(orgNumber, accountBook, dataEntity, true);
            boolean addSucc = true;
            if (!StringUtils.isEmpty((CharSequence)number)) {
                addSucc = numberSet.add(number);
            }
            if (!addSucc) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u4f1a\u8ba1\u8d26\u7c3f\u7f16\u7801\u91cd\u590d\u3002", (String)"AccountBookAddValidator_0", (String)"fi-gl-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            if (this.checkIsLeafOrg(accountBook.getLong("org_id"), accountingSysId) && accountBook.getDynamicObject("startperiod") == null) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5b9e\u4f53\u7ec4\u7ec7\u8d26\u7c3f\uff0c\u542f\u7528\u671f\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AccountBookAddValidator_2", (String)"fi-gl-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            this.checkOrgInAccountingSys(accountingSysId, accountBook.getLong("org.id"), dataEntity);
        }
    }

    private void cacheUpdateInfo(DynamicObject dbData, DynamicObject dynamicObject) {
        Map<String, Set<Long>> importOrgEntry;
        Map<String, Set<Long>> dbOrgEntry;
        Map<String, Set<Long>> importBookEntry;
        StringBuilder descBuilder = new StringBuilder();
        StringBuilder head = new StringBuilder();
        DataEntityPropertyCollection dataEntityPropertyCollection = dbData.getDataEntityType().getProperties();
        for (IDataEntityProperty dataEntityProperty : dataEntityPropertyCollection) {
            String newValue;
            String oldValue;
            String property = dataEntityProperty.getName();
            if ("number".equals(property)) {
                head.append(String.format(ResManager.loadKDString((String)"\u8d26\u7c3f\u7f16\u7801\uff1a%s", (String)"AccountBookAddValidator_17", (String)"fi-gl-opplugin", (Object[])new Object[0]), dbData.getString(dataEntityProperty.getName())));
                continue;
            }
            if (!(dataEntityProperty instanceof BasedataProp) || (oldValue = dbData.getString(property + "_id")).equals(newValue = dynamicObject.getString(property + "_id"))) continue;
            descBuilder.append(String.format(ResManager.loadKDString((String)"%1$s\uff0c\u5b57\u6bb5%2$s:\u4ece%3$s\u6539\u4e3a%4$s", (String)"AccountBookAddValidator_13", (String)"fi-gl-opplugin", (Object[])new Object[0]), "", ((IDataEntityProperty)dbData.getDataEntityType().getProperties().get((Object)property)).getDisplayName().getLocaleValue(), oldValue, newValue));
        }
        Map<String, Set<Long>> dbBookEntry = this.getBookEntryProp(dbData);
        if (!dbBookEntry.equals(importBookEntry = this.getBookEntryProp(dynamicObject))) {
            descBuilder.append(String.format(ResManager.loadKDString((String)"%1$s\uff0c\u5b57\u6bb5\u5173\u8054\u4e1a\u52a1\u8d26\u7c3f:\u4ece%2$s\u6539\u4e3a%3$s", (String)"AccountBookAddValidator_14", (String)"fi-gl-opplugin", (Object[])new Object[0]), "", dbBookEntry, importBookEntry));
        }
        if (!(dbOrgEntry = AccountBookAddValidator.getOrgEntryProp(dbData)).equals(importOrgEntry = AccountBookAddValidator.getOrgEntryProp(dynamicObject))) {
            descBuilder.append(String.format(ResManager.loadKDString((String)"1$s\uff0c\u5b57\u6bb5\u5173\u8054\u4e1a\u52a1\u7ec4\u7ec7:\u4ece%2$s\u6539\u4e3a%3$s", (String)"AccountBookAddValidator_15", (String)"fi-gl-opplugin", (Object[])new Object[0]), "", dbOrgEntry, importOrgEntry));
        }
        if (StringUtils.isEmpty((CharSequence)descBuilder.toString())) {
            descBuilder.append(ResManager.loadKDString((String)"%s\uff0c\u76f8\u5173\u5b57\u6bb5\u65e0\u53d8\u5316", (String)"AccountBookAddValidator_16", (String)"fi-gl-opplugin", (Object[])new Object[0]));
        }
        head.append((CharSequence)descBuilder);
        Long orgId = dbData.getLong("org_id");
        Tuple value = new Tuple((Object)orgId, (Object)head.toString());
        String key = AccountBookHelper.genCacheKey((Object)dbData.getPkValue());
        ThreadCache.put((Object)key, (Object)value);
    }

    private Map<String, Set<Long>> getBookEntryProp(DynamicObject dynamicObject) {
        HashMap<String, Set<Long>> entryInfoMap = new HashMap<String, Set<Long>>(8);
        DynamicObjectCollection bEntrys = dynamicObject.getDynamicObjectCollection("b_entry");
        for (DynamicObject bEntry : bEntrys) {
            String currAppId = bEntry.getDynamicObject("b_app").getString("id");
            DynamicObjectCollection relateBooks = bEntry.getDynamicObjectCollection("b_relatebook");
            Set currRelateBookIds = relateBooks.stream().map(x -> x.getLong("fbasedataid_id")).collect(Collectors.toSet());
            entryInfoMap.put(currAppId, currRelateBookIds);
        }
        return entryInfoMap;
    }

    public static Map<String, Set<Long>> getOrgEntryProp(DynamicObject dynamicObject) {
        HashMap<String, Set<Long>> entryInfoMap = new HashMap<String, Set<Long>>(8);
        DynamicObjectCollection oEntrys = dynamicObject.getDynamicObjectCollection("o_entry");
        for (DynamicObject bEntry : oEntrys) {
            String currAppId = bEntry.getDynamicObject("o_app").getString("id");
            DynamicObjectCollection relateOrgs = bEntry.getDynamicObjectCollection("o_relateorg");
            Set currRelateBookIds = relateOrgs.stream().map(x -> x.getLong("fbasedataid_id")).collect(Collectors.toSet());
            entryInfoMap.put(currAppId, currRelateBookIds);
        }
        return entryInfoMap;
    }

    private boolean isExistCodeRuleInfoWithOrg(Long orgId, DynamicObject accountBook, ExtendedDataEntity dataEntity) {
        CodeRuleInfo coderule = CodeRuleServiceHelper.getCodeRule((String)"gl_accountbook", (DynamicObject)accountBook, (String)orgId.toString());
        if (null != coderule && !coderule.getRuleEntry().isEmpty()) {
            if (coderule.getIsModifiable().booleanValue()) {
                return false;
            }
            for (CodeRuleEntryInfo codeRuleEntryInfo : coderule.getRuleEntry()) {
                if (StringUtils.isBlank((CharSequence)codeRuleEntryInfo.getValueAtribute()) || codeRuleEntryInfo.getValueAtribute().indexOf("org") == -1) continue;
                return true;
            }
        }
        return false;
    }

    private void doNumberValidate(String orgNumber, DynamicObject accountBook, ExtendedDataEntity dataEntity, boolean isSetNumber) {
        QFilter[] numberFilter;
        DynamicObject obj;
        String number = accountBook.getString("number");
        DynamicObject bookstype = accountBook.getDynamicObject("bookstype");
        if (bookstype == null) {
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d26\u7c3f\u7c7b\u578b\u3002", (String)"AccountBookAddValidator_1", (String)"fi-gl-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
            return;
        }
        String booksTypeNumber = bookstype.getString("number");
        if (StringUtils.isBlank((CharSequence)number)) {
            number = kd.fi.gl.util.AccountBookUtil.getAccountBookNumber(orgNumber, booksTypeNumber, accountBook);
            if (isSetNumber) {
                dataEntity.getDataEntity().set("number", (Object)number);
            }
        }
        if ((obj = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"id", (QFilter[])(numberFilter = new QFilter[]{new QFilter("number", "=", (Object)number)}))) != null) {
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u4f1a\u8ba1\u8d26\u7c3f\u7f16\u7801\u91cd\u590d\u3002", (String)"AccountBookAddValidator_0", (String)"fi-gl-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
        }
    }

    private void checkIsChangedNotChangeField(ExtendedDataEntity dataEntity, String ... checkFields) {
        DynamicObject newAccountBook = dataEntity.getDataEntity();
        DynamicObject oldAccountBook = BusinessDataServiceHelper.loadSingle((Object)newAccountBook.getLong("id"), (String)"gl_accountbook");
        DataEntityPropertyCollection dataEntityProperties = newAccountBook.getDataEntityType().getProperties();
        for (String checkField : checkFields) {
            String oldData;
            String newData;
            if (dataEntityProperties.get((Object)checkField) instanceof BasedataProp) {
                newData = newAccountBook.getDynamicObject(checkField) == null ? "" : newAccountBook.getDynamicObject(checkField).getString("id");
                oldData = oldAccountBook.getDynamicObject(checkField) == null ? "" : oldAccountBook.getDynamicObject(checkField).getString("id");
            } else {
                newData = newAccountBook.getString(checkField);
                oldData = oldAccountBook.getString(checkField);
            }
            if (DebugTrace.enable()) {
                logger.info("checkField:{},newData:{},oldData:{}", new Object[]{checkField, newData, oldData});
            }
            if (!(StringUtils.isEmpty((CharSequence)newData) && StringUtils.isNotEmpty((CharSequence)oldData) || StringUtils.isNotEmpty((CharSequence)newData) && StringUtils.isEmpty((CharSequence)oldData)) && (!StringUtils.isNotEmpty((CharSequence)newData) || newData.equals(oldData))) continue;
            if ("curperiod".equals(checkField)) {
                newAccountBook.set("curperiod", oldAccountBook.get("curperiod"));
                continue;
            }
            this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u88ab\u4fee\u6539\u3002", (String)"AccountBookAddValidator_12", (String)"fi-gl-opplugin", (Object[])new Object[0]), ((IDataEntityProperty)newAccountBook.getDataEntityType().getProperties().get((Object)checkField)).getDisplayName().getLocaleValue()), ErrorLevel.Error);
        }
    }

    private boolean checkInitBalances(DynamicObject dynamicObject) {
        QFilter typeQF = new QFilter("booktype", "=", (Object)dynamicObject.getLong("bookstype_id"));
        QFilter orgQF = new QFilter("org", "=", (Object)dynamicObject.getLong("org_id"));
        QFilter delQF = new QFilter("isdeleted", "=", (Object)false);
        boolean isInit = QueryServiceHelper.exists((String)"gl_initbalance", (QFilter[])new QFilter[]{typeQF, orgQF, delQF});
        AccountBookInfo bookInfo = new AccountBookInfo(dynamicObject.getLong("id"));
        DataSet ds = ReciprocalInitUtils.queryAllEndInitReciprocalInit((Long)bookInfo.getOrgId(), (Long)bookInfo.getBookTypeId(), (Long)bookInfo.getAccountTableId());
        HashMap<String, Long> booktypeIdMap = new HashMap<String, Long>(1);
        booktypeIdMap.put("var", bookInfo.getBookTypeId());
        ds = ds.filter("isendinit != null and booktype = var", booktypeIdMap);
        return isInit || ds.hasNext();
    }

    private boolean checkIsLeafOrg(long orgId, long accountingSysId) {
        DynamicObject addview = BusinessDataServiceHelper.loadSingle((String)"bd_accountingsysviewsch", (String)"id", (QFilter[])new QFilter[]{new QFilter("accountingsys", "=", (Object)accountingSysId), new QFilter("ismainview", "=", (Object)true)});
        return QueryServiceHelper.exists((String)"bos_org_structure", (QFilter[])new QFilter[]{new QFilter("view", "=", addview.get("id")), new QFilter("isleaf", "=", (Object)true), new QFilter("org", "=", (Object)orgId)});
    }

    private boolean validateRelateBizEntry(ExtendedDataEntity dataEntity, DynamicObject accountBook) {
        DynamicObjectCollection oEntry;
        DynamicObjectCollection bEntry = accountBook.getDynamicObjectCollection("b_entry");
        if (bEntry != null && !bEntry.isEmpty()) {
            for (int i = 0; i < bEntry.size(); ++i) {
                DynamicObject row = (DynamicObject)bEntry.get(i);
                DynamicObjectCollection relateCols = row.getDynamicObjectCollection("b_relatebook");
                if (relateCols != null && !relateCols.isEmpty()) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7b2c%s\u884c\u5173\u8054\u4e1a\u52a1\u8d26\u7c3f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AccountBookAddValidator_8", (String)"fi-gl-opplugin", (Object[])new Object[]{i + 1}));
                return false;
            }
        }
        if ((oEntry = accountBook.getDynamicObjectCollection("o_entry")) != null && !oEntry.isEmpty()) {
            for (int i = 0; i < oEntry.size(); ++i) {
                DynamicObject row = (DynamicObject)oEntry.get(i);
                DynamicObjectCollection relateCols = row.getDynamicObjectCollection("o_relateorg");
                if (relateCols != null && !relateCols.isEmpty()) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7b2c%s\u884c\u5173\u8054\u4e1a\u52a1\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AccountBookAddValidator_9", (String)"fi-gl-opplugin", (Object[])new Object[]{i + 1}));
                return false;
            }
        }
        return true;
    }

    private Map<Long, Boolean> getBookIdToBudget() {
        HashSet<Long> accountBookIdSet = new HashSet<Long>(this.dataEntities.length);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            accountBookIdSet.add(dataEntity.getDataEntity().getLong("id"));
        }
        HashMap<Long, Boolean> bookIdToBudgetMap = new HashMap<Long, Boolean>(this.dataEntities.length);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_accountbook", (String)"id, isbudget", (QFilter[])new QFilter[]{new QFilter("id", "in", accountBookIdSet)}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                bookIdToBudgetMap.put(row.getLong("id"), row.getBoolean("isbudget"));
            }
        }
        return bookIdToBudgetMap;
    }

    private boolean checkHasLicense(boolean newBudget, boolean oldBudget) {
        return newBudget == oldBudget || LicenseServiceHelper.checkPerformGroup((String)BUDGET_GROUP).getHasLicense() != false;
    }

    private void checkOrgInAccountingSys(long accountingSysId, long orgId, ExtendedDataEntity dataEntity) {
        if (!AccountingSysUtil.checkOrgInAccountingSys((long)accountingSysId, (long)orgId)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0d\u5728\u6838\u7b97\u4f53\u7cfb\u5bf9\u5e94\u7684\u89c6\u56fe\u4e2d\u3002", (String)"AccountBookAddValidator_21", (String)"fi-gl-opplugin", (Object[])new Object[0]));
        }
    }
}

