/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.opplugin;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.bd.util.AccountUtils;
import kd.fi.bd.util.AccountVersionUtil;
import kd.fi.bd.util.BatchProcessUtil;
import kd.fi.gl.balance.CalculatorFactory;
import kd.fi.gl.balance.ICalculator;
import kd.fi.gl.lock.Lock;
import kd.fi.gl.lock.LockKey;
import kd.fi.gl.opplugin.CloseInitBalanceOp;
import kd.fi.gl.util.FlexUtils;

public class BalanceRecalByAccountAssistFixAddOp
extends AbstractOperationServicePlugIn {
    private Log logger = LogFactory.getLog(BalanceRecalByAccountAssistFixAddOp.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
                    QFilter q2;
                    QFilter q1;
                    DynamicObject orgObj;
                    DynamicObject dataEntity = extendedDataEntity.getDataEntity();
                    DynamicObject accounttable = dataEntity.getDynamicObject("accounttable");
                    DynamicObject org = dataEntity.getDynamicObject("org");
                    DynamicObject account = dataEntity.getDynamicObject("account");
                    HashMap newAssistItemValues = new HashMap(16);
                    DynamicObjectCollection checkitementry = dataEntity.getDynamicObjectCollection("checkitementry");
                    for (DynamicObject assistItem : checkitementry) {
                        boolean enaccheck = assistItem.getBoolean("enaccheck");
                        HashMap<String, Boolean> newAssistItemValue = new HashMap<String, Boolean>(16);
                        newAssistItemValue.put("enaccheck", enaccheck);
                        newAssistItemValues.put(assistItem.getDynamicObject("asstactitem").getLong("id"), newAssistItemValue);
                    }
                    boolean isEnaccheckChanges = false;
                    DynamicObjectCollection oldCheckitementrys = account.getDynamicObjectCollection("checkitementry");
                    for (DynamicObject oldCheckitementry : oldCheckitementrys) {
                        Long oldFlexfield = oldCheckitementry.getDynamicObject("asstactitem").getLong("id");
                        Map newAssistItemValue = (Map)newAssistItemValues.get(oldFlexfield);
                        if (newAssistItemValue == null) continue;
                        boolean oldEnaccheck = oldCheckitementry.getBoolean("enaccheck");
                        int enaccheck = ((Boolean)newAssistItemValue.get("enaccheck")).booleanValue();
                        if (enaccheck == oldEnaccheck) continue;
                        isEnaccheckChanges = true;
                        break;
                    }
                    if (!isEnaccheckChanges) {
                        return;
                    }
                    DynamicObject parent = account.getDynamicObject("parent");
                    if (parent != null) {
                        DynamicObject[] paccounts;
                        String pnumber = parent.getString("number");
                        ArrayList<QFilter> queryPaccountFilters = new ArrayList<QFilter>(10);
                        queryPaccountFilters.add(new QFilter("number", "=", (Object)pnumber));
                        queryPaccountFilters.add(new QFilter("enddate", "=", (Object)AccountVersionUtil.getEndDate()));
                        queryPaccountFilters.add(new QFilter("accounttable.id", "=", accounttable.getPkValue()));
                        queryPaccountFilters.add(AccountUtils.getAccountDataFilter((long)org.getLong("id"), (long)((Long)accounttable.getPkValue())));
                        for (DynamicObject paccount : paccounts = BusinessDataServiceHelper.load((String)"bd_accountview", (String)"id,checkitementry.asstactitem,checkitementry.enaccheck", (QFilter[])queryPaccountFilters.toArray(new QFilter[queryPaccountFilters.size()]))) {
                            DynamicObjectCollection oldPCheckitementrys = paccount.getDynamicObjectCollection("checkitementry");
                            for (DynamicObject oldCheckitementry : oldPCheckitementrys) {
                                Long oldFlexfield = oldCheckitementry.getDynamicObject("asstactitem").getLong("id");
                                Map newAssistItemValue = (Map)newAssistItemValues.get(oldFlexfield);
                                if (newAssistItemValue == null) continue;
                                boolean oldEnaccheck = oldCheckitementry.getBoolean("enaccheck");
                                boolean enaccheck = (Boolean)newAssistItemValue.get("enaccheck");
                                if (!oldEnaccheck || enaccheck == oldEnaccheck) continue;
                                this.addMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u5f53\u524d\u79d1\u76ee\u4e0e\u4e0a\u7ea7\u79d1\u76ee\u5f80\u6765\u6838\u7b97\u4e0d\u6ee1\u8db3\u4e0a\u4e0b\u7ea7\u7ba1\u63a7", (String)"BalanceRecalByAccountAssistFixAddOp_1", (String)"fi-bd-formplugin", (Object[])new Object[0]), ErrorLevel.Error);
                                return;
                            }
                        }
                    }
                    if ((orgObj = QueryServiceHelper.queryOne((String)"bos_org_structure", (String)"id,parent", (QFilter[])new QFilter[]{q1 = new QFilter("org", "=", (Object)org.getLong("id")), q2 = new QFilter("view", "=", (Object)10)})).getLong("parent") != 0L) {
                        DynamicObject[] paccounts;
                        ArrayList<QFilter> queryPaccountFilters = new ArrayList<QFilter>(10);
                        queryPaccountFilters.add(new QFilter("number", "=", (Object)account.getString("number")));
                        queryPaccountFilters.add(AccountUtils.getAccountDataFilter((long)orgObj.getLong("parent"), (long)((Long)accounttable.getPkValue())));
                        queryPaccountFilters.add(new QFilter("enddate", "=", (Object)AccountVersionUtil.getEndDate()));
                        queryPaccountFilters.add(new QFilter("accounttable.id", "=", accounttable.getPkValue()));
                        for (DynamicObject paccount : paccounts = BusinessDataServiceHelper.load((String)"bd_accountview", (String)"id,createorg,checkitementry.asstactitem,checkitementry.enaccheck", (QFilter[])queryPaccountFilters.toArray(new QFilter[queryPaccountFilters.size()]))) {
                            DynamicObjectCollection oldPCheckitementrys = paccount.getDynamicObjectCollection("checkitementry");
                            for (DynamicObject oldCheckitementry : oldPCheckitementrys) {
                                Long oldFlexfield = oldCheckitementry.getDynamicObject("asstactitem").getLong("id");
                                Map newAssistItemValue = (Map)newAssistItemValues.get(oldFlexfield);
                                if (newAssistItemValue == null) continue;
                                boolean oldEnaccheck = oldCheckitementry.getBoolean("enaccheck");
                                boolean enaccheck = (Boolean)newAssistItemValue.get("enaccheck");
                                if (!oldEnaccheck || enaccheck == oldEnaccheck) continue;
                                this.addMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u5f53\u524d\u79d1\u76ee\u4e0e\u4e0a\u7ea7\u7ec4\u7ec7(%1$s)\u540c\u79d1\u76ee\u5f80\u6765\u6838\u7b97\u4e0d\u6ee1\u8db3\u4e0a\u4e0b\u7ea7\u7ba1\u63a7", (String)"BalanceRecalByAccountAssistFixAddOp_1", (String)"fi-bd-formplugin", (Object[])new Object[0]), paccount.getDynamicObject("createorg").getString("name")), ErrorLevel.Error);
                                return;
                            }
                        }
                    }
                    ArrayList<Long> porgIds = new ArrayList<Long>(1);
                    porgIds.add(org.getLong("id"));
                    List subordinateOrgIds = OrgServiceHelper.getAllSubordinateOrgs((String)"10", porgIds, (boolean)true);
                    ArrayList<QFilter> queryAccountFilters = new ArrayList<QFilter>(10);
                    queryAccountFilters.add(new QFilter("createorg.id", "in", (Object)subordinateOrgIds));
                    queryAccountFilters.add(new QFilter("accounttable.id", "=", accounttable.getPkValue()));
                    queryAccountFilters.add(new QFilter("number", "like", (Object)(account.getString("number") + "%")));
                    queryAccountFilters.add(new QFilter("isleaf", "=", (Object)true));
                    ArrayList<QFilter> queryInitacccurrentFilters = new ArrayList<QFilter>(10);
                    ArrayList<QFilter> queryReciInitStateFilters = new ArrayList<QFilter>(10);
                    DynamicObjectCollection accountObjs = QueryServiceHelper.query((String)"bd_accountview", (String)"id,checkitementry,checkitementry.id", (QFilter[])queryAccountFilters.toArray(new QFilter[queryAccountFilters.size()]));
                    for (DynamicObject accountObj : accountObjs) {
                        queryInitacccurrentFilters.clear();
                        queryInitacccurrentFilters.add(new QFilter("org", "in", (Object)subordinateOrgIds));
                        queryInitacccurrentFilters.add(new QFilter("account", "=", (Object)accountObj.getLong("id")));
                        DataSet initacccurrents = QueryServiceHelper.queryDataSet((String)"test", (String)"gl_initacccurrent", (String)"org.id oid,org.name oname", (QFilter[])queryInitacccurrentFilters.toArray(new QFilter[queryInitacccurrentFilters.size()]), null).groupBy(new String[]{"oid", "oname"}).finish();
                        for (Row initacccurrent : initacccurrents) {
                            this.addMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%1$s\uff08id\uff1a%2$d\uff09\u5b58\u5728\u5f80\u6765\u8d26\u4f59\u989d\u521d\u59cb\u5316", (String)"BalanceRecalByAccountAssistFixAddOp_1", (String)"fi-bd-formplugin", (Object[])new Object[0]), initacccurrent.getString("oname"), initacccurrent.getLong("oid")), ErrorLevel.Error);
                        }
                        queryReciInitStateFilters.clear();
                        queryReciInitStateFilters.add(new QFilter("org", "in", (Object)subordinateOrgIds));
                        queryReciInitStateFilters.add(new QFilter("account", "=", (Object)accountObj.getLong("id")));
                        queryReciInitStateFilters.add(new QFilter("isendinit", "=", (Object)true));
                        DataSet reciInitStates = QueryServiceHelper.queryDataSet((String)"test", (String)"gl_reci_init_state", (String)"org.id oid,org.name oname,endinitperiod.number enumber ", (QFilter[])queryReciInitStateFilters.toArray(new QFilter[queryReciInitStateFilters.size()]), null).groupBy(new String[]{"oid", "oname", "enumber"}).finish();
                        for (Row reciInitState : reciInitStates) {
                            this.addMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%1$s\uff08id\uff1a%2$d\uff09\u5b58\u5728\u5f80\u6765\u4f59\u989d\u521d\u59cb\u5316\u72b6\u6001\u7ed3\u675f\u521d\u59cb\u5316,\u671f\u95f4%3$s", (String)"BalanceRecalByAccountAssistFixAddOp_2", (String)"fi-bd-formplugin", (Object[])new Object[0]), reciInitState.getString("oname"), reciInitState.getLong("oid"), reciInitState.getString("enumber")), ErrorLevel.Error);
                        }
                    }
                }
            }
        });
    }

    /*
     * Could not resolve type clashes
     */
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        for (DynamicObject dataEntity : e.getDataEntities()) {
            Object accountObj2;
            DynamicObject[] accountObjs;
            DynamicObject accounttable = dataEntity.getDynamicObject("accounttable");
            DynamicObject org = dataEntity.getDynamicObject("org");
            DynamicObject account = dataEntity.getDynamicObject("account");
            DynamicObjectCollection checkitementry = dataEntity.getDynamicObjectCollection("checkitementry");
            ArrayList<Object[]> updateAccountParams = new ArrayList<Object[]>(10);
            ArrayList<Object[]> updateAccountItemEntryParams = new ArrayList<Object[]>(10);
            HashMap<String, Long> newFlexValue = new HashMap<String, Long>(16);
            HashMap<Long, DynamicObject[]> newAssistItemValues = new HashMap<Long, DynamicObject[]>(16);
            for (DynamicObject assistItem : checkitementry) {
                String flexfield = assistItem.getDynamicObject("asstactitem").getString("flexfield");
                boolean enaccheck = assistItem.getBoolean("enaccheck");
                String defaulVal = assistItem.getString("defaulid");
                if (defaulVal != null && !defaulVal.equals("")) {
                    newFlexValue.put(flexfield, Long.parseLong(defaulVal));
                }
                DynamicObject[] newAssistItemValue = new HashMap(16);
                newAssistItemValue.put("enaccheck", enaccheck);
                newAssistItemValues.put(assistItem.getDynamicObject("asstactitem").getLong("id"), newAssistItemValue);
            }
            ArrayList<Long> porgIds = new ArrayList<Long>(1);
            porgIds.add(org.getLong("id"));
            List subordinateOrgIds = OrgServiceHelper.getAllSubordinateOrgs((String)"10", porgIds, (boolean)true);
            ArrayList<QFilter> queryAccountFilters = new ArrayList<QFilter>(10);
            queryAccountFilters.add(new QFilter("createorg.id", "in", (Object)subordinateOrgIds));
            queryAccountFilters.add(new QFilter("accounttable.id", "=", accounttable.getPkValue()));
            queryAccountFilters.add(new QFilter("number", "like", (Object)(account.getString("number") + "%")));
            HashSet<Long> needUpdateVchAccountIds = new HashSet<Long>(10);
            for (Object accountObj2 : accountObjs = BusinessDataServiceHelper.load((String)"bd_accountview", (String)"id,accheck,checkitementry,checkitementry.id,checkitementry.asstactitem,checkitementry.isrequire,checkitementry.isdetail,checkitementry.enaccheck", (QFilter[])queryAccountFilters.toArray(new QFilter[queryAccountFilters.size()]))) {
                needUpdateVchAccountIds.add(accountObj2.getLong("id"));
                boolean oldaccheck = false;
                DynamicObjectCollection oldCheckitementrys = accountObj2.getDynamicObjectCollection("checkitementry");
                Iterator iterator = oldCheckitementrys.iterator();
                while (iterator.hasNext()) {
                    DynamicObject oldCheckitementry = (DynamicObject)iterator.next();
                    long oldentryid = oldCheckitementry.getLong("id");
                    Long oldFlexfield = oldCheckitementry.getDynamicObject("asstactitem").getLong("id");
                    Map newAssistItemValue = (Map)newAssistItemValues.get(oldFlexfield);
                    if (newAssistItemValue == null) continue;
                    boolean enaccheck = (Boolean)newAssistItemValue.get("enaccheck");
                    if (enaccheck) {
                        oldaccheck = true;
                    }
                    updateAccountItemEntryParams.add(new Object[]{enaccheck, oldentryid});
                }
                updateAccountParams.add(new Object[]{oldaccheck, accountObj2.getLong("id")});
            }
            if (updateAccountItemEntryParams.size() > 0) {
                this.batchFixSql("update T_BD_AccountAsstActItem set fenaccheck=? where fentryid = ?", updateAccountItemEntryParams);
            }
            if (updateAccountParams.size() > 0) {
                this.batchFixSql("update t_bd_account set faccheck=? where fid=?", updateAccountParams);
            }
            HashSet<Long> orgIds = new HashSet<Long>(10);
            ArrayList<Object[]> updateVchParams = new ArrayList<Object[]>(10);
            DataSet vouchDataSet = BatchProcessUtil.batchQueryDataSet((Collection)subordinateOrgIds, batchOrgs -> {
                try (ShardingHintContext ignored = ShardingHintContext.createAndSet((String)"t_gl_voucher", (HintCondition[])new HintCondition[]{new HintCondition("forgid", FilterType.in_range, new ArrayList(batchOrgs))});){
                    SqlBuilder queryVch = new SqlBuilder();
                    queryVch.append("select ve.forgid,ve.fentryid,ve.fassgrpid ", new Object[0]);
                    queryVch.append("from t_gl_voucherentry as ve ", new Object[0]);
                    queryVch.appendIn("where ve.forgid ", new ArrayList(batchOrgs));
                    queryVch.appendIn("and ve.faccountid ", new ArrayList(needUpdateVchAccountIds));
                    DataSet dataSet = DB.queryDataSet((String)"BalanceRecalByAccountAssistFixAddOp", (DBRoute)DBRoute.of((String)"GL"), (SqlBuilder)queryVch);
                    return dataSet;
                }
            });
            accountObj2 = null;
            try {
                boolean needUpdateVch = false;
                for (Row row : vouchDataSet) {
                    needUpdateVch = false;
                    Long fassgrpid = row.getLong("fassgrpid");
                    Map flexFieldToValue = new HashMap(16);
                    if (fassgrpid.compareTo(0L) > 0) {
                        String flexValue = this.getAssitFlexValue(fassgrpid);
                        flexFieldToValue = (Map)SerializationUtils.fromJsonString((String)flexValue, Map.class);
                    }
                    for (Map.Entry flexEntry : newFlexValue.entrySet()) {
                        if (flexFieldToValue.containsKey(flexEntry.getKey())) continue;
                        needUpdateVch = true;
                        flexFieldToValue.put(flexEntry.getKey(), flexEntry.getValue());
                    }
                    if (!needUpdateVch) continue;
                    long newAssgrpId = FlexUtils.saveFlexData(flexFieldToValue, (boolean)true);
                    updateVchParams.add(new Object[]{newAssgrpId, row.getLong("fentryid")});
                    orgIds.add(row.getLong("forgid"));
                }
            }
            catch (Throwable needUpdateVch) {
                accountObj2 = needUpdateVch;
                throw needUpdateVch;
            }
            finally {
                if (vouchDataSet != null) {
                    if (accountObj2 != null) {
                        try {
                            vouchDataSet.close();
                        }
                        catch (Throwable needUpdateVch) {
                            ((Throwable)accountObj2).addSuppressed(needUpdateVch);
                        }
                    } else {
                        vouchDataSet.close();
                    }
                }
            }
            if (updateVchParams.size() > 0) {
                this.batchFixSql("update t_gl_voucherentry set fassgrpid = ?  where fentryid = ? ", updateVchParams);
            }
            ArrayList<Object[]> updateBalParams = new ArrayList<Object[]>(10);
            try (DataSet vouchDataSet2 = BatchProcessUtil.batchQueryDataSet((Collection)subordinateOrgIds, batchOrgs -> {
                SqlBuilder queryBal = new SqlBuilder();
                queryBal.append("select v.fid,v.forgid,v.fassgrpid ", new Object[0]);
                queryBal.append("from t_gl_initbalance as v ", new Object[0]);
                queryBal.appendIn("where v.forgid ", new ArrayList(subordinateOrgIds));
                queryBal.appendIn("and v.faccountid ", new ArrayList(needUpdateVchAccountIds));
                return DB.queryDataSet((String)"BalanceRecalByAccountAssistFixAddOp", (DBRoute)DBRoute.of((String)"GL"), (SqlBuilder)queryBal);
            });){
                boolean needUpdateVch = false;
                for (Row row : vouchDataSet2) {
                    needUpdateVch = false;
                    Long fassgrpid = row.getLong("fassgrpid");
                    Map flexFieldToValue = new HashMap(16);
                    if (fassgrpid.compareTo(0L) > 0) {
                        String flexValue = this.getAssitFlexValue(fassgrpid);
                        flexFieldToValue = (Map)SerializationUtils.fromJsonString((String)flexValue, Map.class);
                    }
                    for (Map.Entry flexEntry : newFlexValue.entrySet()) {
                        if (flexFieldToValue.containsKey(flexEntry.getKey())) continue;
                        needUpdateVch = true;
                        flexFieldToValue.put(flexEntry.getKey(), flexEntry.getValue());
                    }
                    if (!needUpdateVch) continue;
                    long newAssgrpId = FlexUtils.saveFlexData(flexFieldToValue, (boolean)true);
                    updateBalParams.add(new Object[]{newAssgrpId, row.getLong("fid")});
                    orgIds.add(row.getLong("forgid"));
                }
            }
            if (updateBalParams.size() > 0) {
                this.batchFixSql("update t_gl_initbalance set fassgrpid = ?  where fid = ? ", updateBalParams);
            }
            QFilter forgid = new QFilter("org", "in", orgIds);
            QFilter faccountTableid = new QFilter("accounttable", "=", accounttable.getPkValue());
            Map books = BusinessDataServiceHelper.loadFromCache((String)"gl_accountbook", (QFilter[])new QFilter[]{forgid, faccountTableid});
            for (DynamicObject book : books.values()) {
                this.recalAcctBal(book);
            }
        }
    }

    private String getAssitFlexValue(Long grpId) {
        DynamicObject assist = QueryServiceHelper.queryOne((String)"gl_assist", (String)"assvals", (QFilter[])new QFilter("id", "=", (Object)grpId).toArray());
        String value = "";
        if (assist != null) {
            value = assist.getString("assvals");
        }
        return value;
    }

    private void recalAcctBal(DynamicObject book) {
        long btId = book.getLong("bookstype_id");
        long startperiodd = book.getLong("startperiod_id");
        long orgId = book.getLong("org_id");
        if (!Lock.tryLock((long)orgId, (long)btId, (LockKey)LockKey.BalanceCal, () -> {
            try (TXHandle txh = TX.requiresNew();){
                this.delBal(orgId, btId, "delete from t_gl_balance where forgid=? and fbooktypeid=?");
                this.calculate(orgId, btId, startperiodd, "gl_balance_log");
                CloseInitBalanceOp op = new CloseInitBalanceOp();
                op.doUpdate(book);
            }
            Long vperiodId = this.getMaxVchPeriodId(orgId, btId);
            long endperiodid = vperiodId != null ? vperiodId.longValue() : book.getLong("curperiod_id");
            QFilter ftypeId = new QFilter("periodtype", "=", (Object)book.getLong("periodtype_id"));
            QFilter fid1 = new QFilter("id", ">=", (Object)startperiodd);
            QFilter fid2 = new QFilter("id", "<=", (Object)endperiodid);
            DynamicObjectCollection col = QueryServiceHelper.query((String)"bd_period", (String)"id", (QFilter[])new QFilter[]{fid1, fid2, ftypeId}, (String)"id");
            if (!col.isEmpty()) {
                for (DynamicObject obj : col) {
                    this.calculate(orgId, btId, obj.getLong("id"), "gl_balance_log");
                }
            }
        })) {
            this.logger.info("get lock fail, please try later");
        }
    }

    private void batchFixSql(String sql, List<Object[]> updateParams) {
        DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)sql, updateParams);
    }

    private void delBal(long orgId, long btId, String sql) {
        try (TXHandle txh = TX.requiresNew();){
            DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)sql, (Object[])new Object[]{orgId, btId});
        }
    }

    private Long getMaxVchPeriodId(long orgId, long btId) {
        return (Long)DB.query((DBRoute)DBRoute.of((String)"gl"), (String)"select max(fperiodid) endperiod from t_gl_voucher where forgid=? and fbooktypeid=? and fbillstatus!='A'", (Object[])new Object[]{orgId, btId}, (ResultSetHandler)new ResultSetHandler<Long>(){

            public Long handle(ResultSet resultSet) throws Exception {
                if (resultSet.next()) {
                    return resultSet.getLong("endperiod");
                }
                return null;
            }
        });
    }

    private boolean calculate(long orgId, long bookTypeId, long periodId, String tableName) {
        Throwable throwable;
        TXHandle txh;
        int count = 0;
        ICalculator calculator = "gl_balance_log".equals(tableName) ? CalculatorFactory.createBalanceCalculator() : CalculatorFactory.createCashflowCalculator();
        do {
            txh = TX.requiresNew();
            throwable = null;
            try {
                count = calculator.calculate(orgId, bookTypeId);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (txh != null) {
                    if (throwable != null) {
                        try {
                            txh.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        txh.close();
                    }
                }
            }
        } while (count > 0);
        txh = TX.requiresNew();
        throwable = null;
        try {
            try {
                calculator.reCalculate(orgId, bookTypeId, periodId);
            }
            catch (Exception ex) {
                txh.markRollback();
                throw ex;
            }
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            if (txh != null) {
                if (throwable != null) {
                    try {
                        txh.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    txh.close();
                }
            }
        }
        return true;
    }
}

