/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.opplugin;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.fi.bd.business.service.LocalCurrencyConfigService;
import kd.fi.bd.business.vo.LocalCurrencyConfigVO;
import kd.fi.bd.consts.MCT;
import kd.fi.bd.util.BatchProcessUtil;
import kd.fi.bd.vo.CommonAssist;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.comassist.CommonDimensionValue;
import kd.fi.gl.comassist.model.ComAssistTable;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.opplugin.InitBalSaveUtil;
import kd.fi.gl.opplugin.InitBalSumData;
import kd.fi.gl.util.GLApp;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.SystemParamHelper;

public class CloseInitBalanceValidator
extends AbstractValidator {
    private FormatObject fobj = InteServiceHelper.getUserFormat((Long)RequestContext.get().getCurrUserId());
    private static final Log logger = LogFactory.getLog(CloseInitBalanceValidator.class);
    private final List<String> maxCommonAssistKeys = ComAssistTable.getMaxCommonAssistKeys();
    private Table<Long, Long, List<CommonDimensionValue>> dimensionTable = null;
    private Table<String, Long, String> nameCache;

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject book = dataEntity.getDataEntity();
            if (!book.getBoolean("enable")) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8d26\u7c3f\u5df2\u7981\u7528\uff0c\u65e0\u6cd5\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"CloseInitBalanceValidator_0", (String)"fi-gl-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            if (book.getBoolean("isendinit")) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u4e0d\u80fd\u91cd\u590d\u6267\u884c\u3002", (String)"CloseInitBalanceValidator_1", (String)"fi-gl-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            long orgId = book.getLong(GLField.id_((String)"org"));
            long bookTypeId = book.getLong(GLField.id_((String)"bookstype"));
            boolean enableBudget = AccSysUtil.getBookFromAccSys((long)orgId, (long)bookTypeId).isBudget();
            this.equalsDebitCredit(dataEntity, enableBudget, false);
            if (enableBudget) {
                this.equalsDebitCredit(dataEntity, enableBudget, true);
            }
            logger.info("\u4f59\u989d:checkReci-begin");
            List<String> msgList = this.checkReci(book);
            logger.info("\u4f59\u989d:checkReci-end");
            if (msgList.isEmpty()) continue;
            for (String s : msgList) {
                this.addMessage(dataEntity, s, ErrorLevel.Error);
            }
        }
    }

    private List<String> checkReci(DynamicObject book) {
        long org = book.getLong(GLField.id_((String)"org"));
        long bookType = book.getLong(GLField.id_((String)"bookstype"));
        AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys((long)org, (long)bookType);
        long curPeriodId = bookInfo.getCurPeriodId();
        QFilter orgFilter = new QFilter("org", "=", (Object)org);
        QFilter bookTypeFilter = new QFilter("booktype", "=", (Object)bookType);
        QFilter periodFilter = new QFilter("endinitperiod", "=", (Object)curPeriodId);
        QFilter isEndInit = new QFilter("isendinit", "=", (Object)true);
        DynamicObjectCollection initAccDyn = QueryServiceHelper.query((String)"gl_reci_init_state", (String)"account.masterid account,account.name name,account.number number", (QFilter[])new QFilter[]{orgFilter, bookTypeFilter, periodFilter, isEndInit});
        List accMasterIds = initAccDyn.stream().mapToLong(x -> x.getLong("account")).boxed().collect(Collectors.toList());
        Map<Long, String> masterIdNameMap = initAccDyn.stream().collect(Collectors.toMap(x -> x.getLong("account"), x -> String.join((CharSequence)" ", x.getString("number"), x.getString("name")), (v1, v2) -> v2));
        String sel = "masterid,checkitementry.asstactitem,checkitementry.enaccheck";
        QFilter idFilter = new QFilter("masterid", "in", accMasterIds);
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)org);
        DynamicObject[] accDyns = BusinessDataServiceHelper.load((String)"bd_accountview", (String)sel, (QFilter[])new QFilter[]{idFilter, baseDataFilter});
        HashMap<Long, List> accFlexMap = new HashMap<Long, List>();
        for (DynamicObject accDyn : accDyns) {
            DynamicObjectCollection assEntry = accDyn.getDynamicObjectCollection("checkitementry");
            for (DynamicObject assDyn : assEntry) {
                String flexField = assDyn.getString("asstactitem.flexfield");
                boolean isAccCheck = assDyn.getBoolean("enaccheck");
                if (!isAccCheck) continue;
                accFlexMap.computeIfAbsent(accDyn.getLong("masterid"), x -> new ArrayList()).add(flexField);
            }
        }
        logger.info("\u4f59\u989d:checkReci-\u83b7\u53d6\u5f80\u6765\u4f59\u989d");
        HashMap<InitKey, Value> reciMap = new HashMap<InitKey, Value>();
        QFilter accFilter = new QFilter("account.masterid", "in", accMasterIds);
        DataSet accCurrentInit = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_initacccurrent", (String)"account.masterid account,currency,assgrp.value assvals,amountfor,amountlocal", (QFilter[])new QFilter[]{orgFilter, bookTypeFilter, accFilter}, null);
        while (accCurrentInit.hasNext()) {
            Row next = accCurrentInit.next();
            long accId = next.getLong("account");
            long curId = next.getLong("currency");
            BigDecimal amtFor = next.getBigDecimal("amountfor");
            BigDecimal amtLocal = next.getBigDecimal("amountlocal");
            String assvalsStr = next.getString("assvals");
            if (assvalsStr == null) continue;
            Map assvals = (Map)SerializationUtils.fromJsonString((String)assvalsStr, Map.class);
            FFValue ffValue = new FFValue();
            for (Map.Entry entry : assvals.entrySet()) {
                ffValue.add((String)entry.getKey(), entry.getValue());
            }
            List validFlexField = (List)accFlexMap.get(accId);
            InitKey key = new InitKey(accId, curId, ffValue.filter(validFlexField));
            Value value = new Value(amtFor, amtLocal);
            reciMap.compute(key, (k, v) -> {
                if (v == null) {
                    return value;
                }
                return new Value(v.amtFor.add(amtFor), v.amtLocal.add(amtLocal));
            });
        }
        logger.info("\u4f59\u989d:checkReci-\u83b7\u53d6\u4f59\u989d\u521d\u59cb\u5316\u6570\u636e");
        HashMap<InitKey, Value> initBalMap = new HashMap<InitKey, Value>();
        DataSet initBalDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_initbalance", (String)"account.masterid account,account.dc dc,currency,assgrp.value assvals,begindebitfor,begindebitlocal,begincreditfor,begincreditlocal", (QFilter[])new QFilter[]{orgFilter, bookTypeFilter, accFilter}, null);
        while (initBalDs.hasNext()) {
            Row next = initBalDs.next();
            long accId = next.getLong("account");
            long curId = next.getLong("currency");
            BigDecimal dc = new BigDecimal(next.getString("dc"));
            BigDecimal amtFor = next.getBigDecimal("begindebitfor").subtract(next.getBigDecimal("begincreditfor")).multiply(dc);
            BigDecimal amtLocal = next.getBigDecimal("begindebitlocal").subtract(next.getBigDecimal("begincreditlocal")).multiply(dc);
            String assvalsStr = next.getString("assvals");
            if (assvalsStr == null) continue;
            Map assvals = (Map)SerializationUtils.fromJsonString((String)assvalsStr, Map.class);
            FFValue ffValue = new FFValue();
            for (Map.Entry entry : assvals.entrySet()) {
                ffValue.add((String)entry.getKey(), entry.getValue());
            }
            List validFlexField = (List)accFlexMap.get(accId);
            InitKey key = new InitKey(accId, curId, ffValue.filter(validFlexField));
            Value value = new Value(amtFor, amtLocal);
            initBalMap.compute(key, (k, v) -> {
                if (v == null) {
                    return value;
                }
                return new Value(v.amtFor.add(amtFor), v.amtLocal.add(amtLocal));
            });
        }
        initBalMap.keySet().forEach(initKey -> reciMap.putIfAbsent((InitKey)initKey, new Value(BigDecimal.ZERO, BigDecimal.ZERO)));
        ArrayList<InitKey> errorList = new ArrayList<InitKey>();
        for (Map.Entry entry : reciMap.entrySet()) {
            InitKey reciKey = (InitKey)entry.getKey();
            Value reciValue = (Value)entry.getValue();
            Value balValue = (Value)initBalMap.get(reciKey);
            if (balValue == null) {
                if (reciValue.amtFor.compareTo(BigDecimal.ZERO) == 0 && reciValue.amtLocal.compareTo(BigDecimal.ZERO) == 0) continue;
                errorList.add(reciKey);
                if (errorList.size() < 20) continue;
                break;
            }
            if (reciValue.amtFor.compareTo(balValue.amtFor) == 0 && reciValue.amtLocal.compareTo(balValue.amtLocal) == 0) continue;
            errorList.add(reciKey);
            if (errorList.size() < 20) continue;
            break;
        }
        ArrayList<String> msgList = new ArrayList<String>();
        if (!errorList.isEmpty()) {
            Map<Long, String> curToNameMap = this.getCurrentNameMap();
            HashMap<String, Set<Object>> flexMap = new HashMap<String, Set<Object>>();
            List collect = errorList.stream().flatMap(x -> x.ffValue.ffMap.entrySet().stream()).collect(Collectors.toList());
            for (Map.Entry entry : collect) {
                flexMap.computeIfAbsent((String)entry.getKey(), (Function<String, Set<Object>>)((Function<String, Set>)k -> new HashSet())).add(entry.getValue());
            }
            Map<TupleK2<String, Object>, TupleK2<String, String>> assgrpIdToNameMap = this.flexToName(flexMap);
            List sortedErrList = errorList.stream().sorted(Comparator.comparing(x -> (String)masterIdNameMap.get(x.account))).collect(Collectors.toList());
            for (InitKey key : sortedErrList) {
                StringBuilder sb = new StringBuilder();
                String accName = masterIdNameMap.get(key.account);
                String printableFlex = this.getPrintableFlex(key.ffValue, assgrpIdToNameMap);
                msgList.add(sb.append(ResManager.loadKDString((String)"\u4e0e\u5f80\u6765\u4f59\u989d\u521d\u59cb\u5316\u6570\u636e\u4e0d\u4e00\u81f4\uff1a", (String)"CloseInitBalanceValidator_2", (String)"fi-gl-opplugin", (Object[])new Object[0])).append(accName).append("-").append(curToNameMap.get(key.currency)).append("-").append(printableFlex).append("\n").toString());
            }
        }
        return msgList;
    }

    private Map<Long, String> getCurrentNameMap() {
        HashMap<Long, String> result = new HashMap<Long, String>();
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_currency", (String)"id,name", null, null);){
            for (Row d : ds) {
                result.put(d.getLong("id"), d.getString("name"));
            }
        }
        return result;
    }

    private Map<TupleK2<String, Object>, TupleK2<String, String>> flexToName(Map<String, Set<Object>> flexMap) {
        HashMap<String, String> flexToEntityNameMap = new HashMap<String, String>();
        HashMap<String, String> flexToNameMap = new HashMap<String, String>();
        try (DataSet asstypeDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_asstacttype", (String)"flexfield,name,valuesource", null, null);){
            for (Row row : asstypeDs) {
                String flexfield = row.getString("flexfield");
                String name = row.getString("name");
                String entityName = row.getString("valuesource");
                flexToNameMap.put(flexfield, name);
                if ("bos_assistantdatagroup".equals(entityName)) {
                    flexToEntityNameMap.put(flexfield, "bos_assistantdata_detail");
                    continue;
                }
                flexToEntityNameMap.put(flexfield, entityName);
            }
        }
        HashMap<Long, String> valueToNameMap = new HashMap<Long, String>(flexMap.size());
        HashMap<String, Set> entityNameToValueMap = new HashMap<String, Set>(flexMap.size());
        for (Map.Entry<String, Set<Object>> entry : flexMap.entrySet()) {
            String entityName = (String)flexToEntityNameMap.get(entry.getKey());
            entityNameToValueMap.computeIfAbsent(entityName, x -> new HashSet(16)).addAll((Collection)entry.getValue());
        }
        for (Map.Entry<String, Set<Object>> entry : entityNameToValueMap.entrySet()) {
            QFilter idFilter = new QFilter("id", "in", entry.getValue());
            BasedataEntityType entityType = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)entry.getKey());
            String name = entityType.getNameProperty();
            DataSet ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)entry.getKey(), (String)("id," + name), (QFilter[])new QFilter[]{idFilter}, null);
            Throwable throwable = null;
            try {
                for (Row d : ds) {
                    valueToNameMap.put(d.getLong("id"), d.getString(name));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ds == null) continue;
                if (throwable != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ds.close();
            }
        }
        HashMap<TupleK2<String, Object>, TupleK2<String, String>> result = new HashMap<TupleK2<String, Object>, TupleK2<String, String>>();
        for (Map.Entry<String, Set<Object>> entry : flexMap.entrySet()) {
            String key = entry.getKey();
            Set<Object> values = entry.getValue();
            for (Object value : values) {
                String flexName = (String)flexToNameMap.get(key);
                String valName = (String)valueToNameMap.get(value);
                result.put(new TupleK2<String, Object>(key, value), new TupleK2<String, String>(flexName, valName));
            }
        }
        return result;
    }

    private String getPrintableFlex(FFValue ffValue, Map<TupleK2<String, Object>, TupleK2<String, String>> assgrpIdToNameMap) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        List collect = ffValue.ffMap.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).collect(Collectors.toList());
        for (Map.Entry entry : collect) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            TupleK2<String, String> nameTuple = assgrpIdToNameMap.get(new TupleK2(key, value));
            sb.append((String)nameTuple.t1).append(":").append((String)nameTuple.t2).append(",");
        }
        String s = sb.toString();
        s = s.substring(0, sb.length() - 1) + "}";
        return s;
    }

    private Table<Long, Long, List<CommonDimensionValue>> getAllBalanceDimensionTable() {
        if (this.dimensionTable == null) {
            HashSet orgs = new HashSet();
            HashSet bookTypes = new HashSet();
            Arrays.stream(this.getDataEntities()).map(ExtendedDataEntity::getDataEntity).forEach(book -> {
                orgs.add(book.getLong(GLField.id_((String)"org")));
                bookTypes.add(book.getLong(GLField.id_((String)"bookstype")));
            });
            List commonAssistKeys = ComAssistTable.getMaxCommonAssistKeys();
            this.dimensionTable = HashBasedTable.create();
            QFilter booktypeQF = new QFilter("booktype", "in", bookTypes);
            BatchProcessUtil.batchQueryDataSet(orgs, batchOrgs -> QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getSimpleName() + "#getAllBalanceDimensions"), (String)"gl_initbalance", (String)("org, booktype, " + String.join((CharSequence)", ", commonAssistKeys)), (QFilter[])new QFilter[]{new QFilter("org", "in", batchOrgs), booktypeQF}, null)).forEachRemaining(row -> {
                Long bookType;
                Long org = row.getLong("org");
                LinkedList<CommonDimensionValue> dimensions = (LinkedList<CommonDimensionValue>)this.dimensionTable.get((Object)org, (Object)(bookType = row.getLong("booktype")));
                if (dimensions == null) {
                    dimensions = new LinkedList<CommonDimensionValue>();
                }
                dimensions.add(CommonDimensionValue.createOnlyBalanced((Long)org, (Long)bookType, (Row)row));
                this.dimensionTable.put((Object)org, (Object)bookType, dimensions);
            });
        }
        return this.dimensionTable;
    }

    private Table<String, Long, String> getBalanceDimensionNameCache() {
        if (this.nameCache == null) {
            this.nameCache = HashBasedTable.create();
            Table<Long, Long, List<CommonDimensionValue>> allCommonDimensionTable = this.getAllBalanceDimensionTable();
            HashMap<String, Set> entityName2IdMap = new HashMap<String, Set>();
            allCommonDimensionTable.cellSet().forEach(cell -> ComAssistTable.get((Long)((Long)cell.getRowKey()), (Long)((Long)cell.getColumnKey())).ifPresent(commonAssistTable -> commonAssistTable.getCommonAssists().forEach(commonAssist -> {
                if (commonAssist.isBalanced) {
                    Set ids = entityName2IdMap.getOrDefault(commonAssist.valueSource, new HashSet());
                    ((List)Objects.requireNonNull(cell.getValue())).forEach(commonDimensionValue -> ids.add(commonDimensionValue.commonAssists[this.maxCommonAssistKeys.indexOf(commonAssist.key)]));
                    entityName2IdMap.put(commonAssist.valueSource, ids);
                }
            })));
            entityName2IdMap.forEach((entity, ids) -> BusinessDataServiceHelper.loadFromCache((String)entity, (String)"name", (QFilter[])new QFilter("id", "in", ids).toArray()).forEach((id, dyo) -> {
                String cfr_ignored_0 = (String)this.nameCache.put(entity, (Object)((Long)id), (Object)dyo.getLocaleString("name").getLocaleValue());
            }));
        }
        return this.nameCache;
    }

    private void equalsDebitCredit(ExtendedDataEntity entity, boolean enableBudget, boolean isBudget) {
        DynamicObject book = entity.getDataEntity();
        long orgId = book.getLong(GLField.id_((String)"org"));
        long bookTypeId = book.getLong(GLField.id_((String)"bookstype"));
        boolean checkbwaccount = SystemParamHelper.getBooleanParam((String)"checkbwaccount", (long)orgId, (boolean)false);
        String budgetMsg = !enableBudget ? "" : (isBudget ? ResManager.loadKDString((String)"\u9884\u7b97\u4f1a\u8ba1\u79d1\u76ee", (String)"CloseInitBalanceValidator_100", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8d22\u52a1\u4f1a\u8ba1\u79d1\u76ee", (String)"CloseInitBalanceValidator_101", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
        Collection configColl = LocalCurrencyConfigService.queryEnableCurrencies((long)orgId, (long)bookTypeId);
        HashMap<String, LocalCurrencyConfigVO> configMap = new HashMap<String, LocalCurrencyConfigVO>(8);
        for (LocalCurrencyConfigVO config : configColl) {
            configMap.put(config.getNumber(), config);
        }
        this.getInitBalanceSum(orgId, bookTypeId, isBudget).forEach((dimensionValue, sumData) -> {
            String commonAssistPreMsg = this.getCommonAssistPreMsg((CommonDimensionValue)dimensionValue);
            sumData.getCurType2sumData().forEach((curType, sumDataTuple) -> {
                int precision = book.getInt("basecurrency.amtprecision");
                String baseCurrencySymbol = book.getString("basecurrency.sign");
                String localCurName = ResManager.loadKDString((String)"\u672c\u4f4d\u5e01", (String)"CloseInitBalanceValidator_7", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]);
                if (configMap.containsKey(curType)) {
                    LocalCurrencyConfigVO config = (LocalCurrencyConfigVO)configMap.get(curType);
                    DynamicObject curDyn = BusinessDataServiceHelper.loadSingleFromCache((Object)config.getCurrencyId(orgId, bookTypeId), (String)"bd_currency", (String)"amtprecision, sign");
                    precision = curDyn.getInt("amtprecision");
                    baseCurrencySymbol = curDyn.getString("sign");
                    localCurName = config.getName().getLocaleValue();
                }
                BigDecimal yearDebit = ((InitBalSumData.SumData)sumDataTuple.item1).getYearDebit();
                BigDecimal yearCredit = ((InitBalSumData.SumData)sumDataTuple.item1).getYearCredit();
                BigDecimal beginDebit = ((InitBalSumData.SumData)sumDataTuple.item1).getBeginDebit();
                BigDecimal beginCredit = ((InitBalSumData.SumData)sumDataTuple.item1).getBeginCredit();
                BigDecimal bwYearDebit = ((InitBalSumData.SumData)sumDataTuple.item2).getYearDebit();
                BigDecimal bwYearCredit = ((InitBalSumData.SumData)sumDataTuple.item2).getYearCredit();
                BigDecimal bwBeginDebit = ((InitBalSumData.SumData)sumDataTuple.item2).getBeginDebit();
                BigDecimal bwBeginCredit = ((InitBalSumData.SumData)sumDataTuple.item2).getBeginCredit();
                if (yearDebit.compareTo(yearCredit) != 0) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"%1$s%5$s\u672c\u5e74\u7d2f\u8ba1%6$s\u501f\uff1a%2$s\uff0c\u8d37\uff1a%3$s\uff0c\u5dee\u5f02\u91d1\u989d\uff1a%4$s\uff0c\u501f\u8d37\u4e0d\u5e73\u8bf7\u68c0\u67e5\u5e76\u4fee\u6539\u3002", (String)"CloseInitBalanceValidator_3", (String)"fi-gl-opplugin", (Object[])new Object[0]), commonAssistPreMsg, this.formatBigDeciml(yearDebit, precision, baseCurrencySymbol), this.formatBigDeciml(yearCredit, precision, baseCurrencySymbol), this.formatBigDeciml(yearDebit.subtract(yearCredit), precision, baseCurrencySymbol), budgetMsg, localCurName));
                }
                if (beginDebit.compareTo(beginCredit) != 0) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"%1$s%5$s\u671f\u521d\u4f59\u989d%6$s\u501f\uff1a%2$s\uff0c\u8d37\uff1a%3$s\uff0c\u5dee\u5f02\u91d1\u989d\uff1a%4$s\uff0c\u501f\u8d37\u4e0d\u5e73\u8bf7\u68c0\u67e5\u5e76\u4fee\u6539\u3002", (String)"CloseInitBalanceValidator_4", (String)"fi-gl-opplugin", (Object[])new Object[0]), commonAssistPreMsg, this.formatBigDeciml(beginDebit, precision, baseCurrencySymbol), this.formatBigDeciml(beginCredit, precision, baseCurrencySymbol), this.formatBigDeciml(beginDebit.subtract(beginCredit), precision, baseCurrencySymbol), budgetMsg, localCurName));
                }
                if (checkbwaccount) {
                    if (bwYearDebit.compareTo(bwYearCredit) != 0) {
                        this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"%1$s%5$s\u8868\u5916\u79d1\u76ee\u672c\u5e74\u7d2f\u8ba1%6$s\u501f\uff1a%2$s\uff0c\u8d37\uff1a%3$s\uff0c\u5dee\u5f02\u91d1\u989d\uff1a%4$s\uff0c\u501f\u8d37\u4e0d\u5e73\u8bf7\u68c0\u67e5\u5e76\u4fee\u6539\u3002", (String)"CloseInitBalanceValidator_5", (String)"fi-gl-opplugin", (Object[])new Object[0]), commonAssistPreMsg, this.formatBigDeciml(bwYearDebit, precision, baseCurrencySymbol), this.formatBigDeciml(bwYearCredit, precision, baseCurrencySymbol), this.formatBigDeciml(bwYearDebit.subtract(bwYearCredit), precision, baseCurrencySymbol), budgetMsg, localCurName));
                    }
                    if (bwBeginDebit.compareTo(bwBeginCredit) != 0) {
                        this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"%1$s%5$s\u8868\u5916\u79d1\u76ee\u671f\u521d\u4f59\u989d%6$s\u501f\uff1a%2$s\uff0c\u8d37\uff1a%3$s\uff0c\u5dee\u5f02\u91d1\u989d\uff1a%4$s\uff0c\u501f\u8d37\u4e0d\u5e73\u8bf7\u68c0\u67e5\u5e76\u4fee\u6539\u3002", (String)"CloseInitBalanceValidator_6", (String)"fi-gl-opplugin", (Object[])new Object[0]), commonAssistPreMsg, this.formatBigDeciml(bwBeginDebit, precision, baseCurrencySymbol), this.formatBigDeciml(bwBeginCredit, precision, baseCurrencySymbol), this.formatBigDeciml(bwBeginDebit.subtract(bwBeginCredit), precision, baseCurrencySymbol), budgetMsg, localCurName));
                    }
                }
            });
        });
    }

    private String getCommonAssistPreMsg(CommonDimensionValue dimensionValue) {
        StringBuilder sb = new StringBuilder();
        ComAssistTable.get((Long)dimensionValue.org, (Long)dimensionValue.bookType).ifPresent(commonAssistTable -> {
            for (int i = 0; i < dimensionValue.commonAssists.length; ++i) {
                long commonAssistValue = dimensionValue.commonAssists[i];
                if (commonAssistValue == 0L) continue;
                CommonAssist commonAssist = (CommonAssist)commonAssistTable.getCommonAssist(this.maxCommonAssistKeys.get(i)).get();
                sb.append(String.format("%s %s", commonAssist.getLocaleName().getLocaleValue(), this.getBalanceDimensionNameCache().get((Object)commonAssist.valueSource, (Object)commonAssistValue))).append("\u3001");
            }
            if (sb.length() > 0) {
                sb.delete(sb.length() - 1, sb.length()).append(": ");
            }
        });
        return sb.toString();
    }

    private Map<CommonDimensionValue, InitBalSumData> getInitBalanceSum(Long org, Long bookType, boolean isBudget) {
        QFilter orgF = new QFilter("org", "=", (Object)org);
        QFilter bookTypeF = new QFilter("booktype", "=", (Object)bookType);
        QFilter deletedF = new QFilter("isdeleted", "=", (Object)false);
        QFilter budgetF = new QFilter("account.accounttype.accounttype", isBudget ? "in" : "not in", (Object)GLUtil.getBudgetTypes());
        boolean checkbwaccount = SystemParamHelper.getBooleanParam((String)"checkbwaccount", (long)org, (boolean)false);
        QFilter[] filters = null;
        if (!checkbwaccount) {
            QFilter accountF = new QFilter("account.bw", "!=", (Object)true);
            filters = new QFilter[]{budgetF, orgF, bookTypeF, deletedF, accountF};
        } else {
            filters = new QFilter[]{budgetF, orgF, bookTypeF, deletedF};
        }
        Collection configs = LocalCurrencyConfigService.queryEnableCurrencies((long)org, (long)bookType);
        List<String> mulLocalAmtSelectFields = InitBalSaveUtil.getMulLocalAmtSelector(configs, MCT.BEGIN_CREDIT, MCT.BEGIN_DEBIT, MCT.YEAR_DEBIT, MCT.YEAR_CREDIT);
        String sel = this.addAllCommonAssistFields(String.join((CharSequence)",", "begindebitlocal", "begincreditlocal", "yeardebitlocal", "yearcreditlocal", "account.bw"));
        mulLocalAmtSelectFields.add(sel);
        sel = String.join((CharSequence)",", mulLocalAmtSelectFields);
        HashMap<CommonDimensionValue, InitBalSumData> allSum = new HashMap<CommonDimensionValue, InitBalSumData>();
        try (DataSet balance = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_initbalance", (String)sel, (QFilter[])filters, null);){
            for (Row row : balance) {
                CommonDimensionValue balanceDimension = CommonDimensionValue.createOnlyBalanced((Long)org, (Long)bookType, (Row)row);
                allSum.computeIfAbsent(balanceDimension, key -> new InitBalSumData(configs)).sum(row);
            }
        }
        return allSum;
    }

    private String addAllCommonAssistFields(String selectField) {
        return this.maxCommonAssistKeys.size() > 0 ? String.join((CharSequence)", ", selectField, String.join((CharSequence)", ", this.maxCommonAssistKeys.toArray(new String[0]))) : selectField;
    }

    private void sum(int startAt, BigDecimal[][] sum, BigDecimal ... amounts) {
        sum[startAt][0] = sum[startAt][0].add(amounts[0]);
        sum[startAt][1] = sum[startAt][1].add(amounts[1]);
        sum[startAt + 1][0] = sum[startAt + 1][0].add(amounts[2]);
        sum[startAt + 1][1] = sum[startAt + 1][1].add(amounts[3]);
    }

    private BigDecimal[][] getDefaultSumArray() {
        BigDecimal[][] sum = new BigDecimal[4][2];
        for (int i = 0; i < sum.length; ++i) {
            sum[i][0] = BigDecimal.ZERO;
            sum[i][1] = BigDecimal.ZERO;
        }
        return sum;
    }

    private String formatBigDeciml(BigDecimal amount, int precision, String baseCurrencySymbol) {
        this.fobj.getCurrencyFormat().setMinimumFractionDigits(precision);
        this.fobj.getCurrencyFormat().setCurrencySymbols(baseCurrencySymbol);
        return FormatFactory.get((FormatTypes)FormatTypes.Currency).getFormat(this.fobj).format(amount);
    }

    private static class FFValue {
        Map<String, Object> ffMap = new HashMap<String, Object>();

        FFValue() {
        }

        public void add(String flexField, Object value) {
            this.ffMap.put(flexField, value);
        }

        public FFValue filter(List<String> flexField) {
            FFValue result = new FFValue();
            for (Map.Entry<String, Object> entry : this.ffMap.entrySet()) {
                if (!flexField.contains(entry.getKey())) continue;
                result.add(entry.getKey(), entry.getValue());
            }
            return result;
        }

        public int hashCode() {
            return this.ffMap.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof FFValue) {
                FFValue e = (FFValue)obj;
                return this.ffMap.equals(e.ffMap);
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{");
            for (Map.Entry<String, Object> entry : this.ffMap.entrySet()) {
                sb.append(entry.getKey()).append(":").append(entry.getValue()).append(";");
            }
            String s = sb.toString();
            s = s.substring(0, sb.length() - 1) + "}";
            return s;
        }
    }

    private static class Value {
        BigDecimal amtFor;
        BigDecimal amtLocal;

        public Value(BigDecimal amtFor, BigDecimal amtLocal) {
            this.amtFor = amtFor;
            this.amtLocal = amtLocal;
        }
    }

    private static class InitKey {
        long account;
        long currency;
        FFValue ffValue;

        InitKey(long account, long currency, FFValue assgrp) {
            this.account = account;
            this.currency = currency;
            this.ffValue = assgrp;
        }

        public int hashCode() {
            int result = Long.hashCode(this.account);
            result = 31 * result + Long.hashCode(this.currency);
            return 31 * result + this.ffValue.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof InitKey) {
                InitKey e = (InitKey)obj;
                return e.account == this.account && e.currency == this.currency && e.ffValue.equals(this.ffValue);
            }
            return false;
        }
    }

    private static class TupleK2<T1, T2> {
        protected final T1 t1;
        protected final T2 t2;

        TupleK2(T1 t1, T2 t2) {
            this.t1 = t1;
            this.t2 = t2;
        }

        public int hashCode() {
            return 31 * Objects.hashCode(this.t1) + Objects.hashCode(this.t2);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof TupleK2) {
                TupleK2 e = (TupleK2)obj;
                return e.t1.equals(this.t1) && e.t2.equals(this.t2);
            }
            return false;
        }

        public String toString() {
            return "{" + this.t1 + ":" + this.t2 + "}";
        }
    }
}

