/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.opplugin;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.ext.fi.accountref.AccountRefUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.service.balance.BalanceQueryExecutor;
import kd.fi.bd.service.balance.QueryParam;
import kd.fi.bd.util.AccountUtils;
import kd.fi.bd.util.DebugTrace;
import kd.fi.bd.vo.CommonAssist;
import kd.fi.gl.comassist.model.ComAssistTable;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.util.GLUtil;

public class CloseInitCashflowValidator
extends AbstractValidator {
    public static final Log logger = LogFactory.getLog(CloseInitCashflowValidator.class);

    public void validate() {
        ArrayList<DynamicObject> successDatas = new ArrayList<DynamicObject>(this.dataEntities.length);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject book = dataEntity.getDataEntity();
            if ("api".equals(RequestContext.get().getClient()) && !GLUtil.hasPermission((String)"4730fc9f000005ae", (Long)book.getLong("org.id"), (String)"gl_initcashflowitem")) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u65e0\u201c\u7ed3\u675f\u521d\u59cb\u5316\u201d\u7684\u529f\u80fd\u6743\u9650\uff0c\u4e0d\u80fd\u8fdb\u884c\u201c\u73b0\u91d1\u6d41\u91cf\u521d\u59cb\u5316>\u7ed3\u675f\u521d\u59cb\u5316\u201d\u64cd\u4f5c\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CloseInitCashflowValidator_9", (String)"fi-gl-opplugin", (Object[])new Object[0]));
                continue;
            }
            ILocaleString orgName = book.getLocaleString("org.name");
            ILocaleString bookTypeName = book.getLocaleString("bookstype.name");
            if (!book.getBoolean("enable")) {
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u3010%s\u3011\u8be5\u8d26\u7c3f\u5df2\u7981\u7528\uff0c\u4e0d\u80fd\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"CloseInitCashflowValidator_0", (String)"fi-gl-opplugin", (Object[])new Object[0]), orgName.getLocaleValue()), ErrorLevel.Error);
                continue;
            }
            long cashflowPeriod = book.getLong(GLField.id_((String)"cashinitperiod"));
            if (cashflowPeriod == 0L) {
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u3010%s\u3011\u8d26\u7c3f\u672a\u5f55\u5165\u73b0\u91d1\u6d41\u91cf\u521d\u59cb\u5316\u671f\u95f4\uff0c\u4e0d\u80fd\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"CloseInitCashflowValidator_2", (String)"fi-gl-opplugin", (Object[])new Object[0]), orgName.getLocaleValue()), ErrorLevel.Error);
                continue;
            }
            if (book.getLong(GLField.id_((String)"curperiod")) != cashflowPeriod) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u201c%1$s\u201d\u201c%2$s\u201d\u7684\u5f53\u524d\u671f\u95f4\u4e0d\u662f\u73b0\u91d1\u6d41\u91cf\u521d\u59cb\u5316\u671f\u95f4\uff0c\u65e0\u6cd5\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"CloseInitCashflowValidator_8", (String)"fi-gl-opplugin", (Object[])new Object[]{orgName.getLocaleValue(), bookTypeName.getLocaleValue()}), ErrorLevel.Error);
                continue;
            }
            if (book.getBoolean("isendinitcashflow")) {
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u3010%s\u3011\u5df2\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u65e0\u9700\u91cd\u590d\u6267\u884c\u3002", (String)"CloseInitCashflowValidator_3", (String)"fi-gl-opplugin", (Object[])new Object[0]), orgName.getLocaleValue()), ErrorLevel.Error);
                continue;
            }
            if (!book.getBoolean("isendinit")) {
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u3010%s\u3011\u79d1\u76ee\u4f59\u989d\u8868\u672a\u521d\u59cb\u5316\uff0c\u4e0d\u80fd\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"CloseInitCashflowValidator_4", (String)"fi-gl-opplugin", (Object[])new Object[0]), orgName.getLocaleValue()), ErrorLevel.Error);
                continue;
            }
            successDatas.add(book);
        }
        if (successDatas.size() > 0) {
            Map<Long, Tuple<String, Map<String, List<String>>>> checkResult = this.checkCloseInitByComassist(successDatas);
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                String errorMsg;
                Map errorMap;
                if (this.getFalseDataEntities().contains(dataEntity)) continue;
                DynamicObject book = dataEntity.getDataEntity();
                long orgId = book.getLong("org.id");
                String orgName = book.getLocaleString("org.name").getLocaleValue();
                if (!checkResult.containsKey(orgId) || CollectionUtils.isEmpty((Map)(errorMap = (Map)checkResult.get((Object)Long.valueOf((long)orgId)).item2))) continue;
                ComAssistTable comAssistTable = ComAssistTable.get((Long)book.getLong("accounttable.id"));
                if (CollectionUtils.isEmpty((Collection)comAssistTable.getBalancedCommonAssistKeys())) {
                    OperateOption option = this.getOption();
                    errorMsg = "";
                    if (option.containsVariable("indexs")) {
                        String indexs = option.getVariableValue("indexs");
                        String[] index = indexs.split("_");
                        errorMsg = String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u7b2c%2$s\u884c\u4e0e\u7b2c%3$s\u884c\u73b0\u91d1\u7b49\u4ef7\u7269\u51c0\u589e\u52a0\u989d\u4e0d\u7b49\u3002", (String)"CloseInitCashflowValidator_5", (String)"fi-gl-opplugin", (Object[])new Object[0]), orgName, index[0], index[1]);
                    } else {
                        errorMsg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e24\u884c\u73b0\u91d1\u53ca\u73b0\u91d1\u7b49\u4ef7\u7269\u51c0\u589e\u52a0\u989d\u4e0d\u7b49\uff0c\u65e0\u6cd5\u5b8c\u6210\u521d\u59cb\u5316\u3002\u8bf7\u524d\u5f80\u8be5\u7ec4\u7ec7\u73b0\u91d1\u6d41\u91cf\u521d\u59cb\u5316\u9875\u9762\uff0c\u70b9\u51fb\u201c\u7ed3\u675f\u521d\u59cb\u5316\u201d\u6309\u94ae\u67e5\u770b\u8be6\u60c5\u3002", (String)"CloseInitCashflowValidator_6", (String)"fi-gl-opplugin", (Object[])new Object[0]), orgName);
                    }
                    this.addMessage(dataEntity, errorMsg, ErrorLevel.Error);
                    continue;
                }
                ArrayList errorComassistValus = new ArrayList();
                errorMap.values().forEach(e -> errorComassistValus.addAll(e));
                errorMsg = String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u5e73\u8861\u516c\u5171\u7ef4\u5ea6\uff1a%2$s\uff1a%3$s\uff0c\u73b0\u91d1\u7b49\u4ef7\u7269\u51c0\u589e\u52a0\u989d\u4e0d\u7b49\u3002", (String)"CloseInitCashflowValidator_7", (String)"fi-gl-opplugin", (Object[])new Object[0]), orgName, StringUtils.join((Object[])errorMap.keySet().toArray(), (String)","), CollectionUtils.isEmpty(errorComassistValus) ? "" : StringUtils.join((Object[])errorComassistValus.toArray(), (String)","));
                this.addMessage(dataEntity, errorMsg, ErrorLevel.Error);
            }
        }
    }

    private Map<Long, Tuple<String, Map<String, List<String>>>> checkCloseInitByComassist(List<DynamicObject> successDatas) {
        HashMap<Long, Tuple<String, Map<String, List<String>>>> result = new HashMap<Long, Tuple<String, Map<String, List<String>>>>(successDatas.size());
        long booksTypeId = successDatas.get(0).getLong("bookstype.id");
        HashMap<String, ArrayList> accountTableOrgs = new HashMap<String, ArrayList>(successDatas.size());
        for (DynamicObject dynamicObject : successDatas) {
            long curPeriod;
            long orgId = dynamicObject.getLong("org.id");
            long accountTable = AccountRefUtils.getCurPeriodAccountTableId((long)orgId, (long)booksTypeId, (long)(curPeriod = dynamicObject.getLong("curperiod.id")));
            String key = accountTable + "_" + curPeriod;
            if (accountTableOrgs.containsKey(key)) {
                ((List)accountTableOrgs.get(key)).add(orgId);
                continue;
            }
            accountTableOrgs.put(key, Lists.newArrayList((Object[])new Long[]{orgId}));
        }
        for (Map.Entry entry : accountTableOrgs.entrySet()) {
            String[] s = ((String)entry.getKey()).split("_");
            long accountTable = Long.parseLong(s[0]);
            long curPeriod = Long.parseLong(s[1]);
            List orgIds = (List)entry.getValue();
            List balanceComassistList = ComAssistTable.get((Long)accountTable).getBalancedCommonAssists();
            QFilter acctFilter = AccountUtils.getAccountDataFilter(new HashSet(orgIds), (long)accountTable);
            DynamicObjectCollection useAccounts = QueryServiceHelper.query((String)"bd_accountview", (String)"id,masterid,iscash,isbank,iscashequivalent", (QFilter[])new QFilter[]{acctFilter});
            ArrayList<Long> accts = new ArrayList<Long>(useAccounts.size());
            for (DynamicObject account : useAccounts) {
                if (!GLUtil.isCashAcct((DynamicObject)account)) continue;
                accts.add(account.getLong("id"));
            }
            if (CollectionUtils.isEmpty((Collection)balanceComassistList)) {
                this.doCheck(orgIds, accts, booksTypeId, accountTable, curPeriod, null, result);
                continue;
            }
            for (CommonAssist commonAssist : balanceComassistList) {
                this.doCheck(orgIds, accts, booksTypeId, accountTable, curPeriod, commonAssist, result);
            }
        }
        return result;
    }

    private void doCheck(List<Long> orgIds, List<Long> accts, long booksTypeId, long accountTable, long curPeriod, CommonAssist commonAssist, Map<Long, Tuple<String, Map<String, List<String>>>> result) {
        HashMap errorMap = new HashMap(orgIds.size());
        HashMap<Long, Map<Long, Object>> comassistBalance = new HashMap<Long, Map<Long, Object>>(orgIds.size());
        StringBuilder selector = new StringBuilder();
        selector.append("org,beginlocal,yeardebitlocal,yearcreditlocal,endlocal");
        if (commonAssist != null) {
            selector.append(",");
            selector.append(commonAssist.getKey());
        }
        QueryParam param = new QueryParam();
        param.setOnlyLeafAcctBal(true);
        param.setAccountFilter(new QFilter("id", "in", accts));
        DataSet balanceDs = BalanceQueryExecutor.getInstance().getBalance(selector.toString(), orgIds.toArray(new Long[0]), booksTypeId, accountTable, curPeriod, curPeriod, param);
        DataSet orgDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bos_org", (String)"id orgid,name orgname,number orgnumber", (QFilter[])new QFilter[]{new QFilter("id", "in", orgIds)}, null);
        balanceDs = balanceDs.join(orgDs, JoinType.LEFT).on("org", "orgid").select(selector.toString().split(","), new String[]{"orgname", "orgnumber"}).finish();
        for (Row row : balanceDs) {
            Map<Long, BigDecimal[]> balanceVal;
            long orgId = row.getLong("org");
            if (!result.containsKey(orgId)) {
                result.put(orgId, (Tuple<String, Map<String, List<String>>>)new Tuple((Object)(row.getString("orgnumber") + " " + row.getString("orgname")), new HashMap()));
            }
            BigDecimal balance = row.getBigDecimal("beginlocal").add(row.getBigDecimal("yeardebitlocal")).subtract(row.getBigDecimal("yearcreditlocal")).subtract(row.getBigDecimal("endlocal"));
            Long comassistVal = 0L;
            if (commonAssist != null) {
                comassistVal = row.getLong(commonAssist.getKey());
            }
            if (comassistBalance.containsKey(orgId)) {
                balanceVal = (Map)comassistBalance.get(orgId);
                if (balanceVal.containsKey(comassistVal)) {
                    ((BigDecimal[])balanceVal.get((Object)comassistVal))[0] = ((BigDecimal[])balanceVal.get(comassistVal))[0].add(balance);
                    continue;
                }
                balanceVal.put(comassistVal, new BigDecimal[]{balance, BigDecimal.ZERO});
                continue;
            }
            balanceVal = new HashMap<Long, BigDecimal[]>();
            balanceVal.put(comassistVal, new BigDecimal[]{balance, BigDecimal.ZERO});
            comassistBalance.put(orgId, balanceVal);
        }
        selector = new StringBuilder();
        selector.append("org,org.name orgname,org.number orgnumber,yearamount,cfitem.direction direction");
        if (commonAssist != null) {
            selector.append(",");
            selector.append(commonAssist.getKey());
        }
        DataSet cashItem = QueryServiceHelper.queryDataSet((String)"kd.fi.gl.cashflow.CashFlowInitExecutor", (String)"gl_initcashflow", (String)selector.toString(), (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds).and("booktype", "=", (Object)booksTypeId).and("tabdelete", "=", (Object)false).and("cfitem.type", "=", (Object)"1")}, null);
        ArrayList<String> groupBys = new ArrayList<String>(Arrays.asList("org", "orgname", "orgnumber", "direction"));
        if (commonAssist != null) {
            groupBys.add(commonAssist.getKey());
        }
        cashItem = cashItem.groupBy(groupBys.toArray(new String[0])).sum("yearamount").finish();
        for (Row row : cashItem) {
            long orgId = row.getLong("org");
            if (!result.containsKey(orgId)) {
                result.put(orgId, (Tuple<String, Map<String, List<String>>>)new Tuple((Object)(row.getString("orgnumber") + " " + row.getString("orgname")), new HashMap()));
            }
            Long comassistVal = 0L;
            if (commonAssist != null) {
                comassistVal = row.getLong(commonAssist.getKey());
            }
            HashMap<Long, BigDecimal[]> cashMap = (HashMap<Long, BigDecimal[]>)comassistBalance.get(orgId);
            BigDecimal yearAmount = row.getBigDecimal("yearamount");
            if ("o".equals(row.getString("direction"))) {
                yearAmount = yearAmount.negate();
            }
            if (CollectionUtils.isEmpty((Map)cashMap)) {
                cashMap = new HashMap<Long, BigDecimal[]>();
                cashMap.put(comassistVal, new BigDecimal[]{BigDecimal.ZERO, yearAmount});
            } else if (cashMap.containsKey(comassistVal)) {
                ((BigDecimal[])cashMap.get((Object)comassistVal))[1] = ((BigDecimal[])cashMap.get(comassistVal))[1].add(yearAmount);
            } else {
                cashMap.put(comassistVal, new BigDecimal[]{BigDecimal.ZERO, yearAmount});
            }
            comassistBalance.put(orgId, cashMap);
        }
        HashMap comassistVals = new HashMap(comassistBalance.size());
        if (commonAssist != null) {
            HashSet comAssistValues = new HashSet(comassistBalance.size());
            comassistBalance.values().forEach(e -> comAssistValues.addAll(e.keySet()));
            DynamicObjectCollection collection = QueryServiceHelper.query((String)commonAssist.valueSource, (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", comAssistValues)});
            if (!CollectionUtils.isEmpty((Collection)collection)) {
                collection.stream().forEach(e -> comassistVals.put(e.getLong("id"), e.getString("name")));
            }
        }
        for (Map.Entry cb : comassistBalance.entrySet()) {
            long orgId = (Long)cb.getKey();
            for (Map.Entry entry : ((Map)cb.getValue()).entrySet()) {
                if (DebugTrace.enable()) {
                    logger.info(String.format("checkCloseInitByComassist comassistBalance entry: [%1$s] ; value: [%2$s , %3$s]", entry.getKey(), ((BigDecimal[])entry.getValue())[0].toString(), ((BigDecimal[])entry.getValue())[1].toString()));
                }
                if (((BigDecimal[])entry.getValue())[0].compareTo(((BigDecimal[])entry.getValue())[1]) == 0) continue;
                String commonAssistName = commonAssist != null ? commonAssist.name : "";
                String errorName = (String)comassistVals.get(entry.getKey());
                HashMap<String, ArrayList> errorDatas = (HashMap<String, ArrayList>)errorMap.get(orgId);
                if (CollectionUtils.isEmpty((Map)errorDatas)) {
                    errorDatas = new HashMap<String, ArrayList>();
                    errorMap.put(orgId, errorDatas);
                }
                if (StringUtils.isEmpty((CharSequence)errorName)) {
                    errorDatas.put(commonAssistName, new ArrayList(1));
                    continue;
                }
                if (errorDatas.containsKey(commonAssistName)) {
                    ((List)errorDatas.get(commonAssistName)).add(errorName);
                    continue;
                }
                errorDatas.put(commonAssistName, Lists.newArrayList((Object[])new String[]{errorName}));
            }
        }
        for (Map.Entry entry : errorMap.entrySet()) {
            if (CollectionUtils.isEmpty((Map)((Map)entry.getValue()))) continue;
            result.put((Long)entry.getKey(), (Tuple<String, Map<String, List<String>>>)new Tuple(result.get(entry.getKey()).item1, entry.getValue()));
        }
    }
}

