/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.opplugin;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.opplugin.GLAccountBookDeleteValidator;
import kd.fi.gl.util.QFBuilder;

public class GLAccountBookDeleteOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List keys = e.getFieldKeys();
        keys.add("org");
        keys.add("bookstype");
        keys.add("isendinitcashflow");
        keys.add("isendinit");
        keys.add("isbizunit");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.getValidators().add(new GLAccountBookDeleteValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] accountBooks = e.getDataEntities();
        QFBuilder qfBuilder = new QFBuilder();
        for (DynamicObject accountBook : accountBooks) {
            long orgId = accountBook.getLong(GLField.id_((String)"org"));
            long bookTypeId = accountBook.getLong(GLField.id_((String)"bookstype"));
            qfBuilder.clear();
            qfBuilder.add("org", "=", (Object)orgId);
            qfBuilder.add("booktype", "=", (Object)bookTypeId);
            DeleteServiceHelper.delete((String)"gl_openedperiod", (QFilter[])qfBuilder.toArray());
            String orgNumber = accountBook.getString("org.number");
            String booksType = accountBook.getString("bookstype.number");
            AccSysUtil.disabledBookIDCache((long)orgId, (long)bookTypeId, (String)orgNumber, (String)booksType);
        }
    }
}

