/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.opplugin;

import com.alibaba.fastjson.JSONObject;
import com.google.common.cache.LoadingCache;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.util.Tuple2;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.model.schema.basedata.MeasureUnitSchema;
import kd.fi.bd.model.schema.property.Prop;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.accsys.AccountInfo;
import kd.fi.gl.balcal.InitBalanceKey;
import kd.fi.gl.comassist.model.ComAssistTable;
import kd.fi.gl.constant.Balance;
import kd.fi.gl.constant.InitBalance;
import kd.fi.gl.opplugin.InitBalSaveUtil;
import kd.fi.gl.util.GLApp;
import kd.fi.gl.util.GLUtil;

public class InitBalanceSaveValidator
extends AbstractValidator {
    private static final String BALKEY = "initbalance-balIds";

    public void addErrorMessage(ExtendedDataEntity dataEntity, String content) {
        super.addErrorMessage(dataEntity, content);
    }

    public void validate() {
        Set<Long> accIds = Stream.of(this.dataEntities).mapToLong(x -> x.getDataEntity().getLong(InitBalance.id_((String)"account"))).boxed().collect(Collectors.toSet());
        Set budgetTypes = GLUtil.getBudgetTypes();
        Map<Long, AccountInfo> accInfoMap = this.getAccountInfoById(accIds);
        ArrayList<InitBalanceKey> balIds = (ArrayList<InitBalanceKey>)ThreadCache.get((Object)BALKEY);
        if (balIds == null) {
            balIds = new ArrayList<InitBalanceKey>(64);
            ThreadCache.put((Object)BALKEY, balIds);
        }
        MeasureUnitSchema unitSchema = MeasureUnitSchema.instance;
        LoadingCache unitCache = GLUtil.getDyoLoadingCache((String)unitSchema.entity, (String)Prop.toSelectFieldStr((Prop[])new Prop[]{unitSchema.group}), (long)100L, (QFilter[])new QFilter[0]);
        Set<InitBalanceKey> initBalanceKeySet = this.buildExistKeys();
        String isCover = this.getOption().getVariableValue("cover", "false");
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            boolean dumpBeginQty;
            long curPeriodId;
            DynamicObject dyn = dataEntity.getDataEntity();
            long orgId = dyn.getLong(InitBalance.id_((String)"org"));
            long bookTypeId = dyn.getLong(InitBalance.id_((String)"booktype"));
            AccountBookInfo book = AccSysUtil.getBookFromAccSys((long)orgId, (long)bookTypeId);
            InitBalSaveUtil.checkMulLocalCurAmtNotZero(dataEntity, orgId, bookTypeId, this);
            long accountTableId = AccSysUtil.getCurPeriodAccountTableId((long)orgId, (long)bookTypeId, (long)book.getStartPeriodId());
            dyn.set("accounttable_id", (Object)accountTableId);
            Object[] commonAssistMustInputSize = ComAssistTable.get((Long)accountTableId).getCommonAssists().stream().filter(commonAssist -> commonAssist.isRequired).filter(comAssist -> dyn.getDynamicObject(comAssist.key) == null).map(commonAssist -> commonAssist.getLocaleName().getLocaleValue()).peek(comAssistName -> this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u516c\u5171\u7ef4\u5ea6\u201c%s\u201d\u4e3a\u5fc5\u5f55\u9879\u3002", (String)"InitBalanceSaveValidator_20", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]), comAssistName))).toArray();
            if (commonAssistMustInputSize.length > 0) continue;
            InitBalanceKey key = this.buildKey(dataEntity);
            if (!Boolean.parseBoolean(isCover) && this.existSameDataFromDB(key, initBalanceKeySet)) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6b64\u6570\u636e\u5728\u5217\u8868\u5df2\u5b58\u5728", (String)"InitBalanceSaveValidator_23", (String)"fi-gl-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            if (balIds.contains(key)) {
                String accountNum = dataEntity.getDataEntity().getString("account.number");
                this.addMessage(dataEntity, ResManager.loadKDString((String)"%1$s\u79d1\u76ee\u5bfc\u5165\u7684\u6570\u636e\u4e2d\u5b58\u5728\u76f8\u540c\u7684\u6570\u636e\u3002", (String)"InitBalanceSaveValidator_0", (String)"fi-gl-opplugin", (Object[])new Object[]{accountNum}), ErrorLevel.Error);
                continue;
            }
            balIds.add(key);
            if (dyn.get("currency") == null) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u5bf9\u5e94\u5e01\u79cd\u3002", (String)"InitBalanceSaveValidator_1", (String)"fi-gl-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            if (book == null) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u5bf9\u5e94\u8d26\u7c3f\u3002", (String)"InitBalanceSaveValidator_2", (String)"fi-gl-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            if (!book.isIsbizunit()) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u65e0\u6cd5\u5bfc\u5165\u865a\u4f53\u8d26\u7c3f\u3002", (String)"InitBalanceSaveValidator_3", (String)"fi-gl-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
            } else if (book.isIsendinit()) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u4e0d\u80fd\u5bfc\u5165\u3002", (String)"InitBalanceSaveValidator_4", (String)"fi-gl-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            dyn.set(InitBalance.id_((String)"curlocal"), (Object)book.getBaseCurrencyId());
            if (book.getBaseCurrencyId() == dyn.getLong(InitBalance.id_((String)"currency"))) {
                String fields = "begindebit#,begincredit#,yeardebit#,yearcredit#,yearprofitdebit#,yearprofitcredit#";
                for (String field : fields.split(",")) {
                    if (0 == dyn.getBigDecimal(field.replace("#", "for")).compareTo(dyn.getBigDecimal(field.replace("#", "local")))) continue;
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u79d1\u76ee\u5e01\u79cd\u548c\u8d26\u7c3f\u672c\u4f4d\u5e01\u4e00\u81f4\u65f6\uff0c\u539f\u5e01\u91d1\u989d\u5e94\u4e0e\u672c\u4f4d\u5e01\u4fdd\u6301\u4e00\u81f4\u3002", (String)"InitBalanceSaveValidator_5", (String)"fi-gl-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                }
            }
            InitBalSaveUtil.checkLocalCurAmtIsSame(dataEntity, book, this);
            long accId = dyn.getLong(InitBalance.id_((String)"account"));
            if (accId == 0L) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u79d1\u76ee\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InitBalanceSaveValidator_6", (String)"fi-gl-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            AccountInfo accountInfo = accInfoMap.get(accId);
            if (accountInfo == null) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u65e0\u6cd5\u65b0\u589e\u975e\u660e\u7ec6\u79d1\u76ee\u3002", (String)"InitBalanceSaveValidator_7", (String)"fi-gl-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            if (!book.isBudget() && budgetTypes.contains(accountInfo.getAccountType())) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6b64\u8d26\u7c3f\u672a\u5f00\u542f\u9884\u7b97\u4f1a\u8ba1\uff0c\u65e0\u6cd5\u521d\u59cb\u5316\u9884\u7b97\u4f1a\u8ba1\u79d1\u76ee\u3002", (String)"InitBalanceSaveValidator_21", (String)"fi-gl-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            long measureunit = dyn.getLong(Balance.join((String[])new String[]{"measureunit", "id"}));
            if (!accountInfo.isQty() && measureunit != 0L) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u79d1\u76ee\u4e0d\u6838\u7b97\u6570\u91cf\uff0c\u4e0d\u5141\u8bb8\u5f55\u5165\u8ba1\u91cf\u5355\u4f4d\u3002", (String)"InitBalanceSaveValidator_8", (String)"fi-gl-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            if (accountInfo.isQty() && measureunit != 0L) {
                long unitGrp = ((DynamicObject)unitCache.getUnchecked((Object)measureunit)).getLong(InitBalance.id_((String)unitSchema.group.toFullName()));
                if (accountInfo.getUnitGroup() != 0L && accountInfo.getUnitGroup() != unitGrp) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8ba1\u91cf\u5355\u4f4d\u6240\u5728\u5206\u7ec4\u4e0e\u79d1\u76ee\u7684\u8ba1\u91cf\u5355\u4f4d\u5206\u7ec4\u5c5e\u6027\u4e0d\u4e00\u81f4\u3002", (String)"InitBalanceSaveValidator_22", (String)"fi-gl-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                    continue;
                }
            }
            if (measureunit == 0L) {
                boolean hasQty;
                boolean bl = hasQty = dyn.getBigDecimal("begindebitqty").compareTo(BigDecimal.ZERO) != 0 || dyn.getBigDecimal("begincreditqty").compareTo(BigDecimal.ZERO) != 0 || dyn.getBigDecimal("yeardebitqty").compareTo(BigDecimal.ZERO) != 0 || dyn.getBigDecimal("yearcreditqty").compareTo(BigDecimal.ZERO) != 0 || dyn.getBigDecimal("yearprofitdebitqty").compareTo(BigDecimal.ZERO) != 0 || dyn.getBigDecimal("yearprofitcreditqty").compareTo(BigDecimal.ZERO) != 0;
                if (hasQty) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8ba1\u91cf\u5355\u4f4d\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u5f55\u5165\u6570\u91cf\u3002", (String)"InitBalanceSaveValidator_9", (String)"fi-gl-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                    continue;
                }
            }
            if ((curPeriodId = book.getCurPeriodId()) % GLUtil.YEAR_PERIOD_L / 10L == 1L) {
                boolean hasYearAmount = dyn.getBigDecimal("yearcreditfor").compareTo(BigDecimal.ZERO) != 0 || dyn.getBigDecimal("yearcreditlocal").compareTo(BigDecimal.ZERO) != 0 || dyn.getBigDecimal("yearcreditqty").compareTo(BigDecimal.ZERO) != 0 || dyn.getBigDecimal("yeardebitfor").compareTo(BigDecimal.ZERO) != 0 || dyn.getBigDecimal("yeardebitlocal").compareTo(BigDecimal.ZERO) != 0 || dyn.getBigDecimal("yeardebitqty").compareTo(BigDecimal.ZERO) != 0;
                boolean mulLocalCurAmtNotZero = InitBalSaveUtil.checkMLYearAmtNotZero(dyn, book);
                if (hasYearAmount || mulLocalCurAmtNotZero) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u4e3a\u4e00\u671f\uff0c\u4e0d\u5141\u8bb8\u5f55\u5165\u672c\u5e74\u7d2f\u8ba1\u3002", (String)"InitBalanceSaveValidator_10", (String)"fi-gl-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                    continue;
                }
                boolean hasProfit = this.checkHasProfit(dyn, book);
                if (hasProfit) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u671f\u95f4\u4e3a\u4e00\u671f\uff0c\u4e0d\u5141\u8bb8\u5f55\u5165\u5b9e\u9645\u635f\u76ca\u3002", (String)"InitBalanceSaveValidator_11", (String)"fi-gl-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                    continue;
                }
            }
            boolean dumpBeginFor = dyn.getBigDecimal("begindebitfor").compareTo(BigDecimal.ZERO) != 0 && dyn.getBigDecimal("begincreditfor").compareTo(BigDecimal.ZERO) != 0;
            boolean dumpBeginLocal = dyn.getBigDecimal("begindebitlocal").compareTo(BigDecimal.ZERO) != 0 && dyn.getBigDecimal("begincreditlocal").compareTo(BigDecimal.ZERO) != 0;
            boolean bl = dumpBeginQty = dyn.getBigDecimal("begindebitqty").compareTo(BigDecimal.ZERO) != 0 && dyn.getBigDecimal("begincreditqty").compareTo(BigDecimal.ZERO) != 0;
            if (dumpBeginFor) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u671f\u521d\u4f59\u989d\u4e0d\u80fd\u540c\u65f6\u5f55\u5165\u501f\u65b9\u539f\u5e01\u548c\u8d37\u65b9\u539f\u5e01\u3002", (String)"InitBalanceSaveValidator_12", (String)"fi-gl-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            if (dumpBeginLocal) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u671f\u521d\u4f59\u989d\u4e0d\u80fd\u540c\u65f6\u5f55\u5165\u501f\u65b9\u672c\u4f4d\u5e01\u548c\u8d37\u65b9\u672c\u4f4d\u5e01\u3002", (String)"InitBalanceSaveValidator_13", (String)"fi-gl-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            if (dumpBeginQty) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u671f\u521d\u4f59\u989d\u4e0d\u80fd\u540c\u65f6\u5f55\u5165\u501f\u65b9\u6570\u91cf\u548c\u8d37\u65b9\u6570\u91cf\u3002", (String)"InitBalanceSaveValidator_14", (String)"fi-gl-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            InitBalSaveUtil.checkMLBeginEnd(dataEntity, book, this);
            Long currencyId = dyn.getLong(InitBalance.id_((String)"currency"));
            String curType = accountInfo.getCurType();
            if ("nocurrency".equals(curType)) {
                Long baseCurrencyId = book.getBaseCurrencyId();
                if (!currencyId.equals(baseCurrencyId)) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u79d1\u76ee\u4ec5\u9650\u4e8e\u6838\u7b97\u672c\u4f4d\u5e01\u3002", (String)"InitBalanceSaveValidator_15", (String)"fi-gl-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                    continue;
                }
            } else if ("descurrency".equals(curType) && !accountInfo.getDesCurIds().contains(currencyId)) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u79d1\u76ee\u53ea\u80fd\u6838\u7b97\u5176\u6307\u5b9a\u5e01\u79cd\u3002", (String)"InitBalanceSaveValidator_16", (String)"fi-gl-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            if (accountInfo.isAssist()) {
                List assItems = accountInfo.getAssItems();
                Map assFlexToNameMap = accountInfo.getAssFlexToNameMap();
                DynamicObject assgrp = dyn.getDynamicObject("assgrp");
                for (Tuple2 assItem : assItems) {
                    JSONObject assValue;
                    if (!((Boolean)assItem.t2).booleanValue()) continue;
                    JSONObject jSONObject = assValue = assgrp == null ? null : JSONObject.parseObject((String)assgrp.getString("value"));
                    if (assValue != null && assValue.keySet().contains(assItem.t1)) continue;
                    String name = (String)assFlexToNameMap.get(assItem.t1);
                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6\uff1a%s\u4e3a\u5fc5\u5f55\u9879\u3002", (String)"InitBalanceSaveValidator_17", (String)"fi-gl-opplugin", (Object[])new Object[0]), name), ErrorLevel.Error);
                    break;
                }
            }
            if (!"4".equals(accountInfo.getAccountType()) && this.checkHasProfit(dyn, book)) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u79d1\u76ee\u4e3a\u635f\u76ca\u7c7b\u79d1\u76ee\u624d\u53ef\u4ee5\u5f55\u5165\u672c\u5e74\u5b9e\u9645\u635f\u76ca\u91d1\u989d\u9879\u3002", (String)"InitBalanceSaveValidator_18", (String)"fi-gl-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
            }
            if (!"4".equals(accountInfo.getAccountType())) continue;
            if (this.chechYearAmortZero(dyn)) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u79d1\u76ee\u4e3a\u635f\u76ca\u7c7b\u79d1\u76ee\uff0c\u635f\u76ca\u7c7b\u79d1\u76ee\u6709\u5b9e\u9645\u53d1\u751f\u989d\u5219\u672c\u5e74\u7d2f\u8ba1\u5fc5\u5f55\u3002", (String)"InitBalanceSaveValidator_19", (String)"fi-gl-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            InitBalSaveUtil.checkMLYearAmtNotZeroWithProfit(dataEntity, book, this);
        }
    }

    private boolean chechYearAmortZero(DynamicObject dyn) {
        return (dyn.getBigDecimal("yearprofitdebitlocal").compareTo(BigDecimal.ZERO) != 0 || dyn.getBigDecimal("yearprofitcreditlocal").compareTo(BigDecimal.ZERO) != 0) && dyn.getBigDecimal("yeardebitlocal").compareTo(BigDecimal.ZERO) == 0 && dyn.getBigDecimal("yearcreditlocal").compareTo(BigDecimal.ZERO) == 0;
    }

    private boolean checkHasProfit(DynamicObject dyn, AccountBookInfo book) {
        return dyn.getBigDecimal("yearprofitcreditfor").compareTo(BigDecimal.ZERO) != 0 || dyn.getBigDecimal("yearprofitcreditlocal").compareTo(BigDecimal.ZERO) != 0 || dyn.getBigDecimal("yearprofitcreditqty").compareTo(BigDecimal.ZERO) != 0 || dyn.getBigDecimal("yearprofitdebitfor").compareTo(BigDecimal.ZERO) != 0 || dyn.getBigDecimal("yearprofitdebitlocal").compareTo(BigDecimal.ZERO) != 0 || dyn.getBigDecimal("yearprofitdebitqty").compareTo(BigDecimal.ZERO) != 0 || InitBalSaveUtil.checkMLYearProfitAmtNotZero(dyn, book);
    }

    private InitBalanceKey buildKey(ExtendedDataEntity dataEntity) {
        DynamicObject initBalance = dataEntity.getDataEntity();
        long orgId = initBalance.getLong(InitBalance.id_((String)"org"));
        long bookTypeId = initBalance.getLong(InitBalance.id_((String)"booktype"));
        long accId = initBalance.getLong("account.masterid");
        long assId = initBalance.getLong(InitBalance.id_((String)"assgrp"));
        long curId = initBalance.getLong(InitBalance.id_((String)"currency"));
        long unitId = initBalance.getLong(InitBalance.id_((String)"measureunit"));
        long[] comAssistIDs = ComAssistTable.get((Long)initBalance.getLong(InitBalance.id_((String)"accounttable"))).getAllCommonAssistKeys().stream().map(arg_0 -> ((DynamicObject)initBalance).getDynamicObject(arg_0)).map(DataEntityBase::getPkValue).map(Long.class::cast).mapToLong(Long::longValue).toArray();
        return new InitBalanceKey(orgId, bookTypeId, accId, assId, curId, unitId, comAssistIDs);
    }

    private Map<Long, AccountInfo> getAccountInfoById(Set<Long> accIds) {
        QFilter idFilter = new QFilter("id", "in", accIds);
        QFilter leafFilter = new QFilter("isleaf", "=", (Object)true);
        String sel = "id,acctcurrency,currencyentry.currency,checkitementry.asstactitem,checkitementry.isrequire,checkitementry.isdetail,isassist,isqty,measureunitgroup,measureunit,accounttype.accounttype";
        DynamicObject[] accDyns = BusinessDataServiceHelper.load((String)"bd_accountview", (String)sel, (QFilter[])new QFilter[]{idFilter, leafFilter});
        HashMap<Long, AccountInfo> result = new HashMap<Long, AccountInfo>(accDyns.length);
        for (DynamicObject accDyn : accDyns) {
            long id = accDyn.getLong("id");
            AccountInfo accountInfo = new AccountInfo(accDyn);
            result.put(id, accountInfo);
        }
        return result;
    }

    private boolean existSameDataFromDB(InitBalanceKey key, Set<InitBalanceKey> initBalanceKeySet) {
        for (InitBalanceKey initBalanceKey : initBalanceKeySet) {
            if (!initBalanceKey.equals((Object)key)) continue;
            return true;
        }
        return false;
    }

    private Set<InitBalanceKey> buildExistKeys() {
        HashSet<Long> idSet = new HashSet<Long>(this.dataEntities.length);
        HashSet<Long> orgIdSet = new HashSet<Long>(this.dataEntities.length);
        HashSet<Long> bookTypeIdSet = new HashSet<Long>(this.dataEntities.length);
        HashSet<Long> accountIdSet = new HashSet<Long>(this.dataEntities.length);
        HashSet<Long> assgrpIdSet = new HashSet<Long>(this.dataEntities.length);
        HashSet<Long> currencyIdSet = new HashSet<Long>(this.dataEntities.length);
        HashSet<Long> unitIdSet = new HashSet<Long>(this.dataEntities.length);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject initBalance = dataEntity.getDataEntity();
            idSet.add(initBalance.getLong("id"));
            orgIdSet.add(initBalance.getLong(InitBalance.id_((String)"org")));
            bookTypeIdSet.add(initBalance.getLong(InitBalance.id_((String)"booktype")));
            accountIdSet.add(initBalance.getLong("account.masterid"));
            assgrpIdSet.add(initBalance.getLong(InitBalance.id_((String)"assgrp")));
            currencyIdSet.add(initBalance.getLong(InitBalance.id_((String)"currency")));
            unitIdSet.add(initBalance.getLong(InitBalance.id_((String)"measureunit")));
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "not in", idSet), new QFilter("org", "in", orgIdSet), new QFilter("booktype", "in", bookTypeIdSet), new QFilter("account.masterid", "in", accountIdSet), new QFilter("assgrp", "in", assgrpIdSet), new QFilter("currency", "in", currencyIdSet), new QFilter("measureunit", "in", unitIdSet), new QFilter("isdeleted", "=", (Object)"0")};
        String allCommonAssistKeys = String.join((CharSequence)", ", ComAssistTable.getMaxCommonAssistKeys());
        if (allCommonAssistKeys.length() > 0) {
            allCommonAssistKeys = ", " + allCommonAssistKeys;
        }
        DynamicObjectCollection initBalanceDys = QueryServiceHelper.query((String)"gl_initbalance", (String)("id, org org_id, booktype booktype_id, accounttable, account.masterid, assgrp assgrp_id, currency currency_id, measureunit measureunit_id" + allCommonAssistKeys), (QFilter[])filters);
        HashSet<InitBalanceKey> existKeySet = new HashSet<InitBalanceKey>(initBalanceDys.size());
        for (DynamicObject initBalance : initBalanceDys) {
            existKeySet.add(new InitBalanceKey(initBalance));
        }
        return existKeySet;
    }
}

