/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.opplugin.reci;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.gl.opplugin.reci.ReciprocalAntiInitValidator;
import kd.fi.gl.util.GLUtil;

public class ReciprocalAntiInitOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new ReciprocalAntiInitValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        super.beginOperationTransaction(args);
        DynamicObject[] dataEntities = args.getDataEntities();
        List accountIdSet = Arrays.stream(dataEntities).map(dynamicObject -> dynamicObject.getLong("account.masterid")).collect(Collectors.toList());
        long orgId = Long.parseLong(this.getOption().getVariableValue("org"));
        long bookType = Long.parseLong(this.getOption().getVariableValue("bookstype"));
        try {
            Object reciprocalInitState;
            QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
            QFilter bookTypeFilter = new QFilter("booktype", "=", (Object)bookType);
            QFilter accountFilter = new QFilter("account.masterid", "in", accountIdSet);
            DynamicObject[] reciprocalInitStates = BusinessDataServiceHelper.load((String)"gl_reci_init_state", (String)"id, account, isendinit, modifier,modifydate", (QFilter[])new QFilter[]{orgFilter, bookTypeFilter, accountFilter});
            QFilter accountSingleFilter = null;
            QFilter stateFilter = new QFilter("status", "not in", (Object)"0");
            HashSet<Long> allMasterIdSet = new HashSet<Long>(8);
            for (int i = 0; i < reciprocalInitStates.length; ++i) {
                reciprocalInitState = reciprocalInitStates[i];
                reciprocalInitState.set("isendinit", (Object)false);
                String userId = RequestContext.get().getUserId();
                reciprocalInitState.set("modifier", (Object)Long.valueOf(userId));
                reciprocalInitState.set("modifydate", (Object)TimeServiceHelper.now());
                DynamicObject acct = reciprocalInitState.getDynamicObject("account");
                allMasterIdSet.add(acct.getLong("masterid"));
            }
            accountSingleFilter = new QFilter("account", "in", allMasterIdSet);
            DataSet ds = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "queryaccurent"), (String)"gl_acccurrent", (String)"account", (QFilter[])new QFilter[]{orgFilter, bookTypeFilter, accountSingleFilter, stateFilter}, null);
            reciprocalInitState = null;
            try {
                for (Row row : ds) {
                    allMasterIdSet.remove(row.getLong("account"));
                }
            }
            catch (Throwable userId) {
                reciprocalInitState = userId;
                throw userId;
            }
            finally {
                if (ds != null) {
                    if (reciprocalInitState != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable userId) {
                            ((Throwable)reciprocalInitState).addSuppressed(userId);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
            List idList = GLUtil.getIdsByMasterIds((String)"bd_accountview", allMasterIdSet, null, (int)-1);
            if (idList != null && !idList.isEmpty()) {
                int size = idList.size() + 1;
                ArrayList<String> idStr = new ArrayList<String>(size);
                ArrayList<Long> param = new ArrayList<Long>(size);
                param.add(orgId);
                param.add(bookType);
                for (Object id : idList) {
                    idStr.add("?");
                    param.add((Long)id);
                }
                ArrayList<QFilter> delFilters = new ArrayList<QFilter>(4);
                QFilter deleteAccountFilter = new QFilter("account.masterid", "in", allMasterIdSet);
                delFilters.add(orgFilter);
                delFilters.add(bookTypeFilter);
                delFilters.add(deleteAccountFilter);
                DeleteServiceHelper.delete((String)"gl_reci_init_state", (QFilter[])delFilters.toArray(new QFilter[0]));
                QFilter deleteInitAcccFilter = new QFilter("voucherid", "=", (Object)0);
                delFilters.add(deleteInitAcccFilter);
                DeleteServiceHelper.delete((String)"gl_acccurrent", (QFilter[])delFilters.toArray(new QFilter[0]));
                String sql = "update t_gl_initacccurrent set freciprocalrecordid = 0 where forgid = ? and fbooktypeid = ? and faccountid in (" + String.join((CharSequence)",", idStr) + ")";
                DB.execute((DBRoute)DBRoute.of((String)"gl"), (String)sql, (Object[])param.toArray());
            }
            SaveServiceHelper.save((DynamicObject[])reciprocalInitStates);
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, new ErrorCode("reciAntiEndInit", e.getMessage()), new Object[]{""});
        }
    }
}

