/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.reciprocal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContextCreator;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.operation.EntityOperateService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.bd.util.BatchProcessUtil;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.accsys.AccountBookInfo;
import kd.fi.gl.enums.WriteOffMode;
import kd.fi.gl.reciprocal.ReciprocalEngine;
import kd.fi.gl.reciprocal.ReciprocalScheme;
import kd.fi.gl.reciprocal.ReciprocalUtils;

public class ReciprocalWriteOffOpService
extends EntityOperateService {
    private static final String ORG = "useorg";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String ACCOUNT = "account";
    private static final String CURRENCY = "currency";
    private static final String ACCOUNTTABLE = "accounttable";
    private static final String WRITEOFFMODE = "writeoffmode";
    private static final String VERIFIORDER = "verifiorder";
    private static final String REVERORDERSAMEDIRE = "reverordersamedire";
    private static final String EQUALAMOUNTPRIORITY = "equalamountpriority";
    private static final String VERIFIDIFFBUSINO = "verifidiffbusino";
    private static final String NOVERIFIBUSINOEMPTY = "noverifibusinoempty";
    private static final String EQUALCANVERFI = "moneyequacanverfi";
    private static final String EXCULDEUNPOSTVOUCHER = "excluunpostvoucher";
    private static final String VOUCHERFILTERJSON = "voucherfilterjson";
    private static final String ENABLE = "enable";
    private static final String select_fileds = "number,name,useorg,account,currency,verifiorder,verifidiffbusino,reverordersamedire,equalamountpriority,noverifibusinoempty,moneyequacanverfi,excluunpostvoucher,enable,voucherfilterjson,writeoffmode";
    private static final Log logger = LogFactory.getLog(ReciprocalWriteOffOpService.class);

    protected void preparePropertys(List<String> fieldKeys) {
        super.preparePropertys(fieldKeys);
        fieldKeys.add(ORG);
        fieldKeys.add(NUMBER);
        fieldKeys.add(NAME);
        fieldKeys.add(ACCOUNT);
        fieldKeys.add(CURRENCY);
        fieldKeys.add(VERIFIORDER);
        fieldKeys.add(REVERORDERSAMEDIRE);
        fieldKeys.add(EQUALAMOUNTPRIORITY);
        fieldKeys.add(VERIFIDIFFBUSINO);
        fieldKeys.add(NOVERIFIBUSINOEMPTY);
        fieldKeys.add(EQUALCANVERFI);
        fieldKeys.add(EXCULDEUNPOSTVOUCHER);
        fieldKeys.add(ENABLE);
        fieldKeys.add(VOUCHERFILTERJSON);
        fieldKeys.add(WRITEOFFMODE);
    }

    /*
     * WARNING - void declaration
     */
    protected void executeOperate(DynamicObject[] entitys) {
        HashMap<String, List> orgAndSchemes;
        block24: {
            void var12_19;
            DynamicObject[] accountbookDt;
            OperateOption option;
            block23: {
                DynamicObject defaultScheme;
                option = this.getOption();
                orgAndSchemes = new HashMap<String, List>();
                if (option == null || !option.containsVariable("autoByPage")) break block23;
                entitys = this.querySchemes(option);
                if (entitys == null || entitys.length <= 0) {
                    logger.info("\u672a\u80fd\u627e\u5230\u5339\u914d\u7684\u6838\u9500\u65b9\u6848\uff0c\u5373\u5c06\u9000\u51fa..");
                    return;
                }
                for (DynamicObject entity : entitys) {
                    ReciprocalScheme scheme = this.buildScheme(entity, Long.valueOf(option.getVariableValue("booktype")), option, null);
                    String key = scheme.getOrg() + "-" + scheme.getBookType();
                    ArrayList<Object> schemes = (ArrayList<Object>)orgAndSchemes.get(key);
                    if (schemes == null) {
                        schemes = new ArrayList<Object>();
                        orgAndSchemes.put(key, schemes);
                    }
                    schemes.add(scheme);
                }
                List accountListFromPage = (List)SerializationUtils.deSerializeFromBase64((String)option.getVariableValue("accountmater"));
                ArrayList schemeAccounts = new ArrayList(8);
                for (List schemes : orgAndSchemes.values()) {
                    for (ReciprocalScheme scheme : schemes) {
                        schemeAccounts.addAll(scheme.getAccountList());
                    }
                }
                if (schemeAccounts.isEmpty()) break block24;
                accountListFromPage.removeAll(schemeAccounts);
                if (accountListFromPage.isEmpty() || (defaultScheme = this.getDefaultScheme(option)) == null) break block24;
                ReciprocalScheme scheme = this.buildDefaultScheme(defaultScheme, Long.valueOf(option.getVariableValue("booktype")), option, accountListFromPage);
                String key = scheme.getOrg() + "-" + scheme.getBookType();
                List schemes = orgAndSchemes.computeIfAbsent(key, v -> new ArrayList(8));
                schemes.add(scheme);
                break block24;
            }
            Long intellexecschemaId = null;
            if (option != null && option.containsVariable("gl_intellexecschema")) {
                intellexecschemaId = Long.valueOf(option.getVariableValue("gl_intellexecschema"));
            }
            if (intellexecschemaId == null) {
                return;
            }
            QFilter intellexecschemaFilter = new QFilter("id", "=", intellexecschemaId);
            QFilter schemaOrgFilter = new QFilter("orgentryentity.orgid", "is not null", null);
            DataSet orgDt = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_intellexecschema", (String)"orgentryentity.orgid orgid", (QFilter[])new QFilter[]{intellexecschemaFilter, schemaOrgFilter}, null);
            HashSet<Long> orgSet = new HashSet<Long>(8);
            for (Row row : orgDt) {
                orgSet.add(row.getLong("orgid"));
            }
            if (orgSet.isEmpty()) {
                QFilter[] filters = new QFilter[]{new QFilter(ENABLE, "=", (Object)"1"), new QFilter("isbizunit", "=", (Object)true)};
                accountbookDt = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_accountbook", (String)"org.id orgid, bookstype.id type", (QFilter[])filters, null);
                for (Row row : accountbookDt) {
                    orgSet.add(row.getLong("orgid"));
                }
            }
            ArrayList<Long> schemeIds = new ArrayList<Long>(8);
            accountbookDt = entitys;
            int n = accountbookDt.length;
            boolean bl = false;
            while (var12_19 < n) {
                DynamicObject entity = accountbookDt[var12_19];
                schemeIds.add(entity.getLong("id"));
                ++var12_19;
            }
            HashMap orgAndSchemeMap = new HashMap(8);
            for (Long l : orgSet) {
                QFilter writeOffWayFilter;
                QFilter enableFilter;
                QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"gl_reciprocal_scheme", (Long)l);
                Map map = BusinessDataServiceHelper.loadFromCache((String)"gl_reciprocal_scheme", (String)ORG, (QFilter[])new QFilter[]{orgFilter, enableFilter = new QFilter(ENABLE, "=", (Object)"1"), writeOffWayFilter = ReciprocalUtils.getWriteOffWayFilter((String)"2")});
                if (map.isEmpty()) continue;
                ArrayList<Long> schemeList = new ArrayList<Long>(8);
                for (Map.Entry entry : map.entrySet()) {
                    DynamicObject schemeObj = (DynamicObject)entry.getValue();
                    schemeList.add(schemeObj.getLong("id"));
                }
                schemeList.retainAll(schemeIds);
                if (schemeList.isEmpty()) continue;
                orgAndSchemeMap.put(l, schemeList);
            }
            if (orgAndSchemeMap.isEmpty()) {
                return;
            }
            ArrayList<Long> authorityOrgList = new ArrayList<Long>(orgAndSchemeMap.keySet());
            Map<Long, List<Long>> map = this.queryExistsBookTypeByOrgIds(authorityOrgList);
            for (DataSet dataSet : entitys) {
                String enable = dataSet.getString(ENABLE);
                if ("0".equals(enable)) continue;
                long schemeId = dataSet.getLong("id");
                for (Long orgId : authorityOrgList) {
                    List schemeIdList = (List)orgAndSchemeMap.get(orgId);
                    if (!schemeIdList.contains(schemeId)) continue;
                    List<Long> bookTypes = map.get(orgId);
                    if (bookTypes == null || bookTypes.size() == 0) {
                        this.addErrorInfo(String.format(ResManager.loadKDString((String)"\u65b9\u6848\u3010%1$s\u3011%2$s\u65e0\u53ef\u7528\u7684\u8d26\u7c3f\u7c7b\u578b\u3002", (String)"ReciprocalWriteOffOpService_0", (String)"fi-gl-opplugin", (Object[])new Object[0]), dataSet.get(NUMBER), dataSet.get(NAME)));
                        continue;
                    }
                    for (Long bookType : bookTypes) {
                        ReciprocalScheme scheme = this.buildScheme((DynamicObject)dataSet, bookType, option, orgId);
                        String key = orgId + "-" + bookType;
                        ArrayList<ReciprocalScheme> schemes = (ArrayList<ReciprocalScheme>)orgAndSchemes.get(key);
                        if (schemes == null) {
                            schemes = new ArrayList<ReciprocalScheme>();
                            orgAndSchemes.put(key, schemes);
                        }
                        schemes.add(scheme);
                    }
                }
            }
        }
        ArrayList<Future> resultList = new ArrayList<Future>(orgAndSchemes.size());
        for (List schemes : orgAndSchemes.values()) {
            Future future = ThreadService.submit((Callable)new ReciprocalEngine(schemes, RequestContextCreator.createForThreadPool()), (TaskType)TaskType.GL_RECIPROCAL_WRITE_OFF);
            resultList.add(future);
        }
        for (Future taskResult : resultList) {
            try {
                if (((Boolean)taskResult.get()).booleanValue()) continue;
                this.getOperationResult().setSuccess(false);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private Map<Long, List<Long>> queryExistsBookTypeByOrgIds(List<Long> orgList) {
        HashMap<Long, List<Long>> bookIdAndTypeMap = new HashMap<Long, List<Long>>();
        try (DataSet dSet = BatchProcessUtil.batchQueryDataSet(orgList, batchData -> QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"gl_accountbook", (String)"org.id id,bookstype.id type", (QFilter[])new QFilter[]{new QFilter("org", "in", batchData), new QFilter(ENABLE, "=", (Object)"1")}, null));){
            for (Row row : dSet) {
                Long orgId = row.getLong("id");
                Long typeId = row.getLong("type");
                ArrayList<Long> lst = (ArrayList<Long>)bookIdAndTypeMap.get(orgId);
                if (lst == null) {
                    lst = new ArrayList<Long>();
                    bookIdAndTypeMap.put(orgId, lst);
                }
                lst.add(typeId);
            }
        }
        return bookIdAndTypeMap;
    }

    private ReciprocalScheme buildScheme(DynamicObject entity, Long bookType, OperateOption option, Long authOrgId) {
        ReciprocalScheme scheme = new ReciprocalScheme();
        scheme.setNumber(entity.getString(NUMBER));
        if (option != null && option.containsVariable("autoByPage")) {
            scheme.setOrg(Long.valueOf(option.getVariableValue("org")));
            scheme.setWriteOffType(1);
            if (option.containsVariable(ACCOUNTTABLE)) {
                scheme.setAccountTableId(Long.valueOf(option.getVariableValue(ACCOUNTTABLE)));
            }
            scheme.setAccountListFromPage((List)SerializationUtils.deSerializeFromBase64((String)option.getVariableValue("accountmater")));
            if (option.containsVariable("startperiod")) {
                scheme.setStartPeriod(Long.valueOf(option.getVariableValue("startperiod")));
            }
            if (option.containsVariable("endperiod")) {
                scheme.setEndPeriod(Long.valueOf(option.getVariableValue("endperiod")));
            }
            if (option.containsVariable("manualWriteoff")) {
                scheme.setManualWriteoff(Boolean.parseBoolean(option.getVariableValue("manualWriteoff")));
            }
        } else {
            scheme.setOrg(authOrgId);
            scheme.setWriteOffType(0);
        }
        scheme.setBookType(bookType);
        DynamicObjectCollection accts = entity.getDynamicObjectCollection(ACCOUNT);
        ArrayList<Long> actIds = new ArrayList<Long>();
        for (DynamicObject acct : accts) {
            DynamicObject basedataid = acct.getDynamicObject("fbasedataid");
            if (basedataid == null) continue;
            actIds.add(basedataid.getLong("masterid"));
        }
        scheme.setAccountList(actIds);
        DynamicObjectCollection currencys = entity.getDynamicObjectCollection(CURRENCY);
        ArrayList<Long> currencyList = new ArrayList<Long>();
        for (DynamicObject currency : currencys) {
            currencyList.add(currency.getLong("fbasedataid_id"));
        }
        if (option != null && option.containsVariable(CURRENCY)) {
            List currencyListFromPage = (List)SerializationUtils.deSerializeFromBase64((String)option.getVariableValue(CURRENCY));
            currencyList.addAll(currencyListFromPage);
        }
        Set assgrpIds = null;
        if (option != null && option.containsVariable("assgrp")) {
            String assgrp = option.getVariableValue("assgrp");
            assgrpIds = (Set)SerializationUtils.deSerializeFromBase64((String)assgrp);
        }
        QFilter vchQFilter = null;
        if (option != null && option.containsVariable("vchQFilter")) {
            String vchQFilterStr = option.getVariableValue("vchQFilter");
            vchQFilter = (QFilter)SerializationUtils.deSerializeFromBase64((String)vchQFilterStr);
        }
        Set reciIds = null;
        if (option != null && option.containsVariable("reciIds")) {
            String reciIdsStr = option.getVariableValue("reciIds");
            reciIds = (Set)SerializationUtils.deSerializeFromBase64((String)reciIdsStr);
        }
        scheme.setCurrencyList(currencyList);
        scheme.setWriteOffMode(entity.getString(WRITEOFFMODE));
        scheme.setVerifiOrder(entity.getString(VERIFIORDER));
        scheme.setReverOrderSameDire(entity.getBoolean(REVERORDERSAMEDIRE));
        scheme.setVerifiDiffBusiNo(entity.getBoolean(VERIFIDIFFBUSINO));
        scheme.setNoVerifiBusiNoEmpty(entity.getBoolean(NOVERIFIBUSINOEMPTY));
        scheme.setEquaCanVerfi(entity.getBoolean(EQUALCANVERFI));
        scheme.setExculdeUnPostVoucher(entity.getBoolean(EXCULDEUNPOSTVOUCHER));
        scheme.setVoucherFilterJson(entity.getString(VOUCHERFILTERJSON));
        scheme.setAssgrpIdList(assgrpIds);
        scheme.setVchQFilterFromPage(vchQFilter);
        scheme.setReciprocalIdList(reciIds);
        scheme.setEqualamountpriority(entity.getBoolean(EQUALAMOUNTPRIORITY));
        if (option != null && option.containsVariable("ITimeService") && option.containsVariable("IUserService")) {
            scheme.setTimeService(option.getVariableValue("ITimeService"));
            scheme.setUserService(option.getVariableValue("IUserService"));
        }
        return scheme;
    }

    private void addErrorInfo(String str) {
        OperateErrorInfo temp = new OperateErrorInfo(str, ErrorLevel.FatalError, (Object)0);
        temp.setMessage(str);
        temp.setTitle(str);
        OperationResult res = this.getOperationResult();
        res.addErrorInfo(temp);
    }

    private DynamicObject[] querySchemes(OperateOption option) {
        String currency;
        List currencyIds;
        Long orgid = Long.valueOf(option.getVariableValue("org"));
        Long booktype = Long.valueOf(option.getVariableValue("booktype"));
        AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys((long)orgid, (long)booktype);
        String accountMaster = option.getVariableValue("accountmater");
        List accountMasterIds = (List)SerializationUtils.deSerializeFromBase64((String)accountMaster);
        QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"gl_reciprocal_scheme", (Long)orgid);
        QFilter accounttableFilter = new QFilter(ACCOUNTTABLE, "=", (Object)bookInfo.getAccountTableId());
        QFilter accountFilter = new QFilter("account.fbasedataid.masterid", "in", (Object)accountMasterIds);
        QFilter enableFilter = new QFilter(ENABLE, "=", (Object)"1");
        QFilter currentyFilter = null;
        if (option.containsVariable(CURRENCY) && (currencyIds = (List)SerializationUtils.deSerializeFromBase64((String)(currency = option.getVariableValue(CURRENCY)))) != null && !currencyIds.isEmpty()) {
            currentyFilter = new QFilter("currency.fbasedataid", "in", (Object)currencyIds).or(new QFilter("currency.fbasedataid", "is null", null));
        }
        QFilter writeOffWayFilter = null;
        writeOffWayFilter = option.containsVariable("manualWriteoff") ? ReciprocalUtils.getWriteOffWayFilter((String)"1") : ReciprocalUtils.getWriteOffWayFilter((String)"2");
        QFilter[] filters = new QFilter[]{orgFilter, accountFilter, enableFilter, currentyFilter, accounttableFilter, writeOffWayFilter};
        DynamicObject[] schemeDynamicObjects = BusinessDataServiceHelper.load((String)"gl_reciprocal_scheme", (String)select_fileds, (QFilter[])filters);
        if (schemeDynamicObjects == null || schemeDynamicObjects.length == 0) {
            accountFilter = new QFilter("account.fbasedataid", "is null", null);
            filters = new QFilter[]{orgFilter, accountFilter, enableFilter, accounttableFilter, writeOffWayFilter};
            schemeDynamicObjects = BusinessDataServiceHelper.load((String)"gl_reciprocal_scheme", (String)select_fileds, (QFilter[])filters);
        }
        for (DynamicObject schemaDyn : schemeDynamicObjects) {
            if (!WriteOffMode.BALANCE.name().equalsIgnoreCase(schemaDyn.getString(WRITEOFFMODE))) continue;
            schemaDyn.set(VERIFIDIFFBUSINO, (Object)Boolean.TRUE);
            schemaDyn.set(NOVERIFIBUSINOEMPTY, (Object)Boolean.FALSE);
            schemaDyn.set(EQUALCANVERFI, (Object)Boolean.FALSE);
            schemaDyn.set(EQUALAMOUNTPRIORITY, (Object)Boolean.FALSE);
            schemaDyn.set(EXCULDEUNPOSTVOUCHER, (Object)Boolean.FALSE);
        }
        return schemeDynamicObjects;
    }

    private ReciprocalScheme buildDefaultScheme(DynamicObject entity, Long bookType, OperateOption option, List<Long> accountListFromPage) {
        ReciprocalScheme scheme = new ReciprocalScheme();
        scheme.setNumber(entity.getString(NUMBER));
        scheme.setOrg(Long.valueOf(option.getVariableValue("org")));
        scheme.setWriteOffType(1);
        scheme.setAccountListFromPage(accountListFromPage);
        if (option != null && option.containsVariable("startperiod")) {
            scheme.setStartPeriod(Long.valueOf(option.getVariableValue("startperiod")));
        }
        if (option != null && option.containsVariable("endperiod")) {
            scheme.setEndPeriod(Long.valueOf(option.getVariableValue("endperiod")));
        }
        if (option != null && option.containsVariable("manualWriteoff")) {
            scheme.setManualWriteoff(Boolean.parseBoolean(option.getVariableValue("manualWriteoff")));
        }
        scheme.setBookType(bookType);
        scheme.setAccountList(accountListFromPage);
        DynamicObjectCollection currencys = entity.getDynamicObjectCollection(CURRENCY);
        ArrayList<Long> currencyList = new ArrayList<Long>();
        for (DynamicObject currency : currencys) {
            currencyList.add(currency.getLong("fbasedataid_id"));
        }
        if (option != null && option.containsVariable(CURRENCY)) {
            List currencyListFromPage = (List)SerializationUtils.deSerializeFromBase64((String)option.getVariableValue(CURRENCY));
            currencyList.addAll(currencyListFromPage);
        }
        Set assgrpIds = null;
        if (option != null && option.containsVariable("assgrp")) {
            String assgrp = option.getVariableValue("assgrp");
            assgrpIds = (Set)SerializationUtils.deSerializeFromBase64((String)assgrp);
        }
        QFilter vchQFilter = null;
        if (option != null && option.containsVariable("vchQFilter")) {
            String vchQFilterStr = option.getVariableValue("vchQFilter");
            vchQFilter = (QFilter)SerializationUtils.deSerializeFromBase64((String)vchQFilterStr);
        }
        Set reciIds = null;
        if (option != null && option.containsVariable("reciIds")) {
            String reciIdsStr = option.getVariableValue("reciIds");
            reciIds = (Set)SerializationUtils.deSerializeFromBase64((String)reciIdsStr);
        }
        scheme.setCurrencyList(currencyList);
        scheme.setVerifiOrder(entity.getString(VERIFIORDER));
        scheme.setReverOrderSameDire(entity.getBoolean(REVERORDERSAMEDIRE));
        scheme.setVerifiDiffBusiNo(entity.getBoolean(VERIFIDIFFBUSINO));
        scheme.setNoVerifiBusiNoEmpty(entity.getBoolean(NOVERIFIBUSINOEMPTY));
        scheme.setEquaCanVerfi(entity.getBoolean(EQUALCANVERFI));
        scheme.setExculdeUnPostVoucher(entity.getBoolean(EXCULDEUNPOSTVOUCHER));
        scheme.setVoucherFilterJson(entity.getString(VOUCHERFILTERJSON));
        scheme.setAssgrpIdList(assgrpIds);
        scheme.setVchQFilterFromPage(vchQFilter);
        scheme.setReciprocalIdList(reciIds);
        scheme.setEqualamountpriority(entity.getBoolean(EQUALAMOUNTPRIORITY));
        if (option != null && option.containsVariable("ITimeService") && option.containsVariable("IUserService")) {
            scheme.setTimeService(option.getVariableValue("ITimeService"));
            scheme.setUserService(option.getVariableValue("IUserService"));
        }
        return scheme;
    }

    private DynamicObject getDefaultScheme(OperateOption option) {
        String currency;
        List currencyIds;
        Long orgid = Long.valueOf(option.getVariableValue("org"));
        Long booktype = Long.valueOf(option.getVariableValue("booktype"));
        AccountBookInfo bookInfo = AccSysUtil.getBookFromAccSys((long)orgid, (long)booktype);
        QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"gl_reciprocal_scheme", (Long)orgid);
        QFilter accounttableFilter = new QFilter(ACCOUNTTABLE, "=", (Object)bookInfo.getAccountTableId());
        QFilter enableFilter = new QFilter(ENABLE, "=", (Object)"1");
        QFilter currentyFilter = null;
        if (option.containsVariable(CURRENCY) && (currencyIds = (List)SerializationUtils.deSerializeFromBase64((String)(currency = option.getVariableValue(CURRENCY)))) != null && !currencyIds.isEmpty()) {
            currentyFilter = new QFilter("currency.fbasedataid", "in", (Object)currencyIds).or(new QFilter("currency.fbasedataid", "is null", null));
        }
        if (currentyFilter == null) {
            currentyFilter = new QFilter("currency.fbasedataid", "in", (Object)bookInfo.getBaseCurrencyId()).or(new QFilter("currency.fbasedataid", "is null", null));
        }
        QFilter accountFilter = new QFilter("account.fbasedataid", "is null", null);
        QFilter writeOffWayFilter = null;
        writeOffWayFilter = option.containsVariable("manualWriteoff") ? ReciprocalUtils.getWriteOffWayFilter((String)"1") : ReciprocalUtils.getWriteOffWayFilter((String)"2");
        QFilter[] filters = new QFilter[]{orgFilter, enableFilter, accountFilter, currentyFilter, accounttableFilter, writeOffWayFilter};
        DynamicObject[] schemeDynamicObjects = BusinessDataServiceHelper.load((String)"gl_reciprocal_scheme", (String)select_fileds, (QFilter[])filters, (String)"currency.fbasedataid asc");
        DynamicObject schemeDynamicObject = null;
        if (schemeDynamicObjects != null && schemeDynamicObjects.length != 0) {
            schemeDynamicObject = schemeDynamicObjects[0];
        }
        return schemeDynamicObject;
    }
}

