/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.validate.flex;

import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.flex.FlexProperty;
import kd.fi.bd.util.FlexUtils;
import kd.fi.gl.flex.FlexValueJson;
import kd.fi.gl.util.GLApp;
import kd.fi.gl.validate.flex.AssistFlexValueValidator;
import kd.fi.gl.validate.flex.BaseDataFlexValueValidator;
import kd.fi.gl.validate.flex.FlexValueDataGetter;
import kd.fi.gl.validate.flex.IFlexValueValidator;
import kd.fi.gl.validate.flex.OrgFlexValueValidator;
import kd.fi.gl.voucher.validate.AccountWrapper;
import kd.fi.gl.voucher.validate.ItemWrapper;
import kd.fi.gl.voucher.validate.VchEntryWrapper;

public class FlexValueValidateService {
    private Map<String, FlexProperty> flexPropertyCache;
    private FlexValueDataGetter flexValueDataGetter;
    private IFlexValueValidator orgFlexValueValidator;
    private IFlexValueValidator baseDataFlexValueValidator;
    private IFlexValueValidator assistFlexValueValidator;

    public FlexValueValidateService() {
        this.init();
    }

    private void init() {
        if (this.flexPropertyCache == null) {
            Map allFlexFieldIdMap = FlexUtils.getAllFlexFieldIdMap();
            this.flexPropertyCache = FlexUtils.batchGetFlexProperty((String[])allFlexFieldIdMap.keySet().toArray(new String[0]));
        }
    }

    private FlexValueDataGetter getFlexValueDataGetter() {
        if (this.flexValueDataGetter == null) {
            this.flexValueDataGetter = new FlexValueDataGetter();
        }
        return this.flexValueDataGetter;
    }

    private IFlexValueValidator getOrgFlexValueValidator() {
        if (this.orgFlexValueValidator == null) {
            this.orgFlexValueValidator = new OrgFlexValueValidator();
        }
        return this.orgFlexValueValidator;
    }

    private IFlexValueValidator getBaseDataFlexValueValidator() {
        if (this.baseDataFlexValueValidator == null) {
            this.baseDataFlexValueValidator = new BaseDataFlexValueValidator();
        }
        return this.baseDataFlexValueValidator;
    }

    private IFlexValueValidator getAssistFlexValueValidator() {
        if (this.assistFlexValueValidator == null) {
            this.assistFlexValueValidator = new AssistFlexValueValidator();
        }
        return this.assistFlexValueValidator;
    }

    public Optional<String> validateMustInput(AccountWrapper account, VchEntryWrapper entryDyn) {
        if (account.getRequiredFlexs().isEmpty()) {
            return Optional.empty();
        }
        DynamicObject flexValueDyn = entryDyn.getDynamicObject("assgrp");
        if (flexValueDyn == null) {
            return Optional.of(ResManager.loadKDString((String)"\u672a\u5f55\u6838\u7b97\u7ef4\u5ea6", (String)"FlexValueValidateService_0", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
        }
        String valueJson = flexValueDyn.getString("value");
        return this.validateMustInput(account, valueJson);
    }

    public Optional<String> validateMustInput(AccountWrapper account, String valueJson) {
        if (account.getRequiredFlexs().isEmpty()) {
            return Optional.empty();
        }
        if (StringUtils.isBlank((CharSequence)valueJson)) {
            return Optional.of(ResManager.loadKDString((String)"\u672a\u5f55\u6838\u7b97\u7ef4\u5ea6", (String)"FlexValueValidateService_0", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
        }
        Map map = (Map)SerializationUtils.fromJsonString((String)valueJson, Map.class);
        for (Map.Entry<String, String> requiredFlex : account.getRequiredFlexs().entrySet()) {
            Object value = map.get(requiredFlex.getKey());
            if (value != null && (value instanceof String || !"0".equals(String.valueOf(value)))) continue;
            return Optional.of(String.format(ResManager.loadKDString((String)"\u672a\u5f55\u5177\u4f53\u6838\u7b97\u7ef4\u5ea6\uff1a%s", (String)"FlexValueValidateService_1", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]), requiredFlex.getValue()));
        }
        return Optional.empty();
    }

    public Optional<String> validateAvailable(ItemWrapper account, VchEntryWrapper entryDyn, String assgrp, boolean isAccount) {
        if (account.getFlexFieldList().isEmpty() || entryDyn.getDynamicObject(assgrp) == null) {
            return Optional.empty();
        }
        return this.validateAvailable(account, entryDyn.getDynamicObject(assgrp).getString("value"), isAccount);
    }

    public Optional<String> validateAvailable(AccountWrapper account, DynamicObject entryDyn) {
        if (account.getFlexFieldList().isEmpty() || entryDyn.getDynamicObject("assgrp") == null) {
            return Optional.empty();
        }
        return this.validateAvailable(account, entryDyn.getDynamicObject("assgrp").getString("value"), Boolean.TRUE);
    }

    public Optional<String> validateAvailable(ItemWrapper account, String valueJson, boolean isAccount) {
        if (account.getFlexFieldList().isEmpty() || StringUtils.isBlank((CharSequence)valueJson)) {
            return Optional.empty();
        }
        FlexValueJson flexValueJson = new FlexValueJson(valueJson);
        Map valueMap = flexValueJson.getValueMap();
        for (Map.Entry valueMapEntry : valueMap.entrySet()) {
            Optional<String> error = this.singleValidate((String)valueMapEntry.getKey(), valueMapEntry.getValue(), account, isAccount);
            if (!error.isPresent()) continue;
            return error;
        }
        return Optional.empty();
    }

    private Optional<String> singleValidate(String flexField, Object value, ItemWrapper account, boolean isAccount) {
        IFlexValueValidator validator;
        FlexProperty flexProperty = this.flexPropertyCache.get(flexField);
        if (null != flexProperty && (validator = this.getValidator(flexProperty)) != null) {
            Optional<String> error = validator.validateDisable(this.getFlexValueDataGetter(), flexProperty, value, isAccount);
            if (error.isPresent()) {
                return error;
            }
            if (account.getDetailFlexs().containsKey(flexProperty.getFlexField()) && (error = validator.validateDetail(this.getFlexValueDataGetter(), flexProperty, value, isAccount)).isPresent()) {
                return error;
            }
        }
        return Optional.empty();
    }

    private IFlexValueValidator getValidator(FlexProperty flexProperty) {
        if ("3".equals(flexProperty.getValueType())) {
            return null;
        }
        if ("2".equals(flexProperty.getValueType())) {
            return this.getAssistFlexValueValidator();
        }
        if ("bos_org".equals(flexProperty.getValueSource()) || "bos_adminorg".equals(flexProperty.getValueSource())) {
            return this.getOrgFlexValueValidator();
        }
        return this.getBaseDataFlexValueValidator();
    }
}

