/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.validate.flex;

import java.util.Collections;
import java.util.Set;
import kd.bos.entity.flex.FlexProperty;
import kd.fi.gl.util.QFBuilder;
import kd.fi.gl.validate.flex.AbstractFlexValueValidator;
import kd.fi.gl.validate.flex.FlexValueDataGetter;

public class OrgFlexValueValidator
extends AbstractFlexValueValidator {
    private static final String ENABLE = "enable";
    private static final String ISFREEZE = "isfreeze";
    private static final String BOS_ORG_STRUCTURE = "bos_org_structure";
    private static final String VIEW = "view";
    private static final String ISLEAF = "isleaf";

    @Override
    public Set<Long> getParentDataSet(FlexValueDataGetter flexValueDataGetter, FlexProperty flexProperty) {
        long orgFuncId = this.getOrgFuncId(flexProperty);
        if (orgFuncId == 0L) {
            return Collections.emptySet();
        }
        String parentDataCacheKey = String.join((CharSequence)"-", "bos_org", String.valueOf(orgFuncId));
        QFBuilder parentFilter = new QFBuilder();
        parentFilter.add(VIEW, "=", (Object)orgFuncId);
        parentFilter.add(ISLEAF, "=", (Object)Boolean.FALSE);
        return flexValueDataGetter.getParentDataSet(parentDataCacheKey, parentFilter, BOS_ORG_STRUCTURE, "org.id");
    }

    @Override
    public Set<Long> getDisableDataSet(FlexValueDataGetter flexValueDataGetter, FlexProperty flexProperty) {
        if ("bos_org".equalsIgnoreCase(flexProperty.getValueSource())) {
            return flexValueDataGetter.getDisableDataSet("bos_org", new QFBuilder(ENABLE, "=", (Object)Boolean.FALSE), "bos_org", "id");
        }
        return flexValueDataGetter.getDisableDataSet(BOS_ORG_STRUCTURE, new QFBuilder(ISFREEZE, "=", (Object)Boolean.TRUE), BOS_ORG_STRUCTURE, "org.id");
    }

    private long getOrgFuncId(FlexProperty flexProperty) {
        if ("bos_org".equals(flexProperty.getValueSource())) {
            return flexProperty.getOrgFunc() > 0L ? flexProperty.getOrgFunc() : 15L;
        }
        if ("bos_adminorg".equals(flexProperty.getValueSource())) {
            return 1L;
        }
        return 0L;
    }
}

