/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.dtxservice;

import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.kdtx.common.exception.NoRetryException;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.kdtx.sdk.api.EventualConsistencyService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bd.util.DebugTrace;
import kd.fi.bd.util.TimerFactory;
import kd.fi.gl.voucher.dtxservice.VoucherPresetParm;
import kd.fi.gl.voucher.preset.CashFlowPresetService;

public class DtxVoucherSavePresetService
extends EventualConsistencyService {
    private static final Log LOG = LogFactory.getLog(DtxVoucherSavePresetService.class);

    public DtxResponse execute(Object param, Object lastReturn) throws Exception {
        long tick = System.currentTimeMillis();
        VoucherPresetParm voucherPresetParm = (VoucherPresetParm)param;
        try (TXHandle x = TX.requiresNew();){
            try {
                TimerFactory.Timer timer = TimerFactory.getTimer(((Object)((Object)this)).getClass());
                timer.time("CashFlowPresetService start");
                CashFlowPresetService.batchPreset(voucherPresetParm);
                timer.time("CashFlowPresetService end");
            }
            catch (Throwable cause) {
                LOG.error(cause);
                x.markRollback();
                throw new NoRetryException("invoke DtxVoucherSubmitPostService fail", cause);
            }
        }
        if (DebugTrace.enable()) {
            LOG.info("DtxVoucherSubmitPostService cost: {}", (Object)(System.currentTimeMillis() - tick));
        }
        return null;
    }
}

