/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.jms;

import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.fi.gl.notice.NoticeQueueParam;
import kd.fi.gl.notice.NoticeTaskDispatcher;
import kd.fi.gl.util.GLUtil;

public class AcNoticeConsumer
implements MessageConsumer {
    private static final Log LOGGER = LogFactory.getLog(AcNoticeConsumer.class);

    public void onMessage(Object msg, String messageId, boolean resend, MessageAcker acker) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Recevied Message: %s, msgId=%s, resend=%s", msg, messageId, resend));
        }
        try {
            if (msg instanceof String) {
                NoticeQueueParam param = (NoticeQueueParam)SerializationUtils.fromJsonString((String)((String)msg), NoticeQueueParam.class);
                NoticeTaskDispatcher.dispatch((NoticeQueueParam)param);
            }
        }
        catch (Exception ex) {
            LOGGER.error(GLUtil.printError((Throwable)ex));
            throw ex;
        }
        finally {
            acker.ack(messageId);
        }
    }
}

