/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.mc.validator;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ValidatePriority;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.gl.business.service.voucher.mc.MulLocalConfig;
import kd.fi.gl.business.vo.voucher.wrap.DynamicVoucherWrap;

public class MulLocalCurrencyInitValidator
extends AbstractValidator {
    public MulLocalCurrencyInitValidator() {
        this.setSeq(0);
        this.setValidatePriority(ValidatePriority.First);
    }

    public void validate() {
        ExtendedDataEntity[] extendedDataEntities = this.getDataEntities();
        CurrencyReader currencyReader = new CurrencyReader(this.getValidateContext().getBillEntityType());
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            MulLocalConfig[] configs;
            DynamicVoucherWrap voucher = new DynamicVoucherWrap(extendedDataEntity.getDataEntity());
            long orgId = voucher.getOrgId();
            long bookTypeId = voucher.getBookTypeId();
            for (MulLocalConfig config : configs = MulLocalConfig.enabledConfigs((long)orgId, (long)bookTypeId)) {
                String currencyKey = config.getCurrencyField();
                DynamicObject currency = voucher.getDynamicObject(currencyKey);
                if (currency != null) continue;
                voucher.set(currencyKey, (Object)currencyReader.loadCurrency(currencyKey, config.getCurrencyId(Long.valueOf(orgId), Long.valueOf(bookTypeId))));
            }
        }
    }

    private static class CurrencyReader {
        private final Map<String, BasedataProp> currencyProps;
        private final Table<String, Long, DynamicObject> currencyCache = HashBasedTable.create();

        private CurrencyReader(MainEntityType billEntityType) {
            Map allFields = billEntityType.getAllFields();
            this.currencyProps = Arrays.stream(MulLocalConfig.getEnabledCurrencyFieldKeys()).collect(Collectors.toMap(x -> x, x -> (BasedataProp)allFields.get(x)));
        }

        private DynamicObject loadCurrency(String currencyKey, Long currencyId) {
            DynamicObject currency = (DynamicObject)this.currencyCache.get((Object)currencyKey, (Object)currencyId);
            if (currency == null) {
                currency = BusinessDataServiceHelper.loadSingleFromCache((Object)currencyId, (DynamicObjectType)this.currencyProps.get(currencyKey).getDynamicComplexPropertyType());
                this.currencyCache.put((Object)currencyKey, (Object)currencyId, (Object)currency);
            }
            return currency;
        }
    }
}

