/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.preset;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.service.voucher.TempVoucherCFService;
import kd.fi.gl.voucher.dtxservice.VoucherPresetParm;
import kd.fi.gl.voucher.preset.BatchPresetProcessor;
import kd.fi.gl.voucher.preset.VoucherHead;

public class CashFlowPresetService {
    private static final String VOUCHER_SELECT_FIELDS = "id,org,period,mainstatus,suppstatus,entries.id entryid,entries.account,entries.account.iscash,entries.account.isbank,entries.account.iscashequivalent,entries.account.accounttype,entries.assgrp,entries.assgrp.value,entries.creditlocal,entries.debitlocal,entries.maincfitem,entries.maincfamount,entries.maincfassgrp,entries.suppcfitem,entries.suppcfamount,entries.account.longnumber,entries.entrydc,entries.account.accounttable";
    private static final int BATCH_PRESET_SIZE = 1000;

    public static void batchPreset(VoucherPresetParm param) {
        Set<Long> voucherIds = param.getVoucherIds();
        if (CollectionUtils.isEmpty(voucherIds)) {
            return;
        }
        List<Long> voucherIdList = CashFlowPresetService.distinctIdColl(voucherIds);
        if (CollectionUtils.isEmpty(voucherIdList)) {
            TempVoucherCFService.updateOrInsert(param.getVoucherIds(), param.getvId2orgId(), param.getVoucher2Cashflow());
            return;
        }
        try (DataSet voucherDataSet = CashFlowPresetService.queryVoucherDataSet(voucherIdList);){
            BatchPresetProcessor batchPresetProcessor = BatchPresetProcessor.create(1000, param);
            VoucherHead lastVoucherHead = null;
            for (Row row : voucherDataSet) {
                Row persist = RowUtil.persist((Row)row);
                Long id = persist.getLong("id");
                if (lastVoucherHead == null || id.longValue() != lastVoucherHead.getId()) {
                    lastVoucherHead = new VoucherHead(id, persist.getString("mainstatus"), persist.getString("suppstatus"), persist.getLong("org"), persist.getLong("entries.account.accounttable"), persist.getLong("period"));
                }
                batchPresetProcessor.processing(lastVoucherHead, persist);
            }
            if (lastVoucherHead != null) {
                batchPresetProcessor.endProcess();
            }
        }
    }

    private static DataSet queryVoucherDataSet(Collection<Long> voucherIdColl) {
        QFilter idFilter = new QFilter("id", "in", voucherIdColl);
        return QueryServiceHelper.queryDataSet((String)CashFlowPresetService.class.getName(), (String)"gl_voucher", (String)VOUCHER_SELECT_FIELDS, (QFilter[])idFilter.toArray(), (String)"id");
    }

    private static List<Long> distinctIdColl(Collection<Long> idColl) {
        return idColl.stream().distinct().filter(x -> x != null && x > 0L).collect(Collectors.toList());
    }
}

