/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.preset;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.util.CollectionUtils;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.bd.util.TimerFactory;

class VoucherBatchProcessor {
    private static final String ENTRY_UPDATE_SQL = "update t_gl_voucherentry set fmaincfitemid=?,fmaincfamount=?,fsuppcfitemid=?,fsuppcfamount=?,fmaincfassgrpid=? where fentryid=?";
    private static final String VOUCHER_UPDATE_SQL = "update t_gl_voucher set fmainstatus=?,fsuppstatus=? where fid=?";
    private final List<Object[]> voucherEntryUpdateParamList;
    private final List<Object[]> voucherUpdateParamList;
    private final Map<Long, List<Object[]>> tempVoucherEntryUpdateParamMap;
    private final List<Long> voucherIdList;
    private final int batchSize;
    private final TimerFactory.Timer timer;

    private VoucherBatchProcessor(int batchSize) {
        this.batchSize = batchSize;
        this.voucherEntryUpdateParamList = new ArrayList<Object[]>(batchSize);
        this.voucherUpdateParamList = new ArrayList<Object[]>(batchSize);
        this.tempVoucherEntryUpdateParamMap = new HashMap<Long, List<Object[]>>(8);
        this.voucherIdList = new ArrayList<Long>(batchSize);
        this.timer = TimerFactory.getTimer(this.getClass());
    }

    protected static VoucherBatchProcessor create(int batchSize) {
        return new VoucherBatchProcessor(batchSize);
    }

    protected void processing() {
        if (this.voucherUpdateParamList.size() >= this.batchSize || this.voucherEntryUpdateParamList.size() >= this.batchSize) {
            this.timer.time("VoucherBatchProcessor_doCurrentBatchUpdate start");
            this.doCurrentBatchUpdate();
            this.timer.time("VoucherBatchProcessor_doCurrentBatchUpdate end");
        }
    }

    protected void endProcess() {
        this.tempVoucherEntryUpdateParamMap.values().forEach(this.voucherEntryUpdateParamList::addAll);
        this.tempVoucherEntryUpdateParamMap.clear();
        this.doCurrentBatchUpdate();
    }

    private void doCurrentBatchUpdate() {
        try (ShardingHintContext ignored = ShardingHintContext.createAndSet((String)"t_gl_voucher", (HintCondition[])new HintCondition[]{new HintCondition("fid", FilterType.in_range, this.voucherIdList)});){
            if (CollectionUtils.isNotEmpty(this.voucherUpdateParamList)) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)VOUCHER_UPDATE_SQL, this.voucherUpdateParamList);
            }
            if (CollectionUtils.isNotEmpty(this.voucherEntryUpdateParamList)) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"gl"), (String)ENTRY_UPDATE_SQL, this.voucherEntryUpdateParamList);
            }
        }
        this.voucherEntryUpdateParamList.clear();
        this.voucherUpdateParamList.clear();
        this.voucherIdList.clear();
    }

    protected void addEntryParam(long voucherId, Object[] param) {
        List list = this.tempVoucherEntryUpdateParamMap.computeIfAbsent(voucherId, k -> new ArrayList(10));
        list.add(param);
    }

    protected void addVoucherParam(long voucherId, Object[] param) {
        this.voucherIdList.add(voucherId);
        this.voucherUpdateParamList.add(param);
        List<Object[]> remove = this.tempVoucherEntryUpdateParamMap.remove(voucherId);
        if (remove != null) {
            this.voucherEntryUpdateParamList.addAll(remove);
        }
    }
}

