/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.util;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.LogFactory;

public class VoucherFieldKeyListProxy
implements InvocationHandler {
    private static final List<String> ALL_ENTRY_PROPS = ImmutableList.of((Object)String.join((CharSequence)".", "entries", "seq"), (Object)"edescription", (Object)"account", (Object)"currency", (Object)"measureunit", (Object)"creditori", (Object)"creditlocal", (Object)"debitori", (Object)"debitlocal", (Object)"expiredate", (Object)"businessnum", (Object)"quantity", (Object[])new String[]{"assgrp", "entrydc", "price", "maincfitem", "maincfassgrp", "maincfamount", "suppcfitem", "suppcfamount", "eorg", "eperiod", "localrate", "comassist1", "comassist2"});
    private static final CopyOnWriteArrayList<Supplier<List<String>>> ENTRY_FIELDS_BUILDERS = new CopyOnWriteArrayList();
    private final List<String> originalObject;
    private final MainEntityType voucherEntityType;
    private boolean alreadyAdd;

    public static void register(Supplier<List<String>> entryFieldsBuilder) {
        ENTRY_FIELDS_BUILDERS.add(entryFieldsBuilder);
    }

    public static List<String> getProxyInstance(List<String> originalObject, MainEntityType voucherEntityType) {
        return (List)Proxy.newProxyInstance(originalObject.getClass().getClassLoader(), originalObject.getClass().getInterfaces(), (InvocationHandler)new VoucherFieldKeyListProxy(originalObject, voucherEntityType));
    }

    private VoucherFieldKeyListProxy(List<String> originalObject, MainEntityType voucherEntityType) {
        this.originalObject = originalObject;
        this.voucherEntityType = voucherEntityType;
        this.alreadyAdd = false;
        this.init();
    }

    private void init() {
        this.originalObject.stream().filter(this::isEntryProp).findAny().ifPresent(prop -> {
            LogFactory.getLog(this.getClass()).warn("===!!!detect entry props added:{}!!!===", prop);
            this.addAllEntryFields();
        });
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().startsWith("add") && !this.alreadyAdd) {
            Object toAdd = args[args.length - 1];
            Set<String> toAddKeys = toAdd instanceof Collection ? (Set<String>)toAdd : Collections.singleton((String)toAdd);
            toAddKeys.stream().filter(this::isEntryProp).findAny().ifPresent(prop -> {
                LogFactory.getLog(this.getClass()).warn("===!!!detect entry props added:{}!!!===", prop);
                this.addAllEntryFields();
            });
        }
        return method.invoke(this.originalObject, args);
    }

    private void addAllEntryFields() {
        LinkedHashSet<String> allEntryFields = new LinkedHashSet<String>(this.originalObject);
        for (Supplier<List<String>> entryFieldsBuilder : ENTRY_FIELDS_BUILDERS) {
            allEntryFields.addAll((Collection<String>)entryFieldsBuilder.get());
        }
        this.originalObject.clear();
        this.originalObject.addAll(allEntryFields);
        this.alreadyAdd = true;
    }

    private boolean isEntryProp(String key) {
        IDataEntityProperty propertyBuf;
        String[] split = key.split("\\.");
        String simpleKey = split[split.length - 1];
        if (split.length > 1) {
            simpleKey = "entries".equalsIgnoreCase(split[0]) ? split[1] : split[0];
        }
        return (propertyBuf = this.voucherEntityType.findProperty(key)) != null && "entries".equals(propertyBuf.getParent().getName()) || (propertyBuf = this.voucherEntityType.findProperty(simpleKey)) != null && "entries".equals(propertyBuf.getParent().getName());
    }

    static {
        VoucherFieldKeyListProxy.register(() -> ALL_ENTRY_PROPS);
    }
}

