/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.validate;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.bd.consts.AccountType;
import kd.fi.gl.cache.CacheKeyPrefix;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.voucher.validate.ItemWrapper;

public class AccountWrapper
extends ItemWrapper {
    public static final String SELECT_FIELDS = String.join((CharSequence)",", "id", "isleaf", "masterid", "isassist", "bw", "number", "dc", "accrualdirection", "acctcurrency", "isqty", "pltype", "iscash", "isbank", "iscashequivalent", "acnotice", "accheck", "startdate", "enddate", "accounttable", "checkitementry.asstactitem", "checkitementry.isrequire", "checkitementry.isdetail", "currencyentry.currency", "accounttype.accounttype", "measureunitgroup", "isjournal");
    private long masterId;
    private String number;
    private boolean leaf;
    private boolean assist;
    private boolean cash;
    private boolean qty;
    private boolean bw;
    private boolean pl;
    private boolean acnotice;
    private boolean accheck;
    private boolean budget;
    private String accrualdirection;
    private String acctcurrency;
    private Date startDate;
    private Date endDate;
    private long accountTable;
    private String dc;
    private String accountType;
    private long measureUnitGroupId;
    private final Set<Long> currencyPkList = new HashSet<Long>();
    private final Map<String, String> requiredFlexs = new HashMap<String, String>();
    private final Map<String, String> detailFlexs = new HashMap<String, String>();
    private List<String> flexFieldList;
    private boolean journal;

    private AccountWrapper(DynamicObject dyn) {
        super(dyn);
    }

    public Long getPk() {
        return this.getId();
    }

    public String getNumber() {
        return this.number;
    }

    public boolean isLeaf() {
        return this.leaf;
    }

    public boolean isAssist() {
        return this.assist;
    }

    public boolean isCash() {
        return this.cash;
    }

    public boolean isQty() {
        return this.qty;
    }

    public boolean isPl() {
        return this.pl;
    }

    public boolean isBudget() {
        return this.budget;
    }

    public boolean isBw() {
        return this.bw;
    }

    public boolean isAcnotice() {
        return this.acnotice;
    }

    public String getAccrualdirection() {
        return this.accrualdirection;
    }

    public String getAcctcurrency() {
        return this.acctcurrency;
    }

    public Set<Long> getCurrencyPkList() {
        return this.currencyPkList;
    }

    @Override
    public Map<String, String> getRequiredFlexs() {
        return this.requiredFlexs;
    }

    private void setPl(boolean pl) {
        this.pl = pl;
    }

    private void setBw(boolean bw) {
        this.bw = bw;
    }

    public void setBudget(boolean budget) {
        this.budget = budget;
    }

    private void setAcnotice(boolean acnotice) {
        this.acnotice = acnotice;
    }

    private void setAccrualdirection(String accrualdirection) {
        this.accrualdirection = accrualdirection;
    }

    private void setNumber(String number) {
        this.number = number;
    }

    private void setLeaf(boolean isleaf) {
        this.leaf = isleaf;
    }

    private void setAssist(boolean isassist) {
        this.assist = isassist;
    }

    private void setCash(boolean iscash) {
        this.cash = iscash;
    }

    private void setQty(boolean isqty) {
        this.qty = isqty;
    }

    private void setAcctcurrency(String acctcurrency) {
        this.acctcurrency = acctcurrency;
    }

    private void addCurrencyPk(Long currencyPk) {
        this.currencyPkList.add(currencyPk);
    }

    @Override
    public Map<String, String> getDetailFlexs() {
        return this.detailFlexs;
    }

    @Override
    public void addDetailFlex(String flexField, String flexName) {
        this.detailFlexs.put(flexField, flexName);
    }

    @Override
    public void addRequiredFlex(String flexField, String flexName) {
        this.requiredFlexs.put(flexField, flexName);
    }

    public boolean isAccheck() {
        return this.accheck;
    }

    public void setAccheck(boolean accheck) {
        this.accheck = accheck;
    }

    public long getMasterId() {
        return this.masterId;
    }

    public void setMasterId(long masterId) {
        this.masterId = masterId;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public long getAccountTable() {
        return this.accountTable;
    }

    public void setAccountTable(long accountTable) {
        this.accountTable = accountTable;
    }

    public String getDc() {
        return this.dc;
    }

    public void setDc(String dc) {
        this.dc = dc;
    }

    public String getAccountType() {
        return this.accountType;
    }

    public void setAccountType(String accountType) {
        this.accountType = accountType;
    }

    public long getMeasureUnitGroupId() {
        return this.measureUnitGroupId;
    }

    public void setMeasureUnitGroupId(long measureUnitGroupId) {
        this.measureUnitGroupId = measureUnitGroupId;
    }

    public boolean isJournal() {
        return this.journal;
    }

    public void setJournal(boolean journal) {
        this.journal = journal;
    }

    @Override
    public List<String> getFlexFieldList() {
        return this.flexFieldList;
    }

    public static AccountWrapper load(Long accountPk) {
        return (AccountWrapper)((Object)ThreadCache.get((Object)(CacheKeyPrefix.ACCOUNT_INFO.name() + "_" + accountPk), () -> AccountWrapper.create(BusinessDataServiceHelper.loadSingleFromCache((Object)accountPk, (String)"bd_accountview", (String)SELECT_FIELDS))));
    }

    public static AccountWrapper create(DynamicObject accDyn) {
        return AccountWrapper.create(accDyn, true);
    }

    public static AccountWrapper create(DynamicObject accDyn, boolean initValue) {
        if (accDyn == null) {
            return null;
        }
        AccountWrapper acc = new AccountWrapper(accDyn);
        if (!initValue) {
            return acc;
        }
        return acc.initValue();
    }

    public AccountWrapper initValue() {
        this.setStartDate(this.getDate("startdate"));
        this.setEndDate(this.getDate("enddate"));
        this.setAccountTable(this.getLong("accounttable.id"));
        this.setNumber(this.getString("number"));
        this.setLeaf(this.getBoolean("isleaf"));
        this.setAssist(this.getBoolean("isassist"));
        this.setQty(this.getBoolean("isqty"));
        this.setCash(this.getBoolean("isbank") || this.getBoolean("iscash") || this.getBoolean("iscashequivalent"));
        this.setBw(this.getBoolean("bw"));
        this.setAcnotice(this.getBoolean("acnotice"));
        this.setAccrualdirection(this.getString("accrualdirection"));
        this.setAcctcurrency(this.getString("acctcurrency"));
        this.setAccheck(this.getBoolean("accheck"));
        this.setMasterId(this.getLong("masterid"));
        this.setPl(GLUtil.isPLAcct((DynamicObject)this.getDyn()));
        this.setDc(this.getString("dc"));
        this.setAccountType(this.getString("accounttype.accounttype"));
        this.setBudget(AccountType.isBudgetProp((String)this.getAccountType()));
        this.setMeasureUnitGroupId(this.getLong("measureunitgroup_id"));
        this.setJournal(this.getBoolean("isjournal"));
        DynamicObjectCollection asstColl = this.getDynamicObjectCollection("checkitementry");
        this.flexFieldList = new ArrayList<String>(asstColl.size());
        for (DynamicObject obj : asstColl) {
            String flexField = obj.getString("asstactitem.flexfield");
            this.flexFieldList.add(flexField);
            if (obj.getBoolean("isrequire")) {
                this.addRequiredFlex(flexField, obj.getString("asstactitem.name"));
            }
            if (!obj.getBoolean("isdetail") || "bd_admindivision".equals(obj.getString("asstactitem.valuesource.id"))) continue;
            this.addDetailFlex(flexField, obj.getString("asstactitem.name"));
        }
        DynamicObjectCollection cyColl = this.getDynamicObjectCollection("currencyentry");
        for (DynamicObject obj : cyColl) {
            this.addCurrencyPk(obj.getLong("currency.id"));
        }
        return this;
    }
}

