/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.validate;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class FlexIdValueCache {
    private final LoadingCache<Long, String> loadingCache;

    public FlexIdValueCache(int maxSize) {
        this.loadingCache = CacheBuilder.newBuilder().maximumSize((long)maxSize).build(CacheLoader.from(id -> {
            if (id == 0L) {
                return "";
            }
            return this.queryFlexIdValue(Collections.singleton(id)).getOrDefault(id, "");
        }));
    }

    public String get(Long id) {
        return (String)this.loadingCache.getUnchecked((Object)id);
    }

    public void fill(Set<Long> ids) {
        if (!ids.isEmpty()) {
            this.loadingCache.putAll(this.queryFlexIdValue(ids));
        }
    }

    private Map<Long, String> queryFlexIdValue(Set<Long> ids) {
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"vch_sub_query_assist", (String)"gl_assist", (String)"id, assvals", (QFilter[])new QFilter("id", "in", ids).toArray(), (String)"id", (int)-1);){
            HashMap<Long, String> valueMap = new HashMap<Long, String>(ids.size());
            dataSet.forEachRemaining(x -> valueMap.put(x.getLong(0), x.getString(1)));
            valueMap.put(0L, "");
            HashMap<Long, String> hashMap = valueMap;
            return hashMap;
        }
    }
}

