/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.validate;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.voucher.util.VoucherUtils;

public class VoucherAntiAuditValidator
extends AbstractValidator {
    public void initializeConfiguration() {
        super.initializeConfiguration();
        this.setOperationName(ResManager.loadKDString((String)"\t\u51ed\u8bc1\u53cd\u5ba1\u6838", (String)"VoucherAntiAuditValidator_0", (String)"fi-gl-opplugin", (Object[])new Object[0]));
    }

    public void validate() {
        this.voucherStatusCheck();
        this.voucherRelationCheck();
    }

    private void voucherRelationCheck() {
        ExtendedDataEntity[] entities = this.dataEntities;
        HashMap<Long, Boolean> map = new HashMap<Long, Boolean>(16);
        ArrayList<Long> vchIDsNeedToCheckRelation = new ArrayList<Long>(entities.length);
        for (ExtendedDataEntity extendedEntity : entities) {
            boolean needSyncDel;
            DynamicObject entity2 = extendedEntity.getDataEntity();
            Long id = entity2.getLong("id");
            Long orgId = entity2.getLong("org.id");
            if (!map.containsKey(orgId)) {
                Object obj = GLUtil.getSystemParam((String)"syndel", (Long)orgId);
                map.put(orgId, obj != null && (Boolean)obj != false);
            }
            if (needSyncDel = ((Boolean)map.get(orgId)).booleanValue()) continue;
            vchIDsNeedToCheckRelation.add(id);
        }
        if (!vchIDsNeedToCheckRelation.isEmpty()) {
            QFilter srcVoucherF = new QFilter("srcvoucherid", "in", vchIDsNeedToCheckRelation);
            Set vchIDExistRelation = QueryServiceHelper.query((String)"gl_voucher_relation", (String)"", (QFilter[])new QFilter[]{srcVoucherF}).stream().mapToLong(relationDyo -> relationDyo.getLong("srcvoucherid")).collect(HashSet::new, Set::add, AbstractCollection::addAll);
            Arrays.stream(this.dataEntities).filter(entity -> vchIDExistRelation.contains(entity.getBillPkId())).forEach(entity -> this.addErrorMessage((ExtendedDataEntity)entity, ResManager.loadKDString((String)"\u5b58\u5728\u51ed\u8bc1\u534f\u540c\u5173\u7cfb\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"VoucherAntiAuditValidator_5", (String)"fi-gl-opplugin", (Object[])new Object[0])));
        }
    }

    private void voucherStatusCheck() {
        Map map = VoucherUtils.getStatusFromDB((ExtendedDataEntity[])this.dataEntities);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject v = dataEntity.getDataEntity();
            DynamicObject book = BusinessDataServiceHelper.loadSingleFromCache((Object)v.getLong("book_id"), (String)"gl_accountbook");
            Long curPeriodId = book.getDynamicObject("curperiod").getLong("id");
            Long vchPeriodId = v.getDynamicObject("period").getLong("id");
            List opPeriod = GLUtil.getOpenPeriod((long)v.getLong("org.id"), (long)v.getLong("booktype.id"));
            if (vchPeriodId < curPeriodId && !opPeriod.contains(vchPeriodId)) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u51ed\u8bc1\u6240\u5c5e\u671f\u95f4\u5df2\u7ed3\u8d26\uff0c\u8bf7\u5148\u53cd\u7ed3\u8d26\u540e\u518d\u64cd\u4f5c\u51ed\u8bc1\u3002", (String)"VoucherAntiAuditValidator_1", (String)"fi-gl-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            String enable = book.getString("enable");
            if ("0".equals(enable)) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u65e0\u6cd5\u64cd\u4f5c\u5df2\u7981\u7528\u8d26\u7c3f\u7684\u51ed\u8bc1\u3002", (String)"VoucherAntiAuditValidator_2", (String)"fi-gl-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            if (v.getBoolean("ispost")) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u8fc7\u8d26\u51ed\u8bc1\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"VoucherAntiAuditValidator_3", (String)"fi-gl-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            if (!"C".equals(map.get(v.getLong("id")))) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u5ba1\u6838\u51ed\u8bc1\u624d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"VoucherAntiAuditValidator_4", (String)"fi-gl-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            if (!v.getDataEntityType().getProperties().containsKey((Object)"entries")) continue;
            for (DynamicObject entry : v.getDynamicObjectCollection("entries")) {
                entry.getDataEntityState().setFromDatabase(true);
            }
        }
    }
}

