/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.validate;

import java.math.BigDecimal;
import java.util.Optional;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.gl.util.SystemParamHelper;
import kd.fi.gl.voucher.validate.VoucherValidateMsgBuilder;

public class VoucherEntryQtyAndPriceValidator {
    private VoucherEntryQtyAndPriceValidator() {
    }

    protected static Optional<String> validate(long orgId, DynamicObject voucherEntryDO) {
        return VoucherEntryQtyAndPriceValidator.validate(VoucherEntryQtyAndPriceValidator.getQtyAndPriceZeroSubmitable(orgId, voucherEntryDO), voucherEntryDO.getInt("seq"));
    }

    protected static Optional<String> validate(long orgId, Row entryRow, boolean isQty) {
        return VoucherEntryQtyAndPriceValidator.validate(isQty ? VoucherEntryQtyAndPriceValidator.getQtyAndPriceZeroSubmitable(orgId, entryRow) : true, entryRow.getInteger("entries.seq"));
    }

    private static Optional<String> validate(boolean qtyAndPriceZeroSubmitable, int seq) {
        if (!qtyAndPriceZeroSubmitable) {
            return Optional.of(String.format(ResManager.loadKDString((String)"\u7b2c%s\u6761\u672a\u5f55\u5165\u6570\u91cf\u548c\u5355\u4ef7\u3002", (String)"VoucherEntryQtyAndPriceValidator_0", (String)"fi-gl-opplugin", (Object[])new Object[0]), seq));
        }
        return Optional.empty();
    }

    private static boolean getQtyAndPriceZeroSubmitable(long orgId, DynamicObject voucherEntryDO) {
        DynamicObject accountDynObj = voucherEntryDO.getDynamicObject("account");
        if (null == accountDynObj) {
            return true;
        }
        if (accountDynObj.getBoolean("isqty")) {
            return VoucherEntryQtyAndPriceValidator.getQtyAndPriceZeroSubmitable(orgId, voucherEntryDO.getBigDecimal("quantity"), voucherEntryDO.getBigDecimal("price"));
        }
        return true;
    }

    private static boolean getQtyAndPriceZeroSubmitable(long orgId, Row entryRow) {
        return VoucherEntryQtyAndPriceValidator.getQtyAndPriceZeroSubmitable(orgId, entryRow.getBigDecimal("entries.quantity"), entryRow.getBigDecimal("entries.price"));
    }

    private static boolean getQtyAndPriceZeroSubmitable(long orgId, BigDecimal qty, BigDecimal price) {
        return !SystemParamHelper.getBooleanParam((String)"qtymustinput", (long)orgId, (boolean)false) || qty.signum() != 0 && price.signum() != 0;
    }

    protected static void appendEntryMsg(VoucherValidateMsgBuilder builder, Optional<String> msg) {
        msg.ifPresent(builder::appendEntryMsg);
    }
}

