/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.validate;

import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.ext.fi.ai.v2.fah.dto.BillToVchRelationDto;
import kd.fi.gl.business.GLServiceFactory;
import kd.fi.gl.interfaces.service.dap.IDAPService;
import kd.fi.gl.notice.NoticeUtils;
import kd.fi.gl.util.GLApp;

public class VoucherNoticeValidator
extends AbstractValidator {
    private static final Set<String> captureActions = ImmutableSet.of((Object)"antiaudit", (Object)"antipost", (Object)"cancel", (Object)"delete");
    private final String voucherAction;

    public VoucherNoticeValidator(String voucherAction) {
        this.voucherAction = voucherAction;
    }

    private static IDAPService getDAPService() {
        return (IDAPService)GLServiceFactory.getService(IDAPService.class);
    }

    public void validate() {
        if (!captureActions.contains(this.voucherAction) || ArrayUtils.isEmpty((Object[])this.dataEntities)) {
            return;
        }
        DynamicObject[] voucherDyns = (DynamicObject[])Arrays.stream(this.dataEntities).map(ExtendedDataEntity::getDataEntity).toArray(DynamicObject[]::new);
        Set filterVouchersForNotice = NoticeUtils.preFilterVouchersForNotice((DynamicObject[])voucherDyns, (String)this.voucherAction);
        if (filterVouchersForNotice.isEmpty()) {
            return;
        }
        Set<Long> voucherIds = this.findVoucherGeneratedVoucherIds(filterVouchersForNotice);
        if (voucherIds.isEmpty()) {
            return;
        }
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            if (!voucherIds.contains((Long)dataEntity.getBillPkId())) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5b58\u5728\u5f80\u6765\u901a\u77e5\u5355\u5df2\u88ab\u5bf9\u65b9\u7ec4\u7ec7\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u80fd%s\u3002", (String)"VoucherNoticeValidator_0", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]), this.getOperationName()));
        }
    }

    public Set<Long> findVoucherGeneratedVoucherIds(Set<Long> voucherIds) {
        HashSet<Long> result = new HashSet<Long>(2);
        HashMap<Long, Long> sourceIdToVchIdMap = new HashMap<Long, Long>(8);
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.appendIn("select fid ,fvoucherid from t_gl_acnotice where fvoucherid", voucherIds.toArray());
        try (DataSet dataSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder);){
            for (Row row : dataSet) {
                sourceIdToVchIdMap.put(row.getLong("fid"), row.getLong("fvoucherid"));
            }
        }
        if (!sourceIdToVchIdMap.isEmpty()) {
            Set sourceIds = sourceIdToVchIdMap.keySet();
            BillToVchRelationDto voucherRelations = VoucherNoticeValidator.getDAPService().getBillToVchReDtoByBillTypeAndIds("gl_acnotice", sourceIds);
            for (BillToVchRelationDto.BillToVoucherRelation relation : voucherRelations) {
                Long billId = relation.getBillId();
                Long voucherId = (Long)sourceIdToVchIdMap.get(billId);
                result.add(voucherId);
            }
        }
        return result;
    }
}

