/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.validate;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Optional;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.gl.business.vo.voucher.Amount;
import kd.fi.gl.business.vo.voucher.AmountField;
import kd.fi.gl.business.vo.voucher.IVoucherEntry;
import kd.fi.gl.validate.bigdata.RowWrapper;
import kd.fi.gl.voucher.validate.AccountWrapper;
import kd.fi.gl.voucher.validate.CfMainItemWrapper;
import kd.fi.gl.wrap.DynWrapper;
import org.apache.commons.lang3.NotImplementedException;

public class VoucherRowWrapper
extends RowWrapper
implements IVoucherEntry {
    private long entryId;
    private AccountWrapper account;
    private CfMainItemWrapper cfMainItem;
    private int seq;
    private long accId;
    private long cfMainItemId;
    private long currencyId;
    private int curAmtPrecision;
    private long flexGroupId;
    private long cfFlexGroupId;
    private String direction;
    private BigDecimal debitLocAmt;
    private BigDecimal creditLocAmt;
    private BigDecimal debitOriAmt;
    private BigDecimal creditOriAmt;
    private Date expireDate;
    private long mainCfItemId;
    private long suppCfItemId;
    private DynamicObject suppCfItem;
    private BigDecimal mainCfAmt;
    private BigDecimal suppCfAmt;

    public VoucherRowWrapper(Row row) {
        super(row);
        this.initValue();
    }

    private void initValue() {
        this.entryId = this.getRow().getLong(8);
        this.seq = this.getRow().getInteger(9);
        this.accId = this.getRow().getLong(7);
        this.cfMainItemId = this.getRow().getLong(14);
        this.currencyId = this.getRow().getLong(26);
        this.curAmtPrecision = this.getRow().getInteger(30) == null ? 0 : this.getRow().getInteger(30);
        this.flexGroupId = this.getRow().getLong(24);
        this.cfFlexGroupId = this.getRow().getLong(15);
        this.direction = this.getRow().getString(23);
        this.debitLocAmt = this.getRow().getBigDecimal(12);
        this.creditLocAmt = this.getRow().getBigDecimal(10);
        this.debitOriAmt = this.getRow().getBigDecimal(13);
        this.creditOriAmt = this.getRow().getBigDecimal(11);
        this.expireDate = this.getRow().getDate(21);
        this.mainCfItemId = this.getRow().getLong(14);
        this.mainCfAmt = this.getRow().getBigDecimal(16);
        this.suppCfItemId = this.getRow().getLong(17);
        this.suppCfAmt = this.getRow().getBigDecimal(18);
    }

    public long getEntryId() {
        return this.entryId;
    }

    public AccountWrapper getAccount() {
        return this.account;
    }

    public void setAccount(AccountWrapper account) {
        this.account = account;
    }

    public CfMainItemWrapper getCfMainItem() {
        return this.cfMainItem;
    }

    public void setCfMainItem(CfMainItemWrapper cfMainItem) {
        this.cfMainItem = cfMainItem;
    }

    public int getSeq() {
        return this.seq;
    }

    public long getAccId() {
        return this.accId;
    }

    public long getCfMainItemId() {
        return this.cfMainItemId;
    }

    public long getCurrencyId() {
        return this.currencyId;
    }

    public int getCurAmtPrecision() {
        return this.curAmtPrecision;
    }

    public long getFlexGroupId() {
        return this.flexGroupId;
    }

    public long getCfFlexGroupId() {
        return this.cfFlexGroupId;
    }

    public String getDirection() {
        return this.direction;
    }

    public BigDecimal getDebitLocAmt() {
        return this.debitLocAmt;
    }

    public BigDecimal getCreditLocAmt() {
        return this.creditLocAmt;
    }

    public BigDecimal getDebitOriAmt() {
        return this.debitOriAmt;
    }

    public BigDecimal getCreditOriAmt() {
        return this.creditOriAmt;
    }

    public Date getExpireDate() {
        return this.expireDate;
    }

    public long getMainCfItemId() {
        return this.mainCfItemId;
    }

    public long getSuppCfItemId() {
        return this.suppCfItemId;
    }

    public DynamicObject getMainCfItem() {
        return Optional.ofNullable(this.cfMainItem).map(DynWrapper::getDyn).orElse(null);
    }

    public DynamicObject getSuppCfItem() {
        return this.suppCfItem;
    }

    public void setSuppCfItem(DynamicObject suppCfItem) {
        this.suppCfItem = suppCfItem;
    }

    public BigDecimal getMainCfAmt() {
        return this.mainCfAmt;
    }

    public BigDecimal getSuppCfAmt() {
        return this.suppCfAmt;
    }

    public BigDecimal getDebit(AmountField field) {
        return this.getBigDecimal(field.getDebitProp().toFullName());
    }

    public BigDecimal getCredit(AmountField field) {
        return this.getBigDecimal(field.getCreditProp().toFullName());
    }

    public Amount getAmount(AmountField field) {
        return new Amount(this.getBigDecimal(field.getDebitProp().toFullName()), this.getBigDecimal(field.getCreditProp().toFullName()));
    }

    public void set(String key, Object value) {
        throw new NotImplementedException();
    }

    public void setBigDecimal(String field, BigDecimal decimal) {
        throw new NotImplementedException();
    }

    public String getEntryDC() {
        return this.getString(23);
    }
}

