/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.validate;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.accountref.AccountRefUtils;
import kd.bos.ext.fi.accountref.AccountVersionReplaceParam;
import kd.bos.ext.fi.accountref.AssGrpDefaultVal;
import kd.bos.ext.fi.lock.IShareLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.bd.consts.MeasureUnit;
import kd.fi.bd.util.AccountUtils;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.bd.util.CashflowLocalSetUtil;
import kd.fi.bd.vo.CommonAssist;
import kd.fi.gl.accsys.AccSysUtil;
import kd.fi.gl.cache.CacheKey;
import kd.fi.gl.cache.CacheKeyPrefix;
import kd.fi.gl.cache.LocalCacheHelper;
import kd.fi.gl.comassist.model.ComAssistTable;
import kd.fi.gl.comassist.service.ComAssistService;
import kd.fi.gl.common.AccountType;
import kd.fi.gl.common.VoucherAgainst;
import kd.fi.gl.constant.basedata.CurrencyConstant;
import kd.fi.gl.enums.GLBillParamEnum;
import kd.fi.gl.formplugin.voucher.VoucherEditArgHelper;
import kd.fi.gl.util.CashFlowItemHelper;
import kd.fi.gl.util.CommonAssistUtil;
import kd.fi.gl.util.DateUtil;
import kd.fi.gl.util.GLApp;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.VoucherSaveValidatorParam;
import kd.fi.gl.validate.bigdata.Context;
import kd.fi.gl.validate.bigdata.ExtDataEntityWrapper;
import kd.fi.gl.validate.bigdata.RowWrapper;
import kd.fi.gl.voucher.opplugin.VchTempNumberService;
import kd.fi.gl.voucher.option.VoucherOption;
import kd.fi.gl.voucher.util.VoucherUtils;
import kd.fi.gl.voucher.validate.AccountWrapper;
import kd.fi.gl.voucher.validate.BaseVoucherValidator;
import kd.fi.gl.wrap.EntryWrapper;

public class VoucherSaveValidator
extends BaseVoucherValidator {
    private Map<String, IShareLock> locks;
    private Map<Long, String> idAndNo = new HashMap<Long, String>(100);
    private static final Log logger = LogFactory.getLog((String)VoucherSaveValidator.class.getTypeName());
    public static final String FIELDS = "e.fid fid,fentryid,fmaincfitemid,fmaincfamount,fsuppcfitemid,fsuppcfamount,fdescription,faccountid,fiscash,fisbank,faccheck,fisjournal,fexpiredate,faccounttypeid, fiscashequivalent,flocaldebit, flocalcredit,b.fnumber accountnumber,e.fseq entryseq,flocalexchangerate,e.fmeasureunitid,e.fquantity,e.fprice";

    public VoucherSaveValidator() {
        this.init();
        this.setOperationName(ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"VoucherSaveValidator_0", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
    }

    public VoucherSaveValidator(Map<String, IShareLock> locks, Map<Long, String> idAndNo) {
        this.idAndNo = idAndNo;
        this.locks = locks;
        this.init();
        this.setOperationName(ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"VoucherSaveValidator_0", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
    }

    @Override
    public void validate() {
        HashMap<Long, ExtendedDataEntity> vMap = new HashMap<Long, ExtendedDataEntity>(this.dataEntities.length);
        Map map = VoucherUtils.getStatusFromDB((ExtendedDataEntity[])this.dataEntities);
        boolean isdap = this.getOption().containsVariable("isdap");
        boolean isCommonAssistEnabled = CommonAssistUtil.isCommonAssistEnabled();
        StringBuilder sb = new StringBuilder();
        ConcurrentHashMap accountReplaceMap = (ConcurrentHashMap)LocalCacheHelper.get((CacheKey)CacheKey.getCacheKey((CacheKeyPrefix)CacheKeyPrefix.GL_ACCOUNT_REPLACE, (Object[])new Object[0]), Map.class);
        Map assgrpReplaceMap = (Map)LocalCacheHelper.get((CacheKey)CacheKey.getCacheKey((CacheKeyPrefix)CacheKeyPrefix.GL_ASSGRP_REPLACE, (Object[])new Object[0]), Map.class);
        ArrayList<ExtendedDataEntity> vlist = new ArrayList<ExtendedDataEntity>(this.dataEntities.length);
        HashSet<Long> allOrgs = new HashSet<Long>(1);
        if (this.getOption().containsVariable("sysvoucher")) {
            VchTempNumberService vchTempNumberService = new VchTempNumberService();
            ArrayList vchDyns = new ArrayList(this.dataEntities.length);
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                vchDyns.add(dataEntity.getDataEntity());
            }
            vchTempNumberService.setTempNumber(vchDyns);
            ExtendedDataEntity[] extendedDataEntityArray = this.dataEntities;
            int n = extendedDataEntityArray.length;
            for (int i = 0; i < n; ++i) {
                ExtendedDataEntity dataEntity;
                dataEntity = extendedDataEntityArray[i];
                this.idAndNo.put(dataEntity.getDataEntity().getLong("id"), dataEntity.getDataEntity().getString("billno"));
            }
        }
        HashSet<String> orgAndAccountTables = new HashSet<String>();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            if (dataEntity.getDataEntity().getString("billno") == null || dataEntity.getDataEntity().getString("billno").trim().equals("")) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u51ed\u8bc1\u53f7\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u51ed\u8bc1\u53f7\u6216\u914d\u7f6e\u9002\u7528\u7684\u51ed\u8bc1\u7f16\u7801\u89c4\u5219\u3002", (String)"VoucherSaveValidator_1", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
            } else {
                String vouchernumber = dataEntity.getDataEntity().getString("billno");
                if (vouchernumber.length() > 30) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u51ed\u8bc1\u53f7\u957f\u5ea6\u4e0d\u5141\u8bb8\u8d85\u8fc730\u4f4d\uff0c\u8bf7\u68c0\u67e5\u7f16\u7801\u89c4\u5219\u914d\u7f6e\u3002", (String)"VoucherSaveValidator_2", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
                }
            }
            long orgId = (Long)dataEntity.getValue("org_id");
            allOrgs.add(orgId);
            this.doLock(orgId, (Long)dataEntity.getValue("booktype_id"), (Long)dataEntity.getValue("period_id"), this.locks);
            if (dataEntity.getDataEntity().getLong("id") == 0L) {
                vlist.add(dataEntity);
            } else {
                sb.append(dataEntity.getBillPkId()).append(",");
                vMap.put(Long.valueOf(String.valueOf(dataEntity.getBillPkId())), dataEntity);
            }
            Long accountTableId = AccSysUtil.getBookFromAccSys((long)((Long)dataEntity.getValue("org_id")), (long)((Long)dataEntity.getValue("booktype_id"))).getAccountTableId();
            if (!isCommonAssistEnabled || !CommonAssistUtil.existCommonAssist((long)accountTableId)) continue;
            orgAndAccountTables.add(dataEntity.getDataEntity().getString("org.id") + "-" + accountTableId);
        }
        CashflowLocalSetUtil.cacheLocalSet(allOrgs);
        HashMap commonAssistAndIds = new HashMap();
        HashMap<Long, Integer> accountTable2Assitsize = new HashMap<Long, Integer>();
        HashMap<String, String> org2CommonAssistName = new HashMap<String, String>();
        if (isCommonAssistEnabled && !orgAndAccountTables.isEmpty()) {
            HashMap<String, String> finalKey2OrgAndAssit = new HashMap<String, String>();
            HashMap<String, Set<Long>> orgAssistAndIds = new HashMap<String, Set<Long>>();
            HashSet ignoreKeys = new HashSet();
            for (String orgAndAccountTable : orgAndAccountTables) {
                Long orgId = Long.parseLong(orgAndAccountTable.split("\\-")[0]);
                Long accountTableId = Long.parseLong(orgAndAccountTable.split("\\-")[1]);
                if (!CommonAssistUtil.existCommonAssist((long)accountTableId)) continue;
                List commonAssists = ComAssistTable.get((Long)accountTableId).getCommonAssists();
                accountTable2Assitsize.put(accountTableId, commonAssists.size());
                for (CommonAssist commonAssist : commonAssists) {
                    String orgAndAssistKey;
                    String finalkey = orgId + "-" + accountTableId + "-" + commonAssist.getKey();
                    org2CommonAssistName.put(finalkey, commonAssist.valueSource);
                    finalKey2OrgAndAssit.put(finalkey, orgId + "-" + commonAssist.valueSource);
                    if (commonAssistAndIds.containsKey(finalkey) || ignoreKeys.contains(orgAndAssistKey = (String)finalKey2OrgAndAssit.get(finalkey))) continue;
                    if (orgAssistAndIds.containsKey(orgAndAssistKey)) {
                        commonAssistAndIds.put(finalkey, orgAssistAndIds.get(orgAndAssistKey));
                        continue;
                    }
                    List qFilters = ComAssistService.generateBackQueryQFilter((CommonAssist)commonAssist, Collections.singletonList(orgId));
                    if (qFilters.isEmpty()) {
                        ignoreKeys.add(orgAndAssistKey);
                        continue;
                    }
                    Set<Long> invalidataIds = this.getInvalidataIds(commonAssist, qFilters);
                    orgAssistAndIds.put(orgAndAssistKey, invalidataIds);
                    commonAssistAndIds.put(finalkey, invalidataIds);
                }
            }
            finalKey2OrgAndAssit.clear();
            orgAssistAndIds.clear();
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
            Set<Long> idSet = Arrays.stream(sb.toString().split(",")).map(Long::valueOf).collect(Collectors.toSet());
            this.preReadAccount(idSet);
            long voucherId = -1L;
            int entryCounts = 0;
            DynamicObject v = null;
            ExtendedDataEntity exd = null;
            boolean isResovle = false;
            HashMap<Long, DynamicObject> entries = new HashMap<Long, DynamicObject>();
            ArrayList<Object> newentries = new ArrayList<DynamicObject>();
            VoucherSaveValidatorParam cp = new VoucherSaveValidatorParam();
            Set entryOidSet = null;
            if (sb.length() > 0) {
                StringBuilder sqlStr = new StringBuilder();
                String sql = sqlStr.append("select ").append(FIELDS).append(" from t_gl_voucherentry e left join t_bd_account b on e.faccountid=b.fid where e.fid in (").append((CharSequence)sb).append(") order by fid").toString();
                try (ShardingHintContext ignored = ShardingHintContext.createAndSet((String)"t_gl_voucher", (HintCondition[])new HintCondition[]{new HintCondition("fid", FilterType.in_range, idSet)});){
                    DataSet ds = DB.queryDataSet((String)"VoucherSaveValidator", (DBRoute)DBRoute.of((String)"gl"), (String)sql);
                    Object object = null;
                    try {
                        for (Row row : ds) {
                            if (voucherId != row.getLong("fid")) {
                                if (voucherId != -1L) {
                                    this.dealOneVoucher(exd, entryCounts, v, newentries, cp);
                                }
                                voucherId = row.getLong("fid");
                                entryCounts = 0;
                                entries = new HashMap();
                                newentries = new ArrayList();
                                this.getMsgBuilder().clear();
                                exd = (ExtendedDataEntity)vMap.remove(voucherId);
                                v = exd.getDataEntity();
                                entryOidSet = VoucherUtils.getEntryOidSet((DynamicObject)v, (DynamicObjectType)v.getDynamicObjectType());
                                isResovle = true;
                                DynamicObject book = v.getDynamicObject("book");
                                long baseCur = book.getLong("basecurrency.id");
                                if (v.get("localcur_id") == null || (Long)v.get("localcur_id") == 0L) {
                                    v.set("localcur_id", (Object)baseCur);
                                }
                                if (this.editAction() && v.getDynamicObjectType().getProperty("entries") != null) {
                                    this.resolveEntry(entries, newentries, v);
                                }
                                if (v.getBoolean("isreverse") && "save".equals(this.getOperateKey())) {
                                    this.getMsgBuilder().appendErrorMsg(VoucherAgainst.saveValidator((DynamicObject)v, (boolean)false));
                                }
                                this.checkPeriodAndBizData(v);
                                this.baseValidate(v, map);
                                cp = new VoucherSaveValidatorParam(exd);
                            }
                            if (v == null) continue;
                            Long entryId = row.getLong("fentryid");
                            if (this.editAction() && entries.containsKey(entryId)) {
                                DynamicObject entry = (DynamicObject)entries.get(entryId);
                                DynamicObject acct = entry.getDynamicObject("account");
                                if (null == acct) continue;
                                ++entryCounts;
                                this.dealForEntry(cp, entry, v.getDate("bizdate"));
                                continue;
                            }
                            if (entryOidSet == null || entryOidSet.contains(entryId) || 0L == row.getLong("faccountid")) continue;
                            ++entryCounts;
                            this.dealForEntry(cp, row, v.getDate("bizdate"));
                        }
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (ds != null) {
                            if (object != null) {
                                try {
                                    ds.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)object).addSuppressed(throwable);
                                }
                            } else {
                                ds.close();
                            }
                        }
                    }
                }
            }
            if (isResovle) {
                this.dealOneVoucher(exd, entryCounts, v, newentries, cp);
            }
        }
        for (ExtendedDataEntity voucherWithId : vMap.values()) {
            if (voucherWithId.getDataEntity().getDynamicObjectType().getProperty("entries") == null) {
                this.addErrorMessage(voucherWithId, ResManager.loadKDString((String)"\u6bcf\u5f20\u51ed\u8bc1\u81f3\u5c11\u5e94\u8be5\u6709\u4e00\u6761\u5206\u5f55\u3002", (String)"VoucherSaveValidator_9", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
                continue;
            }
            vlist.add(voucherWithId);
        }
        if (!vlist.isEmpty()) {
            DynamicObject[] voucher;
            HashSet<Long> srcIds = new HashSet<Long>(vlist.size());
            HashSet<Long> reverseVoucherIds = new HashSet<Long>(vlist.size());
            for (ExtendedDataEntity dataEntity : vlist) {
                voucher = dataEntity.getDataEntity();
                boolean isreverse = voucher.getBoolean("isreverse");
                if (!isreverse) continue;
                srcIds.add(voucher.getLong("sourcebill"));
                reverseVoucherIds.add(voucher.getLong("id"));
            }
            if (!CollectionUtils.isEmpty(srcIds)) {
                DynamicObject[] srvVchs = BusinessDataServiceHelper.load((Object[])srcIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"gl_voucher"));
                HashMap<Long, DynamicObject> srcVchDyn = new HashMap<Long, DynamicObject>(srvVchs.length);
                for (DynamicObject dyn : srvVchs) {
                    srcVchDyn.put(dyn.getLong("id"), dyn);
                }
                Map balanceResult = VoucherAgainst.judgeBalanceBatch(srcVchDyn, reverseVoucherIds);
                ThreadCache.put((Object)CacheKey.getCacheKey((CacheKeyPrefix)CacheKeyPrefix.REVERSE_INFO, (Object[])new Object[0]).toString(), (Object)balanceResult);
                ThreadCache.put((Object)CacheKey.getCacheKey((CacheKeyPrefix)CacheKeyPrefix.REVERSEVOU_DYN, (Object[])new Object[0]).toString(), srcVchDyn);
            }
            for (ExtendedDataEntity dataEntity : vlist) {
                voucher = dataEntity.getDataEntity();
                DynamicObject periodDyn = voucher.getDynamicObject("period");
                long orgid = voucher.getLong("org.id");
                long bookTypeId = voucher.getLong("booktype.id");
                long curAccountTableId = AccSysUtil.getCurPeriodAccountTableId((long)orgid, (long)bookTypeId, (long)periodDyn.getLong("id"));
                DynamicObjectCollection voucherentries = voucher.getDynamicObjectCollection("entries");
                boolean isreverse = voucher.getBoolean("isreverse");
                Set<Long> useAccountIds = null;
                if (isreverse) {
                    useAccountIds = VoucherSaveValidator.getCurOrgUseAccount(orgid, curAccountTableId);
                }
                HashMap<String, Set<Long>> assistName2ValueId = new HashMap<String, Set<Long>>();
                for (DynamicObject voucherEntry : voucherentries) {
                    int entrySeq = voucherEntry.getInt("seq");
                    DynamicObject accountOld = voucherEntry.getDynamicObject("account");
                    if (accountOld == null) {
                        this.addErrorMessage(dataEntity, this.getMsgFormtter().createEntryErrorMsg(entrySeq, null, ResManager.loadKDString((String)"\u79d1\u76ee\u672a\u586b\u5199", (String)"VoucherSaveValidator_3", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0])));
                        continue;
                    }
                    String oldAccountNumber = accountOld.getString("number");
                    long accountTableId = accountOld.getLong("accounttable_id");
                    boolean isTableVersion = false;
                    if (accountTableId != curAccountTableId) {
                        isTableVersion = true;
                        if (isreverse) {
                            this.addErrorMessage(dataEntity, this.getMsgFormtter().createEntryErrorMsg(entrySeq, oldAccountNumber, ResManager.loadKDString((String)"\u8de8\u79d1\u76ee\u8868\u7248\u672c\u4e0d\u5141\u8bb8\u51b2\u9500\u3002", (String)"VoucherSaveValidator_4", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0])));
                            break;
                        }
                    }
                    if ("5".equals(voucher.getString("sourcetype")) || isTableVersion || AccountRefUtils.checkDate((DynamicObject)accountOld, (Date)periodDyn.getDate("enddate")) || isreverse && !useAccountIds.contains(accountOld.getLong("id"))) {
                        long acctMasterid = accountOld.getLong("masterid");
                        String accountKey = AccountRefUtils.getVersonKey((Object[])new Object[]{orgid, acctMasterid, periodDyn.getLong("id")});
                        DynamicObject accountInfo = null;
                        if (accountReplaceMap != null) {
                            accountInfo = (DynamicObject)accountReplaceMap.get(accountKey);
                        } else {
                            accountReplaceMap = new ConcurrentHashMap(16);
                        }
                        AssGrpDefaultVal tableVersonDefaultAssgrp = null;
                        if (Objects.isNull(accountInfo)) {
                            AccountVersionReplaceParam param = new AccountVersionReplaceParam(orgid, acctMasterid, accountTableId, curAccountTableId, null, periodDyn, bookTypeId, accountOld, 0L);
                            if (isTableVersion) {
                                tableVersonDefaultAssgrp = param.getAssgrpDefVal();
                            }
                            param.setIsFromVoucherEdit(isreverse);
                            try {
                                accountInfo = AccountRefUtils.getCurVersionAccount((AccountVersionReplaceParam)param);
                            }
                            catch (KDBizException e) {
                                Optional accNumber = AccountRefUtils.getAccountNumber((AccountVersionReplaceParam)param);
                                Object accountNumber = accNumber.isPresent() ? accNumber.get() : Long.valueOf(acctMasterid);
                                this.addErrorMessage(dataEntity, this.getMsgFormtter().createEntryErrorMsg(entrySeq, oldAccountNumber, String.format(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e0b\u627e\u4e0d\u5230\u7f16\u7801\u4e3a\uff1a%s\u7684\u79d1\u76ee\u6570\u636e\u3002", (String)"VoucherSaveValidator_6", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]), accountNumber)));
                                continue;
                            }
                        }
                        DynamicObject assgrp = null;
                        if (accountOld.getBoolean("isassist") && accountInfo.getBoolean("isassist")) {
                            assgrp = voucherEntry.getDynamicObject("assgrp");
                            if (assgrp == null) {
                                assgrp = AccountRefUtils.createNewFlex();
                            }
                            AccountRefUtils.getAssgrpReplace((DynamicObject)assgrp, (DynamicObject)accountInfo, (long)orgid, (long)acctMasterid, (Map)assgrpReplaceMap, (AssGrpDefaultVal)tableVersonDefaultAssgrp, (long)periodDyn.getLong("id"));
                        }
                        voucherEntry.set("account", (Object)accountInfo);
                        if (voucherEntry.getDate("expiredate") == null && accountInfo.getBoolean("accheck")) {
                            voucherEntry.set("expiredate", VoucherEditArgHelper.getExpireDateOption((DynamicObject)voucher).getDateParser().apply(voucher));
                        }
                        if (assgrp == null || assgrp.getLong("id") == 0L) {
                            voucherEntry.set("assgrp", null);
                            voucherEntry.set("assgrp_id", (Object)0L);
                        } else {
                            voucherEntry.set("assgrp", (Object)assgrp);
                            voucherEntry.set("assgrp_id", (Object)assgrp.getLong("id"));
                        }
                    }
                    if (!isCommonAssistEnabled || !CommonAssistUtil.existCommonAssist((long)accountTableId)) continue;
                    int size = (Integer)accountTable2Assitsize.get(accountTableId);
                    for (int i = 1; i <= size; ++i) {
                        String key = orgid + "-" + accountTableId + "-comassist" + i;
                        if (!commonAssistAndIds.containsKey(key)) continue;
                        Set ids = (Set)commonAssistAndIds.get(key);
                        Long commmonAssistId = voucherEntry.getLong("comassist" + i + "_id");
                        if (commmonAssistId == 0L || ids.contains(commmonAssistId)) continue;
                        Set set = assistName2ValueId.computeIfAbsent((String)org2CommonAssistName.get(key), (Function<String, Set<Long>>)((Function<String, Set>)a -> new HashSet()));
                        set.add(commmonAssistId);
                    }
                }
                if (CommonAssistUtil.existCommonAssist((long)curAccountTableId) && !assistName2ValueId.isEmpty()) {
                    String commonAssistTips = this.genCommonAssistTips(assistName2ValueId);
                    this.addErrorMessage(dataEntity, commonAssistTips);
                }
                this.validateHandle(dataEntity, map);
                this.getMsgBuilder().clear();
            }
            LocalCacheHelper.put((CacheKey)CacheKey.getCacheKey((CacheKeyPrefix)CacheKeyPrefix.GL_ACCOUNT_REPLACE, (Object[])new Object[0]), (Object)accountReplaceMap);
            LocalCacheHelper.put((CacheKey)CacheKey.getCacheKey((CacheKeyPrefix)CacheKeyPrefix.GL_ASSGRP_REPLACE, (Object[])new Object[0]), (Object)assgrpReplaceMap);
        }
    }

    private String genCommonAssistTips(Map<String, Set<Long>> assistName2ValueId) {
        HashMap assistName2ValueName = new HashMap(assistName2ValueId.size());
        for (Map.Entry<String, Set<Long>> entry : assistName2ValueId.entrySet()) {
            String entityName = entry.getKey();
            HashSet names = new HashSet();
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)("genCommonAssistTips" + entityName), (String)entityName, (String)"name", (QFilter[])new QFilter("id", "in", entry.getValue()).toArray(), null);){
                ds.forEachRemaining(row -> names.add(row.getString("name")));
            }
            assistName2ValueName.put(MetadataServiceHelper.getDataEntityType((String)entityName).getDisplayName().toString(), names);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(ResManager.loadKDString((String)"\u51ed\u8bc1\u4fdd\u5b58\u5931\u8d25\uff0c\u8be5\u7528\u6237\u6ca1\u6709\u4ee5\u4e0b\u516c\u5171\u7ef4\u5ea6\u7684\u6570\u636e\u6743\u9650\uff1a", (String)"VoucherSaveValidator_19", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
        for (Map.Entry entry : assistName2ValueName.entrySet()) {
            sb.append((String)entry.getKey()).append(":").append("[");
            int index = 0;
            for (String name : (Set)entry.getValue()) {
                sb.append(name);
                if (++index == ((Set)entry.getValue()).size()) continue;
                sb.append(",");
            }
            sb.append("];");
        }
        sb.append(ResManager.loadKDString((String)"\u8bf7\u4fee\u6539\u6570\u636e\u6743\u9650\u6216\u4fee\u6539\u65b9\u6848\u540e\u91cd\u8bd5\u3002", (String)"VoucherSaveValidator_20", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
        return sb.toString();
    }

    private Set<Long> getInvalidataIds(CommonAssist commonAssist, List<QFilter> qFilters) {
        HashSet<Long> ids = new HashSet<Long>();
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"VoucherSaveValidator#getInvalidataIds", (String)commonAssist.getValueSource(), (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]), null);
        for (Row row : dataSet) {
            ids.add(row.getLong("id"));
        }
        return ids;
    }

    @Override
    public Context buildContext() {
        return null;
    }

    @Override
    public String getDataSetSelect() {
        return null;
    }

    @Override
    public RowWrapper wrapRow(Row row) {
        return null;
    }

    @Override
    public ExtDataEntityWrapper wrapDataEntity(ExtendedDataEntity extendedDataEntity) {
        return null;
    }

    @Override
    public EntryWrapper wrapEntryDyn(DynamicObject entryDyn) {
        return null;
    }

    private DynamicObject getCfItem(long itemId) {
        if (itemId == 0L) {
            return null;
        }
        HashMap<Long, DynamicObject> map = (HashMap<Long, DynamicObject>)ThreadCache.get((Object)"local-cf-key");
        if (map == null) {
            map = new HashMap<Long, DynamicObject>();
            DynamicObjectCollection col = QueryServiceHelper.query((String)"gl_cashflowitem", (String)"id,direction,isdealactivity", null);
            for (DynamicObject obj : col) {
                map.put(obj.getLong("id"), obj);
            }
            ThreadCache.put((Object)"local-cf-key", map);
        }
        return (DynamicObject)map.get(itemId);
    }

    private Optional<String> validateForDataSetRow(Row row) {
        BigDecimal quantity = row.getBigDecimal("fquantity");
        BigDecimal price = row.getBigDecimal("fprice");
        Long unitId = row.getLong("fmeasureunitid");
        if ((unitId == null || unitId == 0L) && (price != null && price.signum() != 0 || quantity != null && quantity.signum() != 0)) {
            return Optional.of(ResManager.loadKDString((String)"\u672a\u586b\u5199\u8ba1\u91cf\u5355\u4f4d\uff0c\u8bf7\u6e05\u9664\u5355\u4ef7\u548c\u6570\u91cf\u3002", (String)"VoucherSaveValidator_16", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
        }
        return Optional.empty();
    }

    private void dealForEntry(VoucherSaveValidatorParam cp, Object entry, Date bizDate) {
        if (entry instanceof DynamicObject) {
            this.validateDynamicEntry(cp, (DynamicObject)entry, true);
            return;
        }
        Row row = (Row)entry;
        int entrySeq = row.getInteger("entryseq");
        String accountNumber = row.getString("accountnumber");
        DynamicObject mainItem = this.getCfItem(row.getLong("fmaincfitemid"));
        BigDecimal mainCFAmt = row.getBigDecimal("fmaincfamount");
        DynamicObject suppItem = this.getCfItem(row.getLong("fsuppcfitemid"));
        BigDecimal suppCFAmt = row.getBigDecimal("fsuppcfamount");
        boolean isCash = row.getBoolean("fiscash") != false || row.getBoolean("fisbank") != false || row.getBoolean("fiscashequivalent") != false;
        boolean isPLAcct = GLUtil.isPLAcct((long)row.getLong("faccounttypeid"));
        boolean isBudget = AccountType.isBudgetType((long)row.getLong("faccounttypeid"));
        BigDecimal debitLoc = row.getBigDecimal("flocaldebit");
        BigDecimal creditLoc = row.getBigDecimal("flocalcredit");
        boolean isAc = row.getBoolean("faccheck");
        Date expireDate = row.getDate("fexpiredate");
        if (null == cp.getVdesc()) {
            cp.setVdesc(row.getString("fdescription"));
        }
        BigDecimal rate = row.getBigDecimal("flocalexchangerate");
        BigDecimal price = row.getBigDecimal("fprice");
        this.validateForDataSetRow(row).ifPresent(x -> this.getMsgBuilder().appendErrorMsg(this.getMsgFormtter().createEntryErrorMsg(entrySeq, accountNumber, (String)x)));
        if (VoucherOption.enablePriceCheck() && price != null && price.compareTo(BigDecimal.ZERO) < 0) {
            this.getMsgBuilder().appendErrorMsg(this.getMsgFormtter().createEntryErrorMsg(entrySeq, accountNumber, ResManager.loadKDString((String)"\u5355\u4ef7\u4e0d\u80fd\u4e3a\u8d1f\u6570\u3002", (String)"VoucherSaveValidator_17", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0])));
        }
        if (isAc) {
            boolean exDateBeforeBizdate = BillParamUtil.getBooleanValue((String)"83bfebc8000017ac", (String)"fi.gl.voucher.expiredatebeforebizdate", (boolean)false);
            if (null == expireDate) {
                this.getMsgBuilder().appendErrorMsg(this.getMsgFormtter().createEntryErrorMsg(entrySeq, accountNumber, ResManager.loadKDString((String)"\u5f80\u6765\u79d1\u76ee\u7684\u5230\u671f\u65e5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"VoucherSaveValidator_7", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0])));
            } else if (!exDateBeforeBizdate && expireDate.before(bizDate)) {
                this.getMsgBuilder().appendErrorMsg(this.getMsgFormtter().createEntryErrorMsg(entrySeq, accountNumber, ResManager.loadKDString((String)"\u5230\u671f\u65e5\u5fc5\u987b\u665a\u4e8e\u4e1a\u52a1\u65e5\u671f\u3002", (String)"VoucherSaveValidator_8", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0])));
            }
        }
        cp.getTotal()[0] = cp.getTotal()[0].add(debitLoc);
        cp.getTotal()[1] = cp.getTotal()[1].add(creditLoc);
        if (!cp.isExistJournalAccount() && ((Row)entry).getBoolean("fisjournal").booleanValue()) {
            cp.setExistJournalAccount(true);
        }
        if (isBudget) {
            return;
        }
        if (isCash) {
            if (!cp.isHashCash()) {
                cp.setHashCash(true);
            }
            cp.setCashtotalamt(cp.getCashtotalamt().add(debitLoc).subtract(creditLoc));
            return;
        }
        if (!cp.isNotC_NotPL() && !isPLAcct) {
            cp.setNotC_NotPL(true);
        }
        if (!cp.isHasPL() && isPLAcct) {
            cp.setHasPL(true);
        }
        if (mainItem != null) {
            if (!cp.isHashMainCf()) {
                cp.setHashMainCf(true);
            }
            boolean in = true;
            if ("o".equals(mainItem.getString("direction"))) {
                cp.setCashtotalused(cp.getCashtotalused().subtract(mainCFAmt));
                in = false;
            } else {
                cp.setCashtotalused(cp.getCashtotalused().add(mainCFAmt));
            }
            boolean isDealactivity = mainItem.getBoolean("isdealactivity");
            if (isDealactivity) {
                BigDecimal bigDecimal = cp.getCashAmt()[0] = in ? cp.getCashAmt()[0].add(mainCFAmt) : cp.getCashAmt()[0].subtract(mainCFAmt);
            }
            if (!cp.isPlMainCf() && isPLAcct) {
                cp.setPlMainCf(true);
            }
        }
        if (isPLAcct) {
            cp.getCashAmt()[1] = cp.getCashAmt()[1].add(creditLoc).subtract(debitLoc);
        }
        if (suppItem != null) {
            if (!cp.isHasSuppCf()) {
                cp.setHasSuppCf(true);
            }
            cp.getCashAmt()[2] = cp.getCashAmt()[2].add(suppCFAmt);
        }
    }

    private void setCFStatus(DynamicObject voucherInfo, VoucherSaveValidatorParam cp) {
        if ("1".equals(voucherInfo.getString("sourcetype"))) {
            voucherInfo.set("mainstatus", (Object)"0");
            voucherInfo.set("suppstatus", (Object)"0");
            return;
        }
        if (cp.isHashCash()) {
            if (cp.isHasPL()) {
                if (cp.isHashMainCf()) {
                    if (cp.getCashtotalused().compareTo(cp.getCashtotalamt()) == 0) {
                        voucherInfo.set("mainstatus", (Object)"3");
                    } else {
                        voucherInfo.set("mainstatus", (Object)"2");
                    }
                    this.setDesignStatus(voucherInfo, cp);
                } else {
                    voucherInfo.set("mainstatus", (Object)"1");
                    voucherInfo.set("suppstatus", (Object)"0");
                }
            } else if (cp.isNotC_NotPL()) {
                if (cp.isHashMainCf()) {
                    if (cp.getCashtotalused().compareTo(cp.getCashtotalamt()) == 0) {
                        voucherInfo.set("mainstatus", (Object)"3");
                    } else {
                        voucherInfo.set("mainstatus", (Object)"2");
                    }
                } else {
                    voucherInfo.set("mainstatus", (Object)"1");
                }
                this.setDesignStatus(voucherInfo, cp);
            }
        } else if (cp.isHasPL()) {
            voucherInfo.set("mainstatus", (Object)"0");
            if (cp.isNotC_NotPL()) {
                this.setDesignStatus(voucherInfo, cp);
            } else {
                voucherInfo.set("suppstatus", (Object)"0");
            }
        } else if (cp.isNotC_NotPL()) {
            voucherInfo.set("suppstatus", (Object)"a");
        } else {
            voucherInfo.set("mainstatus", (Object)"0");
            voucherInfo.set("suppstatus", (Object)"0");
        }
    }

    private void setDesignStatus(DynamicObject voucherInfo, VoucherSaveValidatorParam cp) {
        BigDecimal[] cashAmt = cp.getCashAmt();
        BigDecimal suppAmt = cashAmt[0].subtract(cashAmt[1]);
        if (suppAmt.compareTo(cashAmt[2]) != 0) {
            if (cp.isHashCash() && !cp.isHashMainCf()) {
                voucherInfo.set("suppstatus", (Object)"0");
            } else if (cp.isHasSuppCf()) {
                voucherInfo.set("suppstatus", (Object)"2");
            } else {
                voucherInfo.set("suppstatus", (Object)"1");
            }
        } else if (suppAmt.compareTo(cashAmt[2]) == 0) {
            if (cp.isHasSuppCf()) {
                voucherInfo.set("suppstatus", (Object)"3");
            } else {
                voucherInfo.set("suppstatus", (Object)"0");
            }
        }
    }

    private void dealOneVoucher(ExtendedDataEntity exd, int entryCounts, DynamicObject v, List<DynamicObject> newentries, VoucherSaveValidatorParam cp) {
        if (v == null) {
            return;
        }
        cp.setLocalSet(CashflowLocalSetUtil.isLocalSetThread((long)v.getLong("org_id"), (Date)v.getDate("bookeddate")));
        if (!newentries.isEmpty()) {
            for (DynamicObject entry : newentries) {
                DynamicObject acct = entry.getDynamicObject("account");
                if (null == acct) continue;
                ++entryCounts;
                this.dealForEntry(cp, entry, v.getDate("bizdate"));
            }
        }
        if (entryCounts == 0) {
            this.addMessage(exd, ResManager.loadKDString((String)"\u6bcf\u5f20\u51ed\u8bc1\u81f3\u5c11\u5e94\u8be5\u6709\u4e00\u6761\u5206\u5f55\u3002", (String)"VoucherSaveValidator_9", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]), ErrorLevel.Error);
        } else {
            v.set("debitlocamount", (Object)cp.getTotal()[0]);
            v.set("creditlocamount", (Object)cp.getTotal()[1]);
            v.set("vdescription", (Object)cp.getVdesc());
            String isCheck = v.getString("ischeck");
            if (!"c".equals(isCheck)) {
                if (cp.isHashCash() || cp.isExistJournalAccount()) {
                    v.set("ischeck", (Object)"b");
                } else {
                    v.set("ischeck", (Object)"a");
                }
            }
            v.set("mainstatus", (Object)"0");
            v.set("suppstatus", (Object)"0");
            this.setCFStatus(v, cp);
        }
        if (this.getMsgBuilder().getErrorMsg().length() > 0) {
            this.addMessage(exd, this.getMsgBuilder().getErrorMsg().toString(), ErrorLevel.Error);
        }
    }

    private void resolveEntry(Map<Long, DynamicObject> entries, List<DynamicObject> newentries, DynamicObject v) {
        DynamicObjectCollection col = v.getDynamicObjectCollection("entries");
        for (DynamicObject o : col) {
            long entryId = o.getLong("id");
            if (entryId != 0L) {
                entries.put(entryId, o);
                continue;
            }
            newentries.add(o);
        }
    }

    @Override
    protected void baseValidate(DynamicObject v, Map<Long, String> map) {
        String status;
        if (v.getDataEntityState().getFromDatabase() && !map.containsKey(v.getLong("id"))) {
            this.getMsgBuilder().appendErrorMsg(ResManager.loadKDString((String)"\u8be5\u6761\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u88ab\u5220\u9664\u3002", (String)"VoucherSaveValidator_10", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
            return;
        }
        String string = status = map.get(v.getLong("id")) != null ? map.get(v.getLong("id")) : v.getString("billstatus");
        if (status != null && !status.equals("A")) {
            this.getMsgBuilder().appendErrorMsg(ResManager.loadKDString((String)"\u4ec5\u6682\u5b58\u51ed\u8bc1\u5141\u8bb8\u6682\u5b58\u3002", (String)"VoucherSaveValidator_11", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
        }
    }

    @Override
    public void entryValidate(ExtendedDataEntity dataEntity) {
        DynamicObject v = dataEntity.getDataEntity();
        boolean localSet = CashflowLocalSetUtil.isLocalSetThread((long)v.getLong("org_id"), (Date)v.getDate("bookeddate"));
        DynamicObject book = v.getDynamicObject("book");
        if (book == null) {
            return;
        }
        long baseCur = book.getLong("basecurrency.id");
        if (v.get("localcur_id") == null || (Long)v.get("localcur_id") == 0L) {
            v.set("localcur_id", (Object)baseCur);
        }
        VoucherSaveValidatorParam cp = new VoucherSaveValidatorParam(dataEntity);
        DynamicObjectCollection entrys = v.getDynamicObjectCollection("entries");
        if (entrys == null) {
            return;
        }
        int entryCounts = 0;
        boolean hasCashAcc = false;
        boolean hasPlAcc = false;
        boolean hasNcNpAcc = false;
        BigDecimal suppAmountSum = BigDecimal.ZERO;
        for (DynamicObject entry : entrys) {
            DynamicObject account = entry.getDynamicObject("account");
            if (account == null) continue;
            if (!hasCashAcc && GLUtil.isCashAcct((DynamicObject)account)) {
                hasCashAcc = true;
            }
            if (!hasPlAcc && GLUtil.isPLAcct((DynamicObject)account)) {
                hasPlAcc = true;
            }
            if (!hasNcNpAcc && GLUtil.isNCashNPLAcct((DynamicObject)account)) {
                hasNcNpAcc = true;
            }
            suppAmountSum = suppAmountSum.add(entry.getBigDecimal("suppcfamount"));
        }
        for (DynamicObject entry : entrys) {
            if (!VoucherUtils.isBlankLine((DynamicObject)entry)) {
                ++entryCounts;
            }
            this.validateDynamicEntry(cp, entry, false);
            if (!CashFlowItemHelper.permitDesignCashflow((long)book.getLong("id"), (long)v.getLong("period_id"))) continue;
            this.checkCF(hasCashAcc, hasPlAcc, hasNcNpAcc, suppAmountSum.compareTo(BigDecimal.ZERO) == 0, entry, localSet);
        }
        CashFlowItemHelper.calculateEntry((DynamicObject)v, (boolean)localSet);
        v.set("vdescription", (Object)(entrys.isEmpty() ? "" : ((DynamicObject)entrys.get(0)).getString("edescription")));
        v.set("debitlocamount", (Object)cp.getTotal()[0]);
        v.set("creditlocamount", (Object)cp.getTotal()[1]);
        String checkStatus = v.getString("ischeck");
        if (cp.isHashCash() || cp.isExistJournalAccount()) {
            if (!"c".equals(checkStatus)) {
                v.set("ischeck", (Object)"b");
            }
        } else {
            v.set("ischeck", (Object)"a");
        }
        if (entryCounts == 0) {
            this.getMsgBuilder().appendErrorMsg(ResManager.loadKDString((String)"\u6bcf\u5f20\u51ed\u8bc1\u81f3\u5c11\u5e94\u8be5\u6709\u4e00\u6761\u5206\u5f55\u3002", (String)"VoucherSaveValidator_9", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
        }
    }

    private void validateDynamicEntry(VoucherSaveValidatorParam cp, DynamicObject entry, boolean collectCashFlow) {
        DynamicObject account = entry.getDynamicObject("account");
        if (account == null) {
            return;
        }
        int seq = entry.getInt("seq");
        String accountNumber = account.getString("number");
        long accountTypeId = account.getLong("accounttype_id");
        boolean budgetType = AccountType.isBudgetType((long)accountTypeId);
        if (!cp.isBudget() && budgetType) {
            this.getMsgBuilder().appendErrorMsg(this.getMsgFormtter().createEntryErrorMsg(seq, accountNumber, ResManager.loadKDString((String)"\u6b64\u8d26\u7c3f\u672a\u5f00\u542f\u9884\u7b97\u4f1a\u8ba1\uff0c\u65e0\u6cd5\u5f55\u5165\u9884\u7b97\u79d1\u76ee\u3002", (String)"VoucherSaveValidator_21", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0])));
            return;
        }
        if (null == cp.getVdesc()) {
            cp.setVdesc(entry.getString("edescription"));
        }
        BigDecimal dl = entry.getBigDecimal("debitlocal");
        dl = dl.setScale(cp.getBaseCurrencyScale(), RoundingMode.HALF_UP);
        BigDecimal cl = entry.getBigDecimal("creditlocal");
        cl = cl.setScale(cp.getBaseCurrencyScale(), RoundingMode.HALF_UP);
        entry.set("entrydc", (Object)VoucherUtils.getEntryDc((DynamicObject)entry));
        cp.getTotal()[0] = cp.getTotal()[0].add(dl);
        cp.getTotal()[1] = cp.getTotal()[1].add(cl);
        if (entry.getLong("currency_id") == cp.getBaseCurId()) {
            entry.set("debitori", (Object)dl);
            entry.set("creditori", (Object)cl);
            entry.set("localrate", (Object)BigDecimal.ONE);
        } else {
            DynamicObject currency = entry.getDynamicObject("currency");
            int scale = currency == null ? cp.getBaseCurrencyScale() : currency.getInt(CurrencyConstant.Entity_AMT_Scale.key);
            BigDecimal debitOriAmount = entry.getBigDecimal("debitori");
            BigDecimal creditOriAmount = entry.getBigDecimal("creditori");
            entry.set("debitori", (Object)debitOriAmount.setScale(scale, RoundingMode.HALF_UP));
            entry.set("creditori", (Object)creditOriAmount.setScale(scale, RoundingMode.HALF_UP));
        }
        BigDecimal price = entry.getBigDecimal("price");
        if (VoucherOption.enablePriceCheck() && price != null && price.compareTo(BigDecimal.ZERO) < 0) {
            this.getMsgBuilder().appendErrorMsg(this.getMsgFormtter().createEntryErrorMsg(seq, accountNumber, ResManager.loadKDString((String)"\u5355\u4ef7\u4e0d\u80fd\u4e3a\u8d1f\u6570\u3002", (String)"VoucherSaveValidator_17", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0])));
        }
        if (!MeasureUnit.matchGroup((long)entry.getLong("measureunit.id"), (long)account.getLong("measureunitgroup_id"))) {
            this.getMsgBuilder().appendErrorMsg(this.getMsgFormtter().createEntryErrorMsg(seq, accountNumber, ResManager.loadKDString((String)"\u8ba1\u91cf\u5355\u4f4d\u4e0d\u5728\u79d1\u76ee\u7684\u8ba1\u91cf\u5355\u4f4d\u5206\u7ec4\u5185\u3002", (String)"VoucherSaveValidator_23", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0])));
        }
        boolean isQty = account.getBoolean("isqty");
        boolean isAc = account.getBoolean("accheck");
        if (!isQty) {
            entry.set("measureunit", null);
            entry.set("measureunit_id", (Object)0L);
            entry.set("quantity", (Object)0);
            entry.set("price", (Object)0);
        }
        if (isAc) {
            boolean exDateBeforeBizdate = BillParamUtil.getBooleanValue((String)"83bfebc8000017ac", (String)"fi.gl.voucher.expiredatebeforebizdate", (boolean)false);
            Date expireDate = entry.getDate("expiredate");
            if (null == expireDate) {
                this.getMsgBuilder().appendErrorMsg(this.getMsgFormtter().createEntryErrorMsg(seq, accountNumber, ResManager.loadKDString((String)"\u5f80\u6765\u79d1\u76ee\u7684\u5230\u671f\u65e5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"VoucherSaveValidator_7", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0])));
                return;
            }
            if (!exDateBeforeBizdate && expireDate.before(DateUtil.makeDateOnDayStrart((Date)cp.getBizDate()))) {
                this.getMsgBuilder().appendErrorMsg(this.getMsgFormtter().createEntryErrorMsg(seq, accountNumber, ResManager.loadKDString((String)"\u5230\u671f\u65e5\u5fc5\u987b\u665a\u4e8e\u4e1a\u52a1\u65e5\u671f\u3002", (String)"VoucherSaveValidator_8", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0])));
                return;
            }
        } else {
            entry.set("businessnum", null);
            entry.set("expiredate", null);
        }
        if (!(cp.isFinalProcess() || cp.isDap() || cp.isReverse() || cp.isSynVoucher())) {
            this.validateFlexValueAvailable(entry);
        }
        if (!cp.isHashCash() && (account.getBoolean("iscash") || account.getBoolean("iscashequivalent") || account.getBoolean("isbank"))) {
            cp.setHashCash(true);
        }
        if (!cp.isExistJournalAccount() && account.getBoolean("isjournal")) {
            cp.setExistJournalAccount(true);
        }
        this.checkCurrency(cp.getDataEntity(), entry).ifPresent(s -> this.getMsgBuilder().appendErrorMsg(this.getMsgFormtter().createEntryErrorMsg(seq, accountNumber, (String)s)));
        if (!CashFlowItemHelper.permitDesignCashflow((long)cp.getBookId(), (long)cp.getPeriodId()) || budgetType) {
            this.clearSupp(entry);
            this.clearMain(entry);
        } else {
            DynamicObject mainCf = entry.getDynamicObject("maincfitem");
            DynamicObject supCf = entry.getDynamicObject("suppcfitem");
            if (mainCf != null && !mainCf.getBoolean("isleaf") || supCf != null && !supCf.getBoolean("isleaf")) {
                this.getMsgBuilder().appendErrorMsg(this.getMsgFormtter().createEntryErrorMsg(seq, accountNumber, ResManager.loadKDString((String)"\u51ed\u8bc1\u4e0d\u80fd\u5f55\u5165\u975e\u660e\u7ec6\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\uff0c\u8bf7\u68c0\u67e5\u73b0\u91d1\u6d41\u91cf\u9879\u76ee\u662f\u5426\u4e3a\u660e\u7ec6\u3002", (String)"VoucherSaveValidator_12", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0])));
            }
            if (mainCf != null && "3".equals(mainCf.getString("type"))) {
                this.getMsgBuilder().appendErrorMsg(this.getMsgFormtter().createEntryErrorMsg(seq, accountNumber, ResManager.loadKDString((String)"\u4e3b\u8868\u9879\u76ee\u5f55\u5165\u7684\u662f\u8865\u5145\u8d44\u6599", (String)"VoucherSaveValidator_24", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0])));
            }
            if (supCf != null && "1".equals(supCf.getString("type"))) {
                this.getMsgBuilder().appendErrorMsg(this.getMsgFormtter().createEntryErrorMsg(seq, accountNumber, ResManager.loadKDString((String)"\u8865\u5145\u8d44\u6599\u5f55\u5165\u7684\u662f\u4e3b\u8868\u9879\u76ee", (String)"VoucherSaveValidator_25", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0])));
            }
            if (mainCf != null && "b".equals(mainCf.getString("direction"))) {
                this.getMsgBuilder().appendErrorMsg(this.getMsgFormtter().createEntryErrorMsg(seq, accountNumber, String.format(ResManager.loadKDString((String)"\u4e3b\u8868\u9879\u76ee%s\u7684\u65b9\u5411\u4e3a\u6d41\u5165\u6d41\u51fa", (String)"VoucherSaveValidator_18", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]), mainCf.getString("number"))));
            }
            if (supCf != null && supCf.getBoolean("isprefit")) {
                this.getMsgBuilder().appendErrorMsg(this.getMsgFormtter().createEntryErrorMsg(seq, accountNumber, String.format(ResManager.loadKDString((String)"\u8865\u5145\u8d44\u6599\u4e0d\u5141\u8bb8\u5f55\u5165\u51c0\u5229\u6da6\u9879\u76ee\u3002", (String)"VoucherSaveValidator_22", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]), supCf.getString("number"))));
            }
            if (collectCashFlow) {
                if (account.getBoolean("iscash") || account.getBoolean("iscashequivalent") || account.getBoolean("isbank")) {
                    cp.setCashtotalamt(cp.getCashtotalamt().add(dl).subtract(cl));
                    return;
                }
                boolean isPLAcct = GLUtil.isPLAcct((long)accountTypeId);
                if (!cp.isNotC_NotPL() && !isPLAcct) {
                    cp.setNotC_NotPL(true);
                }
                if (!cp.isHasPL() && isPLAcct) {
                    cp.setHasPL(true);
                }
                if (mainCf != null) {
                    if (!cp.isHashMainCf()) {
                        cp.setHashMainCf(true);
                    }
                    boolean in = true;
                    BigDecimal mainCFAmt = entry.getBigDecimal("maincfamount");
                    if ("o".equals(mainCf.getString("direction"))) {
                        cp.setCashtotalused(cp.getCashtotalused().subtract(mainCFAmt));
                        in = false;
                    } else {
                        cp.setCashtotalused(cp.getCashtotalused().add(mainCFAmt));
                    }
                    boolean isDealactivity = mainCf.getBoolean("isdealactivity");
                    if (isDealactivity) {
                        BigDecimal bigDecimal = cp.getCashAmt()[0] = in ? cp.getCashAmt()[0].add(mainCFAmt) : cp.getCashAmt()[0].subtract(mainCFAmt);
                    }
                    if (!cp.isPlMainCf() && isPLAcct) {
                        cp.setPlMainCf(true);
                    }
                }
                if (isPLAcct) {
                    cp.getCashAmt()[1] = cp.getCashAmt()[1].add(cl).subtract(dl);
                }
                if (supCf != null) {
                    if (!cp.isHasSuppCf()) {
                        cp.setHasSuppCf(true);
                    }
                    cp.getCashAmt()[2] = cp.getCashAmt()[2].add(entry.getBigDecimal("suppcfamount"));
                }
            }
        }
    }

    private Optional<String> checkCurrency(ExtendedDataEntity extendedDataEntity, DynamicObject entryDyn) {
        DynamicObjectCollection currDynColl;
        Set currIdSet;
        DynamicObject accDyn = entryDyn.getDynamicObject("account");
        String currType = accDyn.getString("acctcurrency");
        long currId = entryDyn.getLong("currency.id");
        DynamicObject vchDyn = extendedDataEntity.getDataEntity();
        long baseCurrId = vchDyn.getLong("localcur_id");
        if (baseCurrId == 0L) {
            baseCurrId = vchDyn.getLong("localcur.id");
        }
        if ("nocurrency".equals(currType) && currId != baseCurrId) {
            return Optional.of(ResManager.loadKDString((String)"\u672a\u6307\u5b9a\u5e01\u79cd\u6838\u7b97\uff0c\u8bf7\u4f7f\u7528\u672c\u4f4d\u5e01\u3002", (String)"VoucherSaveValidator_14", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
        }
        if ("descurrency".equals(currType) && !(currIdSet = (currDynColl = accDyn.getDynamicObjectCollection("currencyentry")).stream().map(x -> x.getLong("currency.id")).collect(Collectors.toSet())).contains(currId) && currId != baseCurrId) {
            return Optional.of(ResManager.loadKDString((String)"\u5f53\u524d\u5e01\u79cd\u4e0d\u5305\u542b\u5728\u6838\u7b97\u7684\u5e01\u79cd\u4e2d\u3002", (String)"VoucherSaveValidator_15", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
        }
        return Optional.empty();
    }

    private void validateFlexValueAvailable(DynamicObject entry) {
        Optional<String> error = this.getFlexValueValidateService().validateAvailable((AccountWrapper)((Object)this.getAccCache().get(Long.valueOf(entry.getLong("account.id")))), entry);
        error.ifPresent(s -> this.getMsgBuilder().appendErrorMsg(this.getMsgFormtter().createEntryErrorMsg(entry.getInt("seq"), entry.getString("account.number"), (String)s)));
    }

    private void checkCF(boolean hasCashAcc, boolean hasPlAcc, boolean hasNcNpAcc, boolean suppAmountSumZero, DynamicObject entry, boolean localSet) {
        boolean onlyNcNpAcc;
        if (GLBillParamEnum.VOUCHER_CASHFLOW_SAVEFIX_SKIP.getBooleanValue()) {
            return;
        }
        DynamicObject acct = entry.getDynamicObject("account");
        if (AccountType.isBudgetType((long)acct.getLong("accounttype_id"))) {
            return;
        }
        DynamicObject mainCF = entry.getDynamicObject("maincfitem");
        boolean isCashAcct = GLUtil.isCashAcct((DynamicObject)acct);
        boolean isPlAcct = GLUtil.isPLAcct((DynamicObject)acct);
        boolean onlyCashAcc = hasCashAcc && !hasPlAcc && !hasNcNpAcc;
        boolean onlyPlAcc = !hasCashAcc && hasPlAcc && !hasNcNpAcc;
        boolean bl = onlyNcNpAcc = !hasCashAcc && !hasPlAcc && hasNcNpAcc;
        if (!hasCashAcc || onlyCashAcc) {
            this.clearMain(entry);
            if (onlyCashAcc || onlyPlAcc || onlyNcNpAcc && !suppAmountSumZero) {
                this.clearSupp(entry);
            }
            if (!onlyNcNpAcc) {
                if (localSet && !isPlAcct) {
                    this.clearSupp(entry);
                } else if (!localSet && isPlAcct) {
                    this.clearSupp(entry);
                }
            }
        } else if (localSet) {
            if (!isCashAcct) {
                this.clearMain(entry);
                if (!isPlAcct) {
                    this.clearSupp(entry);
                }
            } else if (mainCF == null || !mainCF.getBoolean("isdealactivity")) {
                this.clearSupp(entry);
            }
        } else if (isCashAcct) {
            this.clearMain(entry);
            this.clearSupp(entry);
        } else if (mainCF == null) {
            this.clearSupp(entry);
        } else if (isPlAcct && mainCF.getBoolean("isdealactivity")) {
            this.clearSupp(entry);
        } else if (!isPlAcct && !mainCF.getBoolean("isdealactivity")) {
            this.clearSupp(entry);
        }
    }

    private void clearSupp(DynamicObject entry) {
        entry.set("suppcfitem", null);
        entry.set("suppcfamount", (Object)0);
    }

    private void clearMain(DynamicObject entry) {
        entry.set("maincfitem", null);
        entry.set("maincfamount", (Object)0);
        entry.set("maincfassgrp", null);
    }

    private static Set<Long> getCurOrgUseAccount(Long orgid, long accountTableId) {
        Set useAccountIds;
        HashMap<Long, Set> accountUseMap = (HashMap<Long, Set>)LocalCacheHelper.get((CacheKey)CacheKey.getCacheKey((CacheKeyPrefix)CacheKeyPrefix.GL_ACCOUNT_ORGUSE, (Object[])new Object[0]), Map.class);
        if (accountUseMap == null) {
            accountUseMap = new HashMap<Long, Set>(10);
        }
        if ((useAccountIds = (Set)accountUseMap.get(orgid)) == null) {
            useAccountIds = AccountUtils.queryAccountIds((long)orgid, (long)accountTableId, null);
            accountUseMap.put(orgid, useAccountIds);
            LocalCacheHelper.put((CacheKey)CacheKey.getCacheKey((CacheKeyPrefix)CacheKeyPrefix.GL_ACCOUNT_ORGUSE, (Object[])new Object[0]), accountUseMap);
        }
        return useAccountIds;
    }
}

