/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.validate;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.ext.fi.accountref.AccountRefUtils;
import kd.bos.ext.fi.lock.IShareLock;
import kd.bos.kdtx.sdk.check.TxCheckUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.bd.util.CashflowLocalSetUtil;
import kd.fi.gl.business.GLServiceFactory;
import kd.fi.gl.cache.CacheKey;
import kd.fi.gl.cache.CacheKeyPrefix;
import kd.fi.gl.cache.IdDynCache;
import kd.fi.gl.cache.LocalCacheHelper;
import kd.fi.gl.cache.MapCache;
import kd.fi.gl.comassist.model.ComAssistTable;
import kd.fi.gl.interfaces.service.voucher.IVoucherQueryService;
import kd.fi.gl.util.GLApp;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.OrgBookTypeUtil;
import kd.fi.gl.util.SystemParamHelper;
import kd.fi.gl.util.TccUtil;
import kd.fi.gl.util.voucher.VoucherNumberUtils;
import kd.fi.gl.validate.bigdata.Context;
import kd.fi.gl.validate.bigdata.ExtDataEntityWrapper;
import kd.fi.gl.validate.bigdata.RowWrapper;
import kd.fi.gl.validate.bigdata.ValidateArg;
import kd.fi.gl.validate.flex.FlexValueValidateService;
import kd.fi.gl.voucher.option.VoucherOption;
import kd.fi.gl.voucher.relation.SyncVoucherSource;
import kd.fi.gl.voucher.util.VoucherUtils;
import kd.fi.gl.voucher.validate.BaseVoucherValidator;
import kd.fi.gl.voucher.validate.CheckableSource;
import kd.fi.gl.voucher.validate.FlexIdValueCache;
import kd.fi.gl.voucher.validate.VchEntryWrapper;
import kd.fi.gl.voucher.validate.VchExtDataEntityWrapper;
import kd.fi.gl.voucher.validate.VoucherCheckValidateUtil;
import kd.fi.gl.voucher.validate.VoucherContext;
import kd.fi.gl.voucher.validate.VoucherRowWrapper;
import kd.fi.gl.voucher.validate.VoucherSubmitQueryUtil;
import kd.fi.gl.voucher.validate.VoucherValidateMsgBuilder;
import kd.fi.gl.voucher.validate.VoucherValidateService;
import kd.fi.gl.voucher.validate.util.AccountTypeGetter;
import kd.fi.gl.voucher.vo.VoucherPK;
import kd.fi.gl.wrap.EntryWrapper;

public class VoucherSubmitValidator
extends BaseVoucherValidator {
    private Map<String, IShareLock> locks;

    public VoucherSubmitValidator() {
        this.init();
        this.setOperationName(ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"VoucherSubmitValidator_0", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
    }

    public VoucherSubmitValidator(Map<String, IShareLock> locks) {
        this.locks = locks;
        this.init();
        this.setOperationName(ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"VoucherSubmitValidator_0", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
    }

    @Override
    protected DataSet queryDataSetByIdSet(Set<Long> idSet) {
        return ((IVoucherQueryService)GLServiceFactory.getService(IVoucherQueryService.class)).queryByIds(idSet, null, this.getDataSetSelect(), "id");
    }

    @Override
    public String getDataSetSelect() {
        return VoucherSubmitQueryUtil.getSelect();
    }

    @Override
    public RowWrapper wrapRow(Row row) {
        return new VoucherRowWrapper(row);
    }

    @Override
    public Context initContext(ExtendedDataEntity[] dataEntities) {
        Context context = super.initContext(dataEntities);
        VoucherContext voucherContext = (VoucherContext)context;
        voucherContext.setSimpleDateFormat(new SimpleDateFormat("yyyy-MM-dd"));
        voucherContext.setAllAccIds(new ArrayList<Long>(dataEntities.length * 2));
        voucherContext.setAllCfMainItemIds(new ArrayList<Long>(dataEntities.length * 2));
        voucherContext.setCashFlowValidateConfigCache((MapCache<Long, String>)new MapCache(new HashMap(2), orgId -> (String)SystemParamHelper.getObjectParam((String)"checkmaincf", (long)orgId)));
        voucherContext.setAutoCheckConfigCache((MapCache<Long, Boolean>)new MapCache(new HashMap(2), orgId -> SystemParamHelper.getBooleanParam((String)"autocheck", (long)orgId, (boolean)false)));
        voucherContext.setOriAmountValidateConfigCache((MapCache<Long, Boolean>)new MapCache(new HashMap(2), orgId -> SystemParamHelper.getBooleanParam((String)"checkoriamount", (long)orgId, (boolean)false)));
        voucherContext.setOffSheetAccountValidateConfigCache((MapCache<Long, Boolean>)new MapCache(new HashMap(2), orgId -> SystemParamHelper.getBooleanParam((String)"checkbwaccount", (long)orgId, (boolean)false)));
        voucherContext.setAmountNonMustInputConfigCache((MapCache<Long, Boolean>)new MapCache(new HashMap(2), orgId -> SystemParamHelper.getBooleanParam((String)"zeroamount", (long)orgId, (boolean)false)));
        voucherContext.setIgnoreQPAConsistencyCheckConfigCache((MapCache<Long, Boolean>)new MapCache(new HashMap(2), orgId -> SystemParamHelper.getBooleanParam((String)"ignoreqpaconsistent", (long)orgId, (boolean)false)));
        voucherContext.setAccTableCache((MapCache<String, ComAssistTable>)new MapCache(new HashMap(2), key -> {
            Long[] idArr = OrgBookTypeUtil.getIdArrayFromKeySplit((String)key);
            long accountTableId = AccountRefUtils.getCurPeriodAccountTableId((long)idArr[0], (long)idArr[1], (long)idArr[2]);
            return ComAssistTable.get((Long)accountTableId);
        }));
        voucherContext.setOpenedPeriodCache((MapCache<String, List<Long>>)new MapCache(new HashMap(2), key -> {
            Tuple orgIdBookTypeId = OrgBookTypeUtil.getOrgIdBookTypeIdTupleByGroupKey((String)key);
            return GLUtil.getOpenPeriod((long)((Long)orgIdBookTypeId.item1), (long)((Long)orgIdBookTypeId.item2));
        }));
        voucherContext.setAssistValueNameCache((MapCache<String, String>)new MapCache(new HashMap(4), key -> {
            String valueSource = key.split(",")[0];
            String pkValue = key.split(",")[1];
            BasedataEntityType type = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)valueSource);
            return BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(pkValue), (DynamicObjectType)type).getString(type.getNameProperty());
        }));
        voucherContext.setPeriodDynCache(new IdDynCache(8, "bd_period", "id,begindate,enddate,name,number,periodnumber,periodyear,isadjustperiod,periodtype.id"));
        voucherContext.setBookDynCache(new IdDynCache(2, "gl_accountbook", "basecurrency.name,curperiod.id,curperiod.begindate,curperiod.enddate,curperiod.name,curperiod.number,curperiod.periodnumber,curperiod.periodyear,defaultvouchertype.name,ismainbook,name,number,periodtype.number,enable,isbudget"));
        voucherContext.setAccountVersionUpdateCache((Map)LocalCacheHelper.get((CacheKey)CacheKey.getCacheKey((CacheKeyPrefix)CacheKeyPrefix.GL_ACCOUNT_REPLACE, (Object[])new Object[0]), Map.class));
        voucherContext.setFlexValueUpdateCache((Map)LocalCacheHelper.get((CacheKey)CacheKey.getCacheKey((CacheKeyPrefix)CacheKeyPrefix.GL_ASSGRP_REPLACE, (Object[])new Object[0]), Map.class));
        voucherContext.setVchDynType(dataEntities[0].getDataEntity().getDynamicObjectType());
        voucherContext.setFlexValueValidateService(new FlexValueValidateService());
        voucherContext.setAccountTypeGetter(new AccountTypeGetter());
        voucherContext.setOrgLocalSetCache(new HashMap<Long, Tuple<Boolean, Date>>(1));
        voucherContext.setCheckableSources(new ArrayList<CheckableSource>(dataEntities.length));
        boolean checkBalLog = VoucherOption.checkBalLog();
        if (checkBalLog) {
            List tempIds = Arrays.asList(dataEntities).stream().filter(x -> "A".equals(x.getDataEntity().getString("billstatus"))).map(e -> e.getDataEntity().getLong("id")).collect(Collectors.toList());
            Set submittedVchId = VoucherUtils.hasSubmittedVchId(tempIds);
            voucherContext.setHasSubmitedIds(submittedVchId);
        }
        voucherContext.setSyncVch(new HashMap<Long, SyncVoucherSource>());
        return voucherContext;
    }

    @Override
    public void onLoopDataEntities(ValidateArg validateArg, ExtDataEntityWrapper dataEntityWrapper) {
        super.onLoopDataEntities(validateArg, dataEntityWrapper);
        VchExtDataEntityWrapper wrapper = (VchExtDataEntityWrapper)dataEntityWrapper;
        this.doLock(wrapper.getOrgId(), wrapper.getBookTypeId(), wrapper.getPeriodId(), this.locks);
        VoucherContext context = this.getContext();
        context.getOrgLocalSetCache().put(wrapper.getOrgId(), null);
        CheckableSource checkableSource = VoucherCheckValidateUtil.getCheckableSourceFromVoucher(wrapper, context);
        wrapper.setCheckableSource(checkableSource);
        if (checkableSource != null) {
            context.getCheckableSources().add(checkableSource);
        }
        if (((VchExtDataEntityWrapper)dataEntityWrapper).isSynVoucher()) {
            SyncVoucherSource synSourceVoucher = new SyncVoucherSource(Long.valueOf(dataEntityWrapper.getDyn().getLong("sourcebill")));
            synSourceVoucher.setMappingVoucher(new VoucherPK(Long.valueOf(dataEntityWrapper.getId())));
            context.getSyncVch().put(dataEntityWrapper.getId(), synSourceVoucher);
        }
    }

    @Override
    public void onLoopEntries(ExtDataEntityWrapper extDataEntityWrapper, EntryWrapper entryWrapper) {
        super.onLoopEntries(extDataEntityWrapper, entryWrapper);
        VchEntryWrapper vchEntryWrapper = (VchEntryWrapper)entryWrapper;
        this.getContext().getAllAccIds().add(vchEntryWrapper.getAccId());
        this.getContext().getAllCfMainItemIds().add(vchEntryWrapper.getCfMainItemId());
    }

    @Override
    public void beforeValidateAllDataEntities(ValidateArg validateAllArg) {
        super.beforeValidateAllDataEntities(validateAllArg);
        VoucherContext voucherContext = this.getContext();
        this.buildAccountRepository(voucherContext.getAllAccIds());
        voucherContext.setAccCache(this.getAccCache());
        this.getContext().getOrgLocalSetCache().putAll(CashflowLocalSetUtil.getLocalSetInfo(this.getContext().getOrgLocalSetCache().keySet()));
        this.buildCfMainItemRepository(voucherContext.getAllCfMainItemIds());
        voucherContext.setCfMainItemCache(this.getCfMainItemCache());
        VoucherCheckValidateUtil.batchLoadCheckableSourcesInfo(this.getContext().getCheckableSources());
        this.getContext().batchInitSynVch();
        voucherContext.setRepeatNoVouchersFromCodeRule((Set)ThreadCache.get((Object)"voucherLoopRepeatIds"));
        Set needCheckVoucherDyns = voucherContext.getAllDataEntityWrapper().stream().map(ExtDataEntityWrapper::getDyn).filter(voucherDyn -> VoucherNumberUtils.maybeRepeat((DynamicObject)voucherDyn, (OperateOption)this.getOption())).collect(Collectors.toSet());
        voucherContext.setRepeatNoVouchers(VoucherNumberUtils.checkRepeatNos(needCheckVoucherDyns, (String)"B"));
    }

    @Override
    public void beforeValidateDataEntitiesFormDb(ValidateArg dbValidateArg, Map<Long, ExtDataEntityWrapper> idDataEntityMap) {
        super.beforeValidateDataEntitiesFormDb(dbValidateArg, idDataEntityMap);
        VoucherContext voucherContext = this.getContext();
        Set<Long> idSet = idDataEntityMap.keySet();
        voucherContext.setVoucherStatusMapFromDb((Map)ThreadCache.get((Object)"voucherInfoMap"));
        this.preRead(idSet, voucherContext);
        voucherContext.setReciStatusMapFromDb(VoucherUtils.getReciRecord(new ArrayList<Long>(idSet)));
        if (!idSet.isEmpty() && TccUtil.isDtxEnable() && !this.getOption().containsVariable("isdap")) {
            voucherContext.setVchIdListInDtx(TxCheckUtil.loadUnfinishedTx((String)"voucher", idSet.stream().map(String::valueOf).collect(Collectors.toList())));
        }
    }

    @Override
    public void beforeValidateOneBillDataSetRow(ValidateArg dbValidateArg, ExtDataEntityWrapper dataEntityWrapper) {
        super.beforeValidateOneBillDataSetRow(dbValidateArg, dataEntityWrapper);
        VchExtDataEntityWrapper vchExtDataEntityWrapper = (VchExtDataEntityWrapper)dataEntityWrapper;
        VoucherContext voucherContext = this.getContext();
        VoucherValidateService.validateBill(vchExtDataEntityWrapper, voucherContext);
        StringBuilder errorMsg = vchExtDataEntityWrapper.getMsgBuilder().getErrorMsg();
        if (errorMsg.length() > 0) {
            this.addErrorMessage(vchExtDataEntityWrapper.getExtendedDataEntity(), errorMsg.toString());
            dbValidateArg.setCancel(true);
        }
    }

    @Override
    public void validateDataSetRow(ValidateArg dbValidateArg, ExtDataEntityWrapper dataEntityWrapper, long validateId, RowWrapper rowWrapper) {
        super.validateDataSetRow(dbValidateArg, dataEntityWrapper, validateId, rowWrapper);
        VchExtDataEntityWrapper vchExtDataEntityWrapper = (VchExtDataEntityWrapper)dataEntityWrapper;
        VoucherContext voucherContext = this.getContext();
        VoucherRowWrapper voucherRowWrapper = (VoucherRowWrapper)rowWrapper;
        long entryId = voucherRowWrapper.getRow().getLong(8);
        VchEntryWrapper vchEntryWrapper = (VchEntryWrapper)vchExtDataEntityWrapper.getEntryWrapperMap().get(entryId);
        VoucherValidateService.validateDataSetRow(vchExtDataEntityWrapper, vchEntryWrapper, voucherRowWrapper, voucherContext);
    }

    @Override
    public void afterOneBillDataSetRowValidated(ValidateArg dbValidateArg, ExtDataEntityWrapper dataEntityWrapper) {
        super.afterOneBillDataSetRowValidated(dbValidateArg, dataEntityWrapper);
        VchExtDataEntityWrapper vchExtDataEntityWrapper = (VchExtDataEntityWrapper)dataEntityWrapper;
        VoucherValidateMsgBuilder msgBuilder = vchExtDataEntityWrapper.getMsgBuilder();
        if (msgBuilder.getEntryMsg().length() > 0) {
            this.addErrorMessage(vchExtDataEntityWrapper.getExtendedDataEntity(), msgBuilder.getEntryMsg().toString());
            return;
        }
        VoucherContext voucherContext = this.getContext();
        VoucherValidateService.validateEntries(vchExtDataEntityWrapper, voucherContext);
        if (msgBuilder.getErrorMsg().length() > 0) {
            this.addErrorMessage(vchExtDataEntityWrapper.getExtendedDataEntity(), msgBuilder.getErrorMsg().toString());
        }
    }

    @Override
    public void afterValidateDataEntitiesFormDb(ValidateArg dbValidateArg, Map<Long, ExtDataEntityWrapper> idDataEntityMap) {
        super.afterValidateDataEntitiesFormDb(dbValidateArg, idDataEntityMap);
    }

    @Override
    public void beforeValidateDataEntity(ValidateArg dataValidateArg, ExtDataEntityWrapper dataEntityWrapper) {
        super.beforeValidateDataEntity(dataValidateArg, dataEntityWrapper);
        VchExtDataEntityWrapper vchExtDataEntityWrapper = (VchExtDataEntityWrapper)dataEntityWrapper;
        VoucherContext voucherContext = this.getContext();
        VoucherValidateService.validateBill(vchExtDataEntityWrapper, voucherContext);
        StringBuilder errorMsg = vchExtDataEntityWrapper.getMsgBuilder().getErrorMsg();
        if (errorMsg.length() > 0) {
            this.addErrorMessage(vchExtDataEntityWrapper.getExtendedDataEntity(), errorMsg.toString());
            dataValidateArg.setCancel(true);
        }
    }

    @Override
    public void validateEntry(ValidateArg dataValidateArg, ExtDataEntityWrapper dataEntityWrapper, EntryWrapper entryWrapper) {
        super.validateEntry(dataValidateArg, dataEntityWrapper, entryWrapper);
        VchExtDataEntityWrapper vchExtDataEntityWrapper = (VchExtDataEntityWrapper)dataEntityWrapper;
        VchEntryWrapper vchEntryWrapper = (VchEntryWrapper)entryWrapper;
        VoucherContext voucherContext = this.getContext();
        VoucherValidateService.validateEntry(vchExtDataEntityWrapper, vchEntryWrapper, voucherContext);
    }

    @Override
    public void afterValidateDataEntity(ValidateArg dataValidateArg, ExtDataEntityWrapper dataEntityWrapper) {
        super.afterValidateDataEntity(dataValidateArg, dataEntityWrapper);
        VchExtDataEntityWrapper vchExtDataEntityWrapper = (VchExtDataEntityWrapper)dataEntityWrapper;
        VoucherValidateMsgBuilder msgBuilder = vchExtDataEntityWrapper.getMsgBuilder();
        if (msgBuilder.getEntryMsg().length() > 0) {
            this.addErrorMessage(vchExtDataEntityWrapper.getExtendedDataEntity(), msgBuilder.getEntryMsg().toString());
            return;
        }
        VoucherContext voucherContext = this.getContext();
        VoucherValidateService.validateEntries(vchExtDataEntityWrapper, voucherContext);
        if (msgBuilder.getErrorMsg().length() > 0) {
            this.addErrorMessage(vchExtDataEntityWrapper.getExtendedDataEntity(), msgBuilder.getErrorMsg().toString());
        }
    }

    protected void preRead(Collection<Long> vchIds, VoucherContext voucherContext) {
        if (vchIds.isEmpty()) {
            return;
        }
        int cacheSize = BillParamUtil.getIntegerValue((String)"83bfebc8000017ac", (String)"fi.gl.voucher.validate.cacheSize", (int)2000);
        try (ShardingHintContext ignored = ShardingHintContext.createAndSet((String)"t_gl_voucher", (HintCondition[])new HintCondition[]{new HintCondition("fid", FilterType.in_range, vchIds)}).prepareShardingIndex();){
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("select faccountid,fmaincfitemid,fassgrpid,fmaincfassgrpid from t_gl_voucherentry where", new Object[0]);
            sqlBuilder.appendIn("fid", new ArrayList<Long>(vchIds));
            try (DataSet accDataSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.of((String)"gl"), (SqlBuilder)sqlBuilder);){
                HashSet<Long> accIds = new HashSet<Long>(vchIds.size() * 2);
                HashSet<Long> cfMainItemIds = new HashSet<Long>(vchIds.size() * 2);
                HashSet<Long> assgrpIds = new HashSet<Long>(vchIds.size() * 2);
                for (Row row : accDataSet) {
                    accIds.add(row.getLong(0));
                    cfMainItemIds.add(row.getLong(1));
                    if (assgrpIds.size() >= cacheSize) continue;
                    Long assgrpId = row.getLong(2);
                    Long mainCfAssgrpId = row.getLong(3);
                    if (assgrpId > 0L) {
                        assgrpIds.add(assgrpId);
                    }
                    if (mainCfAssgrpId <= 0L) continue;
                    assgrpIds.add(mainCfAssgrpId);
                }
                this.buildAccountRepository(accIds);
                this.buildCfMainItemRepository(cfMainItemIds);
                voucherContext.setFlexIdValueCache(new FlexIdValueCache(cacheSize));
                voucherContext.getFlexIdValueCache().fill(assgrpIds);
            }
        }
    }

    @Override
    @Deprecated
    protected void baseValidate(DynamicObject v, Map<Long, String> map) {
    }

    @Override
    @Deprecated
    public void entryValidate(ExtendedDataEntity dataEntity) {
    }
}

