/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.validate;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.util.CollectionUtils;
import kd.fi.bd.util.MultiLangPunc;

public class VoucherValidateMsgFormatter {
    private static final VoucherValidateMsgFormatter INSTANCE = new VoucherValidateMsgFormatter();

    private VoucherValidateMsgFormatter() {
    }

    public static VoucherValidateMsgFormatter get() {
        return INSTANCE;
    }

    public String createEntryErrorMsg(int entrySeq, String accountNumber, String errorMsg) {
        if (entrySeq <= 0) {
            return errorMsg;
        }
        boolean blankAccountNumber = StringUtils.isBlank((CharSequence)accountNumber);
        if (blankAccountNumber) {
            return this.addFullStop(String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\uff1a%s", (String)"VoucherValidatorMsgCreator_0", (String)"fi-gl-opplugin", (Object[])new Object[0]), entrySeq, errorMsg));
        }
        return this.addFullStop(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u79d1\u76ee %2$s\uff1a%3$s", (String)"VoucherValidatorMsgCreator_1", (String)"fi-gl-opplugin", (Object[])new Object[0]), entrySeq, accountNumber, errorMsg));
    }

    public String join(List<String> errorList) {
        if (CollectionUtils.isEmpty(errorList)) {
            return "";
        }
        return errorList.stream().map(this::removeFullStop).collect(Collectors.joining(MultiLangPunc.semicolon()));
    }

    private String addFullStop(String msg) {
        if (StringUtils.isBlank((CharSequence)msg)) {
            return msg;
        }
        String fullStop = MultiLangPunc.fullStop();
        if (StringUtils.isBlank((CharSequence)fullStop)) {
            return msg;
        }
        if (msg.charAt(msg.length() - 1) == fullStop.charAt(0)) {
            return msg;
        }
        return msg + fullStop;
    }

    private String removeFullStop(String msg) {
        if (StringUtils.isBlank((CharSequence)msg)) {
            return msg;
        }
        String fullStop = MultiLangPunc.fullStop();
        if (StringUtils.isBlank((CharSequence)fullStop)) {
            return msg;
        }
        if (msg.charAt(msg.length() - 1) == fullStop.charAt(0)) {
            return msg.substring(0, msg.length() - 1);
        }
        return msg;
    }
}

