/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.validate;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.gl.util.GLUtil;
import kd.fi.gl.util.VoucherEntriesSummary;
import kd.fi.gl.voucher.util.AmountAggregator;
import kd.fi.gl.voucher.validate.AccountWrapper;
import kd.fi.gl.voucher.validate.VchDynWrapper;
import kd.fi.gl.voucher.validate.VchEntryWrapper;
import kd.fi.gl.voucher.validate.VchExtDataEntityWrapper;
import kd.fi.gl.voucher.validate.VoucherContext;
import kd.fi.gl.voucher.validate.VoucherRowWrapper;
import kd.fi.gl.wrap.DynWrapper;

public class VoucherValidateUtil {
    private VoucherValidateUtil() {
    }

    public static void sumEntry(VchExtDataEntityWrapper vchExtDataEntityWrapper, VchEntryWrapper vchEntryWrapper) {
        VoucherEntriesSummary summary = vchExtDataEntityWrapper.getVoucherEntriesSummary();
        AccountWrapper account = vchEntryWrapper.getAccount();
        boolean localSet = vchExtDataEntityWrapper.isLocalSet();
        BigDecimal debitLoc = vchEntryWrapper.getDebitLocAmt();
        BigDecimal creditLoc = vchEntryWrapper.getCreditLocAmt();
        Object[] keys = vchExtDataEntityWrapper.getSumKeyCalcs().stream().map(c -> c.calc(vchEntryWrapper, vchExtDataEntityWrapper)).toArray();
        summary.getDebitLocTotal().accumulate(debitLoc, keys);
        summary.getCreditLocTotal().accumulate(creditLoc, keys);
        summary.getDebitOriTotal().accumulate(vchEntryWrapper.getDebitOriAmt(), keys);
        summary.getCreditOriTotal().accumulate(vchEntryWrapper.getCreditOriAmt(), keys);
        for (AmountAggregator amountAggregator : vchExtDataEntityWrapper.getLocalAmtAggregators()) {
            amountAggregator.sum(vchEntryWrapper, keys);
        }
        if (1 == vchEntryWrapper.getSeq()) {
            summary.setVchDesc(vchEntryWrapper.getString("edescription"));
        }
        if (account.isBudget()) {
            return;
        }
        if (account.isJournal()) {
            summary.setExistJournalAccount(true);
        }
        if (account.isCash()) {
            if (!summary.isExistsCashAccount()) {
                summary.setExistsCashAccount(true);
            }
            summary.setCashAccountDebitTotal(summary.getCashAccountDebitTotal().add(debitLoc).subtract(creditLoc));
            if (!localSet) {
                return;
            }
        }
        boolean isPlAccount = account.isPl();
        if (!summary.isExistsNotCachNotPlAccount() && GLUtil.isNCashNPLAcct((DynamicObject)account.getDyn())) {
            summary.setExistsNotCachNotPlAccount(true);
        }
        if (!summary.isExistsPlAccount() && isPlAccount) {
            summary.setExistsPlAccount(true);
        }
        DynWrapper dynWrapper = vchEntryWrapper.getMainCfItem();
        BigDecimal mainCfAmt = vchEntryWrapper.getMainCfAmt();
        DynWrapper suppItem = vchEntryWrapper.getSuppCfItem();
        BigDecimal suppCfAmt = vchEntryWrapper.getSuppCfAmt();
        if (dynWrapper != null) {
            if (!summary.isMainCfDesignated()) {
                summary.setMainCfDesignated(true);
            }
            boolean in = true;
            if ("o".equals(dynWrapper.getString("direction"))) {
                summary.setDesiginatedMainAmt(summary.getDesiginatedMainAmt().subtract(mainCfAmt));
                in = false;
            } else {
                summary.setDesiginatedMainAmt(summary.getDesiginatedMainAmt().add(mainCfAmt));
            }
            boolean isDealActivity = dynWrapper.getBoolean("isdealactivity");
            if (!summary.isMainCfDesignatedOnPlAcct() && isPlAccount) {
                summary.setMainCfDesignatedOnPlAcct(true);
            }
            if (isDealActivity) {
                BigDecimal amtOnActivities = summary.getAmtOnActivities();
                amtOnActivities = in ? amtOnActivities.add(mainCfAmt) : amtOnActivities.subtract(mainCfAmt);
                summary.setAmtOnActivities(amtOnActivities);
            }
        }
        if (isPlAccount) {
            summary.setNetProfit(summary.getNetProfit().add(creditLoc).subtract(debitLoc));
        }
        if (suppItem != null) {
            summary.setDesiginatedSuppAmt(summary.getDesiginatedSuppAmt().add(suppCfAmt));
            if (!summary.isSuppCfDesignated()) {
                summary.setSuppCfDesignated(true);
            }
        }
    }

    public static void sumEntry(VchExtDataEntityWrapper vchExtDataEntityWrapper, VoucherRowWrapper vchRowWrapper, VoucherContext voucherContext) {
        AccountWrapper account = vchRowWrapper.getAccount();
        boolean localSet = vchExtDataEntityWrapper.isLocalSet();
        BigDecimal debitLoc = vchRowWrapper.getDebitLocAmt();
        BigDecimal creditLoc = vchRowWrapper.getCreditLocAmt();
        VoucherEntriesSummary summary = vchExtDataEntityWrapper.getVoucherEntriesSummary();
        Object[] keys = vchExtDataEntityWrapper.getSumKeyCalcs().stream().map(c -> c.calc(vchRowWrapper, vchExtDataEntityWrapper)).toArray();
        summary.getDebitLocTotal().accumulate(debitLoc, keys);
        summary.getCreditLocTotal().accumulate(creditLoc, keys);
        summary.getDebitOriTotal().accumulate(vchRowWrapper.getDebitOriAmt(), keys);
        summary.getCreditOriTotal().accumulate(vchRowWrapper.getCreditOriAmt(), keys);
        for (AmountAggregator amountAggregator : vchExtDataEntityWrapper.getLocalAmtAggregators()) {
            amountAggregator.sum(vchRowWrapper, keys);
        }
        if ("1".equals(vchRowWrapper.getString(9))) {
            summary.setVchDesc(vchRowWrapper.getString(27));
        }
        if (account.isBudget()) {
            return;
        }
        if (account.isJournal()) {
            summary.setExistJournalAccount(true);
        }
        if (account.isCash()) {
            if (!summary.isExistsCashAccount()) {
                summary.setExistsCashAccount(true);
            }
            summary.setCashAccountDebitTotal(summary.getCashAccountDebitTotal().add(debitLoc).subtract(creditLoc));
            if (!localSet) {
                return;
            }
        }
        boolean isPlAccount = account.isPl();
        if (!summary.isExistsNotCachNotPlAccount() && GLUtil.isNCashNPLAcct((DynamicObject)account.getDyn())) {
            summary.setExistsNotCachNotPlAccount(true);
        }
        if (!summary.isExistsPlAccount() && isPlAccount) {
            summary.setExistsPlAccount(true);
        }
        DynamicObject dynamicObject = vchRowWrapper.getMainCfItem();
        BigDecimal mainCfAmt = vchRowWrapper.getMainCfAmt();
        DynamicObject suppItem = vchRowWrapper.getSuppCfItem();
        BigDecimal suppCfAmt = vchRowWrapper.getSuppCfAmt();
        if (dynamicObject != null) {
            if (!summary.isMainCfDesignated()) {
                summary.setMainCfDesignated(true);
            }
            boolean in = true;
            if ("o".equals(dynamicObject.getString("direction"))) {
                summary.setDesiginatedMainAmt(summary.getDesiginatedMainAmt().subtract(mainCfAmt));
                in = false;
            } else {
                summary.setDesiginatedMainAmt(summary.getDesiginatedMainAmt().add(mainCfAmt));
            }
            boolean isDealActivity = dynamicObject.getBoolean("isdealactivity");
            if (!summary.isMainCfDesignatedOnPlAcct() && isPlAccount) {
                summary.setMainCfDesignatedOnPlAcct(true);
            }
            if (isDealActivity) {
                BigDecimal amtOnActivities = summary.getAmtOnActivities();
                amtOnActivities = in ? amtOnActivities.add(mainCfAmt) : amtOnActivities.subtract(mainCfAmt);
                summary.setAmtOnActivities(amtOnActivities);
            }
        }
        if (isPlAccount) {
            summary.setNetProfit(summary.getNetProfit().add(creditLoc).subtract(debitLoc));
        }
        if (suppItem != null) {
            summary.setDesiginatedSuppAmt(summary.getDesiginatedSuppAmt().add(suppCfAmt));
            if (!summary.isSuppCfDesignated()) {
                summary.setSuppCfDesignated(true);
            }
        }
    }

    public static void setSummary(VchExtDataEntityWrapper vchExtDataEntityWrapper) {
        VoucherEntriesSummary summary = vchExtDataEntityWrapper.getVoucherEntriesSummary();
        VchDynWrapper vchDynWrapper = vchExtDataEntityWrapper.getVchDynWrapper();
        boolean localSet = vchExtDataEntityWrapper.isLocalSet();
        if (vchExtDataEntityWrapper.isProfitVch() || vchExtDataEntityWrapper.isCarryOverVch()) {
            vchDynWrapper.set("mainstatus", "0");
            vchDynWrapper.set("suppstatus", "0");
        } else if (summary.isExistsCashAccount()) {
            if (summary.isExistsPlAccount()) {
                if (summary.isMainCfDesignated()) {
                    if (summary.getDesiginatedMainAmt().compareTo(summary.getCashAccountDebitTotal()) == 0) {
                        vchDynWrapper.set("mainstatus", "3");
                    } else {
                        vchDynWrapper.set("mainstatus", "2");
                    }
                    VoucherValidateUtil.setSuppStatus(vchDynWrapper, summary);
                } else {
                    vchDynWrapper.set("mainstatus", "1");
                    if (localSet) {
                        VoucherValidateUtil.setSuppStatus(vchDynWrapper, summary);
                    } else {
                        vchDynWrapper.set("suppstatus", "0");
                    }
                }
            } else if (summary.isExistsNotCachNotPlAccount()) {
                if (summary.isMainCfDesignated()) {
                    if (summary.getDesiginatedMainAmt().compareTo(summary.getCashAccountDebitTotal()) == 0) {
                        vchDynWrapper.set("mainstatus", "3");
                    } else {
                        vchDynWrapper.set("mainstatus", "2");
                    }
                } else {
                    vchDynWrapper.set("mainstatus", "1");
                }
                VoucherValidateUtil.setSuppStatus(vchDynWrapper, summary);
            } else {
                vchDynWrapper.set("mainstatus", "0");
                vchDynWrapper.set("suppstatus", "0");
            }
        } else if (summary.isExistsPlAccount()) {
            vchDynWrapper.set("mainstatus", "0");
            if (summary.isExistsNotCachNotPlAccount()) {
                VoucherValidateUtil.setSuppStatus(vchDynWrapper, summary);
            } else {
                vchDynWrapper.set("suppstatus", "0");
            }
        } else if (summary.isExistsNotCachNotPlAccount()) {
            vchDynWrapper.set("mainstatus", "0");
            if (summary.isSuppCfDesignated()) {
                if (summary.getDesiginatedSuppAmt().compareTo(BigDecimal.ZERO) == 0) {
                    vchDynWrapper.set("suppstatus", "c");
                } else {
                    vchDynWrapper.set("suppstatus", "b");
                }
            } else {
                vchDynWrapper.set("suppstatus", "a");
            }
        } else {
            vchDynWrapper.set("mainstatus", "0");
            vchDynWrapper.set("suppstatus", "0");
        }
        vchDynWrapper.set("vdescription", summary.getVchDesc());
        vchDynWrapper.set("debitlocamount", summary.getDebitLocTotal().getSum(vchDynWrapper.getLocCurAmtPrecision()));
        vchDynWrapper.set("creditlocamount", summary.getCreditLocTotal().getSum(vchDynWrapper.getLocCurAmtPrecision()));
    }

    private static void setSuppStatus(VchDynWrapper vchDynWrapper, VoucherEntriesSummary result) {
        BigDecimal suppAmt = result.getAmtOnActivities().subtract(result.getNetProfit());
        if (suppAmt.compareTo(result.getDesiginatedSuppAmt()) != 0) {
            if (result.isExistsCashAccount() && !result.isMainCfDesignated()) {
                vchDynWrapper.set("suppstatus", "0");
            } else if (result.isSuppCfDesignated()) {
                vchDynWrapper.set("suppstatus", "2");
            } else {
                vchDynWrapper.set("suppstatus", "1");
            }
        } else if (suppAmt.compareTo(result.getDesiginatedSuppAmt()) == 0) {
            if (result.isSuppCfDesignated()) {
                vchDynWrapper.set("suppstatus", "3");
            } else {
                vchDynWrapper.set("suppstatus", "0");
            }
        } else {
            vchDynWrapper.set("suppstatus", "1");
        }
    }
}

