/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.validate.bill;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.util.CollectionUtils;
import kd.fi.gl.business.vo.voucher.AmountField;
import kd.fi.gl.comassist.model.ComAssistTable;
import kd.fi.gl.util.OrgBookTypeUtil;
import kd.fi.gl.util.VoucherEntriesSummary;
import kd.fi.gl.validate.bigdata.ValidateResult;
import kd.fi.gl.voucher.util.LocalAmountAggregator;
import kd.fi.gl.voucher.util.VoucherUtils;
import kd.fi.gl.voucher.validate.VchExtDataEntityWrapper;
import kd.fi.gl.voucher.validate.VoucherContext;
import kd.fi.gl.voucher.validate.bill.IVoucherValidator;
import kd.fi.gl.voucher.validate.entry.amountKey.ISumKeyCalc;
import kd.fi.gl.voucher.validate.entry.amountKey.impl.BudgetSumKeyCalc;
import kd.fi.gl.voucher.validate.entry.amountKey.impl.ComAssistSumKeyCalc;
import kd.fi.gl.voucher.validate.entry.amountKey.impl.DefaultSumKeyCalc;

public class BillContextInitializer
implements IVoucherValidator {
    private static final List<Function<VchExtDataEntityWrapper, List<AmountField>>> LOCAL_FIELDS_BUILDERS = new ArrayList<Function<VchExtDataEntityWrapper, List<AmountField>>>(2);

    public static synchronized void register(Function<VchExtDataEntityWrapper, List<AmountField>> builder) {
        LOCAL_FIELDS_BUILDERS.add(builder);
    }

    @Override
    public ValidateResult validate(VchExtDataEntityWrapper vchExtDataEntityWrapper, VoucherContext voucherContext) {
        long orgId = vchExtDataEntityWrapper.getOrgId();
        vchExtDataEntityWrapper.setAcAccMasterIdList(new ArrayList<Long>(10));
        vchExtDataEntityWrapper.setAmountNonMustInput((Boolean)voucherContext.getAmountNonMustInputConfigCache().get((Object)orgId));
        vchExtDataEntityWrapper.setAccountTable((ComAssistTable)voucherContext.getAccTableCache().get((Object)OrgBookTypeUtil.createGroupKey((Long[])new Long[]{orgId, vchExtDataEntityWrapper.getBookTypeId(), vchExtDataEntityWrapper.getPeriodId()})));
        vchExtDataEntityWrapper.setVoucherEntriesSummary(new VoucherEntriesSummary());
        if (vchExtDataEntityWrapper.isFromDb()) {
            vchExtDataEntityWrapper.setEntryOidSet(VoucherUtils.getEntryOidSet((DynamicObject)vchExtDataEntityWrapper.getDyn(), (DynamicObjectType)voucherContext.getVchDynType()));
        }
        Map<Long, Tuple<Boolean, Date>> orgLocalCache = voucherContext.getOrgLocalSetCache();
        Date bookedDate = vchExtDataEntityWrapper.getBookedDate();
        vchExtDataEntityWrapper.setLocalSet((Boolean)orgLocalCache.get((Object)Long.valueOf((long)orgId)).item1 != false && ((Date)orgLocalCache.get((Object)Long.valueOf((long)orgId)).item2).getTime() <= bookedDate.getTime());
        vchExtDataEntityWrapper.setSumKeyCalcs(this.initSumKeyClacs(vchExtDataEntityWrapper));
        vchExtDataEntityWrapper.setBudget(vchExtDataEntityWrapper.getVchDynWrapper().getDynamicObject("book").getBoolean("isbudget"));
        ArrayList<AmountField> fields = new ArrayList<AmountField>(2);
        for (Function<VchExtDataEntityWrapper, List<AmountField>> localFieldsBuilder : LOCAL_FIELDS_BUILDERS) {
            fields.addAll((Collection<AmountField>)localFieldsBuilder.apply(vchExtDataEntityWrapper));
        }
        vchExtDataEntityWrapper.setLocalAmountFields(fields);
        ArrayList<LocalAmountAggregator> amountAggregators = new ArrayList<LocalAmountAggregator>(2);
        for (AmountField localAmountField : vchExtDataEntityWrapper.getLocalAmountFields()) {
            amountAggregators.add(new LocalAmountAggregator(localAmountField, vchExtDataEntityWrapper.getVchDynWrapper()));
        }
        vchExtDataEntityWrapper.setLocalAmtAggregators(amountAggregators);
        return ValidateResult.create();
    }

    private List<ISumKeyCalc<?>> initSumKeyClacs(VchExtDataEntityWrapper vchExtDataEntityWrapper) {
        ArrayList result = new ArrayList(2);
        if (vchExtDataEntityWrapper.getVchDynWrapper().getDynamicObject("book").getBoolean("isbudget")) {
            result.add(new BudgetSumKeyCalc());
        }
        if (CollectionUtils.isNotEmpty((Collection)vchExtDataEntityWrapper.getAccountTable().getBalancedCommonAssistKeys())) {
            result.add(new ComAssistSumKeyCalc());
        }
        if (result.isEmpty()) {
            result.add(new DefaultSumKeyCalc());
        }
        return result;
    }
}

