/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.validate.entry;

import java.math.BigDecimal;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.gl.common.VoucherSourceType;
import kd.fi.gl.util.GLApp;
import kd.fi.gl.validate.bigdata.ValidateResult;
import kd.fi.gl.voucher.relation.SyncVoucherSource;
import kd.fi.gl.voucher.validate.AccountWrapper;
import kd.fi.gl.voucher.validate.VchEntryWrapper;
import kd.fi.gl.voucher.validate.VchExtDataEntityWrapper;
import kd.fi.gl.voucher.validate.VoucherContext;
import kd.fi.gl.voucher.validate.VoucherRowWrapper;
import kd.fi.gl.voucher.validate.entry.IVchEntryValidator;

public class AccountControlValidator
implements IVchEntryValidator {
    @Override
    public boolean cancelValidate(ValidateResult result) {
        return !result.isSuccess();
    }

    @Override
    public boolean isEnable(VchExtDataEntityWrapper vchExtDataEntityWrapper, VchEntryWrapper vchEntryWrapper, VoucherContext voucherContext) {
        SyncVoucherSource synSourceVoucher = voucherContext.getSyncVch().get(vchExtDataEntityWrapper.getId());
        boolean srcVchIsNotEndingProcess = synSourceVoucher != null && VoucherSourceType.fromEndingProcess((String)synSourceVoucher.getSourceType());
        return !vchExtDataEntityWrapper.isProfitVch() && !vchExtDataEntityWrapper.isExchangeRateVch() && !vchExtDataEntityWrapper.isAmortVch() && !vchExtDataEntityWrapper.isAutoTransVch() && !vchExtDataEntityWrapper.isCarryOverVch() && !srcVchIsNotEndingProcess;
    }

    @Override
    public boolean isEnable(VchExtDataEntityWrapper vchExtDataEntityWrapper, VchEntryWrapper vchEntryWrapper, VoucherRowWrapper vchRowMapper, VoucherContext voucherContext) {
        return this.isEnable(vchExtDataEntityWrapper, vchEntryWrapper, voucherContext);
    }

    @Override
    public ValidateResult validate(VchExtDataEntityWrapper vchExtDataEntityWrapper, VchEntryWrapper vchEntryWrapper, VoucherContext voucherContext) {
        ValidateResult result = ValidateResult.create();
        AccountWrapper account = vchEntryWrapper.getAccount();
        String direction = vchEntryWrapper.getString("entrydc");
        String directionControl = account.getString("accrualdirection");
        ValidateResult dcResult = this.validateAccountDirectionControl(result, vchEntryWrapper.getDebitLocAmt(), vchEntryWrapper.getCreditLocAmt(), directionControl);
        if (!dcResult.isSuccess()) {
            return dcResult;
        }
        String currencyCtrl = account.getAcctcurrency();
        long entryCurrencyId = vchEntryWrapper.getCurrencyId();
        if (entryCurrencyId == 0L) {
            return result.setErrorMsg(ResManager.loadKDString((String)"\u5e01\u79cd\u672a\u586b\u5199", (String)"AccountControlValidator_5", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
        }
        if ("descurrency".equals(currencyCtrl)) {
            Set<Long> curIdList = account.getCurrencyPkList();
            if (curIdList.isEmpty()) {
                return result.setErrorMsg(ResManager.loadKDString((String)"\u5df2\u6307\u5b9a\u5e01\u79cd\u6838\u7b97\uff0c\u4f46\u672a\u6307\u5b9a\u5e01\u79cd\u3002", (String)"AccountControlValidator_2", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
            }
            if (!curIdList.contains(entryCurrencyId) && entryCurrencyId != vchExtDataEntityWrapper.getVchDynWrapper().getLocCurId()) {
                return result.setErrorMsg(String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7684\u5e01\u79cd\u4e0d\u5305\u62ec%s", (String)"AccountControlValidator_3", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]), vchEntryWrapper.getCurrency().getString("name")));
            }
        } else if ("nocurrency".equals(currencyCtrl) && entryCurrencyId != vchExtDataEntityWrapper.getVchDynWrapper().getLocCurId()) {
            return result.setErrorMsg(ResManager.loadKDString((String)"\u672a\u6307\u5b9a\u5e01\u79cd\u6838\u7b97\uff0c\u8bf7\u4f7f\u7528\u672c\u4f4d\u5e01\u3002", (String)"VoucherSaveValidator_14", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
        }
        return result;
    }

    @Override
    public ValidateResult validate(VchExtDataEntityWrapper vchExtDataEntityWrapper, VchEntryWrapper vchEntryWrapper, VoucherRowWrapper vchRowWrapper, VoucherContext voucherContext) {
        if (vchEntryWrapper != null) {
            return this.validate(vchExtDataEntityWrapper, vchEntryWrapper, voucherContext);
        }
        ValidateResult result = ValidateResult.create();
        AccountWrapper account = vchRowWrapper.getAccount();
        String direction = vchRowWrapper.getDirection();
        String directionControl = account.getAccrualdirection();
        ValidateResult dcResult = this.validateAccountDirectionControl(result, vchRowWrapper.getDebitLocAmt(), vchRowWrapper.getCreditLocAmt(), directionControl);
        if (!dcResult.isSuccess()) {
            return dcResult;
        }
        String currencyCtrl = account.getAcctcurrency();
        long curId = vchRowWrapper.getCurrencyId();
        if (curId == 0L) {
            return result.setErrorMsg(ResManager.loadKDString((String)"\u5e01\u79cd\u672a\u586b\u5199", (String)"AccountControlValidator_5", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
        }
        if ("descurrency".equals(currencyCtrl)) {
            Set<Long> curIdList = account.getCurrencyPkList();
            if (curIdList.size() == 0) {
                return result.setErrorMsg(ResManager.loadKDString((String)"\u5df2\u6307\u5b9a\u5e01\u79cd\u6838\u7b97\uff0c\u4f46\u672a\u6307\u5b9a\u5e01\u79cd\u3002", (String)"AccountControlValidator_2", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
            }
            if (!curIdList.contains(curId) && curId != vchExtDataEntityWrapper.getVchDynWrapper().getLocCurId()) {
                return result.setErrorMsg(ResManager.loadKDString((String)"\u5f53\u524d\u5206\u5f55\u5e01\u79cd\u4e0d\u5305\u62ec\u5728\u6838\u7b97\u7684\u5e01\u79cd\u4e2d\u3002", (String)"AccountControlValidator_4", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
            }
        }
        return result;
    }

    private ValidateResult validateAccountDirectionControl(ValidateResult result, BigDecimal localDebit, BigDecimal localCredit, String directionControl) {
        if ("debit".equals(directionControl) && localCredit != null && localCredit.signum() != 0) {
            return result.setErrorMsg(ResManager.loadKDString((String)"\u65b9\u5411\u63a7\u5236\u4e3a\u501f\u65b9", (String)"AccountControlValidator_0", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
        }
        if ("credit".equals(directionControl) && localDebit != null && localDebit.signum() != 0) {
            return result.setErrorMsg(ResManager.loadKDString((String)"\u65b9\u5411\u63a7\u5236\u4e3a\u8d37\u65b9", (String)"AccountControlValidator_1", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
        }
        return result;
    }
}

