/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.validate.entry;

import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.gl.util.DateUtil;
import kd.fi.gl.util.GLApp;
import kd.fi.gl.validate.bigdata.ValidateResult;
import kd.fi.gl.voucher.validate.AccountWrapper;
import kd.fi.gl.voucher.validate.VchEntryWrapper;
import kd.fi.gl.voucher.validate.VchExtDataEntityWrapper;
import kd.fi.gl.voucher.validate.VoucherContext;
import kd.fi.gl.voucher.validate.VoucherRowWrapper;
import kd.fi.gl.voucher.validate.entry.IVchEntryValidator;

public class ExpireDateValidator
implements IVchEntryValidator {
    @Override
    public ValidateResult validate(VchExtDataEntityWrapper vchExtDataEntityWrapper, VchEntryWrapper vchEntryWrapper, VoucherContext voucherContext) {
        ValidateResult result = ValidateResult.create();
        AccountWrapper account = vchEntryWrapper.getAccount();
        boolean accountCurrent = account.isAccheck();
        Date expireDate = vchEntryWrapper.getExpireDate();
        if (accountCurrent) {
            return this.validateExpireDate(vchExtDataEntityWrapper, result, expireDate);
        }
        return result;
    }

    @Override
    public ValidateResult validate(VchExtDataEntityWrapper vchExtDataEntityWrapper, VchEntryWrapper vchEntryWrapper, VoucherRowWrapper vchRowWrapper, VoucherContext voucherContext) {
        if (vchEntryWrapper != null) {
            return this.validate(vchExtDataEntityWrapper, vchEntryWrapper, voucherContext);
        }
        ValidateResult result = ValidateResult.create();
        AccountWrapper account = vchRowWrapper.getAccount();
        Date expireDate = vchRowWrapper.getRow().getDate(21);
        if (account.isAccheck()) {
            return this.validateExpireDate(vchExtDataEntityWrapper, result, expireDate);
        }
        return result;
    }

    private ValidateResult validateExpireDate(VchExtDataEntityWrapper vchExtDataEntityWrapper, ValidateResult result, Date expireDate) {
        boolean exDateBeforeBizdate = BillParamUtil.getBooleanValue((String)"83bfebc8000017ac", (String)"fi.gl.voucher.expiredatebeforebizdate", (boolean)false);
        if (null == expireDate) {
            return result.setErrorMsg(ResManager.loadKDString((String)"\u5230\u671f\u65e5\u672a\u586b\u5199", (String)"ExpireDateValidator_0", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
        }
        Date tempExpireDate = DateUtil.makeDateOnDayEnd((Date)expireDate);
        if (!exDateBeforeBizdate && tempExpireDate.before(vchExtDataEntityWrapper.getVchDynWrapper().getBizDate())) {
            return result.setErrorMsg(ResManager.loadKDString((String)"\u5230\u671f\u65e5\u5fc5\u987b\u665a\u4e8e\u4e1a\u52a1\u65e5\u671f\u3002", (String)"ExpireDateValidator_1", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]));
        }
        return result;
    }
}

