/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.validate.entry;

import java.util.Optional;
import java.util.function.Supplier;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.util.StringUtils;
import kd.fi.bd.util.BillParamUtil;
import kd.fi.gl.validate.AssGrpMustInputValidator;
import kd.fi.gl.validate.bigdata.ValidateResult;
import kd.fi.gl.voucher.validate.AccountWrapper;
import kd.fi.gl.voucher.validate.CfMainItemWrapper;
import kd.fi.gl.voucher.validate.VchEntryWrapper;
import kd.fi.gl.voucher.validate.VchExtDataEntityWrapper;
import kd.fi.gl.voucher.validate.VoucherContext;
import kd.fi.gl.voucher.validate.VoucherRowWrapper;
import kd.fi.gl.voucher.validate.entry.IVchEntryValidator;

public class FlexValueValidator
implements IVchEntryValidator {
    private static final Supplier<Boolean> alwaysCheckAvailable = () -> BillParamUtil.getBooleanValue((String)"83bfebc8000017ac", (String)"fi.gl.voucher.flex.alwaysCheckAvailable", (boolean)false);

    @Override
    public ValidateResult validate(VchExtDataEntityWrapper vchExtDataEntityWrapper, VchEntryWrapper vchEntryWrapper, VoucherContext voucherContext) {
        ValidateResult result = ValidateResult.create();
        AccountWrapper account = vchEntryWrapper.getAccount();
        Optional<Object> error = Optional.empty();
        if (this.isEnableMustInputValidate(vchExtDataEntityWrapper, vchEntryWrapper, voucherContext)) {
            error = voucherContext.getFlexValueValidateService().validateMustInput(account, vchEntryWrapper);
        }
        if (!error.isPresent() && this.isEnableAvailableValidate(vchExtDataEntityWrapper)) {
            error = voucherContext.getFlexValueValidateService().validateAvailable(account, vchEntryWrapper, "assgrp", Boolean.TRUE);
        }
        if (error.isPresent()) {
            return result.setErrorMsg((String)error.get());
        }
        String errorMsg = AssGrpMustInputValidator.validateCFItem(null, vchEntryWrapper.getEntryDyn());
        if (!StringUtils.isEmpty((String)errorMsg)) {
            return result.setErrorMsg(errorMsg);
        }
        if (this.isEnableAvailableValidate(vchExtDataEntityWrapper) && vchEntryWrapper.getCfMainItem() != null) {
            CfMainItemWrapper cfMainItem = vchEntryWrapper.getCfMainItem();
            error = voucherContext.getFlexValueValidateService().validateAvailable(cfMainItem, vchEntryWrapper, "maincfassgrp", Boolean.FALSE);
        }
        if (error.isPresent()) {
            return result.setErrorMsg((String)error.get());
        }
        return result;
    }

    private boolean isEnableMustInputValidate(VchExtDataEntityWrapper vchExtDataEntityWrapper, VchEntryWrapper vchEntryWrapper, VoucherContext voucherContext) {
        AccountWrapper account = vchEntryWrapper.getAccount();
        String accountType = account.getAccountType();
        return (!vchExtDataEntityWrapper.isProfitVch() || "2".equals(accountType)) && account.isAssist() && !account.getRequiredFlexs().isEmpty();
    }

    private boolean isEnableAvailableValidate(VchExtDataEntityWrapper vchExtDataEntityWrapper) {
        if (alwaysCheckAvailable.get().booleanValue()) {
            return true;
        }
        boolean dapVch = "4".equals(vchExtDataEntityWrapper.getVchDynWrapper().getSourceType());
        boolean isSyncVch = "a".equals(vchExtDataEntityWrapper.getVchDynWrapper().getSourceType());
        return !vchExtDataEntityWrapper.isFinalProcessVch() && !dapVch && !isSyncVch && !vchExtDataEntityWrapper.getVchDynWrapper().isReverse() && !vchExtDataEntityWrapper.isCarryOverVch();
    }

    @Override
    public ValidateResult validate(VchExtDataEntityWrapper vchExtDataEntityWrapper, VchEntryWrapper vchEntryWrapper, VoucherRowWrapper vchRowWrapper, VoucherContext voucherContext) {
        String errorMsg;
        if (vchEntryWrapper != null) {
            return this.validate(vchExtDataEntityWrapper, vchEntryWrapper, voucherContext);
        }
        ValidateResult result = ValidateResult.create();
        Optional<Object> error = Optional.empty();
        String flexJson = voucherContext.getFlexIdValueCache().get(vchRowWrapper.getFlexGroupId());
        if (this.isEnableMustInputValidate(vchExtDataEntityWrapper, vchRowWrapper)) {
            error = voucherContext.getFlexValueValidateService().validateMustInput(vchRowWrapper.getAccount(), flexJson);
        }
        if (!error.isPresent() && this.isEnableAvailableValidate(vchExtDataEntityWrapper, vchRowWrapper)) {
            error = voucherContext.getFlexValueValidateService().validateAvailable(vchRowWrapper.getAccount(), flexJson, Boolean.TRUE);
        }
        if (error.isPresent()) {
            return result.setErrorMsg((String)error.get());
        }
        String cfFlexJson = voucherContext.getFlexIdValueCache().get(vchRowWrapper.getCfFlexGroupId());
        if (this.isEnableCashFlowMustInputValidate(vchRowWrapper) && !StringUtils.isEmpty((String)(errorMsg = AssGrpMustInputValidator.validateCFItemAsstMuestInput(cfFlexJson, vchRowWrapper.getMainCfItem())))) {
            return result.setErrorMsg(errorMsg);
        }
        if (this.isEnableAvailableValidate(vchExtDataEntityWrapper) && vchRowWrapper.getCfMainItem() != null) {
            error = voucherContext.getFlexValueValidateService().validateAvailable(vchRowWrapper.getCfMainItem(), cfFlexJson, Boolean.FALSE);
        }
        if (error.isPresent()) {
            return result.setErrorMsg((String)error.get());
        }
        return result;
    }

    private boolean isEnableMustInputValidate(VchExtDataEntityWrapper vchExtDataEntityWrapper, VoucherRowWrapper vchRowMapper) {
        AccountWrapper account = vchRowMapper.getAccount();
        String accountType = account.getAccountType();
        return (!vchExtDataEntityWrapper.isProfitVch() || "2".equals(accountType)) && account.isAssist() && !account.getRequiredFlexs().isEmpty();
    }

    private boolean isEnableAvailableValidate(VchExtDataEntityWrapper vchExtDataEntityWrapper, VoucherRowWrapper vchRowMapper) {
        if (alwaysCheckAvailable.get().booleanValue()) {
            return true;
        }
        boolean dapVch = "4".equals(vchExtDataEntityWrapper.getVchDynWrapper().getSourceType());
        boolean isSyncVch = "a".equals(vchExtDataEntityWrapper.getVchDynWrapper().getSourceType());
        return !vchExtDataEntityWrapper.isFinalProcessVch() && !dapVch && !isSyncVch && !vchExtDataEntityWrapper.getVchDynWrapper().isReverse() && !vchExtDataEntityWrapper.isCarryOverVch() && vchRowMapper.getAccount().isAssist() && vchRowMapper.getFlexGroupId() > 0L;
    }

    private boolean isEnableCashFlowMustInputValidate(VoucherRowWrapper vchRowWarpper) {
        DynamicObject mainCfItem = vchRowWarpper.getMainCfItem();
        return mainCfItem != null && mainCfItem.getBoolean("isassist") && mainCfItem.getDynamicObjectCollection("assistentry").stream().anyMatch(x -> x.getBoolean("isrequire"));
    }
}

