/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.validate.entry;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.gl.validate.bigdata.ValidateResult;
import kd.fi.gl.voucher.util.VoucherUtils;
import kd.fi.gl.voucher.validate.AccountWrapper;
import kd.fi.gl.voucher.validate.VchEntryWrapper;
import kd.fi.gl.voucher.validate.VchExtDataEntityWrapper;
import kd.fi.gl.voucher.validate.VoucherContext;
import kd.fi.gl.voucher.validate.VoucherRowWrapper;
import kd.fi.gl.voucher.validate.VoucherValidateUtil;
import kd.fi.gl.voucher.validate.entry.IVchEntryValidator;
import kd.fi.gl.wrap.DynWrapper;

public class VchEntryCollector
implements IVchEntryValidator {
    @Override
    public ValidateResult validate(VchExtDataEntityWrapper vchExtDataEntityWrapper, VchEntryWrapper vchEntryWrapper, VoucherContext voucherContext) {
        vchExtDataEntityWrapper.setEntryCount(vchExtDataEntityWrapper.getEntryCount() + 1);
        if (vchEntryWrapper.getDebitLocAmt().compareTo(BigDecimal.ZERO) == 0) {
            vchExtDataEntityWrapper.getCreditAccNumSet().add(vchEntryWrapper.getAccNum());
        } else {
            vchExtDataEntityWrapper.getDebitAccNumSet().add(vchEntryWrapper.getAccNum());
        }
        Long currencyId = vchEntryWrapper.getCurrencyId();
        long locCurId = vchExtDataEntityWrapper.getVchDynWrapper().getLocCurId();
        if (currencyId == locCurId) {
            vchEntryWrapper.setDebitOriAmt(vchEntryWrapper.getDebitLocAmt());
            vchEntryWrapper.setCreditOriAmt(vchEntryWrapper.getCreditLocAmt());
        }
        VoucherValidateUtil.sumEntry(vchExtDataEntityWrapper, vchEntryWrapper);
        boolean multiCurrency = vchExtDataEntityWrapper.isMultiCurrency();
        Long currencyIdForCheckOriAmount = vchExtDataEntityWrapper.getCurrencyIdForCheckOriAmount();
        if (!multiCurrency && currencyIdForCheckOriAmount == 0L) {
            vchExtDataEntityWrapper.setCurrencyIdForCheckOriAmount(currencyId);
            vchExtDataEntityWrapper.setOriAmtPrecision(vchEntryWrapper.getCurrency().getInt("amtprecision"));
        } else if (!multiCurrency && !currencyIdForCheckOriAmount.equals(currencyId)) {
            vchExtDataEntityWrapper.setMultiCurrency(true);
        }
        List<Long> acAccMasterIdList = vchExtDataEntityWrapper.getAcAccMasterIdList();
        AccountWrapper account = vchEntryWrapper.getAccount();
        if (account.isAccheck()) {
            acAccMasterIdList.add(account.getMasterId());
        }
        int[] bits = vchExtDataEntityWrapper.getEntryCountWithDc();
        String entryDc = VoucherUtils.getEntryDc((DynamicObject)vchEntryWrapper.getEntryDyn());
        vchEntryWrapper.set("entrydc", entryDc);
        int n = "1".equals(entryDc) ? 0 : 1;
        bits[n] = bits[n] + 1;
        if (account.isBw()) {
            vchExtDataEntityWrapper.setExistsOffBalanceSheetAccount(true);
        } else {
            vchExtDataEntityWrapper.setExistsOnBalanceSheetAccount(true);
        }
        DynWrapper mainCfItem = vchEntryWrapper.getMainCfItem();
        if (!vchExtDataEntityWrapper.getVchDynWrapper().isSendNotice() && (account.isAcnotice() || mainCfItem != null && mainCfItem.getBoolean("notice"))) {
            vchExtDataEntityWrapper.getVchDynWrapper().setSendNotice(Boolean.TRUE);
        }
        return ValidateResult.create();
    }

    @Override
    public ValidateResult validate(VchExtDataEntityWrapper vchExtDataEntityWrapper, VchEntryWrapper vchEntryWrapper, VoucherRowWrapper vchRowWrapper, VoucherContext voucherContext) {
        if (vchEntryWrapper != null) {
            return this.validate(vchExtDataEntityWrapper, vchEntryWrapper, voucherContext);
        }
        vchExtDataEntityWrapper.setEntryCount(vchExtDataEntityWrapper.getEntryCount() + 1);
        if (vchRowWrapper.getDebitLocAmt().compareTo(BigDecimal.ZERO) == 0) {
            vchExtDataEntityWrapper.getCreditAccNumSet().add(vchRowWrapper.getAccount().getNumber());
        } else {
            vchExtDataEntityWrapper.getDebitAccNumSet().add(vchRowWrapper.getAccount().getNumber());
        }
        vchRowWrapper.setSuppCfItem(VoucherUtils.getCFitem((long)vchExtDataEntityWrapper.getOrgId(), (long)vchRowWrapper.getSuppCfItemId()));
        VoucherValidateUtil.sumEntry(vchExtDataEntityWrapper, vchRowWrapper, voucherContext);
        Long currencyId = vchRowWrapper.getCurrencyId();
        boolean multiCurrency = vchExtDataEntityWrapper.isMultiCurrency();
        Long currencyIdForCheckOriAmount = vchExtDataEntityWrapper.getCurrencyIdForCheckOriAmount();
        if (!multiCurrency && currencyIdForCheckOriAmount == 0L) {
            vchExtDataEntityWrapper.setCurrencyIdForCheckOriAmount(currencyId);
            vchExtDataEntityWrapper.setOriAmtPrecision(vchRowWrapper.getCurAmtPrecision());
        } else if (!multiCurrency && !currencyIdForCheckOriAmount.equals(currencyId)) {
            vchExtDataEntityWrapper.setMultiCurrency(true);
        }
        List<Long> acAccMasterIdList = vchExtDataEntityWrapper.getAcAccMasterIdList();
        AccountWrapper account = vchRowWrapper.getAccount();
        if (account.isAccheck()) {
            acAccMasterIdList.add(account.getMasterId());
        }
        BigDecimal creditLoc = vchRowWrapper.getCreditLocAmt();
        int[] bits = vchExtDataEntityWrapper.getEntryCountWithDc();
        if (creditLoc.signum() == 0) {
            bits[0] = bits[0] + 1;
        } else {
            bits[1] = bits[1] + 1;
        }
        if (account.isBw()) {
            vchExtDataEntityWrapper.setExistsOffBalanceSheetAccount(true);
        } else {
            vchExtDataEntityWrapper.setExistsOnBalanceSheetAccount(true);
        }
        return ValidateResult.create();
    }
}

