/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.gl.voucher.validate.service;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.fi.bd.vo.CommonAssist;
import kd.fi.gl.comassist.model.ComAssistTable;
import kd.fi.gl.constant.GLField;
import kd.fi.gl.util.GLApp;
import kd.fi.gl.util.QFBuilder;
import kd.fi.gl.validate.flex.FlexValueDataGetter;
import kd.fi.gl.voucher.validate.VchEntryWrapper;
import kd.fi.gl.voucher.validate.VoucherRowWrapper;

public class ComAssistValidateService {
    private static final FlexValueDataGetter assistDataGetter = new FlexValueDataGetter();
    private static final String ISLEAF = "isleaf";
    private static final String ENABLE = "enable";

    public static Optional<String> validateMustInput(ComAssistTable table, VchEntryWrapper vchEntryWrapper) {
        return table.getCommonAssists().stream().filter(commonAssist -> commonAssist.isRequired && vchEntryWrapper.getLong(GLField.id_((String)commonAssist.key)) == 0L).findFirst().map(commonAssist -> String.format(ResManager.loadKDString((String)"\u516c\u5171\u7ef4\u5ea6\uff1a%s \u672a\u586b\u5199", (String)"ComAssistValidator_0", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]), commonAssist.name));
    }

    public static Optional<String> validateMustInput(ComAssistTable table, VoucherRowWrapper vchRowWrapper) {
        return table.getCommonAssists().stream().filter(commonAssist -> commonAssist.isRequired && vchRowWrapper.getRow().getLong(commonAssist.key) == 0L).findFirst().map(commonAssist -> String.format(ResManager.loadKDString((String)"\u516c\u5171\u7ef4\u5ea6\uff1a%s \u672a\u586b\u5199", (String)"ComAssistValidator_0", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]), commonAssist.name));
    }

    public static Optional<String> validateAvaiable(ComAssistTable table, VchEntryWrapper vchEntryWrapper) {
        for (CommonAssist commonAssist : table.getCommonAssists()) {
            Optional<String> resultBuf = ComAssistValidateService.singleValidateAvaiable(commonAssist, vchEntryWrapper.getLong(GLField.id_((String)commonAssist.key)));
            if (!resultBuf.isPresent()) continue;
            return resultBuf;
        }
        return Optional.empty();
    }

    public static Optional<String> validateAvaiable(ComAssistTable table, VoucherRowWrapper vchRowWrapper) {
        for (CommonAssist commonAssist : table.getCommonAssists()) {
            Optional<String> resultBuf = ComAssistValidateService.singleValidateAvaiable(commonAssist, vchRowWrapper.getRow().getLong(commonAssist.key));
            if (!resultBuf.isPresent()) continue;
            return resultBuf;
        }
        return Optional.empty();
    }

    private static Optional<String> singleValidateAvaiable(CommonAssist commonAssist, Long pkId) {
        if (commonAssist.isBalanced && ComAssistValidateService.getParentDataSet(commonAssist).contains(pkId)) {
            return Optional.of(String.format(ResManager.loadKDString((String)"\u516c\u5171\u7ef4\u5ea6\u503c%s\u4e0d\u662f\u660e\u7ec6\u503c\u3002", (String)"ComAssistValidateService_0", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]), commonAssist.name));
        }
        if (ComAssistValidateService.getDisabledDataSet(commonAssist).contains(pkId)) {
            return Optional.of(String.format(ResManager.loadKDString((String)"\u516c\u5171\u7ef4\u5ea6\u503c%s\u5df2\u88ab\u7981\u7528\u3002", (String)"ComAssistValidateService_1", (String)GLApp.instance.oppluginModule(), (Object[])new Object[0]), commonAssist.name));
        }
        return Optional.empty();
    }

    private static Set<Long> getParentDataSet(CommonAssist commonAssist) {
        QFBuilder qfBuilder = new QFBuilder();
        switch (commonAssist.valueSource) {
            case "bos_org": 
            case "bos_adminorg": {
                String orgFuncId = "bos_org".equals(commonAssist.valueSource) ? "15" : "01";
                String parentDataCacheKey = String.join((CharSequence)"-", "bos_org", orgFuncId);
                qfBuilder.add("view.treetype", "=", (Object)orgFuncId);
                qfBuilder.add(ISLEAF, "=", (Object)Boolean.FALSE);
                return assistDataGetter.getParentDataSet(parentDataCacheKey, qfBuilder, "bos_org_structure", "org.id");
            }
        }
        if (commonAssist.isAssistantSource()) {
            qfBuilder.add("group", "=", (Object)commonAssist.assistType).add(ISLEAF, "=", (Object)Boolean.FALSE);
            return assistDataGetter.getParentDataSet(commonAssist.assistType.toString(), qfBuilder, "bos_assistantdata_detail", "id");
        }
        if (ComAssistValidateService.getAllEntityPropKeys(commonAssist.valueSource).contains(ISLEAF)) {
            qfBuilder.add(ISLEAF, "=", (Object)Boolean.FALSE);
            return assistDataGetter.getParentDataSet(commonAssist.valueSource, qfBuilder, commonAssist.valueSource, "id");
        }
        return Collections.emptySet();
    }

    private static Set<Long> getDisabledDataSet(CommonAssist commonAssist) {
        QFBuilder qfBuilder = new QFBuilder();
        switch (commonAssist.valueSource) {
            case "bos_org": {
                return assistDataGetter.getDisableDataSet("bos_org", new QFBuilder(ENABLE, "=", (Object)Boolean.FALSE), "bos_org", "id");
            }
            case "bos_adminorg": {
                return assistDataGetter.getDisableDataSet("bos_org_structure", new QFBuilder("isfreeze", "=", (Object)Boolean.TRUE), "bos_org_structure", "org.id");
            }
        }
        if (commonAssist.isAssistantSource()) {
            qfBuilder.add("group", "=", (Object)commonAssist.assistType).add(ENABLE, "=", (Object)Boolean.FALSE);
            return assistDataGetter.getDisableDataSet(commonAssist.assistType.toString(), qfBuilder, "bos_assistantdata_detail", "id");
        }
        if (ComAssistValidateService.getAllEntityPropKeys(commonAssist.valueSource).contains(ENABLE)) {
            return assistDataGetter.getDisableDataSet(commonAssist.valueSource, new QFBuilder(ENABLE, "=", (Object)Boolean.FALSE), commonAssist.valueSource, "id");
        }
        return Collections.emptySet();
    }

    private static Set<String> getAllEntityPropKeys(String entityId) {
        return (Set)ThreadCache.get((Object)("allEntityPropKeys#" + entityId), () -> EntityMetadataCache.getDataEntityType((String)entityId).getAllFields().keySet());
    }
}

