/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.accsys;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.util.Tuple2;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.AppMetadataCache;
import kd.bos.ext.fi.accountref.AccountRefUtils;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bd.cache.CacheHelper;
import kd.fi.bd.cache.DistributeCache;
import kd.fi.bd.util.BatchProcessUtil;
import kd.fi.ict.accsys.AccountBookInfo;
import kd.fi.ict.cache.CacheKey;
import kd.fi.ict.cache.CacheModule;
import kd.fi.ict.cache.ThreadCacheKey;
import kd.fi.ict.util.ContextUtil;
import kd.fi.ict.util.ICTUtils;
import kd.fi.ict.util.PermissonType;

public class AccSysUtil {
    private AccSysUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static AccountBookInfo getBookFromAccSys(long org, long bookType) {
        return (AccountBookInfo)ThreadCache.get((Object)ThreadCacheKey.getAccountBookKey(org, bookType), () -> {
            Long bookId = AccSysUtil.getBookIdFromCache(org, bookType);
            return bookId == null ? null : new AccountBookInfo(bookId);
        });
    }

    public static AccountBookInfo getBookFromAccSys(String orgNumber, String bookTypeNumber) {
        return (AccountBookInfo)ThreadCache.get((Object)ThreadCacheKey.getAccountBookKey(orgNumber, bookTypeNumber), () -> {
            Long bookId = AccSysUtil.getBookIdFromCache(orgNumber, bookTypeNumber);
            return bookId == null ? null : new AccountBookInfo(bookId);
        });
    }

    private static Long getBookIdFromCache(String orgNumber, String bookTypeNumber) {
        return (Long)ThreadCache.get((Object)ThreadCacheKey.getBookIdKey(orgNumber, bookTypeNumber), () -> {
            long result;
            String key = orgNumber + "-" + bookTypeNumber;
            kd.fi.ict.cache.DistributeCache cache = kd.fi.ict.cache.CacheHelper.getDistributeCache(CacheModule.book);
            String bookIdStr = cache.get(key);
            if (StringUtils.isEmpty((String)bookIdStr)) {
                QFilter orgF = new QFilter("org.number", "=", (Object)orgNumber);
                QFilter bookTypeF = new QFilter("bookstype.number", "=", (Object)bookTypeNumber);
                DynamicObjectCollection book = QueryServiceHelper.query((String)"gl_accountbook", (String)"id", (QFilter[])new QFilter[]{orgF, bookTypeF});
                if (book.size() == 0) {
                    return null;
                }
                result = ((DynamicObject)book.get(0)).getLong("id");
                cache.put(key, String.valueOf(result));
            } else {
                result = Long.parseLong(bookIdStr);
            }
            return result;
        });
    }

    public static AccountBookInfo getDefaultBookFromAccSys(Long orgId) {
        return (AccountBookInfo)ThreadCache.get((Object)ThreadCacheKey.getDefAccountBookIdKey(orgId), () -> {
            Long bookId = AccSysUtil.getDefBookIdFromCache(orgId);
            return bookId == null ? null : new AccountBookInfo(bookId);
        });
    }

    public static AccountBookInfo getBookByDataPermission(Long orgId) {
        DynamicObjectCollection bookColl;
        ArrayList<Long> orgIds = new ArrayList<Long>();
        orgIds.add(orgId);
        List<Long> btIds = AccSysUtil.getBookTypeDataPermission(orgIds);
        QFilter qf = new QFilter("org", "=", (Object)orgId);
        if (btIds != null) {
            qf.and(new QFilter("bookstype", "in", btIds));
        }
        return (bookColl = QueryServiceHelper.query((String)"gl_accountbook", (String)"id", (QFilter[])qf.toArray(), (String)"bookstype.accounttype", (int)1)) == null || bookColl.size() <= 0 ? null : new AccountBookInfo(((DynamicObject)bookColl.get(0)).getLong("id"));
    }

    public static List<Long> getAllBookFromAccSys(long orgId) {
        return (List)ThreadCache.get((Object)ThreadCacheKey.getAllBookIdKey(orgId), () -> {
            QFilter h = new QFilter("org", "=", (Object)orgId);
            DynamicObjectCollection coll = QueryServiceHelper.query((String)"gl_accountbook", (String)"id", (QFilter[])new QFilter[]{h}, (String)"bookstype.accounttype");
            ArrayList<Long> idList = new ArrayList<Long>();
            for (DynamicObject obj : coll) {
                idList.add(obj.getLong("id"));
            }
            return idList;
        });
    }

    public static Set<Long> getAllBookTypeFromAccSys(long orgId) {
        return (Set)ThreadCache.get((Object)ThreadCacheKey.getAllBookTypeIdKey(orgId), () -> {
            QFilter h = new QFilter("org", "=", (Object)orgId);
            DynamicObjectCollection coll = QueryServiceHelper.query((String)"gl_accountbook", (String)"bookstype.id id", (QFilter[])new QFilter[]{h}, (String)"bookstype.accounttype");
            HashSet<Long> idSet = new HashSet<Long>();
            for (DynamicObject obj : coll) {
                idSet.add(obj.getLong("id"));
            }
            return idSet;
        });
    }

    public static DynamicObject loadSingleBook(Object orgId, Object bookTypeId, String sel) {
        Long bookId = AccSysUtil.getBookIdFromCache((Long)orgId, (Long)bookTypeId);
        return bookId == null ? null : BusinessDataServiceHelper.loadSingleFromCache((Object)bookId, (String)"gl_accountbook", (String)sel);
    }

    private static Long getBookIdFromCache(long org, long bookType) {
        return (Long)ThreadCache.get((Object)ThreadCacheKey.getBookIdKey(org, bookType), () -> {
            long result;
            String key = CacheKey.getKey(org, bookType);
            kd.fi.ict.cache.DistributeCache cache = kd.fi.ict.cache.CacheHelper.getDistributeCache(CacheModule.book);
            String bookIdStr = cache.get(key);
            if (StringUtils.isEmpty((String)bookIdStr)) {
                QFilter orgF = new QFilter("org", "=", (Object)org);
                QFilter bookTypeF = new QFilter("bookstype", "=", (Object)bookType);
                DynamicObject book = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"id", (QFilter[])new QFilter[]{orgF, bookTypeF});
                if (book == null) {
                    return null;
                }
                result = book.getLong("id");
                cache.put(key, String.valueOf(result));
            } else {
                result = Long.parseLong(bookIdStr);
            }
            return result;
        });
    }

    public static int getAllBookTypeCount() {
        DynamicObjectCollection book = QueryServiceHelper.query((String)"bd_accountbookstype", (String)"id", null);
        return book == null ? 0 : book.size();
    }

    public static DynamicObject getMainBookType() {
        QFilter filter = new QFilter("accounttype", "=", (Object)"1");
        return QueryServiceHelper.queryOne((String)"bd_accountbookstype", (String)"id,number", (QFilter[])filter.toArray());
    }

    public static DynamicObject getMainBook(long orgId) {
        QFilter filter = new QFilter("bookstype", "=", (Object)AccSysUtil.getMainBookType().getLong("id"));
        filter.and(new QFilter("org", "=", (Object)orgId));
        return QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"id,accounttable", (QFilter[])filter.toArray());
    }

    public static Set<Long> getOrgsByPeriodType(Set<Long> orgIds, Long periodType) {
        QFilter filter1 = new QFilter("org", "in", orgIds);
        filter1.and(new QFilter("periodtype", "=", (Object)periodType));
        DynamicObjectCollection multiplechoiceorg = QueryServiceHelper.query((String)"gl_accountbook", (String)"org", (QFilter[])filter1.toArray());
        return multiplechoiceorg.stream().mapToLong(v -> v.getLong("org")).boxed().collect(Collectors.toSet());
    }

    public static Set<Long> getPeriodTypeByOrgs(Set<Long> orgIds) {
        DynamicObjectCollection multiplechoiceorg = BatchProcessUtil.batchQueryDynColl(orgIds, batchData -> {
            QFilter filter1 = new QFilter("org", "in", batchData);
            return QueryServiceHelper.query((String)"gl_accountbook", (String)"periodtype", (QFilter[])filter1.toArray());
        });
        if (!multiplechoiceorg.isEmpty()) {
            return multiplechoiceorg.stream().mapToLong(v -> v.getLong("periodtype")).boxed().collect(Collectors.toSet());
        }
        HashSet<Long> periodtype = new HashSet<Long>(1);
        periodtype.add(0L);
        return periodtype;
    }

    public static Set<Long> getPeriodTypeByAccountBookOrgs(Set<Long> orgIds) {
        QFilter accountTypeFilter = new QFilter("bookstype.accounttype", "=", (Object)"1");
        DynamicObjectCollection multiplechoiceorg = BatchProcessUtil.batchQueryDynColl(orgIds, batchData -> {
            QFilter filter = new QFilter("org", "in", batchData);
            filter.and(accountTypeFilter);
            return QueryServiceHelper.query((String)"gl_accountbook", (String)"periodtype", (QFilter[])filter.toArray());
        });
        if (Objects.nonNull(multiplechoiceorg)) {
            return multiplechoiceorg.stream().mapToLong(v -> v.getLong("periodtype")).boxed().collect(Collectors.toSet());
        }
        HashSet<Long> periodtype = new HashSet<Long>(1);
        periodtype.add(0L);
        return periodtype;
    }

    private static Long getDefBookIdFromCache(Long orgId) {
        return (Long)ThreadCache.get((Object)ThreadCacheKey.getDefBookIdKey(orgId), () -> {
            QFilter qf = new QFilter("org", "=", (Object)orgId);
            DynamicObjectCollection bookColl = QueryServiceHelper.query((String)"gl_accountbook", (String)"id", (QFilter[])qf.toArray(), (String)"bookstype.accounttype", (int)1);
            return bookColl == null || bookColl.size() <= 0 ? null : Long.valueOf(((DynamicObject)bookColl.get(0)).getLong("id"));
        });
    }

    public static boolean isBizUnit(long orgId) {
        QFilter qFilter = new QFilter("org", "=", (Object)orgId);
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"id,isbizunit", (QFilter[])new QFilter[]{qFilter});
        if (dyn == null) {
            return false;
        }
        return dyn.getBoolean("isbizunit");
    }

    public static List<ComboItem> getAcctOrgComboItem(String entityId, boolean isIncludeUnit, PermissonType permType) {
        List<Long> acctOrgPkList = AccSysUtil.getAcctOrgPkList(entityId, isIncludeUnit, permType);
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(10);
        List resultList = BatchProcessUtil.batchProcess(acctOrgPkList, batchData -> QueryServiceHelper.queryPrimaryKeys((String)"bos_org", (QFilter[])new QFilter[]{new QFilter("id", "in", batchData)}, null, (int)-1));
        HashSet orgIds = new HashSet(8);
        resultList.forEach(result -> {
            if (Objects.nonNull(result) && !result.isEmpty()) {
                orgIds.addAll(result);
            }
        });
        try (DataSet orgCol = BatchProcessUtil.batchQueryDataSet(acctOrgPkList, batchData -> QueryServiceHelper.queryDataSet((String)"kd.fi.ict.accsys.AccSysUtil.getAcctOrgComboItem", (String)"gl_accountbook", (String)"org.id orgId,org.number,org.name orgname", (QFilter[])new QFilter[]{new QFilter("org", "in", batchData)}, (String)"org.number"));){
            String old = null;
            for (Row r : orgCol) {
                ComboItem c = new ComboItem();
                Long orgId = r.getLong("orgId");
                if (null == orgId || orgId == 0L || !orgIds.contains(orgId)) continue;
                String orgPk = String.valueOf(orgId);
                if (old == null) {
                    old = orgPk;
                } else {
                    if (old.equals(orgPk)) continue;
                    old = orgPk;
                }
                c.setCaption(new LocaleString(r.getString("orgname")));
                c.setValue(orgPk);
                comboItems.add(c);
            }
        }
        return comboItems;
    }

    public static List<ComboItem> getAllAcctOrgComboItem(String entityId, boolean isIncludeUnit, PermissonType permType) {
        List<Long> acctOrgPkList = AccSysUtil.getAcctOrgPkList(entityId, isIncludeUnit, permType);
        QFilter orgFilter = new QFilter("id", "in", acctOrgPkList);
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(10);
        try (DataSet orgCol = QueryServiceHelper.queryDataSet((String)"kd.fi.ict.accsys.AccSysUtil.getAllAcctOrgComboItem", (String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{orgFilter}, (String)"id");){
            for (Row r : orgCol) {
                ComboItem c = new ComboItem();
                String orgPk = r.getString("id");
                c.setCaption(new LocaleString(r.getString("name")));
                c.setValue(orgPk);
                comboItems.add(c);
            }
        }
        return comboItems;
    }

    public static List<ComboItem> getBookTypeComboByOrg(long orgId) {
        ArrayList<Long> orgIds = new ArrayList<Long>(10);
        orgIds.add(orgId);
        List<ComboItem> result = AccSysUtil.getBookTypeCombo(orgIds, null);
        return result;
    }

    public static List<Long> getBookTypeDataPermission(List<Long> orgs) {
        QFilter permission = PermissionServiceHelper.getDataPermission((long)ContextUtil.getUserId(), null, (String)"bd_accountbookstype", orgs);
        if (null != permission) {
            ArrayList<Long> ids = new ArrayList<Long>(10);
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"AccSysUtil.getBookTypeCombo", (String)"bd_accountbookstype", (String)"id", (QFilter[])new QFilter[]{permission}, null);){
                for (Row row : ds) {
                    ids.add(row.getLong("id"));
                }
            }
            return ids;
        }
        return null;
    }

    public static List<ComboItem> getBookTypeCombo(List<Long> orgs, QFilter qFilters) {
        ArrayList<ComboItem> result = new ArrayList<ComboItem>(10);
        List<Long> bookTypeIds = AccSysUtil.getBookTypeDataPermission(orgs);
        DataSet dataSet = BatchProcessUtil.batchQueryDataSet(orgs, batchData -> {
            QFilter org = new QFilter("org", "in", batchData);
            if (null != bookTypeIds) {
                org = org.and(new QFilter("bookstype", "in", (Object)bookTypeIds));
            }
            if (Objects.nonNull(qFilters)) {
                org.and(qFilters);
            }
            QFilter[] filter = new QFilter[]{org, new QFilter("isbizunit", "=", (Object)"1"), new QFilter("enable", "=", (Object)"1")};
            return QueryServiceHelper.queryDataSet((String)"kd.fi.gl.accsys.AccSysUtil.getBookTypeCombo", (String)"gl_accountbook", (String)"org,bookstype,bookstype.accounttype,bookstype.name btname", (QFilter[])filter, (String)"bookstype.accounttype");
        });
        dataSet = dataSet.groupBy(new String[]{"bookstype", "btname"}).finish();
        for (Row row : dataSet) {
            ComboItem item = new ComboItem();
            long bookstype = row.getLong("bookstype");
            String btname = row.getString("btname");
            item.setCaption(new LocaleString(btname));
            item.setValue(String.valueOf(bookstype));
            result.add(item);
        }
        return result;
    }

    public static List<Long> getAllBookTypeByOrg(long orgId) {
        DataSet bookTypeSet;
        ArrayList<Long> bookTypeList = new ArrayList<Long>(10);
        ArrayList<Long> orgIds = new ArrayList<Long>(10);
        orgIds.add(orgId);
        List<Long> bookTypeIds = AccSysUtil.getBookTypeDataPermission(orgIds);
        QFilter org = new QFilter("org", "=", (Object)orgId);
        if (null != bookTypeIds) {
            org = org.and(new QFilter("bookstype", "in", bookTypeIds));
        }
        if ((bookTypeSet = QueryServiceHelper.queryDataSet((String)"AccSysUtil.getAllBookTypeByOrg", (String)"gl_accountbook", (String)"bookstype", (QFilter[])new QFilter[]{org, new QFilter("isbizunit", "=", (Object)"1"), new QFilter("enable", "=", (Object)"1")}, (String)"bookstype.accounttype")) != null) {
            for (Row row : bookTypeSet) {
                bookTypeList.add(row.getLong("bookstype"));
            }
        }
        return bookTypeList;
    }

    public static QFilter getAccountingOrgFilter(String entityId, boolean isIncludeUnit, PermissonType permType) {
        List<Long> orgIds = AccSysUtil.getAcctOrgPkList(entityId, isIncludeUnit, permType);
        return new QFilter("id", "in", orgIds);
    }

    public static QFilter getAcctOrgFilter(String entityId, boolean isIncludeUnit, PermissonType permType) {
        List<Long> orgIds = AccSysUtil.getAcctOrgPkList(entityId, isIncludeUnit, permType);
        return new QFilter("id", "in", orgIds);
    }

    public static long getAccountingOrg(String entityId, boolean isIncludeUnit, PermissonType permType) {
        List<Long> orgIds = AccSysUtil.getAcctOrgPkList(entityId, isIncludeUnit, permType);
        long orgId = 0L;
        if (!orgIds.isEmpty()) {
            Long curLoginOrg = RequestContext.get().getOrgId();
            orgId = orgIds.contains(curLoginOrg) ? curLoginOrg.longValue() : orgIds.get(0).longValue();
        }
        return orgId;
    }

    public static List<Long> getAcctOrgPkList(String entityId, boolean isIncludeUnit, PermissonType permType) {
        String appId = AppMetadataCache.getAppInfo((String)"ict").getId();
        HasPermOrgResult permOrgRs = PermissionServiceHelper.getAllPermOrgs((Long)ContextUtil.getUserId(), (String)appId, (String)entityId, (String)permType.getPermId());
        LinkedHashSet<Long> orgSet = new LinkedHashSet<Long>();
        Map<Long, Set<Long>> viewOrgMap = isIncludeUnit ? AccSysUtil.getViewOrgMap() : AccSysUtil.getMainViewOrgMap();
        for (Set<Long> orgs : viewOrgMap.values()) {
            orgSet.addAll(orgs);
        }
        List permOrgs = new ArrayList();
        if (!permOrgRs.hasAllOrgPerm()) {
            permOrgs = permOrgRs.getHasPermOrgs();
            orgSet.retainAll(permOrgs);
        }
        HashSet permChildOrg = new HashSet(orgSet);
        if (isIncludeUnit) {
            Map<Long, Set> filteredViewOrgMap = viewOrgMap.entrySet().stream().filter(x -> {
                Set value = (Set)x.getValue();
                value.retainAll(permChildOrg);
                return !value.isEmpty();
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            DataSet orgStructureByViews = AccSysUtil.getOrgStructureByViews(filteredViewOrgMap.keySet());
            LinkedHashSet parentOrgs = new LinkedHashSet();
            for (Map.Entry<Long, Set> entry : filteredViewOrgMap.entrySet()) {
                List<Object> rs = new LinkedList();
                Set orgs = entry.getValue();
                orgs.retainAll(orgSet);
                if (!orgs.isEmpty()) {
                    rs = AccSysUtil.getParentOrgId(orgStructureByViews.copy().filter("view = " + entry.getKey()), orgs, false);
                }
                parentOrgs.addAll(rs);
            }
            if (!permOrgRs.hasAllOrgPerm()) {
                parentOrgs.retainAll(permOrgs);
            }
            parentOrgs.addAll(orgSet);
            parentOrgs.addAll(permOrgs);
            orgSet = parentOrgs;
        }
        return new ArrayList<Long>(orgSet);
    }

    public static HasPermOrgResult getAllPermOrgs(String entityId, String permType) {
        Long userId = Long.valueOf(RequestContext.get().getUserId());
        String appId = AppMetadataCache.getAppInfo((String)"ict").getId();
        HasPermOrgResult hasPermOrg = PermissionServiceHelper.getAllPermOrgs((long)userId, (String)"10", (String)appId, (String)entityId, (String)permType);
        return hasPermOrg;
    }

    public static boolean isPerm(String entityId, String permType) {
        HasPermOrgResult hasPermOrg = AccSysUtil.getAllPermOrgs(entityId, permType);
        return hasPermOrg == null ? false : hasPermOrg.hasAllOrgPerm();
    }

    public static boolean isCustomPerm(String entityId, String permId) {
        HasPermOrgResult hasPermOrg = AccSysUtil.getAllPermOrgs(entityId, permId);
        return hasPermOrg == null ? false : hasPermOrg.hasAllOrgPerm();
    }

    public static Long getMainViewByOrgAndBT(Long orgId, Long bookTypeId) {
        Map<Long, Map<Long, List<Long>>> mainViewOrgBTMap = AccSysUtil.getMainViewOrgBTMap();
        for (Map.Entry<Long, Map<Long, List<Long>>> entry : mainViewOrgBTMap.entrySet()) {
            Map<Long, List<Long>> orgBTMap = entry.getValue();
            for (Map.Entry<Long, List<Long>> listEntry : orgBTMap.entrySet()) {
                if (!listEntry.getKey().equals(orgId) || !listEntry.getValue().contains(bookTypeId)) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    public static Set<Long> getViewByOrg(Long orgId) {
        Set<Long> orgs;
        Map<Long, Set<Long>> viewOrgMap = AccSysUtil.getViewOrgMap();
        Map<Long, Set<Long>> statViewOrgMap = AccSysUtil.getStatViewOrgMap();
        LinkedHashSet<Long> viewList = new LinkedHashSet<Long>();
        QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
        QFilter viewFilter = new QFilter("view", "in", viewOrgMap.keySet());
        DynamicObjectCollection orgStructure = QueryServiceHelper.query((String)"bos_org_structure", (String)"view,view.number number", (QFilter[])new QFilter[]{orgFilter, viewFilter});
        orgStructure.sort((v1, v2) -> {
            String num1 = v1.getString("number");
            if (num1 == null) {
                return -1;
            }
            String num2 = v2.getString("number");
            if (num2 == null) {
                return 1;
            }
            String[] split1 = num1.split(":");
            String[] split2 = num2.split(":");
            String splitNum1 = split1.length > 1 ? split1[1] : split1[0];
            String splitNum2 = split2.length > 1 ? split2[1] : split2[0];
            return splitNum1.compareTo(splitNum2);
        });
        for (DynamicObject dyn : orgStructure) {
            long view = dyn.getLong("view");
            orgs = statViewOrgMap.get(view);
            if (orgs != null && orgs.contains(orgId)) continue;
            viewList.add(view);
        }
        LinkedHashSet<Long> result = new LinkedHashSet<Long>();
        DataSet orgStructureByViews = AccSysUtil.getOrgStructureByViews(viewList);
        for (Long view : viewList) {
            orgs = viewOrgMap.get(view);
            List<Long> parentOrgId = AccSysUtil.getParentOrgId(orgStructureByViews.copy().filter("view = " + view), orgs, true);
            if (!parentOrgId.contains(orgId)) continue;
            result.add(view);
        }
        return result;
    }

    private static DataSet getOrgStructureByViews(Collection<Long> views) {
        QFilter mainViewFilter = new QFilter("view", "in", views);
        return QueryServiceHelper.queryDataSet((String)"GLUtil.getParentOrgId", (String)"bos_org_structure", (String)"org,parent,view", (QFilter[])new QFilter[]{mainViewFilter}, null);
    }

    private static Map<Long, Set<Long>> getViewOrgMap() {
        Map<Long, Map<Long, List<Long>>> viewOrgBTMap = AccSysUtil.getViewOrgBTMap();
        HashMap<Long, Set<Long>> viewOrgMap = new HashMap<Long, Set<Long>>(viewOrgBTMap.size());
        for (Map.Entry<Long, Map<Long, List<Long>>> entry : viewOrgBTMap.entrySet()) {
            HashSet<Long> orgSet = new HashSet<Long>(entry.getValue().keySet());
            viewOrgMap.put(entry.getKey(), orgSet);
        }
        return viewOrgMap;
    }

    public static Map<Long, Map<Long, List<Long>>> getViewOrgBTMap() {
        Map<Long, Map<Long, List<Long>>> mainViewOrgBTMap = AccSysUtil.getMainViewOrgBTMap();
        Map<Long, Map<Long, List<Long>>> statViewOrgBTMap = AccSysUtil.getStatViewOrgBTMap();
        mainViewOrgBTMap.putAll(statViewOrgBTMap);
        return mainViewOrgBTMap;
    }

    public static Set<Long> getChildOrgsByView(Long org, Long view, String formId) {
        HashSet<Long> parent = new HashSet<Long>();
        parent.add(org);
        Set<Long> childOrgList = AccSysUtil.getChildOrgId("10", view, parent, true);
        HashSet<Long> orgViewSet = new HashSet<Long>();
        Map<Long, Set<Long>> viewOrgMap = AccSysUtil.getViewOrgMap();
        Set<Long> orgSet = viewOrgMap.get(view);
        if (orgSet != null) {
            orgViewSet.addAll(orgSet);
        }
        List<Long> permOrgList = AccSysUtil.getAcctOrgPkList(formId, false, PermissonType.VIEW);
        childOrgList.retainAll(orgViewSet);
        childOrgList.retainAll(permOrgList);
        return childOrgList;
    }

    public static Set<Long> getChildOrgId(String ovType, Long iOrgViewId, Set<Long> parentList, boolean includeParentSelf) {
        HashSet<Long> result = new HashSet<Long>();
        if (parentList == null || parentList.size() == 0) {
            return result;
        }
        if (includeParentSelf) {
            result.addAll(parentList);
        }
        QFilter treeTypeFilter = new QFilter("view.treetype", "=", (Object)ovType);
        QFilter mainViewFilter = new QFilter("view", "=", (Object)iOrgViewId);
        try (DataSet orgDataSet = QueryServiceHelper.queryDataSet((String)"GLUtil.getParentOrgId", (String)"bos_org_structure", (String)"org,parent", (QFilter[])new QFilter[]{treeTypeFilter, mainViewFilter}, null);){
            AccSysUtil.getChildOrgIdHelper(parentList, result, orgDataSet);
        }
        return result;
    }

    private static void getChildOrgIdHelper(Set<Long> parentList, Set<Long> result, DataSet orgDataSet) {
        HashSet<Long> childOrgId = new HashSet<Long>();
        String parentStr = parentList.toString().replace("[", "(").replace("]", ")");
        try (DataSet childOrgSet = orgDataSet.copy().filter("parent in " + parentStr);){
            for (Row row : childOrgSet) {
                Long org = row.getLong("org");
                if (org == null || org == 0L) continue;
                childOrgId.add(org);
            }
            if (childOrgId.size() > 0) {
                result.addAll(childOrgId);
                AccSysUtil.getChildOrgIdHelper(childOrgId, result, orgDataSet);
            }
        }
    }

    private static Map<Long, Set<Long>> getMainViewOrgMap() {
        Map<Long, Map<Long, List<Long>>> viewOrgBTMap = AccSysUtil.getMainViewOrgBTMap();
        HashMap<Long, Set<Long>> viewOrgMap = new HashMap<Long, Set<Long>>(viewOrgBTMap.size());
        for (Map.Entry<Long, Map<Long, List<Long>>> entry : viewOrgBTMap.entrySet()) {
            HashSet<Long> orgSet = new HashSet<Long>(entry.getValue().keySet());
            viewOrgMap.put(entry.getKey(), orgSet);
        }
        return viewOrgMap;
    }

    private static Map<Long, Set<Long>> getStatViewOrgMap() {
        Map<Long, Map<Long, List<Long>>> viewOrgBTMap = AccSysUtil.getStatViewOrgBTMap();
        HashMap<Long, Set<Long>> viewOrgMap = new HashMap<Long, Set<Long>>(viewOrgBTMap.size());
        for (Map.Entry<Long, Map<Long, List<Long>>> entry : viewOrgBTMap.entrySet()) {
            HashSet<Long> orgSet = new HashSet<Long>(entry.getValue().keySet());
            viewOrgMap.put(entry.getKey(), orgSet);
        }
        return viewOrgMap;
    }

    private static Map<Long, Map<Long, List<Long>>> getMainViewOrgBTMap() {
        return AccSysUtil.getViewOrgBTMapHelper(true);
    }

    private static Map<Long, Map<Long, List<Long>>> getStatViewOrgBTMap() {
        return AccSysUtil.getViewOrgBTMapHelper(false);
    }

    private static Map<Long, Map<Long, List<Long>>> getViewOrgBTMapHelper(boolean isMainView) {
        DistributeCache cache = CacheHelper.getDistributeCache((kd.fi.bd.cache.CacheModule)kd.fi.bd.cache.CacheModule.accSys);
        String str = cache.get(isMainView ? "accsys-mainvieworgbooktype-cache" : "accsys-statvieworgbooktype-cache");
        if (str != null) {
            Map map = (Map)ICTUtils.fromSerializedString(str);
            return map;
        }
        HashMap<Long, Map<Long, List<Long>>> result = new HashMap<Long, Map<Long, List<Long>>>();
        QFilter[] bookQF = new QFilter[]{new QFilter("isbizunit", "=", (Object)"1")};
        QFilter[] viewQF = new QFilter[]{new QFilter("ismainview", "=", (Object)isMainView)};
        try (DataSet bookDataSet = QueryServiceHelper.queryDataSet((String)(AccSysUtil.class.getName() + ".getMainViewOrgBTMap#getBook"), (String)"gl_accountbook", (String)"bookstype,org,accountingsys", (QFilter[])bookQF, null);
             DataSet viewDataSet = QueryServiceHelper.queryDataSet((String)(AccSysUtil.class.getName() + ".getMainViewOrgBTMap#getView"), (String)"bd_accountingsysviewsch", (String)"id,accountingsys", (QFilter[])viewQF, null);
             DataSet finish = bookDataSet.join(viewDataSet, JoinType.INNER).on("accountingsys", "accountingsys").select(new String[]{"bookstype", "org"}, new String[]{"id"}).finish();){
            for (Row row : finish) {
                Map orgBookTypeMap;
                long mainView = row.getLong("id");
                long org = row.getLong("org");
                long bookType = row.getLong("bookstype");
                if (result.containsKey(mainView)) {
                    List<Long> bookTypeList;
                    orgBookTypeMap = (Map)result.get(mainView);
                    if (orgBookTypeMap.containsKey(org)) {
                        bookTypeList = (List)orgBookTypeMap.get(org);
                        bookTypeList.add(bookType);
                        orgBookTypeMap.put(org, bookTypeList);
                        result.put(mainView, orgBookTypeMap);
                        continue;
                    }
                    bookTypeList = new ArrayList<Long>();
                    bookTypeList.add(bookType);
                    orgBookTypeMap.put(org, bookTypeList);
                    result.put(mainView, orgBookTypeMap);
                    continue;
                }
                orgBookTypeMap = new HashMap();
                ArrayList<Long> bookTypes = new ArrayList<Long>();
                bookTypes.add(bookType);
                orgBookTypeMap.put(org, bookTypes);
                result.put(mainView, orgBookTypeMap);
            }
        }
        CacheHelper.getDistributeCache((kd.fi.bd.cache.CacheModule)kd.fi.bd.cache.CacheModule.accSys).put(isMainView ? "accsys-mainvieworgbooktype-cache" : "accsys-statvieworgbooktype-cache", ICTUtils.toSerializedString(result));
        return result;
    }

    private static List<Long> getParentOrgId(DataSet orgDataSet, Set<Long> childList, boolean includeChildSelf) {
        LinkedList<Long> result = new LinkedList<Long>();
        if (childList == null || childList.isEmpty()) {
            return result;
        }
        AccSysUtil.getParentOrgIdHelper(childList, result, orgDataSet);
        if (includeChildSelf) {
            result.addAll(childList);
        }
        return result;
    }

    private static void getParentOrgIdHelper(Set<Long> childList, LinkedList<Long> result, DataSet orgDataSet) {
        LinkedHashSet<Long> parentOrgId = new LinkedHashSet<Long>();
        if (Objects.isNull(childList)) {
            childList = new HashSet<Long>(0);
        }
        HashMap<String, Set<Long>> params = new HashMap<String, Set<Long>>(1);
        params.put("var1", childList);
        try (DataSet parentOrgSet = orgDataSet.copy().filter("org in var1", params);){
            for (Row row : parentOrgSet) {
                Long parent = row.getLong("parent");
                if (parent == null || parent == 0L) continue;
                parentOrgId.add(parent);
            }
            if (parentOrgId.size() > 0) {
                for (Long pid : parentOrgId) {
                    if (result.contains(pid)) continue;
                    result.addFirst(pid);
                }
                AccSysUtil.getParentOrgIdHelper(parentOrgId, result, orgDataSet);
            }
        }
    }

    public static Long getDefaultAcctOrg(List<Long> orgPkList) {
        Long curLoginOrg = RequestContext.get().getOrgId();
        if (orgPkList.contains(curLoginOrg)) {
            return curLoginOrg;
        }
        if (!orgPkList.isEmpty()) {
            return orgPkList.get(0);
        }
        return null;
    }

    public static long getOffSetOrg(long orgId, long opOrgId, long accsysId) {
        ArrayList<Long> orgs = new ArrayList<Long>();
        orgs.add(orgId);
        orgs.add(opOrgId);
        long parentId = AccSysUtil.getParentOrgByChildre(orgs, accsysId);
        QFilter fmergeOrg = new QFilter("merge", "=", (Object)parentId);
        return 0L;
    }

    public static long getParentOrgByChildre(List<Long> filterOrgs, long accsysId) {
        if (filterOrgs == null || filterOrgs.isEmpty()) {
            return 0L;
        }
        if (filterOrgs.size() == 1) {
            return filterOrgs.get(0);
        }
        QFilter[] filters = new QFilter[]{new QFilter("accountingsys", "=", (Object)accsysId), new QFilter("ismainview", "=", (Object)"1")};
        DynamicObject obj = QueryServiceHelper.queryOne((String)"bd_accountingsysviewsch", (String)"id", (QFilter[])filters);
        try (DataSet orgDataSet = QueryServiceHelper.queryDataSet((String)(AccSysUtil.class.getName() + ".getParentOrg"), (String)"bos_org_structure", (String)"org,parent", (QFilter[])new QFilter[]{new QFilter("view", "=", (Object)obj.getLong("id"))}, null);){
            Map<Long, Set<Long>> orgTreeMap = AccSysUtil.getOrgTreeMap(orgDataSet);
            Set<Long> topOrgs = orgTreeMap.get(0L);
            if (topOrgs.size() == 0) {
                long l = 0L;
                return l;
            }
            HashMap<Long, Tuple2<Integer, Integer>> orgTagMap = new HashMap<Long, Tuple2<Integer, Integer>>();
            Long topOrg = topOrgs.iterator().next();
            int[] cnt = new int[]{0};
            AccSysUtil.explore(orgTreeMap, topOrg, orgTagMap, cnt);
            Tuple2<Integer, Integer> range = AccSysUtil.getRange(filterOrgs, orgTagMap);
            if (range == null) {
                long l = topOrg;
                return l;
            }
            List collect = orgTagMap.entrySet().stream().filter(e -> (Integer)((Tuple2)e.getValue()).t1 <= (Integer)range.t1 && (Integer)((Tuple2)e.getValue()).t2 >= (Integer)range.t2).sorted(Comparator.comparing(o -> (Integer)((Tuple2)o.getValue()).t2)).collect(Collectors.toList());
            long l = (Long)((Map.Entry)collect.get(0)).getKey();
            return l;
        }
    }

    private static Tuple2<Integer, Integer> getRange(List<Long> filterOrgs, Map<Long, Tuple2<Integer, Integer>> orgTagMap) {
        Set collect = orgTagMap.entrySet().stream().filter(e -> filterOrgs.contains(e.getKey())).map(Map.Entry::getValue).collect(Collectors.toSet());
        Optional<Integer> min = collect.stream().map(x -> (Integer)x.t1).min(Integer::compareTo);
        Optional<Integer> max = collect.stream().map(x -> (Integer)x.t2).max(Integer::compareTo);
        return min.map(integer -> new Tuple2(integer, max.get())).orElse(null);
    }

    private static void explore(Map<Long, Set<Long>> orgTreeMap, Long org, Map<Long, Tuple2<Integer, Integer>> orgTagMap, int[] cnt) {
        orgTagMap.put(org, (Tuple2<Integer, Integer>)new Tuple2((Object)0, (Object)0));
        AccSysUtil.preVisit(org, orgTagMap, cnt);
        for (Long leafOrg : orgTreeMap.get(org)) {
            if (orgTagMap.get(leafOrg) != null) continue;
            AccSysUtil.explore(orgTreeMap, leafOrg, orgTagMap, cnt);
        }
        AccSysUtil.postVisit(org, orgTagMap, cnt);
    }

    private static void postVisit(Long org, Map<Long, Tuple2<Integer, Integer>> orgTagMap, int[] cnt) {
        Tuple2<Integer, Integer> old = orgTagMap.get(org);
        int n = cnt[0];
        cnt[0] = n + 1;
        orgTagMap.put(org, (Tuple2<Integer, Integer>)new Tuple2(old.t1, (Object)n));
    }

    private static void preVisit(Long org, Map<Long, Tuple2<Integer, Integer>> orgTagMap, int[] cnt) {
        int n = cnt[0];
        cnt[0] = n + 1;
        orgTagMap.put(org, (Tuple2<Integer, Integer>)new Tuple2((Object)n, (Object)0));
    }

    private static Map<Long, Set<Long>> getOrgTreeMap(DataSet orgDataSet) {
        HashMap<Long, Set<Long>> result = new HashMap<Long, Set<Long>>();
        for (Row row : orgDataSet) {
            Long org = row.getLong("org");
            Long parent = row.getLong("parent");
            result.putIfAbsent(org, new HashSet());
            result.compute(parent, (k, v) -> {
                if (v == null) {
                    HashSet<Long> leaf = new HashSet<Long>();
                    leaf.add(org);
                    return leaf;
                }
                v.add(org);
                return v;
            });
        }
        return result;
    }

    public static long getCurPeriodAccountTableId(long orgId, long bookTypeId, long periodId) {
        return AccountRefUtils.getCurPeriodAccountTableId((long)orgId, (long)bookTypeId, (long)periodId);
    }
}

