/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.accsys;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public final class AccountBookInfo
implements Serializable {
    private static final long serialVersionUID = -451463358628060096L;
    private long id;
    private long org;
    private String orgName;
    private long bookstype;
    private long basecurrency;
    private long periodtype;
    private long startperiod;
    private long curperiod;
    private long exratetable;
    private long accounttable;
    private long cashinitperiod;
    private long accountingsys;
    private boolean isendinit;
    private String enable;
    private boolean isbizunit;
    private Date curperiodEndDate;
    private static final String sqlSelectField = "org,bookstype,basecurrency,periodtype,startperiod,curperiod,curperiod.enddate,exratetable,accounttable,cashinitperiod,isendinit,enable,isbizunit,accountingsys";

    public static AccountBookInfo of(long bookId) {
        return new AccountBookInfo(bookId);
    }

    public static AccountBookInfo of(long orgId, long bookTypeId) {
        return new AccountBookInfo(orgId, bookTypeId);
    }

    public static List<AccountBookInfo> of(Set<Long> orgIds, long bookTypeId) {
        ArrayList<AccountBookInfo> bookInfoList = new ArrayList<AccountBookInfo>(orgIds.size());
        orgIds.forEach(v -> {
            AccountBookInfo bookInfo = AccountBookInfo.of(v, bookTypeId);
            if (bookInfo.getId() > 0L) {
                bookInfoList.add(bookInfo);
            }
        });
        return bookInfoList;
    }

    public AccountBookInfo(long bookId) {
        DynamicObject accountBook = BusinessDataServiceHelper.loadSingle((Object)bookId, (String)"gl_accountbook", (String)sqlSelectField);
        this.createAccountBookInfo(accountBook);
    }

    public AccountBookInfo(Long orgId, Long bookTypeId) {
        QFilter orgF = new QFilter("org", "=", (Object)orgId);
        QFilter bookTypeF = new QFilter("bookstype", "=", (Object)bookTypeId);
        DynamicObject accountBook = BusinessDataServiceHelper.loadSingleFromCache((String)"gl_accountbook", (String)sqlSelectField, (QFilter[])new QFilter[]{orgF, bookTypeF});
        this.createAccountBookInfo(accountBook);
    }

    private void createAccountBookInfo(DynamicObject accountBook) {
        if (Objects.nonNull(accountBook)) {
            this.id = accountBook.getLong("id");
            this.org = accountBook.getLong("org.id");
            this.orgName = accountBook.getString("org.name");
            this.bookstype = accountBook.getLong("bookstype.id");
            this.accounttable = accountBook.getLong("accounttable.id");
            this.basecurrency = accountBook.getLong("basecurrency.id");
            this.periodtype = accountBook.getLong("periodtype.id");
            this.startperiod = accountBook.getLong("startperiod.id");
            this.curperiod = accountBook.getLong("curperiod.id");
            this.curperiodEndDate = accountBook.getDate("curperiod.enddate");
            this.exratetable = accountBook.getLong("exratetable.id");
            this.cashinitperiod = accountBook.getLong("cashinitperiod.id");
            this.accountingsys = accountBook.getLong("accountingsys.id");
            this.isendinit = accountBook.getBoolean("isendinit");
            this.isbizunit = accountBook.getBoolean("isbizunit");
            this.enable = accountBook.getString("enable");
        }
    }

    public long getId() {
        return this.id;
    }

    public long getOrgId() {
        return this.org;
    }

    public String getOrgName() {
        return this.orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public long getBookTypeId() {
        return this.bookstype;
    }

    public long getBaseCurrencyId() {
        return this.basecurrency;
    }

    public long getPeriodTypeId() {
        return this.periodtype;
    }

    public long getStartPeriodId() {
        return this.startperiod;
    }

    public long getCurPeriodId() {
        return this.curperiod;
    }

    public long getExrateTableId() {
        return this.exratetable;
    }

    public long getAccountTableId() {
        return this.accounttable;
    }

    public long getCashinitPeriodId() {
        return this.cashinitperiod;
    }

    public long getAccountingsysId() {
        return this.accountingsys;
    }

    public boolean isIsendinit() {
        return this.isendinit;
    }

    public String getEnable() {
        return this.enable;
    }

    public boolean isIsbizunit() {
        return this.isbizunit;
    }

    public Date getCurperiodEndDate() {
        return this.curperiodEndDate;
    }

    public void setCurperiodEndDate(Date curperiodEndDate) {
        this.curperiodEndDate = curperiodEndDate;
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    public boolean equals(Object obj) {
        if (obj instanceof AccountBookInfo) {
            return this.id == ((AccountBookInfo)obj).getId();
        }
        return false;
    }

    public String toString() {
        return "id:" + this.id + ";org:" + this.org + ";bookstype:" + this.bookstype + ";basecurrency:" + this.basecurrency + ";periodtype:" + this.periodtype + ";startperiod:" + this.startperiod + ";curperiod:" + this.curperiod + ";accounttable:" + this.accounttable + ";exratetable:" + this.exratetable + ";cashinitperiod:" + this.cashinitperiod + ";isendinit:" + this.isendinit + ";enable:" + this.enable;
    }
}

