/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.common;

import java.text.NumberFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.ext.fi.util.DateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class GenBillNoHelper {
    public static Map<Long, String> getOrgIdByNumber(List<Long> orgIds) {
        HashMap<Long, String> orgIdByOrgNumber = new HashMap<Long, String>(0);
        orgIds.forEach(v -> {
            String orgNumber = GenBillNoHelper.genBillNo(v);
            orgIdByOrgNumber.put((Long)v, orgNumber);
        });
        return orgIdByOrgNumber;
    }

    public static String genCrossNumber(Long orgId, String dateStr, String crossType, String seq) {
        return GenBillNoHelper.genBillNo(orgId) + dateStr + crossType + seq;
    }

    public static String genBillNo(Long orgId) {
        DynamicObject bosOrg = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bos_org");
        return bosOrg.getString("number");
    }

    public static String[] genNumbers(int size) {
        int len = String.valueOf(size).length();
        String[] strs = new String[size];
        for (int i = 0; i < size; ++i) {
            strs[i] = GenBillNoHelper.generateSerival(len, i + 1);
        }
        return strs;
    }

    public static String generateSerival(int length, int number) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setGroupingUsed(false);
        nf.setMinimumIntegerDigits(length);
        return nf.format(number);
    }

    public static String toFormatDate() {
        return DateUtils.formatString((Date)new Date(), (String)"yyyyMMddhhmmss");
    }
}

