/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.enums;

import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;

public enum TransactionType {
    BOND_DEBT("1"),
    INTERNAL_CONTACTS("2"),
    PROFIT_AND_LOSS("3"),
    CASH_FLOW("4");

    private String type;

    private TransactionType(String type) {
        this.type = type;
    }

    public String getTransactionType() {
        return this.type;
    }

    public static TransactionType getTransactionTypeByDynamicObjectType(DynamicObject dynObj) {
        return Arrays.asList("ict_relcfrecord", "ict_check_cash_record").contains(dynObj.getDataEntityType().getName()) ? CASH_FLOW : BOND_DEBT;
    }

    public static List<String> TransactionTypeByAccount() {
        return Arrays.asList(BOND_DEBT.getTransactionType(), INTERNAL_CONTACTS.getTransactionType(), PROFIT_AND_LOSS.getTransactionType());
    }
}

