/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.format;

import java.math.BigDecimal;
import java.text.Format;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.fi.ict.util.ContextUtil;

public class UserFormatter {
    private final FormatObject formatObject;

    public UserFormatter() {
        this(ContextUtil.getUserId());
    }

    public UserFormatter(long userId) {
        this.formatObject = InteServiceHelper.getUserFormat((Long)userId);
    }

    public String formatAmount(BigDecimal amount, String currencySign, int amtprecision) {
        this.formatObject.getCurrencyFormat().setMinimumFractionDigits(amtprecision);
        this.formatObject.getCurrencyFormat().setCurrencySymbols(currencySign);
        Format format = FormatFactory.get((FormatTypes)FormatTypes.Currency).getFormat(this.formatObject);
        return format.format(amount);
    }

    public String formatNumber(BigDecimal number) {
        Format format = FormatFactory.get((FormatTypes)FormatTypes.Number).getFormat(this.formatObject);
        return format.format(number);
    }

    public String toStringInt(BigDecimal number) {
        this.formatObject.getCurrencyFormat().setMinimumFractionDigits(0);
        this.formatObject.getCurrencyFormat().setCurrencySymbols("");
        Format format = FormatFactory.get((FormatTypes)FormatTypes.Currency).getFormat(this.formatObject);
        return format.format(number);
    }
}

