/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.lock;

import java.util.Arrays;
import kd.bos.dataentity.entity.DynamicObject;
import kd.fi.ict.enums.TransactionType;
import kd.fi.ict.enums.VerifyType;

public enum LockKey {
    AccountRec,
    CfItemRec,
    AcctPuchAmtRe,
    CfPuchAmtRe;


    public static LockKey getLockKeyByTransactionType(String transactionType) {
        return TransactionType.CASH_FLOW.getTransactionType().equals(transactionType) ? CfItemRec : AccountRec;
    }

    public static LockKey getLockKeyByDynamicObjectType(DynamicObject dynObj) {
        return Arrays.asList("ict_relcfrecord", "ict_check_cash_record").contains(dynObj.getDataEntityType().getName()) ? CfItemRec : AccountRec;
    }

    public static LockKey getLockKeyByVerifyType(VerifyType verifyType) {
        return VerifyType.ACCT == verifyType ? AccountRec : CfItemRec;
    }
}

