/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.lock;

import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.mutex.ShareLock;
import kd.fi.ict.lock.LockHandler;
import kd.fi.ict.lock.LockKey;

public class ShareLockHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean requireLock(String key, boolean isShare, LockHandler handler) {
        ShareLock shareLock = ShareLock.create();
        try {
            boolean lock = shareLock.requireLock(key, isShare);
            if (lock) {
                try (TXHandle h = TX.required((String)("fi_ict_" + key));){
                    try {
                        handler.handle();
                    }
                    catch (Exception e) {
                        h.markRollback();
                        String msg = ResManager.loadKDString((String)"\u7a0b\u5e8f\u5f02\u5e38\u9000\u51fa", (String)"ShareLockHelper_0", (String)"fi-ict-common", (Object[])new Object[0]);
                        throw new KDException((Throwable)e, ErrorCode.of((String)msg, (String)"ict", (String)"autocheck", (String)msg), new Object[]{String.format("Error:%s", e.getMessage())});
                    }
                }
            }
            boolean bl = lock;
            return bl;
        }
        finally {
            shareLock.release();
        }
    }

    public static boolean requireLockNotRelease(String key, boolean isShare, LockHandler handler) {
        ShareLock shareLock = ShareLock.create();
        boolean lock = shareLock.requireLock(key, isShare);
        if (lock) {
            try (TXHandle h = TX.required((String)("fi_ict_" + key));){
                try {
                    handler.handle();
                }
                catch (Exception e) {
                    h.markRollback();
                    throw e;
                }
            }
        }
        return lock;
    }

    public static boolean tryLockNotRelease(String key, LockHandler handler) {
        return ShareLockHelper.requireLockNotRelease(key, false, handler);
    }

    public static boolean tryLock(long orgId, long oporgId, long schemeId, long currency, LockKey lockKey, LockHandler handler) {
        String reconcKey = orgId >= oporgId ? oporgId + "-" + orgId + "-" + schemeId + "-" + currency : orgId + "-" + oporgId + "-" + schemeId + "-" + currency;
        String key = "fi/ict/" + (Object)((Object)lockKey) + "/" + reconcKey;
        return ShareLockHelper.requireLock(key, false, handler);
    }

    public static boolean tryLock(long orgId, LockKey lockKey, LockHandler handler) {
        String reconcKey = orgId + "";
        String key = "fi/ict/" + (Object)((Object)lockKey) + "/" + reconcKey;
        return ShareLockHelper.requireLock(key, false, handler);
    }
}

