/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.bd.util.AccountUtils;
import kd.fi.bd.util.CashflowItemVersionUtil;
import kd.fi.ict.enums.KDBoolean;
import kd.fi.ict.util.QFBuilder;

public class AccountServiceHelper {
    private static final QFilter LEAF_FILTER = new QFilter("isleaf", "=", (Object)KDBoolean.TRUE.getValue());

    private AccountServiceHelper() {
    }

    public static DataSet getAccountDataSet(long orgId, long accountTableId, Date date, boolean isOnlyLeaf, QFilter customFilter, String ... fields) {
        QFBuilder qfBuilder = AccountServiceHelper.getAccountFilter(orgId, accountTableId, date, isOnlyLeaf, customFilter);
        if (Objects.isNull(fields) || fields.length == 0) {
            fields = new String[]{"id"};
        }
        return QueryServiceHelper.queryDataSet((String)AccountServiceHelper.class.getName(), (String)"bd_accountview", (String)String.join((CharSequence)",", fields), (QFilter[])qfBuilder.toArray(), (String)"id");
    }

    public static QFBuilder getAccountFilter(long orgId, long accountTableId, boolean isOnlyLeaf, QFilter customFilter) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("accounttable", "=", accountTableId);
        qfBuilder.add("enable", "=", KDBoolean.TRUE.getValue());
        if (!Objects.isNull(customFilter)) {
            qfBuilder.add(customFilter);
        }
        if (isOnlyLeaf) {
            qfBuilder.add(LEAF_FILTER);
        }
        qfBuilder.add(AccountServiceHelper.getBaseDataFilter(orgId));
        return qfBuilder;
    }

    public static List<Long> getAllLeafAccountIds(long orgId, long accountTableId, List<Long> masterIds) {
        return AccountServiceHelper.getAllLeafAccounts(orgId, accountTableId, masterIds, "id");
    }

    public static List<Long> getAllLeafAccountMasterIds(long orgId, long accountTableId, List<Long> masterIds) {
        return AccountServiceHelper.getAllLeafAccounts(orgId, accountTableId, masterIds, "masterid");
    }

    private static List<Long> getAllLeafAccounts(long orgId, long accountTableId, List<Long> masterIds, String idField) {
        ArrayList<Long> result = new ArrayList<Long>(masterIds.size());
        QFBuilder accountFilter = AccountServiceHelper.getAccountFilter(orgId, accountTableId, false, new QFilter("masterid", "in", masterIds));
        Collection accounts = BusinessDataServiceHelper.loadFromCache((String)"bd_accountview", (String)String.join((CharSequence)",", "number", "isleaf", idField), (QFilter[])accountFilter.toArray()).values();
        HashSet<String> parentNumbers = new HashSet<String>(masterIds.size());
        for (DynamicObject account : accounts) {
            if (account.getBoolean("isleaf")) {
                result.add(account.getLong(idField));
                continue;
            }
            parentNumbers.add(account.getString("number"));
        }
        if (!parentNumbers.isEmpty()) {
            result.addAll(AccountServiceHelper.getLeafAccounts(parentNumbers, orgId, accountTableId, idField));
        }
        return result;
    }

    private static List<Long> getLeafAccounts(Set<String> parentNumbers, long orgId, long accountTableId, String idField) {
        ArrayList<Long> result = new ArrayList<Long>(parentNumbers.size());
        QFBuilder accountFilter = AccountServiceHelper.getAccountFilter(orgId, accountTableId, false, new QFilter(String.join((CharSequence)".", "parent", "number"), "in", parentNumbers));
        Collection accounts = BusinessDataServiceHelper.loadFromCache((String)"bd_accountview", (String)String.join((CharSequence)",", "number", "isleaf", idField), (QFilter[])accountFilter.toArray()).values();
        parentNumbers.clear();
        for (DynamicObject account : accounts) {
            if (account.getBoolean("isleaf")) {
                result.add(account.getLong(idField));
                continue;
            }
            parentNumbers.add(account.getString("number"));
        }
        if (!parentNumbers.isEmpty()) {
            result.addAll(AccountServiceHelper.getLeafAccounts(parentNumbers, orgId, accountTableId, idField));
        }
        return result;
    }

    public static QFilter getBaseDataFilter(long orgId) {
        return (QFilter)ThreadCache.get((Object)(AccountServiceHelper.class.getName() + "_getBaseDataFilter" + orgId), () -> BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)orgId));
    }

    public static QFBuilder getAccountFilter(long orgId, long accountTableId, Date date, boolean isOnlyLeaf, QFilter customFilter) {
        QFBuilder qfBuilder = AccountServiceHelper.getAccountFilter(orgId, accountTableId, isOnlyLeaf, customFilter);
        if (Objects.isNull(date)) {
            qfBuilder.add("enddate", "=", AccountServiceHelper.getEndDate());
        } else {
            qfBuilder.add("startdate", "<=", date);
            qfBuilder.add("enddate", ">", date);
        }
        return qfBuilder;
    }

    public static QFBuilder getInterAccountFilter(long orgId, long accountTableId, boolean isOnlyLeaf) {
        return AccountServiceHelper.getAccountFilter(orgId, accountTableId, null, isOnlyLeaf, null);
    }

    public static QFBuilder getInterCashItemFilter(long orgId, boolean isOnlyLeaf) {
        return AccountServiceHelper.getInterCashItemFilter(orgId, null, isOnlyLeaf);
    }

    public static QFBuilder getInterCashItemFilter(long orgId, Date date, boolean isOnlyLeaf) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", (Long)orgId));
        if (isOnlyLeaf) {
            qfBuilder.add(LEAF_FILTER);
        }
        if (Objects.isNull(date)) {
            qfBuilder.add("enddate", "=", CashflowItemVersionUtil.getEndDate());
        } else {
            qfBuilder.add("startdate", "<=", date);
            qfBuilder.add("enddate", ">", date);
        }
        return qfBuilder;
    }

    public static Set<Long> getAcctIdByMasterId(long orgId, Long masterId) {
        return AccountServiceHelper.getDateIdByMasterId(orgId, masterId, "bd_accountview");
    }

    public static Set<Long> getTreeAllIdsByAcctId(long orgId, long acctId, boolean isinClude) {
        HashSet<Long> Ids = new HashSet<Long>(10);
        Ids.addAll(AccountServiceHelper.getParentIdsByAcctId(orgId, acctId, isinClude));
        Ids.addAll(AccountServiceHelper.getChildrenIdsByAcctNumber(orgId, acctId, isinClude, false));
        return Ids;
    }

    public static Set<String> getAcctAllChildNumbersByLongNumbers(long orgId, long accountTableId, Set<String> longNoumbers) {
        QFilter filter = new QFilter("accounttable", "=", (Object)accountTableId);
        filter.and(AccountUtils.getAccountDataFilter((long)orgId, (long)accountTableId));
        filter.and("enddate", "=", (Object)AccountServiceHelper.getEndDate());
        QFilter longNumbuuerFilter = null;
        for (String longNumber : longNoumbers) {
            QFilter qFilter = new QFilter("longnumber", "like", (Object)(longNumber + "%"));
            if (Objects.isNull(longNumbuuerFilter)) {
                longNumbuuerFilter = qFilter;
                continue;
            }
            longNumbuuerFilter.or(qFilter);
        }
        if (Objects.nonNull(longNumbuuerFilter)) {
            filter.and(longNumbuuerFilter);
        }
        DynamicObjectCollection dynColl = QueryServiceHelper.query((String)AccountServiceHelper.class.getName(), (String)"bd_accountview", (String)"number", (QFilter[])filter.toArray(), null);
        HashSet<String> numbers = new HashSet<String>(10);
        dynColl.forEach(v -> numbers.add(v.getString("number")));
        return numbers;
    }

    public static Set<String> getCfAllChildNumbersByLongNumbers(long orgId, Set<String> longNoumbers) {
        QFilter filter = BaseDataServiceHelper.getBaseDataFilter((String)"gl_cashflowitem", (Long)orgId);
        filter.and(new QFilter("enddate", "=", (Object)AccountServiceHelper.getEndDate()));
        QFilter longNumberFilter = null;
        for (String longNumber : longNoumbers) {
            QFilter qFilter = new QFilter("longnumber", "like", (Object)(longNumber + "%"));
            if (Objects.isNull(longNumberFilter)) {
                longNumberFilter = qFilter;
                continue;
            }
            longNumberFilter.or(qFilter);
        }
        if (Objects.nonNull(longNumberFilter)) {
            filter.and(longNumberFilter);
        }
        DynamicObjectCollection dynColl = QueryServiceHelper.query((String)AccountServiceHelper.class.getName(), (String)"gl_cashflowitem", (String)"number", (QFilter[])filter.toArray(), null);
        HashSet<String> numbers = new HashSet<String>(10);
        dynColl.forEach(v -> numbers.add(v.getString("number")));
        return numbers;
    }

    public static Set<Long> getParentIdsByAcctId(long orgId, long acctId, boolean isinClude) {
        HashSet<Long> Ids = new HashSet<Long>(10);
        ORM orm = ORM.create();
        QFilter filter = new QFilter("id", "=", (Object)acctId);
        filter.and("enddate", "=", (Object)AccountServiceHelper.getEndDate());
        try (DataSet ds = orm.queryDataSet("getParentIdsByAcctId", "bd_accountview", "id,parent", filter.toArray());){
            while (ds.hasNext()) {
                Row next = ds.next();
                if (next.getLong("parent") == 0L) continue;
                Ids.add(next.getLong("parent"));
                Ids.addAll(AccountServiceHelper.getParentIdsByAcctId(orgId, next.getLong("parent"), isinClude));
            }
        }
        if (isinClude) {
            Ids.add(acctId);
        }
        return Ids;
    }

    public static Set<Long> getChildrenIdsByAcctId(long orgId, long acctId, boolean isinClude, boolean isOnlyLeaf) {
        HashSet<Long> Ids = new HashSet<Long>(10);
        ORM orm = ORM.create();
        QFilter filter = new QFilter("parent", "=", (Object)acctId);
        filter.and("enddate", "=", (Object)AccountServiceHelper.getEndDate());
        try (DataSet ds = orm.queryDataSet("getChildrenIdsByAcctId", "bd_accountview", "id,isleaf", filter.toArray());){
            while (ds.hasNext()) {
                Row next = ds.next();
                Boolean isleaf = next.getBoolean("isleaf");
                if (isOnlyLeaf) {
                    if (isleaf.booleanValue()) {
                        Ids.add(next.getLong("id"));
                    }
                } else {
                    Ids.add(next.getLong("id"));
                }
                if (isleaf.booleanValue()) continue;
                Ids.addAll(AccountServiceHelper.getChildrenIdsByAcctId(orgId, next.getLong("id"), isinClude, isOnlyLeaf));
            }
        }
        if (isinClude) {
            Ids.add(acctId);
        }
        return Ids;
    }

    public static Set<Long> getChildrenIdsByAcctNumber(long orgId, long acctId, boolean isinClude, boolean isOnlyLeaf) {
        return AccountServiceHelper.getChildrenIdsByNumber(acctId, isinClude, "bd_accountview");
    }

    public static Set<Long> getCfIdByMasterId(long orgId, Long masterId) {
        return AccountServiceHelper.getDateIdByMasterId(orgId, masterId, "gl_cashflowitem");
    }

    public static Set<Long> getTreeAllIdsByCfId(long orgId, long cfId, boolean isinClude) {
        HashSet<Long> Ids = new HashSet<Long>(10);
        Ids.addAll(AccountServiceHelper.getParentIdsByCfId(orgId, cfId, isinClude));
        Ids.addAll(AccountServiceHelper.getChildrenIdsByCfId(orgId, cfId, isinClude, false));
        return Ids;
    }

    public static Set<Long> getParentIdsByCfId(long orgId, long cfId, boolean isinClude) {
        HashSet<Long> Ids = new HashSet<Long>(10);
        ORM orm = ORM.create();
        QFilter filter = new QFilter("id", "=", (Object)cfId);
        try (DataSet ds = orm.queryDataSet("getParentIdsByCfId", "gl_cashflowitem", "id,parent", filter.toArray());){
            while (ds.hasNext()) {
                Row next = ds.next();
                if (next.getLong("parent") == 0L) continue;
                Ids.add(next.getLong("parent"));
                Ids.addAll(AccountServiceHelper.getParentIdsByCfId(orgId, next.getLong("parent"), isinClude));
            }
        }
        if (isinClude) {
            Ids.add(cfId);
        }
        return Ids;
    }

    public static Set<Long> getChildrenIdsByCfId(long orgId, long cfId, boolean isinClude, boolean isOnlyLeaf) {
        HashSet<Long> Ids = new HashSet<Long>(10);
        ORM orm = ORM.create();
        QFilter filter = new QFilter("parent", "=", (Object)cfId);
        try (DataSet ds = orm.queryDataSet("getChildrenIdsByCfId", "gl_cashflowitem", "id,isleaf", filter.toArray());){
            while (ds.hasNext()) {
                Row next = ds.next();
                Boolean isleaf = next.getBoolean("isleaf");
                if (isOnlyLeaf) {
                    if (isleaf.booleanValue()) {
                        Ids.add(next.getLong("id"));
                    }
                } else {
                    Ids.add(next.getLong("id"));
                }
                if (isleaf.booleanValue()) continue;
                Ids.addAll(AccountServiceHelper.getChildrenIdsByCfId(orgId, next.getLong("id"), isinClude, isOnlyLeaf));
            }
        }
        if (isinClude) {
            Ids.add(cfId);
        }
        return Ids;
    }

    public static Set<Long> getChildrenIdsByCfItemNumber(long orgId, long cfId, boolean isinClude, boolean isOnlyLeaf) {
        return AccountServiceHelper.getChildrenIdsByNumber(cfId, isinClude, "gl_cashflowitem");
    }

    public static Set<Long> getDateIdByMasterId(long orgId, Long masterId, String formKey) {
        QFilter filter = new QFilter("masterid", "=", (Object)masterId);
        ORM orm = ORM.create();
        DataSet ds = orm.queryDataSet("getParentIdsByCfId", formKey, "id,parent", filter.toArray());
        HashSet<Long> ids = new HashSet<Long>(0);
        while (ds.hasNext()) {
            Row next = ds.next();
            ids.add(next.getLong("id"));
        }
        return ids;
    }

    private static Set<Long> getChildrenIdsByNumber(long itemMasterId, boolean isinClude, String formKey) {
        HashSet<Long> Ids = new HashSet<Long>(10);
        DynamicObject dyn = BusinessDataServiceHelper.loadSingleFromCache((Object)itemMasterId, (String)formKey);
        QFilter filter = new QFilter("longnumber", "like", (Object)(dyn.getString("longnumber") + "%"));
        if ("bd_accountview".equals(formKey)) {
            filter = QFilter.of((String)"accounttable = ?", (Object[])new Object[]{dyn.getLong("accounttable.id")});
            filter.and(new QFilter("longnumber", "like", (Object)(dyn.getString("longnumber") + "%")));
        }
        DynamicObjectCollection dynColl = QueryServiceHelper.query((String)AccountServiceHelper.class.getName(), (String)formKey, (String)"longnumber,id,masterid,isleaf", (QFilter[])filter.toArray(), null);
        HashSet acctIds = new HashSet(dynColl.size());
        dynColl.forEach(v -> acctIds.add(v.getLong("masterid")));
        filter = new QFilter("masterid", "in", acctIds);
        ORM orm = ORM.create();
        try (DataSet ds = orm.queryDataSet(AccountServiceHelper.class.getName(), formKey, "id,masterid,isleaf", filter.toArray());){
            while (ds.hasNext()) {
                Row next = ds.next();
                Boolean isleaf = next.getBoolean("isleaf");
                if (!isleaf.booleanValue()) continue;
                Ids.add(next.getLong("masterid"));
            }
        }
        return Ids;
    }

    public static List<String> getValueSource() {
        return new ArrayList<String>(Arrays.asList("bd_customer", "bd_supplier", "bos_org", "bd_bizpartner"));
    }

    private static Date getEndDate() {
        try {
            SimpleDateFormat dt = new SimpleDateFormat("yyyy-MM-dd");
            return dt.parse("2999-12-31");
        }
        catch (ParseException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u89e3\u6790\u5f02\u5e38", (String)"AccountServiceHelper_0", (String)"fi-ict-common", (Object[])new Object[0]));
        }
    }
}

