/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class DataSetHelper {
    private static final Log LOGGER = LogFactory.getLog(DataSetHelper.class);
    private static boolean isConsolePrint = true;

    public static List<String> getDataSetFileds(DataSet dataSet) {
        if (dataSet == null) {
            return new ArrayList<String>();
        }
        RowMeta rowMeta = dataSet.getRowMeta();
        Field[] fields = rowMeta.getFields();
        ArrayList<String> fieldNames = new ArrayList<String>(fields.length);
        for (Field field : fields) {
            fieldNames.add(field.getAlias());
        }
        return fieldNames;
    }

    public static void printDataSet(DataSet dataSet) {
        DataSetHelper.printDataSet(dataSet, 99999, null);
    }

    public static void printDataSet(DataSet dataSet, Integer maxRows) {
        DataSetHelper.printDataSet(dataSet, maxRows, null);
    }

    public static void printDataSet(DataSet dataSet, List<String> printCols) {
        DataSetHelper.printDataSet(dataSet, 99999, printCols);
    }

    public static void printDataSet(DataSet dataSet, Integer maxRows, List<String> printCols) {
        try (DataSet ds = dataSet.copy();){
            RowMeta rowMeta = ds.getRowMeta();
            Field[] fields = DataSetHelper.getVaildFields(printCols, rowMeta);
            Integer[] colMaxLen = new Integer[fields.length];
            ArrayList<String[]> allData = new ArrayList<String[]>();
            String[] titleData = new String[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                String name;
                titleData[i] = name = fields[i].getName();
                int len = name.length();
                if (len / 4 > 0) {
                    len += 4 - len % 4;
                }
                colMaxLen[i] = len;
            }
            allData.add(titleData);
            int nextIndex = 0;
            while (ds.hasNext() && nextIndex <= maxRows) {
                ++nextIndex;
                Row row = ds.next();
                String[] rowData = new String[fields.length];
                for (int i = 0; i < fields.length; ++i) {
                    String value = String.valueOf(row.get(i)).replace("0E-10", "0");
                    int len = value.length();
                    if (value.length() / 4 > 0) {
                        len = value.length() + (4 - value.length() % 4);
                    }
                    if (len > colMaxLen[i]) {
                        colMaxLen[i] = len;
                    }
                    rowData[i] = value.replace("\r\n", "");
                }
                allData.add(rowData);
            }
            DataSetHelper.printLog("** @ DataSet ResultTable");
            for (String[] allDatum : allData) {
                DataSetHelper.printWarp((String[])allData.get(0), colMaxLen);
                DataSetHelper.printRow(allDatum, colMaxLen);
            }
            DataSetHelper.printWarp((String[])allData.get(0), colMaxLen);
        }
    }

    private static Field[] getVaildFields(List<String> printCols, RowMeta rowMeta) {
        Field[] fields = rowMeta.getFields();
        ArrayList<Field> validFields = new ArrayList<Field>();
        if (Objects.nonNull(printCols) && printCols.size() > 0) {
            for (Field field : fields) {
                String name = field.getName();
                if (!printCols.contains(name)) continue;
                validFields.add(field);
            }
            fields = validFields.toArray(new Field[0]);
        }
        return fields;
    }

    private static void printWarp(String[] rowVal, Integer[] colMaxLen) {
        StringBuilder builder = new StringBuilder("** +");
        for (int i = 0; i < rowVal.length; ++i) {
            int len = colMaxLen[i] % 4 == 0 ? colMaxLen[i] + 4 : colMaxLen[i] + colMaxLen[i] % 4;
            builder.append(new String(new char[len - (i > 0 ? 1 : 0)]).replace('\u0000', '-')).append('+');
        }
        DataSetHelper.printLog(builder.toString());
    }

    private static void printRow(String[] rowVal, Integer[] colMaxLen) {
        StringBuilder format = new StringBuilder("** |");
        for (int i = 0; i < rowVal.length; ++i) {
            int chineseCount = DataSetHelper.getChineseCount(rowVal[i]);
            int len = colMaxLen[i];
            int vallen = rowVal[i].length();
            if (chineseCount > 0) {
                len = DataSetHelper.getLen2(chineseCount, len, vallen, rowVal[i]);
            }
            format.append('%').append(i + 1).append("$-").append(len).append('s').append('\t').append('|');
        }
        DataSetHelper.printLog(format.toString(), rowVal);
    }

    private static int getLen2(int chineseCount, int len, int vallen, String val) {
        if (chineseCount == vallen) {
            return len - Math.max((int)Math.rint((double)chineseCount / 8.0), 1) * 4;
        }
        if (vallen - chineseCount > chineseCount) {
            if (chineseCount % 4 < 2) {
                return len - Math.max((int)Math.rint((double)chineseCount / 8.0), 0) * 4 - 8;
            }
            return len - Math.max((int)Math.rint((double)chineseCount / 8.0), 0) * 4;
        }
        if (chineseCount % 4 < 2) {
            return len - Math.max((int)Math.floor((double)chineseCount / 8.0), 0) * 4;
        }
        return len - Math.max((int)Math.floor((double)chineseCount / 8.0), 0) * 4 - 4;
    }

    private static int getChineseCount(String value) {
        char[] chars;
        int count = 0;
        for (char aChar : chars = value.toCharArray()) {
            if (!DataSetHelper.isChinese(aChar)) continue;
            ++count;
        }
        return count;
    }

    private static boolean isChinese(char c) {
        Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
        return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION;
    }

    private static void printLog(String format, String ... str) {
        if (!isConsolePrint) {
            LOGGER.info("{}", (Object)String.format(format, new Object[]{str}));
        }
    }

    private static void printLog(String str) {
        if (!isConsolePrint) {
            LOGGER.info("{}", (Object)str);
        }
    }

    public void setConsolePrint(boolean consolePrint) {
        isConsolePrint = consolePrint;
    }
}

