/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ict.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.BigDecimalType;
import kd.bos.algo.datatype.BooleanType;
import kd.bos.algo.datatype.IntegerType;
import kd.bos.algo.datatype.LongType;
import kd.bos.algo.datatype.StringType;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.entity.flex.FlexEntireData;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.KDBizException;
import kd.bos.flex.FlexService;
import kd.bos.form.IFormView;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.ict.cache.ThreadCacheKey;

public class ICTUtils {
    private static final Log LOGGER = LogFactory.getLog(ICTUtils.class);
    public static final Long MAX_PERIOD = 99999999999L;
    public static final Long TYPE_PERIOD_L = 100000000L;
    public static final Long YEAR_PERIOD_L = 10000L;
    public static final long MAIN_BOOK_TYPEID = 237528347981256704L;

    public static String toSerializedString(Object obj) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream os = new ObjectOutputStream(out);
            os.writeObject(obj);
            return Base64.getEncoder().encodeToString(out.toByteArray());
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public static Object fromSerializedString(String s) {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(Base64.getDecoder().decode(s));
            ObjectInputStream is = new ObjectInputStream(in);
            return is.readObject();
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public static List<String> getDataSetCols(DataSet ds) {
        RowMeta rowMeta = ds.getRowMeta();
        Field[] fields = rowMeta.getFields();
        ArrayList<String> list = new ArrayList<String>(fields.length);
        for (Field field : fields) {
            list.add(field.getName());
        }
        return list;
    }

    public static DataSet gainSumSet(DataSet ds, String[] groupBy, String[] sumBy) {
        Field[] oldFields = ds.getRowMeta().getFields();
        String[] sel = new String[groupBy.length + sumBy.length];
        System.arraycopy(groupBy, 0, sel, 0, groupBy.length);
        System.arraycopy(sumBy, 0, sel, groupBy.length, sumBy.length);
        GroupbyDataSet groupbyDataSet = ds.select(sel).groupBy(groupBy);
        for (String sum : sumBy) {
            groupbyDataSet.sum(sum);
        }
        DataSet finish = groupbyDataSet.finish();
        finish = ICTUtils.gainSumSetHelper(finish, oldFields);
        return finish;
    }

    public static DataSet gainSumSetHelper(DataSet ds, Field[] oldFields) {
        ArrayList<String> list = new ArrayList<String>();
        List<String> newCols = ICTUtils.getDataSetCols(ds);
        for (Field field : oldFields) {
            String name = field.getName().toLowerCase();
            if (newCols.contains(name)) {
                list.add(name);
                continue;
            }
            DataType dataType = field.getDataType();
            if (dataType instanceof LongType) {
                list.add("0L " + name);
                continue;
            }
            if (dataType instanceof IntegerType) {
                list.add("0 " + name);
                continue;
            }
            if (dataType instanceof BigDecimalType) {
                list.add("0.0 " + name);
                continue;
            }
            if (dataType instanceof StringType) {
                list.add("'' " + name);
                continue;
            }
            if (!(dataType instanceof BooleanType)) continue;
            list.add("false " + name);
        }
        ds = ds.select(list.toArray(new String[0]));
        return ds;
    }

    public static String printError(Throwable t) {
        if (null == t) {
            return null;
        }
        StringBuilder upper = new StringBuilder();
        if (null != t.getCause() && null != t.getCause().getStackTrace()) {
            upper.append(ICTUtils.printError(t.getCause())).append("\n");
        }
        StringWriter sW = new StringWriter();
        try (PrintWriter writer = new PrintWriter(sW);){
            LOGGER.error(t);
            writer.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return upper.append(sW.toString()).toString();
    }

    public static List<Long> getAllSuperiorOrgIds(Object useorgId, boolean isIncludeCurOrg) {
        long orgid = Long.parseLong(String.valueOf(useorgId));
        ArrayList<Long> ids = new ArrayList<Long>();
        String longnumber = "";
        QFilter f2 = new QFilter("view.number", "=", (Object)"10");
        QFilter f3 = new QFilter("org", "=", useorgId);
        String algoKey = "kd.fi.ict.util.ICTUtils.getAllSuperiorOrgIds";
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"bos_org_structure", (String)"longnumber", (QFilter[])new QFilter[]{f2, f3}, (String)"longnumber", (int)1);){
            for (Row row : dataSet) {
                longnumber = row.getString("longnumber");
            }
        }
        if (StringUtils.isNotEmpty((String)longnumber)) {
            ArrayList<String> longnumbers = new ArrayList<String>();
            String[] ls = longnumber.split("!");
            for (int i = 0; i < ls.length; ++i) {
                String pernum = ls[i];
                if (longnumbers.isEmpty()) {
                    longnumbers.add(pernum);
                    continue;
                }
                longnumbers.add((String)longnumbers.get(longnumbers.size() - 1) + "!" + pernum);
            }
            if (longnumbers.size() != 1) {
                QFilter f4 = new QFilter("longnumber", "in", longnumbers);
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"bos_org_structure", (String)"org", (QFilter[])new QFilter[]{f2, f4}, (String)"level");){
                    for (Row row : dataSet) {
                        ids.add(row.getLong("org"));
                    }
                }
            }
        }
        if (isIncludeCurOrg) {
            if (!ids.contains(orgid)) {
                ids.add(orgid);
            }
        } else if (ids.contains(orgid)) {
            Iterator it = ids.iterator();
            while (it.hasNext()) {
                long id = (Long)it.next();
                if (id != orgid) continue;
                it.remove();
            }
        }
        return ids;
    }

    public static Object getSystemParam(String paramName, Long org) {
        String appId = AppMetadataCache.getAppInfo((String)"ict").getId();
        AppParam param = new AppParam(appId, "10", org, Long.valueOf(0L));
        return SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param, (String)paramName);
    }

    public static Long getCustomFilterId(IFormView view, String fieldName) {
        List<Long> list = ICTUtils.getCustomFilterIds(view, fieldName);
        if (list != null && !list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public static List<Long> getCustomFilterIds(IFormView view, String fieldName) {
        IListView listView = (IListView)view;
        ControlFilters c = listView.getControlFilters();
        if (c == null) {
            return null;
        }
        List result = c.getFilter(fieldName);
        ArrayList<Long> ids = new ArrayList<Long>(result.size());
        for (Object v : result) {
            if ("".equals(v.toString())) continue;
            ids.add(Long.parseLong(v.toString()));
        }
        return ids;
    }

    public static FlexEntireData buildFlexEntireData(Map<String, Object> flexFieldValueMap) {
        FlexEntireData flexEntireData = new FlexEntireData();
        ArrayList<FlexEntireData.FlexData> flexDatas = new ArrayList<FlexEntireData.FlexData>();
        for (Map.Entry<String, Object> entry : flexFieldValueMap.entrySet()) {
            String flexField = entry.getKey();
            Object value = entry.getValue();
            FlexEntireData.FlexData flexData = new FlexEntireData.FlexData(flexEntireData);
            if (value instanceof Long) {
                flexData.setDbType(FlexEntireData.FlexFieldDataType.LONG);
            } else if (value instanceof String) {
                flexData.setDbType(FlexEntireData.FlexFieldDataType.STRING);
            }
            flexData.setPropId(flexField);
            flexData.setValue(value);
            if (value == null) continue;
            flexDatas.add(flexData);
        }
        flexEntireData.setFlexDatas(flexDatas);
        return flexEntireData;
    }

    public static void saveNewAssgrpVal(List<FlexEntireData> flexEntireDatas) {
        MainEntityType flexEntityType = new MainEntityType();
        flexEntityType.setAlias("T_GL_ASSIST");
        flexEntityType.setDBRouteKey("gl");
        FlexService.batchSaveFlexData((MainEntityType)flexEntityType, flexEntireDatas);
    }

    public static DynamicObject getPreviousPeriod(Object curPeriodId) {
        if (curPeriodId == null) {
            return null;
        }
        try {
            String entityName = "bd_period";
            String selector = "id,name,periodtype.id periodtype_id,periodyear,periodnumber,begindate,enddate";
            DynamicObject currPeriod = BusinessDataServiceHelper.loadSingle((Object)curPeriodId, (String)"bd_period");
            Object periodtypeid = currPeriod.get("periodtype_id");
            QFilter filterDate = new QFilter("id", "<", curPeriodId);
            QFilter filterType = new QFilter("periodtype.id", "=", periodtypeid);
            DynamicObjectCollection coll = QueryServiceHelper.query((String)entityName, (String)selector, (QFilter[])new QFilter[]{filterDate, filterType}, (String)"id desc", (int)1);
            if (coll == null || coll.isEmpty()) {
                return null;
            }
            return (DynamicObject)coll.get(0);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static List<Long> getPeriodIds(String compare, Long period) {
        if (period == 0L) {
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.add(0L);
            return ids;
        }
        QFilter periodTypeF = new QFilter("periodtype", "=", (Object)(period / TYPE_PERIOD_L));
        QFilter periodFilter = new QFilter("id", compare, (Object)period);
        ArrayList<Long> result = new ArrayList<Long>();
        try (DataSet rs = QueryServiceHelper.queryDataSet((String)"GLUtil.getPeriodIds", (String)"bd_period", (String)"id", (QFilter[])new QFilter[]{periodTypeF, periodFilter}, null);){
            for (Row r : rs) {
                result.add(r.getLong(0));
            }
        }
        if (compare.equalsIgnoreCase("<") || compare.equalsIgnoreCase("<=")) {
            result.add(0L);
        } else if (compare.equalsIgnoreCase(">") || compare.equalsIgnoreCase(">=")) {
            result.add(MAX_PERIOD);
        }
        return result;
    }

    public static Set<Long> getPeriodIdSet(Date beginDate, Date endDate) {
        QFilter beginDateFilter = new QFilter("begindate", ">=", (Object)beginDate);
        QFilter endDateFilter = new QFilter("enddate", "<=", (Object)endDate);
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bd_period", (String)"id", (QFilter[])new QFilter[]{beginDateFilter, endDateFilter});
        HashSet<Long> pdIdSet = new HashSet<Long>();
        for (DynamicObject pd : coll) {
            pdIdSet.add(pd.getLong("id"));
        }
        return pdIdSet;
    }

    public static Set<Long> getChildOrgId(String ovType, Long iOrgViewId, Set<Long> parentList, boolean includeParentSelf) {
        HashSet<Long> result = new HashSet<Long>();
        if (parentList == null || parentList.size() == 0) {
            return result;
        }
        if (includeParentSelf) {
            result.addAll(parentList);
        }
        QFilter treeTypeFilter = new QFilter("view.treetype", "=", (Object)ovType);
        QFilter mainViewFilter = new QFilter("view", "=", (Object)iOrgViewId);
        try (DataSet orgDataSet = QueryServiceHelper.queryDataSet((String)"GLUtil.getParentOrgId", (String)"bos_org_structure", (String)"org,parent", (QFilter[])new QFilter[]{treeTypeFilter, mainViewFilter}, null);){
            ICTUtils.getChildOrgIdHelper(parentList, result, orgDataSet);
        }
        return result;
    }

    public static Set<Long> getChildOrgId(Long parentId, boolean includeParentSelf) {
        HashSet<Long> parentList = new HashSet<Long>(1);
        parentList.add(parentId);
        return ICTUtils.getChildOrgId(parentList, includeParentSelf);
    }

    public static Set<Long> getChildOrgId(Set<Long> parentList, boolean includeParentSelf) {
        HashSet<Long> result = new HashSet<Long>();
        if (parentList == null || parentList.size() == 0) {
            return result;
        }
        if (includeParentSelf) {
            result.addAll(parentList);
        }
        QFilter treeTypeFilter = new QFilter("view.treetype", "=", (Object)"10");
        QFilter mainViewFilter = new QFilter("view.number", "=", (Object)"10");
        try (DataSet orgDataSet = QueryServiceHelper.queryDataSet((String)"GLUtil.getParentOrgId", (String)"bos_org_structure", (String)"org,parent", (QFilter[])new QFilter[]{treeTypeFilter, mainViewFilter}, null);){
            ICTUtils.getChildOrgIdHelper(parentList, result, orgDataSet);
        }
        return result;
    }

    private static void getChildOrgIdHelper(Set<Long> parentList, Set<Long> result, DataSet orgDataSet) {
        HashSet<Long> childOrgId = new HashSet<Long>();
        String parentStr = parentList.toString().replace("[", "(").replace("]", ")");
        try (DataSet childOrgSet = orgDataSet.copy().filter("parent in " + parentStr);){
            for (Row row : childOrgSet) {
                Long org = row.getLong("org");
                if (org == null || org == 0L) continue;
                childOrgId.add(org);
            }
            if (childOrgId.size() > 0) {
                result.addAll(childOrgId);
                ICTUtils.getChildOrgIdHelper(childOrgId, result, orgDataSet);
            }
        }
    }

    public static BigDecimal getExchangeRate(Long exchangeTableID, Long sourceCurrencyID, Long targetCurrencyID, Date date) {
        int precision;
        BigDecimal exchangeRate = null;
        DynamicObject rateObj = ICTUtils.getExchangeRateInfo(exchangeTableID, sourceCurrencyID, targetCurrencyID, date);
        if (null != rateObj) {
            exchangeRate = rateObj.getBigDecimal("excval");
            precision = rateObj.getInt("precision");
            if (precision != 0) {
                exchangeRate = exchangeRate.setScale(precision, 4);
            }
        }
        if (exchangeRate != null) {
            return exchangeRate;
        }
        rateObj = ICTUtils.getExchangeRateInfo(exchangeTableID, targetCurrencyID, sourceCurrencyID, date);
        if (null != rateObj) {
            exchangeRate = rateObj.getBigDecimal("indirectexrate");
            precision = rateObj.getInt("precision");
            if (precision != 0) {
                exchangeRate = exchangeRate.setScale(precision, 4);
            }
        }
        return exchangeRate;
    }

    public static DynamicObject getExchangeRateInfo(Long exchangeTableID, Long sourceCurrencyID, Long targetCurrencyID, Date date) {
        ORM orm = ORM.create();
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        QFilter exchangeTableFilter = new QFilter("exctable", "=", (Object)exchangeTableID);
        filterList.add(exchangeTableFilter);
        QFilter sourceCurrencyFilter = new QFilter("orgcur", "=", (Object)sourceCurrencyID);
        filterList.add(sourceCurrencyFilter);
        QFilter targetCurrencyFilter = new QFilter("cur", "=", (Object)targetCurrencyID);
        filterList.add(targetCurrencyFilter);
        QFilter targetEnableFilter = new QFilter("enable", "=", (Object)"1");
        filterList.add(targetEnableFilter);
        if (date != null) {
            QFilter dateFilter = new QFilter("effectdate", "<=", (Object)date);
            filterList.add(dateFilter);
        }
        String selectFields = "id,excval,indirectexrate,precision";
        String orderBys = "effectdate desc";
        int top = 1;
        QFilter[] filters = new QFilter[filterList.size()];
        for (int i = 0; i < filterList.size(); ++i) {
            filters[i] = (QFilter)filterList.get(i);
        }
        DynamicObjectCollection list = orm.query("bd_exrate_tree", selectFields, filters, orderBys, top);
        if (list != null && list.size() > 0) {
            return (DynamicObject)list.get(0);
        }
        return null;
    }

    public static Date strToDate(String strDate) {
        SimpleDateFormat formatter = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);
        ParsePosition pos = new ParsePosition(0);
        Date strtodate = formatter.parse(strDate, pos);
        return strtodate;
    }

    public static int daysBetween(Date smdate, Date bdate) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        smdate = sdf.parse(sdf.format(smdate));
        bdate = sdf.parse(sdf.format(bdate));
        Calendar cal = Calendar.getInstance();
        cal.setTime(smdate);
        long time1 = cal.getTimeInMillis();
        cal.setTime(bdate);
        long time2 = cal.getTimeInMillis();
        long between_days = (time2 - time1) / 86400000L;
        return Integer.parseInt(String.valueOf(between_days));
    }

    public static Date getCurMonthFirstDay() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
        Calendar c = Calendar.getInstance();
        c.add(2, 0);
        c.set(5, 1);
        String dateStr = format.format(c.getTime());
        try {
            return format.parse(dateStr);
        }
        catch (Exception e) {
            return new Date();
        }
    }

    public static Date getNextMonthFirstDay() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
        Calendar c = Calendar.getInstance();
        c.add(2, 1);
        c.set(5, 1);
        String dateStr = format.format(c.getTime());
        try {
            return format.parse(dateStr);
        }
        catch (Exception e) {
            return new Date();
        }
    }

    public static String getNowByUserTimeZone() {
        Date now = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        sdf.setTimeZone(TimeServiceHelper.getUserTimeZone().getTimeZone());
        try {
            return sdf.format(now);
        }
        catch (Exception exception) {
            return "2020-01-01 00:00:00";
        }
    }

    public static Date getMonthFirstCurDate(Date date) {
        if (Objects.isNull(date)) {
            date = new Date();
        }
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(TimeServiceHelper.getUserTimeZone().getTimeZone());
        cal.setTime(date);
        cal.set(5, 1);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(10, 0);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
        String dateStr = format.format(cal.getTime());
        try {
            return format.parse(dateStr);
        }
        catch (Exception e) {
            return new Date();
        }
    }

    public static Date getMonthLastCurDate(Date date) {
        if (Objects.isNull(date)) {
            date = new Date();
        }
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(TimeServiceHelper.getUserTimeZone().getTimeZone());
        cal.setTime(date);
        if (cal.get(5) != 1) {
            cal.add(2, 1);
        }
        cal.set(5, 1);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(10, 0);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
        String dateStr = format.format(cal.getTime());
        try {
            return format.parse(dateStr);
        }
        catch (Exception e) {
            return new Date();
        }
    }

    public static Date getBeforeCurTimeByDays(int days) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(TimeServiceHelper.getUserTimeZone().getTimeZone());
        cal.set(5, cal.get(5) - days);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(10, 0);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
        sdf.setTimeZone(TimeServiceHelper.getUserTimeZone().getTimeZone());
        try {
            return sdf.parse(sdf.format(cal.getTime()));
        }
        catch (Exception exception) {
            return cal.getTime();
        }
    }

    public static Date getBeginCurTime() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(TimeServiceHelper.getUserTimeZone().getTimeZone());
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(10, 0);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
        sdf.setTimeZone(TimeServiceHelper.getUserTimeZone().getTimeZone());
        try {
            return sdf.parse(sdf.format(cal.getTime()));
        }
        catch (Exception exception) {
            return cal.getTime();
        }
    }

    public static Date getEndCurTime() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(TimeServiceHelper.getUserTimeZone().getTimeZone());
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(10, 0);
        cal.add(5, 1);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
        sdf.setTimeZone(TimeServiceHelper.getUserTimeZone().getTimeZone());
        try {
            return sdf.parse(sdf.format(cal.getTime()));
        }
        catch (Exception exception) {
            return cal.getTime();
        }
    }

    public static int getCurrencyScale(Long currencyId) {
        return (Integer)ThreadCache.get((Object)ThreadCacheKey.getCurrencyPrecisionKey(currencyId, "convertamt"), () -> BusinessDataServiceHelper.loadSingleFromCache((Object)currencyId, (String)"bd_currency").getInt("amtprecision"));
    }
}

